/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.app.Activity;
import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.appbase.permission.helper.SimplePermissionListener;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ViewImage;
import com.yy.base.logger.MLog;
import com.yy.base.startup.ActivityStackManager;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.grace.Call;
import com.yy.grace.Callback;
import com.yy.grace.Response;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import java.io.File;

public class SaveImageJsEvent
implements JsEvent {
    private static final String TAG = "AddFriendJsEvent";
    private static final String WEB_IMAGE_CACHE = "DCIM/VIMI8";
    public static final String PNG_SUFFIX = ".png";
    public static final String JPG_SUFFIX = ".jpg";
    public static final String WEBP_SUFFIX = ".webp";

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.saveImage;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    PermissionHelper.checkStoragePermission((Activity)ActivityStackManager.getInstance().currentActivity(), (IPermissionListener)new SimplePermissionListener(){

                        public void onPermissionGranted(@NonNull String[] permission) {
                            YYTaskExecutor.execute((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    SaveImageJsEvent.this.savaImage(param, callback);
                                }
                            });
                        }
                    });
                }
                catch (Exception e) {
                    MLog.error((Object)SaveImageJsEvent.TAG, (String)("savaImage error:" + e.getMessage()), (Object[])new Object[0]);
                }
            }
        });
    }

    public void savaImage(@NonNull String paramJson, final @Nullable IJsEventCallback callback) {
        block8: {
            try {
                BaseJsParam err;
                final SaveImageParam param = (SaveImageParam)JsonParser.parseJsonObject((String)paramJson, SaveImageParam.class);
                if (param == null) {
                    BaseJsParam err2 = BaseJsParam.errorParam((int)0, (String)"paramJson is not right");
                    if (callback != null) {
                        callback.callJs((IJsParam)err2);
                    }
                    return;
                }
                if (StringUtils.isEmpty((String)param.url)) {
                    err = BaseJsParam.errorParam((int)0, (String)"url is not right");
                    if (callback != null) {
                        callback.callJs((IJsParam)err);
                    }
                }
                if (StringUtils.isEmpty((String)param.name)) {
                    err = BaseJsParam.errorParam((int)0, (String)"name is not right");
                    if (callback != null) {
                        callback.callJs((IJsParam)err);
                    }
                }
                String extPath = Build.BRAND.equals("Xiaomi") ? Environment.getExternalStorageDirectory().getPath() + "/DCIM/Camera" : Environment.getExternalStorageDirectory().getPath() + "/DCIM";
                final String imgPath = extPath + File.separator + param.name;
                HttpUtil.downloadFile((String)param.url, (String)imgPath, (String)param.md5, (Callback)new Callback<File>(){

                    public void onResponse(Call<File> call, Response<File> response) {
                        MLog.info((Object)SaveImageJsEvent.TAG, (String)"download dynamic resource success url: %s, path: %s", (Object[])new Object[]{param.url, imgPath});
                        FeatureLog.i((String)"FTQuicFileDownload", (String)"download dynamic resource success url: %s, path: %s", (Object[])new Object[]{param.url, imgPath});
                        ViewImage.insertImgToAlbum((String)imgPath);
                        BaseJsParam.DataBuilder builder = BaseJsParam.builder();
                        builder.put("url", (Object)param.url);
                        builder.put("img_path", (Object)imgPath);
                        if (callback != null) {
                            callback.callJs((IJsParam)builder.build());
                        }
                    }

                    public void onFailure(Call<File> call, Throwable e) {
                        MLog.error((Object)SaveImageJsEvent.TAG, (String)"downloadRes url: %s, path: %s", (Object[])new Object[]{param.url, imgPath, e});
                        FeatureLog.e((String)"FTQuicFileDownload", (String)"downloadRes url: %s, path: %s", (Object[])new Object[]{param.url, imgPath, e});
                        if (callback != null) {
                            BaseJsParam err = BaseJsParam.errorParam((int)0, (String)("" + e.toString()));
                            callback.callJs((IJsParam)err);
                        }
                    }
                });
            }
            catch (Exception e) {
                if (callback == null) break block8;
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)("" + e.toString()));
                callback.callJs((IJsParam)err);
            }
        }
    }

    @DontProguardClass
    static class SaveImageParam {
        String url;
        String md5 = "";
        String name;

        SaveImageParam() {
        }
    }
}

