/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.webbussiness.base;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.web.JsEventControllerCallback;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DontProguardClass;
import com.yy.base.utils.FP;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.bean.GameMatchNotifyRes;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.pkgame.PkGamePlayContext;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.event.parqam.BaseJsParam;
import com.yy.webservice.event.parqam.IJsParam;
import java.util.HashMap;

class MatchGameJsEvent
implements JsEvent {
    private static final String TAG = "MatchGameJsEvent";
    private static final int START_GAME_VALID = 1;
    private static final int START_GAME_NEED_DOWNLOAD = 2;
    private static final int START_GAME_UNFOUND = 3;
    private final JsEventControllerCallback mControllerCallback;

    MatchGameJsEvent(@NonNull JsEventControllerCallback callback) {
        this.mControllerCallback = callback;
    }

    @NonNull
    public JsMethod method() {
        return JsEventDefine.BASE.startMatchedGame;
    }

    public void jsCall(@NonNull IWebBusinessHandler webHandler, final @NonNull String param, final @Nullable IJsEventCallback callback) {
        if (TextUtils.isEmpty((CharSequence)param)) {
            MLog.error((Object)TAG, (String)"param is empty", (Object[])new Object[0]);
            if (callback != null) {
                BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is null");
                callback.callJs((IJsParam)err);
            }
            return;
        }
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                MatchGameJsEvent.this.matchGame(param, callback);
            }
        });
    }

    private void matchGame(@NonNull String paramJson, @Nullable IJsEventCallback callback) {
        final MatchGameParam param = (MatchGameParam)((Object)JsonParser.parseJsonObject((String)paramJson, MatchGameParam.class));
        if (param != null) {
            final GameInfo gameInfo = ((IGameInfoService)this.mControllerCallback.getService().getService(IGameInfoService.class)).getGameInfoByGid(param.getGameId());
            if (gameInfo == null) {
                this.resultCallback(callback, param.getGameId(), param.activityId, 3);
                return;
            }
            if (!((IGameService)this.mControllerCallback.getService().getService(IGameService.class)).isGameValid(gameInfo)) {
                this.resultCallback(callback, param.getGameId(), param.activityId, 2);
                return;
            }
            this.resultCallback(callback, param.getGameId(), param.activityId, 1);
            final HashMap<String, String> map = new HashMap<String, String>();
            map.put("key_activity", param.activityId);
            map.put("key_show_result_mode", param.showResultMode);
            map.put("extend_from_h5", param.extra);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    PkGamePlayContext gamePlayContext = new PkGamePlayContext(GameContextDef.JoinFrom.FROM_H5);
                    gamePlayContext.setGameUrl(param.getResource().getUrl());
                    gamePlayContext.setGameInfo(gameInfo);
                    gamePlayContext.setRoomId(param.getResource().getRoomid());
                    gamePlayContext.addAllExtendValue(map);
                    IUserInfoService service = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
                    UserInfoKS other = service.getUserInfo(param.getUid());
                    if (!FP.empty((CharSequence)param.getNick())) {
                        other.setValue("nick", (Object)param.getNick());
                    }
                    if (param.getSex() != -1L) {
                        other.setValue("sex", (Object)((int)param.getSex()));
                    }
                    if (!FP.empty((CharSequence)param.getAvatarUrl())) {
                        other.setValue("avatar", (Object)param.getAvatarUrl());
                    }
                    UserInfoKS self = service.getUserInfo(AccountUtil.getUid());
                    gamePlayContext.updateUserInfo(other.uid, other);
                    gamePlayContext.updateUserInfo(self.uid, self);
                    ((IGameCenterService)MatchGameJsEvent.this.mControllerCallback.getService().getService(IGameCenterService.class)).joinGame(gameInfo, (GamePlayContext)gamePlayContext);
                }
            });
        } else if (callback != null) {
            BaseJsParam err = BaseJsParam.errorParam((int)0, (String)"paramJson is illegal");
            callback.callJs((IJsParam)err);
        }
    }

    private void resultCallback(@Nullable IJsEventCallback callback, String gameId, String activityId, int result) {
        if (callback != null) {
            BaseJsParam.DataBuilder builder = BaseJsParam.builder().put("gameId", (Object)gameId).put("result", (Object)result);
            if (!TextUtils.isEmpty((CharSequence)activityId)) {
                builder.put("activityId", (Object)activityId);
            }
            BaseJsParam param = builder.build();
            callback.callJs((IJsParam)param);
        }
    }

    @DontProguardClass
    static class MatchGameParam
    extends GameMatchNotifyRes {
        String showResultMode;
        String activityId;
        String extra;

        private MatchGameParam(GameMatchNotifyRes.Builder builder) {
            super(builder);
        }
    }
}

