/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.unifyconfig;

import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import java.util.concurrent.ConcurrentHashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class UnifyDefaultConfigProcess {
    private static final String TAG = "DefaultConfig";
    private static final String[] AREAS = new String[]{"in", "id", "sg", "ua"};
    private static final int CLEAR_DATA_DELAY_TIME = 180000;
    private static final String FORMAT_AREA_CONFIG = "ibigboss/%s/config.bat";
    private static final String FORMAT_AREA_COMMON_CONFIG = "ibigboss/common/config.bat";
    private static final ConcurrentHashMap<String, JsonConofigWrap> sConfigs = new ConcurrentHashMap();
    private static final Runnable sRunnable = () -> sConfigs.clear();

    @Nullable
    public static String getDefaultConfig(String code) {
        YYTaskExecutor.removeTask((Runnable)sRunnable);
        YYTaskExecutor.execute((Runnable)sRunnable, (long)180000L);
        MLog.infoIfDebug((Object)TAG, (String)("get default config code " + code), (Object[])new Object[0]);
        return UnifyDefaultConfigProcess.getCodeConfig(UnifyDefaultConfigProcess.handleAreaConfig(), code);
    }

    private static JsonConofigWrap handleAreaConfig() {
        String path = FORMAT_AREA_COMMON_CONFIG;
        String country = UnifyDefaultConfigProcess.countryCode();
        if (StringUtils.isNotEmpty((String)country) && UnifyDefaultConfigProcess.isContainInConfigArea(country)) {
            path = StringUtils.format((String)FORMAT_AREA_CONFIG, (Object[])new Object[]{country.toLowerCase()});
        }
        MLog.infoIfDebug((Object)TAG, (String)("get default config country " + country), (Object[])new Object[0]);
        if (sConfigs.containsKey(path)) {
            return sConfigs.get(path);
        }
        byte[] bytes = YYFileUtils.readFromAssets((String)path);
        MLog.infoIfDebug((Object)TAG, (String)("path " + path + " bytes " + bytes), (Object[])new Object[0]);
        if (bytes != null) {
            JsonConofigWrap conofigWrap = UnifyDefaultConfigProcess.parseDefaultFile(path, StringUtils.byteToStringUtf8((byte[])bytes));
            sConfigs.put(path, conofigWrap);
            MLog.infoIfDebug((Object)TAG, (String)("path " + path + " jsonConfig " + conofigWrap.mJsonConfig), (Object[])new Object[0]);
            return conofigWrap;
        }
        return UnifyDefaultConfigProcess.readCommonConfig();
    }

    private static JsonConofigWrap readCommonConfig() {
        if (sConfigs.containsKey(FORMAT_AREA_COMMON_CONFIG)) {
            return sConfigs.get(FORMAT_AREA_COMMON_CONFIG);
        }
        String configJson = StringUtils.byteToStringUtf8((byte[])YYFileUtils.readFromAssets((String)FORMAT_AREA_COMMON_CONFIG));
        JsonConofigWrap conofigWrap = UnifyDefaultConfigProcess.parseDefaultFile(FORMAT_AREA_COMMON_CONFIG, configJson);
        sConfigs.put(FORMAT_AREA_COMMON_CONFIG, conofigWrap);
        return conofigWrap;
    }

    private static JsonConofigWrap parseDefaultFile(String path, String configJson) {
        JsonConofigWrap conofigWrap = new JsonConofigWrap();
        conofigWrap.mIsFromCommon = StringUtils.equalsIgnoreCase((String)path, (String)FORMAT_AREA_COMMON_CONFIG);
        conofigWrap.mJsonConfig = configJson;
        return conofigWrap;
    }

    private static String getCodeConfig(JsonConofigWrap jsonConfig, String code) {
        block8: {
            if (jsonConfig == null) {
                if (RuntimeContext.sIsDebuggable) {
                    throw new RuntimeException("get default error!!!!");
                }
                return "";
            }
            try {
                JSONObject respJo = JsonParser.obtainJSONObject((String)jsonConfig.mJsonConfig);
                if (respJo.has("data")) {
                    JSONObject dataJo = respJo.getJSONObject("data");
                    if (dataJo.has(code)) {
                        return UnifyDefaultConfigProcess.parseCodeConfigString(dataJo, code);
                    }
                    if (!jsonConfig.mIsFromCommon) {
                        JSONObject commonDataJo;
                        JsonConofigWrap jsonConofigWrap = UnifyDefaultConfigProcess.readCommonConfig();
                        respJo = JsonParser.obtainJSONObject((String)jsonConofigWrap.mJsonConfig);
                        if (respJo.has("data") && (commonDataJo = respJo.getJSONObject("data")).has(code)) {
                            return UnifyDefaultConfigProcess.parseCodeConfigString(commonDataJo, code);
                        }
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
                if (!RuntimeContext.sIsDebuggable) break block8;
                throw new RuntimeException("Parse default config json fail\uff01\uff01\uff01\uff0cplease check assets json format");
            }
        }
        return "";
    }

    private static String parseCodeConfigString(JSONObject dataJo, String code) {
        String config = "";
        JSONObject valueJo = dataJo.optJSONObject(code);
        if (valueJo != null && valueJo.has("value")) {
            config = valueJo.optString("value");
            MLog.infoIfDebug((Object)TAG, (String)("config = " + config), (Object[])new Object[0]);
        }
        return config;
    }

    private static boolean isContainInConfigArea(String country) {
        for (String area : AREAS) {
            if (!StringUtils.equalsIgnoreCase((String)area, (String)country)) continue;
            return true;
        }
        return false;
    }

    private static String countryCode() {
        String code = AccountUtil.realCountry();
        if (TextUtils.isEmpty((CharSequence)code)) {
            code = SystemUtils.getHagoCountry();
        }
        if (code == null) {
            return "";
        }
        return code.toUpperCase();
    }

    private static class JsonConofigWrap {
        boolean mIsFromCommon = false;
        String mJsonConfig = "{}";

        private JsonConofigWrap() {
        }
    }
}

