/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.splash;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.push.tips.PushPermissionTipManager;
import com.yy.appbase.resource.file.ResPersistUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IFrequencyLimitExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.TimeUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.module.splash.ConfigureSplashData;
import com.yy.hiyo.module.splash.SplashDataRes;
import com.yy.hiyo.module.splash.SplashModel;
import com.yy.hiyo.module.splash.SplashShowData;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public enum SplashManager {
    INSTANCE;

    private static final String TAG = "SplashManager";
    private static final String CONFIG_PATH = "/splash/sconfig.txt";
    private static final String SHOW_CONFIG_PATH = "/splash/showConfig.txt";
    private static final String GAME_IDS_PATH = "/splash/splash_cache_game_ids.txt";
    private boolean splashViewShowIng = false;
    private final Object fileLock = new Object();
    private SplashDataRes mLocalSplashDataRes;
    private volatile List<ConfigureSplashData> mSplashs = null;
    public ConfigureSplashData mLastConfigureSplashData;
    private SplashShowData mSplashShowData;
    private List<String> cacheGameIds = new ArrayList<String>();
    private boolean hasReadGidConfig = false;
    private IFrequencyLimitExecutor mLimitExecutor;
    private SplashModel mSplashModel;

    public void loadSplash() {
        if (AccountUtil.getUid() <= 0L) {
            return;
        }
        this.getSplashModel().loadSplash();
    }

    private SplashModel getSplashModel() {
        if (this.mSplashModel == null) {
            this.mSplashModel = new SplashModel();
        }
        return this.mSplashModel;
    }

    public boolean needShowSplash() {
        return this.checkSplashDataValid();
    }

    private boolean checkSplashDataValid() {
        ConfigureSplashData splashData = this.getWillLoadSplashData();
        MLog.debug((Object)"SplashController", (String)("checkSplashDataValid: " + splashData), (Object[])new Object[0]);
        return splashData != null && splashData.checkSplashValid() && splashData.isResourceHadDownloaded();
    }

    @Nullable
    public ConfigureSplashData getWillLoadSplashData() {
        return this.mLastConfigureSplashData != null ? this.mLastConfigureSplashData : this.getFirstValidSplash();
    }

    @Nullable
    public ConfigureSplashData getFirstValidSplash() {
        List<ConfigureSplashData> splashConfigData = this.getSavedSplashData();
        return this.getLoadStategy().loadSplash(splashConfigData, false);
    }

    public boolean isSplashViewShowIng() {
        return this.splashViewShowIng;
    }

    public void setSplashViewShowIng(boolean splashViewShowIng) {
        this.splashViewShowIng = splashViewShowIng;
        PushPermissionTipManager.setIsSplashViewShowIng((boolean)splashViewShowIng);
    }

    public void loadSplashConfigAsyn() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                List<ConfigureSplashData> splashDataList = SplashManager.this.getSavedSplashData();
                ConfigureSplashData configureSplashData = SplashManager.this.getLoadStategy().loadSplash(splashDataList, true);
                if (configureSplashData != null) {
                    SplashManager.this.mLastConfigureSplashData = configureSplashData;
                }
                SplashManager.this.loadSplash();
            }
        });
    }

    public void preloadSplashIcon() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SplashManager.this.loadShowData();
                ConfigureSplashData splashData = SplashManager.this.getFirstValidSplash();
                if (splashData == null) {
                    return;
                }
                SplashManager.this.mLastConfigureSplashData = splashData;
                SplashManager.this.mLastConfigureSplashData.setLocalFilePath(splashData.getResourceFilePath());
            }
        };
        YYTaskExecutor.execute((Runnable)runnable);
    }

    public synchronized List<ConfigureSplashData> getSavedSplashData() {
        if (this.mSplashs != null) {
            return this.mSplashs;
        }
        MLog.info((Object)TAG, (String)"getSavedSplashData", (Object[])new Object[0]);
        this.cacheGameIds = this.getCacheGameIds();
        SplashDataRes res = this.getLocalSplashDataRes();
        if (res != null && !FP.empty(res.list)) {
            this.mSplashs = res.list;
            if (YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.execute(this::preloadPath);
            } else {
                this.preloadPath();
            }
        }
        return this.mSplashs;
    }

    private synchronized void preloadPath() {
        if (FP.empty(this.mSplashs)) {
            return;
        }
        for (ConfigureSplashData data : this.mSplashs) {
            if (data == null || TextUtils.isEmpty((CharSequence)data.mResourceUrl)) continue;
            ResPersistUtils.fetchFilePath((ResPersistUtils.Dir)ResPersistUtils.Dir.SPLASH, (String)data.mResourceUrl);
        }
    }

    public synchronized void releaseData() {
        if (this.mSplashs != null) {
            this.mSplashs.clear();
        }
    }

    private SplashDataRes getLocalSplashDataRes() {
        if (this.mLocalSplashDataRes == null) {
            this.mLocalSplashDataRes = this.getSplashModel().readConfig();
        }
        return this.mLocalSplashDataRes;
    }

    private String getGameIdsPath() {
        return YYFileUtils.getConfigDir().getAbsolutePath() + GAME_IDS_PATH;
    }

    public void setGameIds(List<GameInfo> gameInfos) {
        this.cacheGameIds.clear();
        final StringBuilder gameStr = new StringBuilder();
        if (gameInfos != null && !gameInfos.isEmpty()) {
            for (GameInfo gameInfo : gameInfos) {
                gameStr.append(gameInfo.gid).append(",");
                this.cacheGameIds.add(gameInfo.gid);
            }
        }
        MLog.debug((Object)TAG, (String)"setGameIds :%s", (Object[])new Object[]{gameStr.toString()});
        if (this.mLimitExecutor == null) {
            this.mLimitExecutor = YYTaskExecutor.createAFrequencyLimitExecut((long)8000L, (boolean)false);
        }
        this.mLimitExecutor.execute(new Runnable(){

            @Override
            public void run() {
                YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        File file = new File(SplashManager.this.getGameIdsPath());
                        try {
                            YYFileUtils.writeBytesToFile((File)file, (byte[])gameStr.toString().getBytes(), (boolean)false);
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    private List<String> getCacheGameIds() {
        if (this.hasReadGidConfig) {
            return this.cacheGameIds;
        }
        ArrayList<String> gameIds = new ArrayList<String>();
        byte[] bytes = YYFileUtils.readBytes((String)this.getGameIdsPath());
        String gids = null;
        if (bytes != null && bytes.length > 0 && !StringUtils.isEmpty((String)(gids = new String(bytes)))) {
            String[] ids = gids.split(",");
            gameIds.addAll(Arrays.asList(ids));
        }
        this.hasReadGidConfig = true;
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)TAG, (String)"getCacheGameIds :%s", (Object[])new Object[]{gids});
        }
        return gameIds;
    }

    private ILoadFirstSplashStrategy getLoadStategy() {
        return new ATestLoadStrategy();
    }

    public void clickSplash(String splashId) {
        SplashShowData.SplashShow targetShowData = this.getTargetShowData(splashId);
        if (targetShowData != null) {
            targetShowData.hasClick = true;
            if (this.mSplashShowData != null) {
                this.mSplashShowData.lastUpdateTime = System.currentTimeMillis();
                this.mSplashShowData.lastShowSplashId = splashId;
                YYTaskExecutor.execute(() -> JsonParser.writeJsonFile((String)this.getShowDataSaveConfigPath(), (Object)this.mSplashShowData, SplashShowData.class));
            }
        }
    }

    public void splashShow(String splashId) {
        SplashShowData.SplashShow targetShowData = this.getTargetShowData(splashId);
        if (targetShowData != null) {
            ++targetShowData.showTimes;
            MLog.debug((Object)TAG, (String)("update showTimes=" + targetShowData.showTimes + "; id=" + targetShowData.splashId), (Object[])new Object[0]);
        }
        if (this.mSplashShowData != null) {
            this.mSplashShowData.lastUpdateTime = System.currentTimeMillis();
            this.mSplashShowData.lastShowSplashId = splashId;
            YYTaskExecutor.execute(() -> JsonParser.writeJsonFile((String)this.getShowDataSaveConfigPath(), (Object)this.mSplashShowData, SplashShowData.class));
        }
    }

    private SplashShowData.SplashShow getTargetShowData(String splashId) {
        SplashShowData.SplashShow target = null;
        if (StringUtils.isNotEmpty((String)splashId) && this.mSplashShowData != null) {
            boolean hasHandle = false;
            List<SplashShowData.SplashShow> splashShows = this.mSplashShowData.mSplashShows;
            if (splashShows == null) {
                this.mSplashShowData.mSplashShows = splashShows = new CopyOnWriteArrayList<SplashShowData.SplashShow>();
            }
            if (!splashShows.isEmpty()) {
                for (SplashShowData.SplashShow show : splashShows) {
                    if (!splashId.equals(show.splashId)) continue;
                    hasHandle = true;
                    target = show;
                    break;
                }
            }
            if (!hasHandle) {
                target = new SplashShowData.SplashShow();
                target.splashId = splashId;
                splashShows.add(target);
            }
        }
        return target;
    }

    private void loadShowData() {
        if (this.mSplashShowData == null) {
            String path = this.getShowDataSaveConfigPath();
            if (YYFileUtils.isPathExist((String)path)) {
                this.mSplashShowData = (SplashShowData)JsonParser.parseJsonFile((String)path, SplashShowData.class);
            }
            if (this.mSplashShowData == null || !TimeUtils.isSameDay((long)this.mSplashShowData.lastUpdateTime, (long)System.currentTimeMillis())) {
                this.mSplashShowData = new SplashShowData();
            }
        }
    }

    private String getShowDataSaveConfigPath() {
        return YYFileUtils.getConfigDir().getAbsolutePath() + SHOW_CONFIG_PATH;
    }

    private class ATestLoadStrategy
    implements ILoadFirstSplashStrategy {
        private ATestLoadStrategy() {
        }

        @Override
        public ConfigureSplashData loadSplash(List<ConfigureSplashData> splashDataList, boolean downloadOthers) {
            if (FP.empty(splashDataList)) {
                MLog.error((Object)SplashManager.TAG, (String)"loadSplash configureSplashData empty!!!", (Object[])new Object[0]);
                return null;
            }
            ConfigureSplashData lastConfigureSplashData = null;
            for (int i = splashDataList.size() - 1; i >= 0; --i) {
                ConfigureSplashData splashConfigData = splashDataList.get(i);
                if (splashConfigData == null || !splashConfigData.checkSplashValid()) {
                    MLog.error((Object)SplashManager.TAG, (String)"loadSplash configureSplashData check Splash id not Valid:%s !!!", (Object[])new Object[]{splashConfigData != null ? splashConfigData.splashId : ""});
                    continue;
                }
                boolean isResourceHadDownloaded = splashConfigData.isResourceHadDownloaded();
                MLog.debug((Object)SplashManager.TAG, (String)"isResourceHadDownloaded=%b, id=%s", (Object[])new Object[]{isResourceHadDownloaded, splashConfigData.splashId});
                if (isResourceHadDownloaded) {
                    if (lastConfigureSplashData != null) continue;
                    String splashId = splashConfigData.splashId;
                    if (StringUtils.isEmpty((String)splashId)) {
                        MLog.error((Object)SplashManager.TAG, (String)"splashId empty!!!, res:%s", (Object[])new Object[]{splashConfigData.mResourceUrl});
                        continue;
                    }
                    boolean isTodayShowValid = this.isTodayShowValidData(splashConfigData, SplashManager.this.mSplashShowData);
                    if (!isTodayShowValid) continue;
                    String gameId = splashConfigData.gameId;
                    if (StringUtils.isNotEmpty((String)gameId)) {
                        IGameInfoService gameInfoService = null;
                        if (RuntimeContext.sIsAppStartFinished) {
                            gameInfoService = ServiceManager.getInstance().getService(IGameInfoService.class);
                        }
                        if (gameInfoService != null) {
                            GameInfo gInfo = gameInfoService.getGameInfoByGid(gameId);
                            if (gInfo == null) {
                                MLog.error((Object)SplashManager.TAG, (String)"gInfo null!!! splashId:%s, gameId:%s ", (Object[])new Object[]{splashId, gameId});
                                continue;
                            }
                        } else {
                            MLog.info((Object)SplashManager.TAG, (String)"gameInfoService null, skip check game info!!!!", (Object[])new Object[0]);
                            if (!SplashManager.this.cacheGameIds.contains(gameId)) {
                                MLog.info((Object)SplashManager.TAG, (String)"cache gid not contain gid:%s !!!!", (Object[])new Object[]{gameId});
                                continue;
                            }
                            MLog.info((Object)SplashManager.TAG, (String)"cache gid contain gid:%s", (Object[])new Object[]{gameId});
                        }
                    }
                    lastConfigureSplashData = splashConfigData;
                    if (downloadOthers) continue;
                    break;
                }
                if (!downloadOthers) continue;
                splashConfigData.downloadResFile();
            }
            if (lastConfigureSplashData == null) {
                MLog.info((Object)SplashManager.TAG, (String)"mLastConfigureSplashData null!!!", (Object[])new Object[0]);
            }
            return lastConfigureSplashData;
        }

        private boolean isTodayShowValidData(@NonNull ConfigureSplashData configData, SplashShowData splashShowData) {
            boolean testSwitch = SettingFlags.getBoolean((String)"ENV_AD_DIALOG", (boolean)false);
            if (SystemUtils.isShowEnvSetting() && testSwitch) {
                return true;
            }
            if (splashShowData == null || splashShowData.mSplashShows == null) {
                return true;
            }
            MLog.debug((Object)SplashManager.TAG, (String)("lastShow splashId=" + splashShowData.lastShowSplashId + "; currId=" + configData.splashId), (Object[])new Object[0]);
            if (configData.splashId != null && !configData.splashId.equals(splashShowData.lastShowSplashId) && splashShowData.lastUpdateTime + (long)configData.showInterval * 1000L > System.currentTimeMillis()) {
                MLog.debug((Object)SplashManager.TAG, (String)("show interval invalid " + splashShowData.lastUpdateTime + "; " + configData.showInterval), (Object[])new Object[0]);
                return false;
            }
            String splashId = configData.splashId;
            for (SplashShowData.SplashShow splashShow : splashShowData.mSplashShows) {
                if (!splashId.equals(splashShow.splashId) || splashShow.isValid(configData.showCount)) continue;
                MLog.info((Object)SplashManager.TAG, (String)"is not valid!!! splashShow:%s", (Object[])new Object[]{splashShow});
                return false;
            }
            return true;
        }
    }

    private static interface ILoadFirstSplashStrategy {
        public ConfigureSplashData loadSplash(List<ConfigureSplashData> var1, boolean var2);
    }
}

