/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.splash;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import com.yy.appbase.R;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.app.web.WebManager;
import com.yy.hiyo.login.base.utils.NextBtn;
import com.yy.hiyo.main.R;
import com.yy.webservice.webwindow.webview.base.YYWebView;

public class PrivacyView
extends YYLinearLayout {
    private FrameLayout mTitleBar;
    private WebManager mWebManager;
    private WebView mWebView;
    private NextBtn mAgreeBtn;
    private IPrivacyViewCallBack mCallBack;

    public PrivacyView(Context context, IPrivacyViewCallBack callBack) {
        super(context);
        this.mCallBack = callBack;
        this.initViews(context);
        this.initWebView();
    }

    private void initViews(Context context) {
        int titleBarHeight = ResourceUtils.getDimen((int)R.dimen.commom_titlebar_height);
        this.mTitleBar = this.createTitleBar(context);
        this.mWebView = new YYWebView(context);
        this.mAgreeBtn = new NextBtn(context);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(titleBarHeight, -1);
        this.mTitleBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = new LinearLayout.LayoutParams(0, -1);
        layoutParams.weight = 1.0f;
        this.mWebView.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        this.mAgreeBtn.setLayoutParams((ViewGroup.LayoutParams)this.createLLayoutParams());
        this.mAgreeBtn.hideArrow();
        this.mAgreeBtn.setText((CharSequence)ResourceUtils.getString((int)R.string.splash_privacy_agree));
        this.mAgreeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PrivacyView.this.onAgreeBtnClick();
            }
        });
        this.setOrientation(1);
        this.addView((View)this.mTitleBar);
        this.addView((View)this.mWebView);
        this.addView((View)this.mAgreeBtn);
    }

    private void initWebView() {
    }

    private LinearLayout.LayoutParams createLLayoutParams() {
        int btnHeight = ResourceUtils.getDimen((int)R.dimen.splash_agree_btn_height);
        int topMargin = ResourceUtils.getDimen((int)R.dimen.splash_agree_btn_top);
        int leftMargin = ResourceUtils.getDimen((int)R.dimen.splash_agree_btn_left);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, btnHeight);
        layoutParams.topMargin = topMargin;
        layoutParams.bottomMargin = topMargin;
        layoutParams.leftMargin = leftMargin;
        layoutParams.rightMargin = leftMargin;
        return layoutParams;
    }

    private FrameLayout createTitleBar(Context context) {
        int titleTextSize = ResourceUtils.getDimen((int)R.dimen.commom_titlebar_textsize);
        int backTextSize = ResourceUtils.getDimen((int)R.dimen.splash_privacy_backtitle_textsize);
        int iconPadding = ResourceUtils.getDimen((int)R.dimen.commom_titlebar_iconpadding);
        int textColor = ResourceUtils.getColor((int)R.color.splash_back_title);
        YYFrameLayout titleBar = new YYFrameLayout(context);
        YYTextView backTitle = new YYTextView(context);
        YYTextView title = new YYTextView(context);
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-2, -1);
        layoutParams.leftMargin = iconPadding;
        backTitle.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layoutParams = new FrameLayout.LayoutParams(-2, -2);
        layoutParams.leftMargin = iconPadding;
        layoutParams.gravity = 17;
        title.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        backTitle.setTextSize(0, (float)backTextSize);
        backTitle.setTextColor(textColor);
        backTitle.setGravity(16);
        backTitle.setCompoundDrawables(ResourceUtils.getDrawable((int)R.drawable.icon_nav_back), null, null, null);
        backTitle.setCompoundDrawablePadding(iconPadding);
        backTitle.setText((CharSequence)ResourceUtils.getString((int)R.string.splash_privacy_back));
        title.setTextSize(0, (float)titleTextSize);
        title.setTextColor(textColor);
        title.setText((CharSequence)(ResourceUtils.getString((int)R.string.splash_privacy_title_privacy) + " & " + ResourceUtils.getString((int)R.string.splash_privacy_title_Terms)));
        titleBar.addView((View)backTitle);
        titleBar.addView((View)title);
        backTitle.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PrivacyView.this.onBackClick();
            }
        });
        return titleBar;
    }

    private void onBackClick() {
        if (this.mCallBack != null) {
            this.mCallBack.onBackClicked();
        }
    }

    private void onAgreeBtnClick() {
        if (this.mCallBack != null) {
            this.mCallBack.onAgreeBtnClicked();
        }
    }

    public static interface IPrivacyViewCallBack {
        public void onBackClicked();

        public void onAgreeBtnClicked();

        public String getYYDefaultUa();
    }
}

