/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.main;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Message;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.DiskCacheChecker;
import com.yy.appbase.R;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.ui.dialog.NotificationDialog;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.appbase.unifyconfig.config.LoginTypeConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.env.YYGlideModule;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.NotificationsUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.SingleToastUtil;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.channel.ChannelNotifyDef;
import com.yy.hiyo.login.LoginMsgDef;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.main.R;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.module.coderate.SettingCodeRateDialog;
import com.yy.hiyo.module.matchgender.IMatchGenderDialog;
import com.yy.hiyo.module.push.tip.PushTipManager;
import com.yy.hiyo.module.setting.account.PasswordManageWindow;
import com.yy.hiyo.module.setting.main.ISettingCallback;
import com.yy.hiyo.module.setting.main.SettingWindow;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.push.base.PushSDKHelper;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.msg.BanPushNotifyReq;
import ikxd.msg.IM;
import ikxd.msg.Uri;
import java.lang.ref.WeakReference;

public class SettingController
extends DefaultController
implements UICallBacks,
ISettingCallback {
    public static final String TAG = "SettingController";
    private SettingWindow mWindow;
    private PushTipManager mPushTipManager;
    private static final String ID_COUNTRY = "id";
    private static final String IN_COUNTRY = "in";
    private int selectGender = 0;
    private int mCurrentCodeRate = 0;
    private WeakReference<AbstractWindow> mSubWindow;

    public SettingController(Environment env) {
        super(env);
        if (this.mPushTipManager == null) {
            this.mPushTipManager = new PushTipManager(env);
        }
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
    }

    private void updateData() {
        this.updateLoginAccountState();
        this.checkIsShowSelectGender();
    }

    private void checkIsShowSelectGender() {
        if (this.isShowMatchGenderEntrance()) {
            this.mWindow.getPager().setMatchGenderVisible(0);
            this.updateSelectGender();
        } else {
            if (SettingFlags.containKey((String)(AccountUtil.getUid() + "match_gender"))) {
                SettingFlags.removeKey((String)(AccountUtil.getUid() + "match_gender"));
            }
            this.mWindow.getPager().setMatchGenderVisible(8);
        }
    }

    private boolean isShowMatchGenderEntrance() {
        CommonConfigData data;
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
        if (config instanceof CommonConfig && (data = ((CommonConfig)config).getData()) != null) {
            return data.matchGenderSwitch;
        }
        return true;
    }

    private void updateSelectGender() {
        if (SettingFlags.containKey((String)(AccountUtil.getUid() + "match_gender"))) {
            int selectGender;
            this.selectGender = selectGender = SettingFlags.getIntValue((String)(AccountUtil.getUid() + "match_gender"), (int)0);
            this.onMatchGenderSelect(selectGender);
        }
    }

    private void updateCacheSize() {
        final String[] result = new String[]{null};
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                result[0] = YYGlideModule.getImageCacheSize();
            }
        }, (Runnable)new Runnable(){

            @Override
            public void run() {
                if (result[0] == null) {
                    return;
                }
                if (SettingController.this.mWindow != null && SettingController.this.mWindow.getPager() != null) {
                    SettingController.this.mWindow.getPager().updateCacheSize(result[0]);
                }
            }
        });
    }

    private void updateCacheSize(String str) {
        if (this.mWindow != null && this.mWindow.getPager() != null) {
            this.mWindow.getPager().updateCacheSize(str);
        }
    }

    private void updateLoginAccountState() {
        if (this.mWindow != null && this.mWindow.getPager() != null) {
            this.mWindow.getPager().updateLoginAccountState();
        }
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        MLog.debug((Object)TAG, (String)("onWindowDetach name: " + abstractWindow.getName()), (Object[])new Object[0]);
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
            this.selectGender = 0;
        } else if (this.mSubWindow != null && abstractWindow == this.mSubWindow.get()) {
            this.mSubWindow = null;
        }
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
            boolean isForeground;
            if (this.getCurrentWindow() == this.mWindow && (isForeground = ((Boolean)notification.extObj).booleanValue())) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NotificationsUtils.resetHasTestFlag();
                        NotificationsUtils.isNotificationEnabled((Context)RuntimeContext.sApplicationContext);
                    }
                }, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                    }
                });
            }
        } else if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
            MLog.info((Object)TAG, (String)"receive login success notify", (Object[])new Object[0]);
            if (this.getCurrentWindow() == this.mWindow) {
                this.finish();
            }
        }
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.SHOW_WINDOW_SETTING) {
            MLog.info((Object)TAG, (String)"SHOW_WINDOW_SETTING", (Object[])new Object[0]);
            if (this.mWindow != null) {
                MLog.info((Object)TAG, (String)"mWindow is not null, so pop it", (Object[])new Object[0]);
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            this.mWindow = new SettingWindow(this.mContext, this);
            this.updateData();
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            if (msg.arg1 == 1 && !SettingFlags.containKey((String)(AccountUtil.getUid() + "match_gender"))) {
                SettingFlags.setIntValue((String)(AccountUtil.getUid() + "match_gender"), (int)0);
            } else if (msg.arg1 == 2) {
                this.showCodeRateDialog();
            }
        } else if (msg.what == MsgDef.OPEN_WINDOW_PWD_MANAGE) {
            this.onPasswordManageClick();
        }
    }

    public Object handleMessageSync(Message msg) {
        return super.handleMessageSync(msg);
    }

    public void onWindowShown(AbstractWindow abstractWindow) {
        super.onWindowShown(abstractWindow);
        this.showNotificationDialog();
        this.updateCacheSize();
        this.refreshPrivacyRedPoint();
    }

    private boolean isAccountId() {
        MLog.info((Object)TAG, (String)("\u7528\u6237\u7684\u6ce8\u518c\u56fd\u5bb6\u4fe1\u606f:" + AccountModel.getInstance().getAccountInfo().registerCountry), (Object[])new Object[0]);
        if (AccountModel.getInstance().getAccountInfo() != null && ID_COUNTRY.equals(AccountModel.getInstance().getAccountInfo().registerCountry)) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)TAG, (String)"\u7528\u6237\u7684\u6ce8\u518c\u56fd\u5bb6\u662f\u5370\u5c3c", (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    private void refreshPrivacyRedPoint() {
        if (RuntimeContext.isNewInstalled()) {
            return;
        }
        if (this.mWindow == null) {
            return;
        }
        boolean isRedPointShow = SettingFlags.getBoolean((String)"privacy_recommend_discover", (boolean)true);
        if (isRedPointShow) {
            if (this.isAccountIn()) {
                this.mWindow.setPrivacyRedPoint(0);
            }
        } else {
            this.mWindow.setPrivacyRedPoint(8);
        }
    }

    private boolean isAccountIn() {
        MLog.info((Object)TAG, (String)("\u7528\u6237\u7684\u6ce8\u518c\u56fd\u5bb6\u4fe1\u606f:" + AccountModel.getInstance().getAccountInfo().registerCountry), (Object[])new Object[0]);
        if (AccountModel.getInstance().getAccountInfo() != null && IN_COUNTRY.equals(AccountModel.getInstance().getAccountInfo().registerCountry)) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)TAG, (String)"\u7528\u6237\u7684\u6ce8\u518c\u56fd\u5bb6\u662f\u5370\u5ea6", (Object[])new Object[0]);
            }
            return true;
        }
        return false;
    }

    private void showNotificationDialog() {
        boolean isNotificationShow;
        if (!NotificationsUtils.isNotificationEnabled((Context)RuntimeContext.sApplicationContext) && (isNotificationShow = SettingFlags.getBoolean((String)(AccountUtil.getUid() + "notification_show_tag"), (boolean)true))) {
            OkCancelDialog dialog = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.notification_dialog_title), (CharSequence)ResourceUtils.getString((int)R.string.date_picker_confirm), (CharSequence)ResourceUtils.getString((int)R.string.notification_dialog_cancel), true, false, new OkCancelDialogListener(){

                public void onCancel() {
                    if (SettingController.this.mDialogLinkManager != null) {
                        SettingController.this.mDialogLinkManager.dismissDialog();
                        SettingFlags.setBoolean((String)(AccountUtil.getUid() + "notification_show_tag"), (boolean)false);
                    }
                }

                public void onOk() {
                    PushTipManager.toNotificationAppSetting((Activity)SettingController.this.mContext);
                }
            });
            dialog.setCancelListener(new DialogInterface.OnCancelListener(){

                public void onCancel(DialogInterface dialog) {
                    if (SettingController.this.mDialogLinkManager != null) {
                        SettingController.this.mDialogLinkManager.dismissDialog();
                        SettingFlags.setBoolean((String)(AccountUtil.getUid() + "notification_show_tag"), (boolean)false);
                    }
                }
            });
            if (this.mDialogLinkManager != null) {
                this.mDialogLinkManager.showDialog((BaseDialog)dialog);
            }
        }
    }

    @Override
    public void onBack() {
        AbstractWindow curWin = this.getCurrentWindow();
        MLog.debug((Object)TAG, (String)("onBack win: " + curWin.getName()), (Object[])new Object[0]);
        if (curWin == this.mWindow) {
            this.finish();
        } else if (this.mSubWindow != null && this.mSubWindow.get() == curWin) {
            this.mSubWindow = null;
            this.mWindowMgr.popWindow(true, curWin);
        }
    }

    @Override
    public void onNotificationSwitchClick() {
        this.sendMessage(MsgDef.SHOW_WINDOW_NOTIFICATION);
    }

    @Override
    public void onBlackListClick() {
        this.sendMessage(UserMsgDef.SHOW_WINDOW_BLACKLIST);
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("function_id", "blacklist"));
    }

    @Override
    public void onAboutClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("function_id", "about_version"));
        this.sendMessage(MsgDef.SHOW_WINDOW_ABOUT_US);
    }

    @Override
    public void onPrivacyClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("function_id", "privacy"));
        this.sendMessage(MsgDef.OPEN_WINDOW_PRIVACY);
    }

    @Override
    public void onMatchGenderClick() {
        if (this.mDialogLinkManager == null) {
            return;
        }
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("function_id", "matching_gender_show"));
        this.mDialogLinkManager.showDialog((BaseDialog)new IMatchGenderDialog(this, this.selectGender));
    }

    @Override
    public void onMatchGenderSelect(int index) {
        if (this.mWindow == null || this.mWindow.getPager() == null) {
            return;
        }
        if (index == 0) {
            this.mWindow.getPager().updateSelectGender(R.string.sex_all);
        } else if (index == 1) {
            this.mWindow.getPager().updateSelectGender(R.string.sex_woman);
        } else if (index == 2) {
            this.mWindow.getPager().updateSelectGender(R.string.sex_man);
        }
        this.selectGender = index;
        MLog.info((Object)TAG, (String)"onMatchGenderSelect selectGender = %d", (Object[])new Object[]{this.selectGender});
    }

    @Override
    public void onFollowUsOnSns() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("function_id", "follow_click").put("user_role", "-1").put("gid", "").put("mode_key", RuntimeContext.useOldRoom() ? "1" : "2"));
        this.sendMessage(MsgDef.OPEN_WINDOW_FOLLOW_US);
    }

    @Override
    public void onGamePreferClick() {
        this.sendMessage(UserMsgDef.MSG_OPEN_GAME_PREFER_SETTING_WINDOW);
    }

    @Override
    public void onChangeLanguageClick() {
        this.sendMessage(BaseMsgDef.SHOW_CHANGED_LANGUAGE_DIALOG);
    }

    @Override
    public void onClearClick() {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("function_id", "clear_cache"));
        if (this.mDialogLinkManager == null) {
            return;
        }
        this.mDialogLinkManager.showDialog((BaseDialog)new NotificationDialog((CharSequence)ResourceUtils.getString((int)R.string.clear_cache_tips), true, new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                if (SettingController.this.mDialogLinkManager == null) {
                    return;
                }
                SettingController.this.mDialogLinkManager.dismissDialog();
                DiskCacheChecker.clearCache();
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.CLEAR_CACHE_DATA));
                SettingController.this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog());
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SingleToastUtil.showToast((Context)SettingController.this.mContext, (String)ResourceUtils.getString((int)R.string.clear_cache_success));
                        SettingController.this.mDialogLinkManager.dismissDialog();
                        SettingController.this.updateCacheSize("");
                    }
                }, (long)1500L);
            }
        }));
    }

    @Override
    public void onSourceClick() {
        this.sendMessage(AppbaseMsgDef.OPEN_GAME_SOURCE_PAGE);
    }

    private void submitNotificationStatus(final boolean isNotification) {
        int isBan = isNotification ? 0 : 1;
        BanPushNotifyReq pushNotifyReq = new BanPushNotifyReq.Builder().IsBan(Integer.valueOf(isBan)).build();
        IM msg = new IM.Builder().header(ProtoManager.getInstance().getHeader("ikxd_msg_d")).uri(Uri.kUriBanPushNotifyReq).ban_push_notify_req(pushNotifyReq).build();
        ProtoManager.getInstance().send((AndroidMessage)msg, (IProtoCallback)new IProtoCallback<IM>(){

            public void onResponse(@Nullable IM message) {
                if (message != null && message.header != null && message.header.code == 0L) {
                    MLog.info((Object)SettingController.TAG, (String)("\u4e0a\u62a5\u6210\u529f:" + isNotification), (Object[])new Object[0]);
                }
            }

            public boolean retryWhenTimeout(boolean canRetry) {
                return false;
            }

            public boolean retryWhenError(boolean canRetry, String reason, int code) {
                return false;
            }
        });
    }

    @Override
    public void onAccountSwitchClick() {
        MLog.info((Object)TAG, (String)"onAccountSwitchClick", (Object[])new Object[0]);
        MsgDispatcher.getInstance().sendMessage(LoginMsgDef.MSG_LOGIN_RELOGIN_DIALOG, 14);
    }

    @Override
    public void onSignOutClick() {
        MLog.info((Object)TAG, (String)"onSignOutclicked!", (Object[])new Object[0]);
        String tips = ResourceUtils.getString((int)R.string.tips_login_out_confirm);
        String leftBtn = ResourceUtils.getString((int)R.string.login_feedback);
        String rightBtn = ResourceUtils.getString((int)R.string.btn_sign_out);
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.LOGIN_TYPE_CONFIG);
        LoginTypeConfigData loginTypeConfigData = null;
        if (configData instanceof LoginTypeConfigData) {
            loginTypeConfigData = (LoginTypeConfigData)configData;
        }
        boolean hitException = false;
        if (loginTypeConfigData != null && loginTypeConfigData.hasException(AccountUtil.getsLoginType()) && !StringUtils.isEmpty((String)loginTypeConfigData.logoutExceptionDes)) {
            hitException = true;
            rightBtn = ResourceUtils.getString((int)R.string.btn_cancel);
            leftBtn = ResourceUtils.getString((int)R.string.btn_sign_out);
            tips = loginTypeConfigData.logoutExceptionDes;
        }
        final boolean toFeedBack = !hitException;
        OkCancelDialog dialog = new OkCancelDialog((CharSequence)tips, (CharSequence)rightBtn, (CharSequence)leftBtn, true, true, new OkCancelDialogListener(){

            public void onCancel() {
                MLog.info((Object)SettingController.TAG, (String)"choose feedback!", (Object[])new Object[0]);
                if (toFeedBack) {
                    SettingController.this.sendMessage(MsgDef.SHOW_WINDOW_FEEDBACK, -1, 1);
                    SettingController.statLoginOutDialog(true, false, false);
                } else {
                    if (AccountUtil.getUid() > 0L) {
                        PushSDKHelper.getPushService().getPushHelper().unBindAccount(Long.valueOf(AccountUtil.getUid()));
                    }
                    SettingController.this.sendMessage(MsgDef.LOGIN_OUT, 1, -1, null);
                    SettingController.statLoginOutDialog(false, true, false);
                }
                SettingController.this.finish();
            }

            public void onOk() {
                MLog.info((Object)SettingController.TAG, (String)"choose SignOut!", (Object[])new Object[0]);
                if (toFeedBack) {
                    if (AccountUtil.getUid() > 0L) {
                        PushSDKHelper.getPushService().getPushHelper().unBindAccount(Long.valueOf(AccountUtil.getUid()));
                    }
                    SettingController.this.sendMessage(MsgDef.LOGIN_OUT, 1, -1, null);
                    SettingController.statLoginOutDialog(false, true, false);
                } else {
                    SettingController.statLoginOutDialog(false, false, false);
                }
                SettingController.this.finish();
            }
        });
        dialog.setCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                MLog.info((Object)SettingController.TAG, (String)"choose cancel!", (Object[])new Object[0]);
                SettingController.statLoginOutDialog(false, false, true);
            }
        });
        this.mDialogLinkManager.showDialog((BaseDialog)dialog);
    }

    private void finish() {
        AbstractWindow sub;
        MLog.info((Object)TAG, (String)"finish", (Object[])new Object[0]);
        AbstractWindow curWin = this.getCurrentWindow();
        AbstractWindow abstractWindow = sub = this.mSubWindow == null ? null : (AbstractWindow)this.mSubWindow.get();
        if (sub != null) {
            this.mWindowMgr.popWindow(curWin == sub, sub);
        }
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(curWin == this.mWindow, (AbstractWindow)this.mWindow);
        }
        this.mWindow = null;
        this.mSubWindow = null;
        this.selectGender = 0;
    }

    @Override
    public void onCodeRateClick(int selectIndex) {
        this.mCurrentCodeRate = selectIndex;
        SharedPreferencesUtils.INSTANCE.getSharedPreferences(this.mContext, "Live" + AccountUtil.getUid(), 0).edit().putInt("AudienceCodeRateMode", selectIndex).apply();
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ChannelNotifyDef.AUDIENCE_CODE_RATE_SWITCH, (Object)selectIndex));
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("function_id", "view_mode_pop").put("item", String.valueOf(selectIndex + 1)));
    }

    @Override
    public void showCodeRateDialog() {
        if (this.mDialogLinkManager == null) {
            return;
        }
        this.mDialogLinkManager.showDialog((BaseDialog)new SettingCodeRateDialog(this, this.mCurrentCodeRate));
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("function_id", "view_mode_click"));
    }

    @Override
    public void onPasswordManageClick() {
        AbstractWindow last;
        AbstractWindow abstractWindow = last = this.mSubWindow == null ? null : (AbstractWindow)this.mSubWindow.get();
        if (last != null && last.isAttachToWindow()) {
            this.mWindowMgr.popWindow(false, last);
            this.mSubWindow = null;
        }
        PasswordManageWindow win = new PasswordManageWindow(this.mContext, this);
        this.mSubWindow = new WeakReference<PasswordManageWindow>(win);
        this.mWindowMgr.pushWindow((AbstractWindow)win, true);
    }

    @Override
    public void onSetPasswordClick() {
        final AbstractWindow curWin = this.getCurrentWindow();
        MsgDispatcher.getInstance().sendMessage(LoginMsgDef.MSG_LOGIN_SET_PWD);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SettingController.this.mSubWindow != null && SettingController.this.mSubWindow.get() == curWin) {
                    SettingController.this.mWindowMgr.popWindow(false, curWin);
                }
            }
        });
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "set_password_click"));
    }

    @Override
    public void onResetPasswordClick() {
        final AbstractWindow curWin = this.getCurrentWindow();
        MsgDispatcher.getInstance().sendMessage(LoginMsgDef.MSG_LOGIN_RESET_PWD);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (SettingController.this.mSubWindow != null && SettingController.this.mSubWindow.get() == curWin) {
                    SettingController.this.mWindowMgr.popWindow(false, curWin);
                }
            }
        });
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("function_id", "reset_password_click"));
    }

    private void initCodeRateSetting() {
        boolean showCodeRate = SharedPreferencesUtils.INSTANCE.getSharedPreferences(this.mContext, "Live" + AccountUtil.getUid(), 0).getBoolean("ShowAudienceCodeRateSetting", false);
        if (showCodeRate) {
            this.mCurrentCodeRate = SharedPreferencesUtils.INSTANCE.getSharedPreferences(this.mContext, "Live" + AccountUtil.getUid(), 0).getInt("AudienceCodeRateMode", 0);
            this.mWindow.getPager().showCodeRateSetting();
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026523").put("function_id", "view_mode_show"));
        }
    }

    private static void statLoginOutDialog(final boolean chooseFeedBack, final boolean chooseSignOut, final boolean cancel) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                StatisContent statContent = new StatisContent();
                statContent.put("act", "hagoperf");
                if (chooseSignOut) {
                    statContent.put("ifield", 1);
                } else if (chooseFeedBack) {
                    statContent.put("ifield", 2);
                } else if (cancel) {
                    statContent.put("ifield", 3);
                }
                statContent.put("perftype", "ssignout");
                HiidoStatis.reportContent((StatisContent)statContent);
            }
        });
    }
}

