/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.envsetting.hookview;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.yy.base.logger.MLog;
import com.yy.base.utils.printview.PrintViewUtils;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.main.R;
import com.yy.hiyo.module.setting.envsetting.hookview.FloatingMagnetView;
import com.yy.hiyo.module.setting.envsetting.hookview.IFloatingView;
import com.yy.hiyo.module.setting.envsetting.hookview.ViewInspectUtil;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;

public class FloatingView
implements IFloatingView {
    private static final String TAG = "FloatingView";
    private FloatingMagnetView mEnFloatingView;
    private static volatile FloatingView mInstance;
    private WeakReference<FrameLayout> mContainer;
    private Activity attachedActivity;
    private IFloatingView.FloatingCallback floatingCallback;
    private int marginLeftRight = 15;
    private int marginBottom = 400;
    private ViewGroup.LayoutParams mLayoutParams = this.getParams();
    private LinkedList<View> mViews = new LinkedList();
    private View curView;

    @Override
    public void setFloatingCallback(IFloatingView.FloatingCallback floatingCallback) {
        this.floatingCallback = floatingCallback;
    }

    @Override
    public void updateViews(LinkedList<View> views) {
        this.curView = views.getFirst();
        this.mViews.clear();
        this.mViews.addAll(views);
    }

    @Override
    public void updateViewInfo(@NotNull String info) {
        if (this.getView() != null) {
            ((TextView)this.getView().findViewById(R.id.viewInfo)).setText((CharSequence)info);
        }
    }

    @Override
    public void updateLockStatus(boolean locked) {
        if (this.getView() != null) {
            ((ImageView)this.getView().findViewById(R.id.iconLock)).setImageResource(locked ? R.drawable.ic_lock : R.drawable.ic_unlock);
        }
    }

    private FloatingView() {
        this.registerActivity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FloatingView get() {
        if (mInstance != null) return mInstance;
        Class<FloatingView> clazz = FloatingView.class;
        synchronized (FloatingView.class) {
            if (mInstance != null) return mInstance;
            mInstance = new FloatingView();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    @Override
    public FloatingView remove() {
        new Handler(Looper.getMainLooper()).post(new Runnable(){

            @Override
            public void run() {
                if (FloatingView.this.mEnFloatingView == null) {
                    return;
                }
                if (ViewCompat.isAttachedToWindow((View)FloatingView.this.mEnFloatingView) && FloatingView.this.getContainer() != null) {
                    FloatingView.this.getContainer().removeView((View)FloatingView.this.mEnFloatingView);
                }
                FloatingView.this.mEnFloatingView = null;
            }
        });
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureFloatingView() {
        FloatingView floatingView = this;
        synchronized (floatingView) {
            if (this.mEnFloatingView == null) {
                return;
            }
            this.mEnFloatingView.setLayoutParams(this.mLayoutParams);
            this.addViewToWindow((View)this.mEnFloatingView);
        }
    }

    public FloatingView add() {
        this.ensureFloatingView();
        return this;
    }

    @Override
    public FloatingView attach(Activity activity) {
        this.attachedActivity = activity;
        this.attach(this.getActivityRoot(activity));
        return this;
    }

    @Override
    public FloatingView attach(FrameLayout container) {
        if (container == null || this.mEnFloatingView == null) {
            this.mContainer = new WeakReference<FrameLayout>(container);
            return this;
        }
        if (this.mEnFloatingView.getParent() == container) {
            return this;
        }
        if (this.mEnFloatingView.getParent() != null) {
            ((ViewGroup)this.mEnFloatingView.getParent()).removeView((View)this.mEnFloatingView);
        }
        this.mContainer = new WeakReference<FrameLayout>(container);
        container.addView((View)this.mEnFloatingView);
        return this;
    }

    @Override
    public FloatingView detach(Activity activity) {
        this.detach(this.getActivityRoot(activity));
        this.attachedActivity = null;
        return this;
    }

    @Override
    public FloatingView detach(FrameLayout container) {
        if (this.mEnFloatingView != null && container != null && ViewCompat.isAttachedToWindow((View)this.mEnFloatingView)) {
            container.removeView((View)this.mEnFloatingView);
        }
        if (this.getContainer() == container) {
            this.mContainer = null;
        }
        return this;
    }

    @Override
    public FloatingMagnetView getView() {
        return this.mEnFloatingView;
    }

    @Override
    public FloatingView show() {
        if (this.mEnFloatingView == null) {
            if (this.attachedActivity == null) {
                this.attachedActivity = ViewInspectUtil.getRunningActivity();
            }
            this.mEnFloatingView = (FloatingMagnetView)LayoutInflater.from((Context)this.attachedActivity).inflate(R.layout.layout_float, null);
            this.mEnFloatingView.findViewById(R.id.btnClose).setOnClickListener(v -> this.remove());
            this.mEnFloatingView.findViewById(R.id.btnParent).setOnClickListener(v -> {
                if (this.floatingCallback == null) {
                    return;
                }
                if (this.mViews != null && !this.mViews.isEmpty() && this.mViews.contains(this.curView)) {
                    ViewInspectUtil.clearViewBorder(this.curView);
                    int index = this.mViews.indexOf(this.curView);
                    if (++index >= this.mViews.size()) {
                        index = this.mViews.size() - 1;
                    }
                    this.curView = this.mViews.get(index);
                    this.floatingCallback.onShowParent(this.curView);
                }
            });
            this.mEnFloatingView.findViewById(R.id.btnChild).setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (FloatingView.this.floatingCallback == null) {
                        return;
                    }
                    if (FloatingView.this.mViews != null && !FloatingView.this.mViews.isEmpty() && FloatingView.this.mViews.contains(FloatingView.this.curView)) {
                        ViewInspectUtil.clearViewBorder(FloatingView.this.curView);
                        int index = FloatingView.this.mViews.indexOf(FloatingView.this.curView);
                        if (--index < 0) {
                            index = 0;
                        }
                        FloatingView.this.curView = (View)FloatingView.this.mViews.get(index);
                        FloatingView.this.floatingCallback.onShowChild(FloatingView.this.curView);
                    }
                }
            });
            this.mEnFloatingView.findViewById(R.id.iconLock).setOnClickListener(v -> {
                if (this.floatingCallback != null) {
                    this.floatingCallback.onLockSwitch();
                }
            });
            this.mEnFloatingView.findViewById(R.id.hookTrigger).setOnClickListener(v -> {
                if (this.floatingCallback != null) {
                    this.floatingCallback.onTriggerHook();
                }
                PrintViewUtils.viewTraversal((View)this.attachedActivity.findViewById(0x1020002), (Function2)new Function2<View, Integer, Boolean>(){
                    private boolean isWindowPrinted = false;
                    private final String[] indent = new String[]{"|  ", "!  ", "\u00a1  ", ":  ", "*  ", "\u2022  ", ".  "};

                    public Boolean invoke(View view, Integer depth) {
                        if (view instanceof DefaultWindow) {
                            if (this.isWindowPrinted) {
                                return false;
                            }
                            this.isWindowPrinted = true;
                        }
                        StringBuilder sBuilder = new StringBuilder();
                        for (int i = 0; i < depth; ++i) {
                            sBuilder.append(this.indent[i % this.indent.length]);
                        }
                        sBuilder.append(view.getClass().getSimpleName());
                        sBuilder.append(" - hashCode:").append(view.hashCode());
                        String idName = "";
                        try {
                            idName = view.getResources().getResourceEntryName(view.getId());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        sBuilder.append(" - id: ").append(idName);
                        sBuilder.append(" - layoutLeft:").append(view.getLeft());
                        sBuilder.append(" - layoutTop:").append(view.getTop());
                        sBuilder.append(" - layoutRight:").append(view.getRight());
                        sBuilder.append(" - layoutBottom:").append(view.getBottom());
                        sBuilder.append(" - width:").append(view.getWidth());
                        sBuilder.append(" - height:").append(view.getHeight());
                        sBuilder.append(" - visible:").append(view.getVisibility());
                        sBuilder.append(" - alpha:").append(view.getAlpha());
                        if (view instanceof TextView) {
                            sBuilder.append(" - text:").append(((TextView)view).getText());
                        }
                        sBuilder.append('\n');
                        MLog.info((Object)FloatingView.TAG, (String)sBuilder.toString(), (Object[])new Object[0]);
                        return true;
                    }
                });
            });
        }
        this.add().attach(this.attachedActivity);
        return this;
    }

    public FloatingView customView(FloatingMagnetView viewGroup) {
        this.mEnFloatingView = viewGroup;
        return this;
    }

    public FloatingView layoutParams(ViewGroup.LayoutParams params) {
        this.mLayoutParams = params;
        if (this.mEnFloatingView != null) {
            this.mEnFloatingView.setLayoutParams(params);
        }
        return this;
    }

    private void addViewToWindow(View view) {
        if (this.getContainer() == null) {
            return;
        }
        if (this.getContainer().indexOfChild(view) >= 0) {
            Log.w((String)TAG, (String)"addViewToWindow has been add");
            return;
        }
        this.getContainer().addView(view);
    }

    private FrameLayout getContainer() {
        if (this.mContainer == null) {
            return null;
        }
        return (FrameLayout)this.mContainer.get();
    }

    private FrameLayout.LayoutParams getParams() {
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-2, -2);
        params.gravity = 0x800055;
        params.setMargins(this.marginLeftRight, params.topMargin, this.marginLeftRight, this.marginBottom);
        return params;
    }

    private FrameLayout getActivityRoot(Activity activity) {
        if (activity == null) {
            return null;
        }
        try {
            return (FrameLayout)activity.getWindow().getDecorView().findViewById(0x1020002);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void registerActivity() {
        ViewInspectUtil.getApp().registerActivityLifecycleCallbacks(new Application.ActivityLifecycleCallbacks(){

            public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
            }

            public void onActivityStarted(@NonNull Activity activity) {
                FloatingView.this.attach(activity);
            }

            public void onActivityResumed(@NonNull Activity activity) {
            }

            public void onActivityPaused(@NonNull Activity activity) {
            }

            public void onActivityStopped(@NonNull Activity activity) {
                FloatingView.this.detach(activity);
            }

            public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
            }

            public void onActivityDestroyed(@NonNull Activity activity) {
            }
        });
    }
}

