/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.setting.envsetting.hagologanalyse;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hago.xlog.KLogUtils;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.Analyser;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.ILogControllerCallBack;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.LogAnalyseMainWindow;
import com.yy.hiyo.module.setting.envsetting.hagologanalyse.data.LogItem;
import java.io.File;
import java.util.ArrayList;

public class FileSelectWindow
extends DefaultWindow {
    private File[] mFiles;
    private ListView mResultListView;
    private BaseAdapter mResultListViewAdapter;
    private ArrayList<LogItem> mResultItems;
    private View mLastSelectFileView;
    private FrameLayout mLayout;
    private ILogControllerCallBack myCallBack;

    public FileSelectWindow(Context context, ILogControllerCallBack callBacks) {
        super(context, callBacks.getUICallBacks(), "LogFileSelectWindow");
        this.myCallBack = callBacks;
        YYLinearLayout layout2 = new YYLinearLayout(context);
        layout2.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        layout2.setOrientation(1);
        this.getBaseLayer().setBackgroundColor(-1);
        this.getBaseLayer().addView((View)layout2);
        LogAnalyseMainWindow.initTitleBar(context, (ViewGroup)layout2, new View.OnClickListener(){

            public void onClick(View view) {
                if (FileSelectWindow.this.myCallBack != null) {
                    FileSelectWindow.this.myCallBack.onBackIconClicked((AbstractWindow)FileSelectWindow.this);
                }
            }
        });
        FrameLayout containerLayout = new FrameLayout(context);
        containerLayout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        this.mLayout = containerLayout;
        layout2.addView((View)this.mLayout);
        this.initFiles();
    }

    private void show() {
        Analyser.sContext = this.getContext();
        int screenHeight = ((Activity)this.getContext()).getWindowManager().getDefaultDisplay().getHeight();
        ListView listView = new ListView(this.getContext());
        listView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, (screenHeight -= FileSelectWindow.dip2px(this.getContext(), 100.0f)) / 2));
        listView.setAdapter((ListAdapter)new BaseAdapter(){

            public int getCount() {
                if (FileSelectWindow.this.mFiles == null || FileSelectWindow.this.mFiles.length == 0) {
                    return 0;
                }
                return FileSelectWindow.this.mFiles.length;
            }

            public Object getItem(int position) {
                if (FileSelectWindow.this.mFiles == null || FileSelectWindow.this.mFiles.length == 0) {
                    return "";
                }
                return FileSelectWindow.this.mFiles[position];
            }

            public long getItemId(int position) {
                return 0L;
            }

            public boolean isEnabled(int position) {
                return true;
            }

            public View getView(int position, View convertView, ViewGroup parent) {
                TextView line = null;
                if (!(convertView instanceof TextView)) {
                    line = new TextView(FileSelectWindow.this.getContext());
                    line.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, FileSelectWindow.dip2px(FileSelectWindow.this.getContext(), 50.0f)));
                    line.setTextColor(-65536);
                    line.setTextSize(2, 15.0f);
                    line.setGravity(16);
                    line.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            if (FileSelectWindow.this.mLastSelectFileView != null) {
                                FileSelectWindow.this.mLastSelectFileView.setBackgroundColor(0);
                            }
                            Object item = this.getItem((Integer)v.getTag());
                            FileSelectWindow.this.mLastSelectFileView = v;
                            v.setBackgroundColor(-7829368);
                            if (item instanceof File) {
                                FileSelectWindow.this.mResultItems = Analyser.parseFile((File)item);
                                FileSelectWindow.this.mResultListViewAdapter.notifyDataSetChanged();
                            }
                        }
                    });
                } else {
                    line = (TextView)convertView;
                }
                line.setBackgroundColor(0);
                line.setTag((Object)position);
                Object item = this.getItem(position);
                line.setText((CharSequence)(item == null ? "" : ((File)item).getName()));
                return line;
            }
        });
        listView.setScrollbarFadingEnabled(false);
        ListView listViewResult = new ListView(this.getContext());
        listViewResult.setBackgroundColor(-256);
        this.mResultListView = listViewResult;
        this.mResultListViewAdapter = new BaseAdapter(){

            public int getCount() {
                if (FileSelectWindow.this.mResultItems == null || FileSelectWindow.this.mResultItems.size() == 0) {
                    return 0;
                }
                return FileSelectWindow.this.mResultItems.size();
            }

            public Object getItem(int position) {
                if (FileSelectWindow.this.mResultItems == null || FileSelectWindow.this.mResultItems.size() == 0) {
                    return 0;
                }
                return FileSelectWindow.this.mResultItems.get(position);
            }

            public long getItemId(int position) {
                return 0L;
            }

            public View getView(int position, View convertView, ViewGroup parent) {
                TextView line = null;
                if (!(convertView instanceof TextView)) {
                    line = new TextView(FileSelectWindow.this.getContext());
                    line.setLayoutParams((ViewGroup.LayoutParams)new AbsListView.LayoutParams(-1, FileSelectWindow.dip2px(FileSelectWindow.this.getContext(), 50.0f)));
                    line.setTextColor(-65536);
                    line.setTextSize(2, 15.0f);
                    line.setGravity(16);
                } else {
                    line = (TextView)convertView;
                }
                Object item = this.getItem(position);
                if (item instanceof LogItem) {
                    final LogItem logItem = (LogItem)item;
                    line.setText((CharSequence)("size:" + logItem.charNum + " " + logItem.percent + "% tag:" + logItem.tag));
                    line.setOnClickListener(new View.OnClickListener(){

                        public void onClick(View v) {
                            FileSelectWindow.this.myCallBack.openLogDetail(logItem);
                        }
                    });
                }
                return line;
            }
        };
        FrameLayout.LayoutParams layout2 = new FrameLayout.LayoutParams(-1, screenHeight / 2);
        layout2.topMargin = screenHeight / 2;
        listViewResult.setLayoutParams((ViewGroup.LayoutParams)layout2);
        listViewResult.setAdapter((ListAdapter)this.mResultListViewAdapter);
        listViewResult.setScrollbarFadingEnabled(false);
        this.mLayout.addView((View)listView);
        this.mLayout.addView((View)listViewResult);
    }

    private void initFiles() {
        File[] files = KLogUtils.getLogFileList();
        if (files != null) {
            this.mFiles = new File[files.length + 1];
            if (files.length > 0) {
                this.mFiles[0] = files[0].getParentFile();
                for (int i = 0; i < files.length; ++i) {
                    this.mFiles[i + 1] = files[i];
                }
            }
        }
        this.show();
    }

    public static int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

