/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.screenshot;

import android.content.Context;
import android.database.ContentObserver;
import android.database.Cursor;
import android.net.Uri;
import android.os.Handler;
import android.provider.MediaStore;
import android.text.TextUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.hiyo.module.screenshot.ScreenShotDialog;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.socialplatformbase.data.ShareData;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ScreenShotHelper
implements ScreenShotDialog.ScreenShotCallback,
ISharePage {
    private String mPreFileName = "";
    private static final String[] KEYWORDS = new String[]{"screenshot", "screen_shot", "screen-shot", "screen shot", "screencapture", "screen_capture", "screen-capture", "screen capture", "screencap", "screen_cap", "screen-cap", "screen cap", "\u622a\u5c4f"};
    private static final String[] MEDIA_PROJECTIONS = new String[]{"_data", "datetaken"};
    private ContentObserver mInternalObserver;
    private ContentObserver mExternalObserver;
    private IIntlShareService shareService;
    private Handler mHandler;
    private Context mContext;

    public ScreenShotHelper(Context context, @NotNull IIntlShareService shareService) {
        this.mContext = context;
        this.shareService = shareService;
    }

    public void start() {
        this.mHandler = YYTaskExecutor.getLooperThreadHandler();
        this.mInternalObserver = new MediaContentObserver(MediaStore.Images.Media.INTERNAL_CONTENT_URI, this.mHandler, this.mContext);
        this.mExternalObserver = new MediaContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, this.mHandler, this.mContext);
        if (this.mContext != null) {
            this.mContext.getContentResolver().registerContentObserver(MediaStore.Images.Media.INTERNAL_CONTENT_URI, false, this.mInternalObserver);
            this.mContext.getContentResolver().registerContentObserver(MediaStore.Images.Media.EXTERNAL_CONTENT_URI, false, this.mExternalObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMediaContentChange(Uri contentUri, Context context) {
        long screenshotTime = System.currentTimeMillis();
        Cursor cursor = null;
        try {
            cursor = context.getContentResolver().query(contentUri, MEDIA_PROJECTIONS, "_data like? OR _data like?", new String[]{"%screen%", "%\u622a\u5c4f%"}, "date_added");
            if (cursor == null) {
                return;
            }
            if (!cursor.moveToFirst()) {
                return;
            }
            String data = "";
            long dateTaken = 0L;
            while (cursor.moveToNext()) {
                int dataIndex = cursor.getColumnIndex("_data");
                int dateTakenIndex = cursor.getColumnIndex("datetaken");
                dateTaken = cursor.getLong(dateTakenIndex);
                if (dateTaken >= screenshotTime) continue;
                data = cursor.getString(dataIndex);
            }
            if (TextUtils.isEmpty((CharSequence)data) || dateTaken == 0L) {
                return;
            }
            this.handleMediaRowData(data, dateTaken);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    public void stop() {
        if (this.mContext != null) {
            this.mContext.getContentResolver().unregisterContentObserver(this.mInternalObserver);
            this.mContext.getContentResolver().unregisterContentObserver(this.mExternalObserver);
        }
    }

    private void handleMediaRowData(final String data, long dateTaken) {
        if (this.mContext == null) {
            return;
        }
        MLog.info((Object)"ScreenShot", (String)("\u622a\u5c4f\u83b7\u53d6\u5230\u7684\u6570\u636e:" + data), (Object[])new Object[0]);
        if (this.checkScreenShot(data, dateTaken)) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ScreenShotDialog screenShotDialog = new ScreenShotDialog(ScreenShotHelper.this.mContext, ScreenShotHelper.this);
                    screenShotDialog.loadImage(data);
                    if (RuntimeContext.sIsForeground) {
                        screenShotDialog.show();
                    }
                }
            });
        }
    }

    private boolean checkScreenShot(String data, long dateTaken) {
        if (this.mPreFileName.equals(data = data.toLowerCase())) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime > dateTaken && currentTime - dateTaken > 10000L) {
            return false;
        }
        for (String keyWork : KEYWORDS) {
            if (!data.contains(keyWork)) continue;
            this.mPreFileName = data;
            return true;
        }
        return false;
    }

    @Override
    public List<BaseShareChannel> getShareChannels() {
        return this.shareService.getChannelsByPage((ISharePage)this);
    }

    @Override
    public void share(int channelId, String shareImagePath) {
        ShareData shareData = ShareData.builder().type(1).to(1).imgPath(shareImagePath).systemShare(true).build();
        this.shareService.share(channelId, shareData);
    }

    public String getPageName() {
        return "game_screenshot_share_page";
    }

    private class MediaContentObserver
    extends ContentObserver {
        private Context mContext;
        private Uri mContentUri;

        MediaContentObserver(Uri contentUri, Handler handler, Context context) {
            super(handler);
            this.mContentUri = contentUri;
            this.mContext = context;
        }

        public void onChange(boolean selfChange) {
            super.onChange(selfChange);
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    ScreenShotHelper.this.handleMediaContentChange(MediaContentObserver.this.mContentUri, MediaContentObserver.this.mContext);
                }
            }, (long)600L);
        }
    }
}

