/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.screenshot;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.os.Environment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.bumptech.glide.load.DataSource;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.BitmapUtils;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ScreenUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.R;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.main.R;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.List;

public class ScreenShotDialog
extends YYDialog
implements View.OnClickListener {
    private TextView mIvClose;
    private RecycleImageView mIvContent;
    private YYFrameLayout mFlContent;
    private YYRelativeLayout mRlRoot;
    private YYLinearLayout mLlContent;
    private YYLinearLayout mLlShareContent;
    private RecycleImageView mIvShareContent;
    private YYFrameLayout mFlShareContent;
    private LinearLayout mLlSharePlatformContainer;
    private ScreenShotCallback callback;

    public ScreenShotDialog(Context context, ScreenShotCallback callback) {
        super(context, R.style.Dialog_Fullscreen);
        this.callback = callback;
        View root = LayoutInflater.from((Context)context).inflate(R.layout.layout_share_float_layer, null);
        this.setContentView(root);
        this.findViews(root);
        this.initChannels();
    }

    private void findViews(View root) {
        this.mIvClose = (TextView)root.findViewById(R.id.iv_share_close);
        this.mIvContent = (RecycleImageView)root.findViewById(R.id.iv_share_background);
        this.mFlContent = (YYFrameLayout)root.findViewById(R.id.fl_share_content);
        this.mRlRoot = (YYRelativeLayout)root.findViewById(R.id.rl_share_root);
        this.mLlContent = (YYLinearLayout)root.findViewById(R.id.ll_share_content);
        this.mIvShareContent = (RecycleImageView)root.findViewById(R.id.iv_share_background_view);
        this.mLlShareContent = (YYLinearLayout)root.findViewById(R.id.ll_share_content_view);
        this.mFlShareContent = (YYFrameLayout)root.findViewById(R.id.fl_share_content_view);
        this.mLlSharePlatformContainer = (LinearLayout)root.findViewById(R.id.share_platform_container);
        this.mIvClose.setOnClickListener((View.OnClickListener)this);
        this.mRlRoot.setOnClickListener((View.OnClickListener)this);
    }

    public void loadImage(String data) {
        int screenHeight = ScreenUtils.getInstance().getHeightPixels();
        int screenWidth = ScreenUtils.getInstance().getWidthPixels();
        RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)this.mFlContent.getLayoutParams();
        lp.topMargin = (int)(0.07 * (double)screenHeight);
        this.mFlContent.setLayoutParams((ViewGroup.LayoutParams)lp);
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)this.mLlContent.getLayoutParams();
        params.width = (int)(0.65 * (double)screenWidth);
        params.height = (int)(0.65 * (double)screenHeight);
        this.mLlContent.setLayoutParams((ViewGroup.LayoutParams)params);
        ImageLoader.with((ImageView)this.mIvContent, (String)data).skipMemCache(true).skipDiskCache(true).setListener((ImageLoader.BaseLoadListener)new ImageLoader.ImageLoadListener(){

            public void onLoadFailed(Exception e) {
            }

            public void onResourceReady(Object resource, boolean isFirstResource, DataSource dataSource) {
                ScreenShotDialog.this.mFlContent.setVisibility(0);
            }
        }).load();
        ImageLoader.with((ImageView)this.mIvShareContent, (String)data).skipMemCache(true).skipDiskCache(true).load();
    }

    private void initChannels() {
        if (this.callback == null) {
            return;
        }
        List<BaseShareChannel> channelList = this.callback.getShareChannels();
        if (channelList == null) {
            return;
        }
        for (BaseShareChannel shareChannel : channelList) {
            int marginValue;
            if (shareChannel.getId() == 6) continue;
            YYImageView shareIv = new YYImageView(this.getContext());
            int iconResId = 0;
            int idResId = 0;
            switch (shareChannel.getId()) {
                case 2: {
                    idResId = R.id.share_platform_whatsapp;
                    iconResId = R.drawable.ico_share_whatsapp;
                    break;
                }
                case 5: {
                    idResId = R.id.share_platform_facebook;
                    iconResId = R.drawable.ico_share_facebook;
                    break;
                }
                case 3: {
                    idResId = R.id.share_platform_instagram;
                    iconResId = R.drawable.ico_share_ins;
                    break;
                }
                case 1: {
                    idResId = R.id.share_platform_line;
                    iconResId = R.drawable.ico_share_line;
                    break;
                }
                case 9: {
                    idResId = R.id.share_platform_vk;
                    iconResId = R.drawable.ico_share_vk;
                    break;
                }
            }
            shareIv.setImageResource(iconResId);
            shareIv.setId(idResId);
            LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-2, -2);
            lp.leftMargin = marginValue = ResolutionUtils.dip2Px((float)12.0f);
            lp.rightMargin = marginValue;
            this.mLlSharePlatformContainer.addView((View)shareIv, (ViewGroup.LayoutParams)lp);
            shareIv.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onClick(View v) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.network_error), (int)0);
                }
            }
        });
        int id2 = v.getId();
        if (id2 == R.id.share_platform_instagram) {
            this.reportShare("4");
            this.saveShareBitmap(3);
        } else if (id2 == R.id.share_platform_line) {
            this.reportShare("2");
            this.saveShareBitmap(1);
        } else if (id2 == R.id.share_platform_facebook) {
            this.reportShare("1");
            this.saveShareBitmap(5);
        } else if (id2 == R.id.share_platform_whatsapp) {
            this.reportShare("3");
            this.saveShareBitmap(2);
        } else if (id2 == R.id.share_platform_vk) {
            this.saveShareBitmap(9);
            this.reportShare("6");
        } else if (id2 == R.id.iv_share_close || id2 == R.id.rl_share_root) {
            this.dismiss();
        }
    }

    private void saveShareBitmap(final int channelId) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String shareImagePath;
                String path = "";
                if (ScreenShotDialog.this.mFlShareContent != null) {
                    Bitmap bitmap = ScreenShotDialog.this.loadBitmapFromView((View)ScreenShotDialog.this.mFlShareContent);
                    try {
                        boolean isHasSDCard = Environment.getExternalStorageState().equals("mounted");
                        if (!isHasSDCard) {
                            throw new Exception("\u521b\u5efa\u6587\u4ef6\u5931\u8d25!");
                        }
                        File sdRoot = FileStorageUtils.getInstance().getTempDir();
                        File file = new File(sdRoot, "share.png");
                        FileOutputStream fos = new FileOutputStream(file);
                        path = file.getAbsolutePath();
                        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fos);
                        fos.flush();
                        fos.close();
                    }
                    catch (Exception e) {
                        MLog.info((Object)"ScreenShotDialog", (String)"\u521b\u5efa\u6587\u4ef6\u5931\u8d25", (Object[])new Object[0]);
                    }
                    finally {
                        if (bitmap != null) {
                            bitmap.recycle();
                            bitmap = null;
                        }
                    }
                }
                if (!TextUtils.isEmpty((CharSequence)(shareImagePath = path))) {
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (ScreenShotDialog.this.callback != null) {
                                ScreenShotDialog.this.callback.share(channelId, shareImagePath);
                            }
                            ScreenShotDialog.this.dismiss();
                        }
                    });
                }
            }
        });
    }

    private Bitmap loadBitmapFromView(View v) {
        int w = v.getWidth();
        int h = v.getHeight();
        Bitmap bmp = BitmapUtils.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas c = new Canvas(bmp);
        c.drawColor(-1);
        v.layout(0, 0, w, h);
        v.draw(c);
        return bmp;
    }

    private Bitmap deleteNoUseWhiteSpace(Bitmap originBitmap) {
        int h;
        int w;
        int w2;
        boolean holdBlackPix;
        int h2;
        int[] imgThePixels = new int[originBitmap.getWidth() * originBitmap.getHeight()];
        originBitmap.getPixels(imgThePixels, 0, originBitmap.getWidth(), 0, 0, originBitmap.getWidth(), originBitmap.getHeight());
        int top = 0;
        int left = 0;
        int right = 0;
        int bottom = 0;
        for (h2 = 0; h2 < originBitmap.getHeight(); ++h2) {
            holdBlackPix = false;
            for (w2 = 0; w2 < originBitmap.getWidth(); ++w2) {
                if (originBitmap.getPixel(w2, h2) == -1) continue;
                holdBlackPix = true;
                break;
            }
            if (holdBlackPix) break;
            ++top;
        }
        for (w = 0; w < originBitmap.getWidth(); ++w) {
            holdBlackPix = false;
            for (h = 0; h < originBitmap.getHeight(); ++h) {
                if (originBitmap.getPixel(w, h) == -1) continue;
                holdBlackPix = true;
                break;
            }
            if (holdBlackPix) break;
            ++left;
        }
        for (w = originBitmap.getWidth() - 1; w >= 0; --w) {
            holdBlackPix = false;
            for (h = 0; h < originBitmap.getHeight(); ++h) {
                if (originBitmap.getPixel(w, h) == -1) continue;
                holdBlackPix = true;
                break;
            }
            if (holdBlackPix) break;
            ++right;
        }
        for (h2 = originBitmap.getHeight() - 1; h2 >= 0; --h2) {
            holdBlackPix = false;
            for (w2 = 0; w2 < originBitmap.getWidth(); ++w2) {
                if (originBitmap.getPixel(w2, h2) == -1) continue;
                holdBlackPix = true;
                break;
            }
            if (holdBlackPix) break;
            ++bottom;
        }
        int cropHeight = originBitmap.getHeight() - bottom - top;
        int cropWidth = originBitmap.getWidth() - left - right;
        int[] newPix = new int[cropWidth * cropHeight];
        int i = 0;
        for (int h3 = top; h3 < top + cropHeight; ++h3) {
            for (int w3 = left; w3 < left + cropWidth; ++w3) {
                newPix[i++] = originBitmap.getPixel(w3, h3);
            }
        }
        return Bitmap.createBitmap((int[])newPix, (int)cropWidth, (int)cropHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
    }

    private void reportShare(String channel) {
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023801").put("function_id", "1").put("page_id", "2").put("share_channel", channel));
    }

    public static interface ScreenShotCallback {
        public List<BaseShareChannel> getShareChannels();

        public void share(int var1, String var2);
    }
}

