/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.screenshot;

import android.content.DialogInterface;
import android.os.Message;
import com.google.gson.annotations.SerializedName;
import com.yy.appbase.core.DefaultController;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.hiyo.module.screenshot.ScreenShotDialog;
import com.yy.hiyo.share.base.BaseShareChannel;
import com.yy.hiyo.share.base.IIntlShareService;
import com.yy.hiyo.share.base.ISharePage;
import com.yy.socialplatformbase.data.ShareData;
import java.io.File;
import java.util.List;

public class GameScreenShotController
extends DefaultController
implements ScreenShotDialog.ScreenShotCallback,
ISharePage {
    private static final String TAG = "GameScreenShotController";

    public GameScreenShotController(Environment env) {
        super(env);
    }

    public void handleMessage(Message msg) {
        if (msg.what == BaseMsgDef.MSG_GAME_SCREEN_SHOT_SHARE) {
            String json = (String)msg.obj;
            this.handleShowShare(json);
        }
    }

    private void handleShowShare(final String jsonData) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                GameScreenShotInfo gameScreenShotInfo = GameScreenShotController.this.parseFromJson(jsonData);
                if (gameScreenShotInfo == null) {
                    return;
                }
                final String imgPath = gameScreenShotInfo.imagePath;
                if (!GameScreenShotController.this.checkImage(imgPath)) {
                    return;
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!RuntimeContext.sIsForeground) {
                            return;
                        }
                        ScreenShotDialog screenShotDialog = new ScreenShotDialog(GameScreenShotController.this.mContext, GameScreenShotController.this);
                        screenShotDialog.loadImage(imgPath);
                        screenShotDialog.setOnDismissListener(new DialogInterface.OnDismissListener(){

                            public void onDismiss(DialogInterface dialog) {
                                GameScreenShotController.this.deleteImageAsync(imgPath);
                            }
                        });
                        screenShotDialog.show();
                    }
                });
            }
        });
    }

    private GameScreenShotInfo parseFromJson(String json) {
        if (FP.empty((CharSequence)json)) {
            return null;
        }
        GameScreenShotInfo gameScreenShotInfo = null;
        try {
            gameScreenShotInfo = (GameScreenShotInfo)JsonParser.parseJsonObject((String)json, GameScreenShotInfo.class);
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"parseFromJson error", (Object[])new Object[0]);
        }
        return gameScreenShotInfo;
    }

    private boolean checkImage(String imgPath) {
        return YYFileUtils.isFileExisted((String)imgPath);
    }

    private void deleteImageAsync(final String imgPath) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                YYFileUtils.delete((File)new File(imgPath));
            }
        });
    }

    @Override
    public List<BaseShareChannel> getShareChannels() {
        return ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).getChannelsByPage((ISharePage)this);
    }

    @Override
    public void share(int channelId, String shareImagePath) {
        ShareData shareData = ShareData.builder().type(1).to(1).imgPath(shareImagePath).systemShare(true).build();
        ((IIntlShareService)this.getServiceManager().getService(IIntlShareService.class)).share(channelId, shareData);
    }

    public String getPageName() {
        return "game_screenshot_share_page";
    }

    class GameScreenShotInfo {
        @SerializedName(value="imagePath")
        private String imagePath;

        GameScreenShotInfo() {
        }
    }
}

