/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.push.lockscreen;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.app.WallpaperManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.os.Bundle;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.Window;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import androidx.annotation.Nullable;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.callback.SimpleAnimatorListener;
import com.yy.appbase.push.NotificationManager;
import com.yy.appbase.push.PushNotification;
import com.yy.appbase.push.PushNotificationData;
import com.yy.appbase.push.lockscreen.LockScreenInfo;
import com.yy.appbase.push.lockscreen.LockScreenPushManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.hiyo.main.R;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.msg.StyleType;
import org.json.JSONObject;

public class LockScreenPushActivity
extends FragmentActivity
implements View.OnClickListener,
View.OnTouchListener {
    private static final String TAG = "LockScreenPushActivity";
    private View mViewContainer;
    private View mBtnGo;
    private View mBtnClose;
    private YYTextView mTvTitle;
    private YYTextView mTvContent;
    private RecycleImageView mIvHead;
    private View mSlideView;
    private View mRootView;
    private LockScreenInfo mScreenInfo;
    private static final int SLIDE_DISTANCE = 350;
    private boolean isAnimating = false;
    private int mScreenWidth;
    private int mOrientation = 1;
    private float mStartY;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LockScreenInfo info = null;
        if (this.getIntent() != null && this.getIntent().getParcelableExtra("lock_data_info") != null) {
            info = (LockScreenInfo)this.getIntent().getParcelableExtra("lock_data_info");
        }
        if (info == null) {
            MLog.error((Object)TAG, (String)"onCreate LockScreenInfo is null!!!!!!", (Object[])new Object[0]);
            this.finish();
            return;
        }
        Window window = this.getWindow();
        window.addFlags(0x4000000);
        window.addFlags(0x480000);
        this.setContentView(R.layout.activity_lock_screen_layout);
        this.mRootView = this.findViewById(R.id.rl_root_view);
        try {
            if (FileStorageUtils.isStoragePermissionGranted((Context)this)) {
                Drawable drawable2 = WallpaperManager.getInstance((Context)this).getDrawable();
                this.mRootView.setBackgroundDrawable(drawable2);
            }
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"getDrawable fail", (Throwable)e, (Object[])new Object[0]);
        }
        LockScreenPushManager.getInstance().setShowingLockActivity(true);
        this.mScreenInfo = info;
        this.mScreenWidth = ResolutionUtils.getScreenWidth((Context)this);
        if (this.mScreenWidth <= 0) {
            this.mScreenWidth = ResolutionUtils.dip2Px((float)390.0f);
        }
        this.mOrientation = this.getResources().getConfiguration().orientation;
        this.initView();
        this.reportShowLockPush();
        MLog.info((Object)TAG, (String)"onCreate!!!!!!!", (Object[])new Object[0]);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (newConfig != null) {
            this.updateLayoutChannged(newConfig.orientation);
        }
        MLog.info((Object)TAG, (String)"onConfigurationChanged!!!!!!!", (Object[])new Object[0]);
    }

    private void updateLayoutChannged(int orientation) {
        if (this.mOrientation == orientation) {
            return;
        }
        this.mOrientation = orientation;
        this.updateViewLayoutParams();
    }

    private void updateViewLayoutParams() {
        this.mViewContainer.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                LockScreenPushActivity.this.mViewContainer.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                MLog.info((Object)LockScreenPushActivity.TAG, (String)"addOnGlobalLayoutListener or: %s  slide Top: %s  mmViewContainer bottom: %s", (Object[])new Object[]{LockScreenPushActivity.this.mOrientation, LockScreenPushActivity.this.mSlideView.getTop(), LockScreenPushActivity.this.mViewContainer.getBottom()});
                try {
                    LockScreenPushActivity.this.changeLayout();
                }
                catch (Exception e) {
                    MLog.info((Object)LockScreenPushActivity.TAG, (String)"updateViewLayoutParams changeLayout ex: %s", (Object[])new Object[]{e});
                }
            }
        });
    }

    private void changeLayout() {
        if (this.mOrientation == 1) {
            RelativeLayout.LayoutParams mViewContainerLayoutParams = new RelativeLayout.LayoutParams(this.mScreenWidth, -2);
            mViewContainerLayoutParams.addRule(13);
            this.mViewContainer.setLayoutParams((ViewGroup.LayoutParams)mViewContainerLayoutParams);
            RelativeLayout.LayoutParams slideContainerLayoutParams = (RelativeLayout.LayoutParams)this.mSlideView.getLayoutParams();
            slideContainerLayoutParams.bottomMargin = ResolutionUtils.dip2Px((float)28.0f);
            this.mSlideView.setLayoutParams((ViewGroup.LayoutParams)slideContainerLayoutParams);
        } else if (this.mSlideView.getTop() - this.mViewContainer.getBottom() < ResolutionUtils.dip2Px((float)10.0f)) {
            RelativeLayout.LayoutParams mViewContainerLayoutParams = new RelativeLayout.LayoutParams(this.mScreenWidth, -2);
            mViewContainerLayoutParams.addRule(14);
            this.mViewContainer.setLayoutParams((ViewGroup.LayoutParams)mViewContainerLayoutParams);
            RelativeLayout.LayoutParams slideContainerLayoutParams = (RelativeLayout.LayoutParams)this.mSlideView.getLayoutParams();
            slideContainerLayoutParams.bottomMargin = 0;
            this.mSlideView.setLayoutParams((ViewGroup.LayoutParams)slideContainerLayoutParams);
        }
    }

    private void reportShowLockPush() {
        String gid = "";
        String msgId = "";
        int pushType = -1;
        int channelType = 0;
        if (!FP.empty((CharSequence)this.mScreenInfo.payload)) {
            try {
                JSONObject payloadJson = JsonParser.obtainJSONObject((String)this.mScreenInfo.payload);
                if (payloadJson.has("push_type")) {
                    pushType = payloadJson.optInt("push_type");
                }
                if (payloadJson.has("jump")) {
                    String jump = payloadJson.optString("jump");
                    JSONObject jumpPayload = JsonParser.obtainJSONObject((String)jump);
                    if (jumpPayload.has("gameid")) {
                        gid = jumpPayload.optString("gameid");
                    }
                    if (jumpPayload.has("msgid")) {
                        msgId = jumpPayload.optString("msgid");
                    }
                }
                channelType = PushNotification.Companion.getChannelIdByChannelSource(this.mScreenInfo.pushSource, payloadJson);
            }
            catch (Exception e) {
                MLog.info((Object)TAG, (String)"reportShowLockPush json: %s", (Object[])new Object[]{e});
            }
        }
        HiidoEvent event = HiidoEvent.obtain().eventId("20025571").put("push_source", this.mScreenInfo.pushSource).put("function_id", "show").put("channel", this.mScreenInfo.channelType).put("gid", gid).put("msg_id", msgId).put("push_id", String.valueOf(this.mScreenInfo.pushId)).put("push_type", String.valueOf(pushType)).put("push_style", String.valueOf(this.mScreenInfo.style)).put("app_foreground", RuntimeContext.sIsForeground ? "1" : "0").put("offline_msg", this.mScreenInfo.isOfflineMsg ? "1" : "0");
        if (channelType > 0) {
            event.put("channel_type", String.valueOf(channelType));
        }
        HiidoStatis.reportEvent((HiidoEvent)event);
    }

    private void initView() {
        if (this.mScreenInfo.style == StyleType.StyleTypeLockScreen1.getValue() && !FP.empty((CharSequence)this.mScreenInfo.avatar)) {
            this.mViewContainer = this.findViewById(R.id.rl_pic_container);
            this.mIvHead = (RecycleImageView)this.findViewById(R.id.iv_pic_head);
            this.mBtnClose = this.findViewById(R.id.iv_pic_close);
            this.mTvContent = (YYTextView)this.findViewById(R.id.tv_pic_desc);
            this.mTvTitle = (YYTextView)this.findViewById(R.id.tv_pic_title);
            this.mBtnGo = this.findViewById(R.id.tv_pic_go);
            this.updateImagePushPic(this.mScreenInfo.avatar);
        } else {
            this.mViewContainer = this.findViewById(R.id.rl_text_container);
            this.mBtnClose = this.findViewById(R.id.iv_text_close);
            this.mTvTitle = (YYTextView)this.findViewById(R.id.tv_text_title);
            this.mTvContent = (YYTextView)this.findViewById(R.id.tv_text_desc);
            this.mBtnGo = this.findViewById(R.id.tv_text_go);
        }
        this.mViewContainer.setVisibility(0);
        this.mSlideView = this.findViewById(R.id.ll_slide_arrow);
        this.mSlideView.setOnTouchListener((View.OnTouchListener)this);
        GradientDrawable mGoDrawable = new GradientDrawable();
        mGoDrawable.setColor(ColorUtils.parseColor((String)"#ff4a6d"));
        mGoDrawable.setCornerRadius((float)ResolutionUtils.dip2Px((float)3.0f));
        this.mBtnGo.setBackground((Drawable)mGoDrawable);
        this.mBtnGo.setOnClickListener((View.OnClickListener)this);
        this.mViewContainer.setOnClickListener((View.OnClickListener)this);
        this.mBtnClose.setOnClickListener((View.OnClickListener)this);
        this.updatePushContent(this.mScreenInfo.title, this.mScreenInfo.content);
        this.updateViewLayoutParams();
    }

    public void updatePushContent(String title, String content) {
        this.mTvContent.setText((CharSequence)content);
        this.mTvTitle.setText((CharSequence)title);
    }

    public void updateImagePushPic(String url) {
        ImageLoader.loadImage((ImageView)this.mIvHead, (String)url, (int)R.drawable.bg_lock_screen);
    }

    public void onClick(View v) {
        if (this.isAnimating) {
            return;
        }
        if (v == this.mBtnClose) {
            this.finishAndShowPush();
        } else if (v == this.mViewContainer || v == this.mBtnGo) {
            this.handleJump();
            this.finish();
        }
    }

    private void handleJump() {
        MLog.info((Object)TAG, (String)"handleJump payload: %s", (Object[])new Object[]{this.mScreenInfo.payload});
        Intent resultIntent = new Intent("android.intent.action.VIEW");
        resultIntent.addCategory("android.intent.category.DEFAULT");
        ComponentName cn = new ComponentName(AppKeysDef.getAppPackageName(), AppKeysDef.getLauncherActivity());
        resultIntent.setComponent(cn);
        resultIntent.putExtra("payload", this.mScreenInfo.payload);
        resultIntent.addFlags(0x10200000);
        this.startActivity(resultIntent);
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (v == this.mSlideView && !this.isAnimating) {
            int action = event.getAction();
            float y = event.getRawY();
            switch (action) {
                case 0: {
                    this.mStartY = y;
                    break;
                }
                case 2: {
                    this.handleMove(y);
                    break;
                }
                case 1: 
                case 3: {
                    this.handleEndSlide();
                    break;
                }
            }
            return true;
        }
        return false;
    }

    private void handleMove(float y) {
        float moveY = y - this.mStartY;
        if (moveY >= 0.0f) {
            moveY = 0.0f;
        }
        this.mRootView.setTranslationY(moveY);
    }

    private void handleEndSlide() {
        ObjectAnimator animator;
        int translateX = (int)this.mRootView.getTranslationY();
        if (Math.abs(translateX) > 350) {
            animator = ObjectAnimator.ofFloat((Object)this.mRootView, (String)"translationY", (float[])new float[]{this.mRootView.getTranslationY(), -this.mRootView.getHeight()});
            animator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    LockScreenPushActivity.this.isAnimating = false;
                    LockScreenPushActivity.this.finishAndShowPush();
                }
            });
        } else {
            animator = ObjectAnimator.ofFloat((Object)this.mRootView, (String)"translationY", (float[])new float[]{this.mRootView.getTranslationY(), this.mRootView.getTranslationY(), 0.0f});
            animator.addListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    LockScreenPushActivity.this.isAnimating = false;
                }
            });
        }
        animator.setDuration(200L);
        this.isAnimating = true;
        animator.start();
    }

    private void finishAndShowPush() {
        this.finish();
        try {
            if (this.mScreenInfo.style == StyleType.StyleTypeLockScreen1.getValue()) {
                this.mScreenInfo.avatar = this.mScreenInfo.avatar + "?x-oss-process=image/resize,m_fill,h_100,w_100";
            }
            PushNotificationData data = new PushNotificationData(this.mScreenInfo.pushId, this.mScreenInfo.channelType, this.mScreenInfo.pushSource, this.mScreenInfo.payload).with(this.mScreenInfo.content, this.mScreenInfo.title, this.mScreenInfo.avatar).with(this.mScreenInfo.isShowPush, this.mScreenInfo.isOfflineMsg).withUid(this.mScreenInfo.uid).withStyle(StyleType.StyleTypeViewSquareSmallButton.getValue());
            data.setFirstReceive(false);
            NotificationManager.Instance.showNotification((Context)this, data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onBackPressed() {
    }

    protected void onDestroy() {
        super.onDestroy();
        this.mRootView.clearAnimation();
        MLog.info((Object)TAG, (String)"onDestroy !!!", (Object[])new Object[0]);
        LockScreenPushManager.getInstance().setShowingLockActivity(false);
    }
}

