/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.network.prevent;

import android.os.SystemClock;
import com.yy.appbase.http.BaseResponseBean;
import com.yy.appbase.http.IHttpRequestSender;
import com.yy.appbase.http.INetCustomRespCallback;
import com.yy.appbase.http.INetOriginRespByteArrayHeaderCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.hiyo.proto.callback.DefaultCacheEffectiveTimeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.Call;

public class HttpRequestPreventDuplicater {
    private String TAG = "RequestPreventer_Http";
    private HttpRequest mCurRequesting;
    private HttpRequestResponseEx mRequestResponseEx;
    private String key;
    private long lastObtainCacheEffectiveTime;
    private ICallback mCallback;
    private int preventNumInCacheTime = 0;
    private long lastCacheStartTime = 0L;
    private boolean mOpenEqualLog;
    private Runnable recycleResponse;

    public HttpRequestPreventDuplicater(String key, ICallback callback) {
        if (SystemUtils.isShowEnvSetting()) {
            // empty if block
        }
        this.mOpenEqualLog = false;
        this.recycleResponse = null;
        this.key = key;
        this.TAG = "RequestPreventer_Http";
        this.mCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpRequestResponseEx getCacheData(String url, byte[] postContent, Map<String, String> param, int type2, Map<String, String> headDataToAdd, long cacheEffectiveTime, long curTime) {
        boolean maybeDuplicateRequest = false;
        HttpRequestBaseData data = null;
        HttpRequestPreventDuplicater httpRequestPreventDuplicater = this;
        synchronized (httpRequestPreventDuplicater) {
            if (this.mRequestResponseEx != null) {
                if (curTime <= 0L) {
                    curTime = SystemClock.uptimeMillis();
                }
                if (curTime > 0L && curTime - this.mRequestResponseEx.data.startTime < cacheEffectiveTime) {
                    if (this.isRequestEqual(this.mRequestResponseEx.data, url, postContent, param, type2, headDataToAdd)) {
                        if (this.preventNumInCacheTime == 0) {
                            this.lastCacheStartTime = curTime;
                        } else if (curTime - this.lastCacheStartTime > 60000L) {
                            this.lastCacheStartTime = curTime;
                            this.preventNumInCacheTime = 0;
                        }
                        ++this.preventNumInCacheTime;
                        MLog.info((Object)this.TAG, (String)"url:%s, hit cache:1, happen prevent duplicate num:%d, allRequestNum:%d!", (Object[])new Object[]{this.key, ++DefaultCacheEffectiveTimeUtil.sHttpPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum});
                        return this.mRequestResponseEx;
                    }
                    if (SystemUtils.isShowEnvSetting()) {
                        MLog.info((Object)this.TAG, (String)"url:%s, hit cache:0, by request params not equal!", (Object[])new Object[]{this.key});
                    }
                } else {
                    this.preventNumInCacheTime = 0;
                    maybeDuplicateRequest = true;
                    data = this.mRequestResponseEx.data;
                    if (SystemUtils.isShowEnvSetting()) {
                        MLog.info((Object)this.TAG, (String)"url:%s, hit cache:0, by cache\u5931\u6548\uff0ccurtime:%s, cacheTime:%s, cacheEffectiveTime:%s!", (Object[])new Object[]{this.key, String.valueOf(curTime), String.valueOf(this.mRequestResponseEx.data.startTime), String.valueOf(cacheEffectiveTime)});
                    }
                }
            }
        }
        if (maybeDuplicateRequest && data != null) {
            this.mCallback.maybeDuplicateRequest(this, data, url, postContent, param, type2, headDataToAdd);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int isRequestSending(String url, byte[] postContent, Map<String, String> param, int type2, Map<String, String> headDataToAdd, long cacheEffectiveTime, long curTime) {
        HttpRequestPreventDuplicater httpRequestPreventDuplicater = this;
        synchronized (httpRequestPreventDuplicater) {
            boolean isStart = this.isStarted(url, postContent, param, type2, headDataToAdd);
            if (isStart) {
                if (curTime <= 0L) {
                    curTime = SystemClock.uptimeMillis();
                }
                if (curTime > 0L && curTime - this.mCurRequesting.data.startTime > cacheEffectiveTime) {
                    return 2;
                }
                return 1;
            }
            return 3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Data> void httpReq(String url, byte[] postContent, Map<String, String> param, int type2, final INetRespCallback<Data> callback, Map<String, String> headDataToAdd, IHttpRequestSender sender) {
        HttpRequestResponseEx cacheData;
        long cacheEffectiveTime = this.mCallback.getCacheEffectiveTime(url, param, type2, callback, headDataToAdd);
        if (cacheEffectiveTime <= 0L) {
            HttpRequestPreventDuplicater.sendInner(url, postContent, param, type2, callback, headDataToAdd, sender);
            MLog.info((Object)this.TAG, (String)"not use PreventDuplicater:%s!", (Object[])new Object[]{url});
            return;
        }
        ++DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum;
        this.lastObtainCacheEffectiveTime = cacheEffectiveTime;
        long curTime = -1L;
        if (this.mRequestResponseEx != null) {
            curTime = SystemClock.uptimeMillis();
        }
        if ((cacheData = this.getCacheData(url, postContent, param, type2, headDataToAdd, cacheEffectiveTime, curTime)) != null) {
            this.mCallback.onDuplicateRequest(false, cacheData.data, DefaultCacheEffectiveTimeUtil.sHttpPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum, this.preventNumInCacheTime);
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (callback != null) {
                        callback.onResponse(cacheData.response, cacheData.res, cacheData.id);
                    }
                }
            });
            return;
        }
        int isRequestSend = 3;
        HttpRequest curRequest = null;
        HttpRequestPreventDuplicater httpRequestPreventDuplicater = this;
        synchronized (httpRequestPreventDuplicater) {
            isRequestSend = this.isRequestSending(url, postContent, param, type2, headDataToAdd, cacheEffectiveTime, curTime);
            if (isRequestSend == 1) {
                if (callback != null) {
                    this.mCurRequesting.callBacks.add(callback);
                }
            } else if (isRequestSend == 3) {
                curRequest = this.mCurRequesting = HttpRequestPreventDuplicater.obtainRequest(url, postContent, param, type2, callback, headDataToAdd);
            }
        }
        if (isRequestSend == 1) {
            if (this.preventNumInCacheTime == 0) {
                this.lastCacheStartTime = curTime;
            } else if (curTime - this.lastCacheStartTime > 60000L) {
                this.lastCacheStartTime = curTime;
                this.preventNumInCacheTime = 0;
            }
            ++this.preventNumInCacheTime;
            MLog.info((Object)this.TAG, (String)"url:%s, hit cache:1, has a equal request is sending happen prevent duplicate num:%d, allRequestNum:%d!", (Object[])new Object[]{this.key, ++DefaultCacheEffectiveTimeUtil.sHttpPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum});
            this.mCallback.onDuplicateRequest(false, this.mCurRequesting != null ? this.mCurRequesting.data : null, DefaultCacheEffectiveTimeUtil.sHttpPreventNum, DefaultCacheEffectiveTimeUtil.sHttpAllRequestNum, this.preventNumInCacheTime);
        } else if (isRequestSend == 2 || isRequestSend == 3) {
            if (curRequest == null) {
                curRequest = HttpRequestPreventDuplicater.obtainRequest(url, postContent, param, type2, callback, headDataToAdd);
            }
            HttpRequestPreventDuplicater.sendInner(url, postContent, param, type2, new MyNetRespCallback<Data>(callback, curRequest), headDataToAdd, sender);
            if (isRequestSend == 2) {
                if (RuntimeContext.isInGray()) {
                    MLog.info((Object)this.TAG, (String)"url:%s, hit cache:0, has a equal request sending, but time exceed!", (Object[])new Object[]{this.key});
                }
                this.preventNumInCacheTime = 0;
            } else if (RuntimeContext.isInGray()) {
                MLog.info((Object)this.TAG, (String)"url:%s, hit cache:0, has no valid cache and no equal request is sending!", (Object[])new Object[]{this.key});
            }
        }
    }

    public boolean isStarted(String url, byte[] postContent, Map<String, String> param, int type2, Map<String, String> headDataToAdd) {
        if (this.mCurRequesting == null) {
            return false;
        }
        return this.isRequestEqual(this.mCurRequesting.data, url, postContent, param, type2, headDataToAdd);
    }

    public boolean isRequestEqual(HttpRequestBaseData data, String url, byte[] postContent, Map<String, String> param, int type2, Map<String, String> headDataToAdd) {
        if (data == null) {
            return false;
        }
        if (!StringUtils.equal((String)data.url, (String)url)) {
            if (this.mOpenEqualLog) {
                MLog.info((Object)this.TAG, (String)"request equal:0, by url not equal:%s,%s", (Object[])new Object[]{url, data.url});
            }
            return false;
        }
        if (data.type != type2) {
            if (this.mOpenEqualLog) {
                MLog.info((Object)this.TAG, (String)"request equal:0, by type not equal:%s,%d,%d", (Object[])new Object[]{url, data.type, type2});
            }
            return false;
        }
        if (data.postContent != null && postContent == null || data.postContent == null && postContent != null || postContent != null && data.postContent.length != postContent.length) {
            if (this.mOpenEqualLog) {
                MLog.info((Object)this.TAG, (String)"request equal:0, by postContent size not equal!", (Object[])new Object[0]);
            }
            return false;
        }
        if (postContent != null && postContent.length > 0) {
            boolean contentEqual = true;
            byte[] toCompare = data.postContent;
            for (int i = 0; i < postContent.length; ++i) {
                if (postContent[i] == toCompare[i]) continue;
                contentEqual = false;
                break;
            }
            if (!contentEqual) {
                if (this.mOpenEqualLog) {
                    MLog.info((Object)this.TAG, (String)"request equal:0, by postContent not equal!", (Object[])new Object[0]);
                }
                return false;
            }
        }
        if (!HttpRequestPreventDuplicater.isMapEqual(data.headDataToAdd, headDataToAdd)) {
            if (this.mOpenEqualLog) {
                MLog.info((Object)this.TAG, (String)"request equal:0, by postContent not equal:%s, compare:%s!", (Object[])new Object[]{data.headDataToAdd, headDataToAdd});
            }
            return false;
        }
        if (!HttpRequestPreventDuplicater.isMapEqual(data.param, param)) {
            if (this.mOpenEqualLog) {
                MLog.info((Object)this.TAG, (String)"request equal:0, by param not equal:%s, compare:%s!", (Object[])new Object[]{data.param, param});
            }
            return false;
        }
        if (this.mOpenEqualLog) {
            MLog.info((Object)this.TAG, (String)"request started find:%s, param:%s,head:%s!", (Object[])new Object[]{url, param, headDataToAdd});
        }
        return true;
    }

    private static boolean isMapEqual(Map<String, String> one, Map<String, String> two) {
        if (one == null && two == null) {
            return true;
        }
        if (one != null && two == null || one == null && two != null || one.size() != two.size()) {
            return false;
        }
        Set<String> keys = one.keySet();
        for (String key : keys) {
            if (StringUtils.equal((String)one.get(key), (String)two.get(key))) continue;
            return false;
        }
        return true;
    }

    public static HttpRequest obtainRequest(String url, byte[] postContent, Map<String, String> param, int type2, INetRespCallback callback, Map<String, String> headDataToAdd) {
        HttpRequest requestData = new HttpRequest();
        requestData.data = new HttpRequestBaseData();
        requestData.data.startTime = SystemClock.uptimeMillis();
        requestData.data.postContent = postContent;
        requestData.data.url = url;
        if (param != null) {
            requestData.data.param = new HashMap<String, String>(param);
        }
        if (headDataToAdd != null) {
            requestData.data.headDataToAdd = new HashMap<String, String>(headDataToAdd);
        }
        requestData.data.type = type2;
        if (callback != null) {
            requestData.callBacks.add(callback);
        }
        return requestData;
    }

    public void onFinish(HttpRequest requestData) {
        if (requestData == this.mCurRequesting) {
            this.mCurRequesting = null;
        }
    }

    public List<INetRespCallback> getCallBacks(HttpRequest requestData) {
        return new ArrayList<INetRespCallback>(requestData.callBacks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onErrorInner(HttpRequest requestData, Call call, Exception e, int id2) {
        List<INetRespCallback> callBacks = null;
        HttpRequestPreventDuplicater httpRequestPreventDuplicater = this;
        synchronized (httpRequestPreventDuplicater) {
            callBacks = this.getCallBacks(requestData);
            this.onFinish(requestData);
        }
        if (callBacks != null && callBacks.size() > 0) {
            for (INetRespCallback item : callBacks) {
                if (item == null) continue;
                item.onError(call, e, id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <Data> void onResponseInner(HttpRequest requestData, String response, BaseResponseBean<Data> res, int id2) {
        List<INetRespCallback> callBacks = null;
        HttpRequestPreventDuplicater httpRequestPreventDuplicater = this;
        synchronized (httpRequestPreventDuplicater) {
            callBacks = this.getCallBacks(requestData);
            if (this.mRequestResponseEx == null || this.mRequestResponseEx != null && requestData.data.startTime > this.mRequestResponseEx.data.startTime) {
                this.mRequestResponseEx = new HttpRequestResponseEx();
                this.mRequestResponseEx.data = requestData.data;
                this.mRequestResponseEx.res = res;
                this.mRequestResponseEx.response = response;
                this.mRequestResponseEx.id = id2;
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)this.TAG, (String)"url:%s, RequestResponseEx update:%s!", (Object[])new Object[]{this.key, String.valueOf(requestData.data.startTime)});
                }
            }
            this.onFinish(requestData);
        }
        this.recycleResponse();
        if (callBacks != null && callBacks.size() > 0) {
            for (INetRespCallback item : callBacks) {
                if (item == null) continue;
                item.onResponse(response, res, id2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onResponseInner(HttpRequest requestData, String response, BaseResponseBean<byte[]> res, int id2, Map<String, List<String>> responseHeader) {
        List<INetRespCallback> callBacks = null;
        HttpRequestPreventDuplicater httpRequestPreventDuplicater = this;
        synchronized (httpRequestPreventDuplicater) {
            callBacks = this.getCallBacks(requestData);
            if (this.mRequestResponseEx == null || this.mRequestResponseEx != null && requestData.data.startTime > this.mRequestResponseEx.data.startTime) {
                this.mRequestResponseEx = new HttpRequestResponseEx();
                this.mRequestResponseEx.data = requestData.data;
                this.mRequestResponseEx.res = res;
                this.mRequestResponseEx.response = response;
                this.mRequestResponseEx.id = id2;
                if (SystemUtils.isShowEnvSetting()) {
                    MLog.info((Object)this.TAG, (String)"url:%s, RequestResponseEx update:%s!", (Object[])new Object[]{this.key, String.valueOf(requestData.data.startTime)});
                }
            }
            this.onFinish(requestData);
        }
        this.recycleResponse();
        if (callBacks != null && callBacks.size() > 0) {
            for (INetRespCallback item : callBacks) {
                if (item != null && item instanceof INetOriginRespByteArrayHeaderCallback) {
                    ((INetOriginRespByteArrayHeaderCallback)item).onResponse(response, res, id2, responseHeader);
                    continue;
                }
                if (item == null || !SystemUtils.isShowEnvSetting()) continue;
                throw new RuntimeException("callback is invalide:" + item);
            }
        }
    }

    private static <Data> void sendInner(String url, byte[] postContent, Map<String, String> param, int type2, INetRespCallback<Data> callback, Map<String, String> headDataToAdd, IHttpRequestSender sender) {
        sender.httpReq(url, postContent, param, type2, callback, headDataToAdd);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onNetConnected() {
        HttpRequestPreventDuplicater httpRequestPreventDuplicater = this;
        synchronized (httpRequestPreventDuplicater) {
            if (this.mCurRequesting != null) {
                this.mCurRequesting.data.startTime = 0L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onLoginOut() {
        HttpRequestPreventDuplicater httpRequestPreventDuplicater = this;
        synchronized (httpRequestPreventDuplicater) {
            if (this.mCurRequesting != null) {
                this.mCurRequesting.data.startTime = 0L;
            }
            if (this.mRequestResponseEx != null) {
                this.mRequestResponseEx = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onTrimMemory(long curTime) {
        HttpRequestPreventDuplicater httpRequestPreventDuplicater = this;
        synchronized (httpRequestPreventDuplicater) {
            if (this.mRequestResponseEx != null && curTime - this.mRequestResponseEx.data.startTime > this.lastObtainCacheEffectiveTime) {
                this.mRequestResponseEx = null;
            }
        }
    }

    void recycleResponse() {
        long lastObtainCacheEffectiveTime = this.lastObtainCacheEffectiveTime;
        if (lastObtainCacheEffectiveTime > 0L && this.mRequestResponseEx != null) {
            if (this.recycleResponse != null) {
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.recycleResponse);
            }
            final HttpRequestResponseEx finalData = this.mRequestResponseEx;
            this.recycleResponse = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HttpRequestPreventDuplicater httpRequestPreventDuplicater = HttpRequestPreventDuplicater.this;
                    synchronized (httpRequestPreventDuplicater) {
                        if (HttpRequestPreventDuplicater.this.mRequestResponseEx == finalData) {
                            HttpRequestPreventDuplicater.this.mRequestResponseEx = null;
                        }
                    }
                    HttpRequestPreventDuplicater.this.recycleResponse = null;
                    if (SystemUtils.isShowEnvSetting()) {
                        MLog.info((Object)HttpRequestPreventDuplicater.this.TAG, (String)"recycleResponse!", (Object[])new Object[0]);
                    }
                }
            };
            YYTaskExecutor.postToMainThread((Runnable)this.recycleResponse, (long)(lastObtainCacheEffectiveTime + 2000L));
        }
    }

    static interface ICallback {
        public long getCacheEffectiveTime(String var1, Map<String, String> var2, int var3, INetRespCallback var4, Map<String, String> var5);

        public void onDuplicateRequest(boolean var1, HttpRequestBaseData var2, int var3, int var4, int var5);

        public void maybeDuplicateRequest(HttpRequestPreventDuplicater var1, HttpRequestBaseData var2, String var3, byte[] var4, Map<String, String> var5, int var6, Map<String, String> var7);
    }

    public class MyNetRespCallback<Data>
    implements INetCustomRespCallback {
        private INetRespCallback<Data> mCallback;
        private HttpRequest mRequestData;

        public MyNetRespCallback(INetRespCallback<Data> callback, HttpRequest requestData) {
            this.mCallback = callback;
            this.mRequestData = requestData;
        }

        public void onError(Call call, Exception e, int id2) {
            HttpRequestPreventDuplicater.this.onErrorInner(this.mRequestData, call, e, id2);
        }

        public void onResponse(String response, BaseResponseBean res, int id2) {
            HttpRequestPreventDuplicater.this.onResponseInner(this.mRequestData, response, res, id2);
        }

        public INetRespCallback<Data> getOriginCallback() {
            return this.mCallback;
        }

        public void onResponse(String response, BaseResponseBean<byte[]> res, int id2, Map<String, List<String>> responseHeader) {
            HttpRequestPreventDuplicater.this.onResponseInner(this.mRequestData, response, (BaseResponseBean<byte[]>)res, id2, responseHeader);
        }
    }

    static class HttpRequestResponseEx {
        public HttpRequestBaseData data;
        public BaseResponseBean res;
        public String response;
        public int id;

        HttpRequestResponseEx() {
        }
    }

    static class HttpRequest {
        public HttpRequestBaseData data;
        public final ArrayList<INetRespCallback> callBacks = new ArrayList(3);

        HttpRequest() {
        }
    }

    public static class HttpRequestBaseData {
        public String url;
        public byte[] postContent;
        public Map<String, String> param;
        public int type;
        public Map<String, String> headDataToAdd;
        public long startTime;
    }
}

