/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.network;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.os.SystemClock;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.FrameLayout;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.DataSource;
import com.bumptech.glide.load.engine.PerformanceData;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.IHttpMetricMonitor;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.web.IWebManager;
import com.yy.appbase.service.web.IWebManagerCallBack;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.okhttp.websocket.WsClient;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.CountryCodeUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.grace.Request;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.module.performancemonitor.perfcollect.global.RepeatRequestsMonitor;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.ErrorTimesJudger;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.RegisterHostSwitcher;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.notify.NotifyFrequencyController;
import com.yy.hiyo.proto.IMonitor;
import com.yy.hiyo.proto.ProtoMonitor;
import com.yy.webservice.webwindow.webview.Utils;
import com.yy.webservice.webwindow.webview.base.YYWebView;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.Map;

public class NetWorkWrapper
extends DefaultController {
    private static volatile IHttpMetricMonitor sHttpMonitor;
    private static IMonitor sWsMonitor;
    private static ImageLoader.IMonitor sImagepMonitor;
    private NotifyFrequencyController mNotifyFrequencyController;
    private IWebManager mWebManager;
    private WebView mWebView;
    private IQueueTaskExecutor mTaskExecutor;
    private volatile boolean mHasTested;
    private long mLastCountertime;
    private RegisterHostSwitcher mRegisterHostSwitcher = new RegisterHostSwitcher();
    private ErrorTimesJudger mErrorTimesJudger;
    private boolean mStatImageHttpError;
    private int mOpenWsClientBackgroundReconnectAB = -1;
    YYFrameLayout mWebViewContiner;

    public NetWorkWrapper(Environment env) {
        super(env);
        this.registerMessage(BaseMsgDef.MSG_NET_WORK_CHECK_BY_WS_ERROR);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
        NotificationCenter.getGlobalInstance().register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        this.mRegisterHostSwitcher.init();
        this.mErrorTimesJudger = new ErrorTimesJudger();
    }

    public void onConfigUpdate() {
        if (this.mNotifyFrequencyController != null) {
            this.mNotifyFrequencyController.onConfigUpdate();
        }
    }

    public void onLowMemery() {
        if (this.mNotifyFrequencyController != null) {
            this.mNotifyFrequencyController.onLowMemery();
        }
    }

    public static void onHttpRequestStart(Request chain) {
        RepeatRequestsMonitor.onHttpRequestStart(chain);
    }

    public static void setHttpMonitor(IHttpMetricMonitor monitor) {
        sHttpMonitor = monitor;
    }

    public static void setProtoMonitor(IMonitor monitor) {
        sWsMonitor = monitor;
    }

    public static void setImageMonitor(ImageLoader.IMonitor monitor) {
        sImagepMonitor = monitor;
    }

    private IQueueTaskExecutor getTaskExecutor() {
        if (this.mTaskExecutor == null) {
            this.mTaskExecutor = YYTaskExecutor.createAQueueExcuter();
        }
        return this.mTaskExecutor;
    }

    public void init() {
        this.mNotifyFrequencyController = new NotifyFrequencyController();
        this.mNotifyFrequencyController.init();
        IHttpMetricMonitor innerCallback = new IHttpMetricMonitor(){

            public void onStart(int index, String originUrl, String request, Map<String, String> header) {
                if (sHttpMonitor != null) {
                    sHttpMonitor.onStart(index, originUrl, request, header);
                }
            }

            public void onCancel(int index, String originUrl, String request, Map<String, String> header) {
                if (sHttpMonitor != null) {
                    sHttpMonitor.onCancel(index, originUrl, request, header);
                }
            }

            public void onFailure(int index, String originUrl, String request, Throwable e, Map<String, String> header) {
                if (sHttpMonitor != null) {
                    sHttpMonitor.onFailure(index, originUrl, request, e, header);
                }
                NetWorkWrapper.this.onNetError(request, e);
                MLog.info((Object)"NetWorkWrapper", (String)("http onFailure " + request), (Object[])new Object[0]);
            }

            public void onResponse(int index, String originUrl, String request, long response, Map<String, String> header) {
                if (sHttpMonitor != null) {
                    sHttpMonitor.onResponse(index, originUrl, request, response, header);
                }
                if (request != null) {
                    boolean useBackUpSuccess;
                    boolean bl = useBackUpSuccess = !StringUtils.equal((String)originUrl, (String)request);
                    if (useBackUpSuccess) {
                        MLog.info((Object)"NetWorkWrapper", (String)"http use backup success %s!", (Object[])new Object[]{request});
                        NetWorkWrapper.this.mRegisterHostSwitcher.onNetError("use backup success!", request, false);
                    }
                }
            }
        };
        HttpUtil.setHttpMetric((IHttpMetricMonitor)innerCallback);
        ProtoMonitor.setMonitor((IMonitor)new IMonitor(){

            public void onRequestStart(long seqId, int requestLength, String wsUrl, String protoServiceName, String method, int uri, long queueSize, AndroidMessage proto) {
                if (sWsMonitor != null) {
                    sWsMonitor.onRequestStart(seqId, requestLength, wsUrl, protoServiceName, method, uri, queueSize, proto);
                }
            }

            public void onHttpRpcRequestStart(String roomId, String url, String protoServiceName, String method, AndroidMessage proto) {
                if (sWsMonitor != null) {
                    sWsMonitor.onHttpRpcRequestStart(roomId, url, protoServiceName, method, proto);
                }
            }

            public void onResponse(long seqId, int resLength) {
                if (sWsMonitor != null) {
                    sWsMonitor.onResponse(seqId, resLength);
                }
            }

            public void onTimeout(long seqId) {
                if (sWsMonitor != null) {
                    sWsMonitor.onTimeout(seqId);
                }
            }

            public void onError(long seqId, String reason, int code) {
                if (sWsMonitor != null) {
                    sWsMonitor.onError(seqId, reason, code);
                }
            }

            public void onNotify(String wsUrl, String protoServiceName, int length) {
                if (sWsMonitor != null) {
                    sWsMonitor.onNotify(wsUrl, protoServiceName, length);
                }
            }

            public void onCheckOutExe(int consume, String statStr) {
                if (sWsMonitor != null) {
                    sWsMonitor.onCheckOutExe(consume, statStr);
                }
            }

            public void onMsgConsumeTime(long seqId, String protoServiceName, int uri, long time, int retryTimes, String traceStr) {
                if (sWsMonitor != null) {
                    sWsMonitor.onMsgConsumeTime(seqId, protoServiceName, uri, time, retryTimes, traceStr);
                }
            }

            public void onResponseTimeGap(long seqId, String protoServiceName, int uri, long time) {
                if (sWsMonitor != null) {
                    sWsMonitor.onResponseTimeGap(seqId, protoServiceName, uri, time);
                }
            }

            public void onResponseExcuteTime(long seqId, String protoServiceName, int uri, long time) {
                if (sWsMonitor != null) {
                    sWsMonitor.onResponseExcuteTime(seqId, protoServiceName, uri, time);
                }
            }

            public boolean isEnableWsClientBackgroundReconnect(WsClient socket, String wsUrl) {
                if (NetWorkWrapper.this.mOpenWsClientBackgroundReconnectAB == -1) {
                    if (CountryCodeUtils.isCountrySa() || CountryCodeUtils.isCountryArabia()) {
                        return false;
                    }
                    IAB abValue = NewABDefine.WSCLIENT_BACKGROUND_RECONNECT.getTest();
                    if (NewABDefine.WSCLIENT_BACKGROUND_RECONNECT.isValid()) {
                        if (NAB.A.equals((Object)abValue)) {
                            NetWorkWrapper.this.mOpenWsClientBackgroundReconnectAB = 2;
                        } else if (NAB.B.equals((Object)abValue)) {
                            NetWorkWrapper.this.mOpenWsClientBackgroundReconnectAB = 2;
                        } else if (NAB.C.equals((Object)abValue)) {
                            NetWorkWrapper.this.mOpenWsClientBackgroundReconnectAB = 1;
                        } else if (NAB.D.equals((Object)abValue)) {
                            NetWorkWrapper.this.mOpenWsClientBackgroundReconnectAB = 1;
                        }
                    }
                }
                if (NetWorkWrapper.this.mOpenWsClientBackgroundReconnectAB == 1) {
                    RuntimeContext.ChannelHeartItem item = RuntimeContext.getCurMainChannel();
                    if (item != null && StringUtils.isNotEmpty((String)item.getRoomId())) {
                        MLog.info((Object)"NetWorkWrapper", (String)"enableWsClientBackgroundReconnect!", (Object[])new Object[0]);
                        return true;
                    }
                    MLog.info((Object)"NetWorkWrapper", (String)"disEnableWsClientBackgroundReconnect!", (Object[])new Object[0]);
                    return false;
                }
                return false;
            }
        });
        if (SettingFlags.getBoolean((String)"globalnetimage", (boolean)false)) {
            ImageLoader.addMonitor((ImageLoader.IMonitor)new ImageLoader.IMonitor(){

                public void onStart(int id2, boolean loadImage, @Nullable String url, int width, int height) {
                    if (sImagepMonitor != null) {
                        sImagepMonitor.onStart(id2, loadImage, url, width, height);
                    }
                }

                public void onSuccess(int id2, @Nullable String url, int size, boolean isFirstResource, @Nullable DataSource dataSource, @Nullable PerformanceData performanceData) {
                    if (sImagepMonitor != null) {
                        sImagepMonitor.onSuccess(id2, url, size, isFirstResource, dataSource, performanceData);
                    }
                }

                public void onError(int id2, @Nullable String url, Exception e) {
                    if (sImagepMonitor != null) {
                        sImagepMonitor.onError(id2, url, e);
                    }
                    NetWorkWrapper.this.onNetError(url, e);
                }

                public void onHappenHttpError(String url) {
                    if (NetWorkWrapper.this.mStatImageHttpError) {
                        return;
                    }
                    NetWorkWrapper.this.mStatImageHttpError = true;
                    StatisContent statContent = new StatisContent();
                    statContent.put("act", "hagoperf");
                    statContent.put("sfield", url);
                    statContent.put("perftype", "imagehttp");
                    HiidoStatis.reportContent((StatisContent)statContent);
                }

                public void onClear(int id2) {
                    if (sImagepMonitor != null) {
                        sImagepMonitor.onClear(id2);
                    }
                }
            });
        }
    }

    public void handleMessage(Message msg) {
        if (msg == null) {
            return;
        }
        if (msg.what == BaseMsgDef.MSG_NET_WORK_CHECK_BY_WS_ERROR && StringUtils.isNotEmpty((String)((String)msg.obj))) {
            Bundle data = msg.getData();
            String wsUrl = data != null ? data.getString("url") : "";
            this.onNetError((String)msg.obj, wsUrl, true);
        }
    }

    public void notify(Notification notification) {
        if (notification != null && notification.id == NotificationDef.N_NETWORK_STATE_CHANGE) {
            this.clearErrorList();
        } else if (notification != null && notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
            this.mRegisterHostSwitcher.onLoginOut();
        }
    }

    private void onNetError(String url, Throwable e) {
        this.onNetError(e != null ? e.toString() : "", url, false);
    }

    private synchronized void onNetError(String error, String url, boolean wsError) {
        this.mRegisterHostSwitcher.onNetError(error, url, wsError);
        this.handleNetTestWhenError(error, url, wsError);
    }

    private synchronized void handleNetTestWhenError(String error, final String url, final boolean wsError) {
        if (this.mHasTested) {
            return;
        }
        if (!(wsError || !StringUtils.isEmpty((String)url) && url.startsWith("http"))) {
            return;
        }
        String errorInfo = error;
        if (StringUtils.isEmpty((String)errorInfo)) {
            return;
        }
        if (RuntimeContext.sIsDebuggable ? !NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) : !SettingFlags.getBoolean((String)"network_diagnosis", (boolean)false) || !NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            return;
        }
        boolean netError = false;
        if (errorInfo.contains("java.net.ConnectException")) {
            netError = true;
        } else if (errorInfo.contains("java.net.SocketTimeoutException")) {
            netError = true;
        } else if (errorInfo.contains("java.io.EOFException")) {
            netError = true;
        } else if (errorInfo.contains("SSLException")) {
            netError = true;
        } else if (errorInfo.contains("javax.net.ssl.SSLHandshakeException")) {
            netError = true;
        }
        if (!netError) {
            return;
        }
        final long curTime = SystemClock.uptimeMillis();
        if (curTime < 0L) {
            return;
        }
        if (this.mLastCountertime > 0L && curTime - this.mLastCountertime < 200L) {
            return;
        }
        this.mLastCountertime = curTime;
        this.getTaskExecutor().execute(new Runnable(){

            @Override
            public void run() {
                boolean sPingFacebook = NetworkUtils.pingHost((String)"m.facebook.com");
                if (!sPingFacebook) {
                    return;
                }
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        NetWorkWrapper.this.handleError(url, wsError, curTime);
                    }
                });
            }
        }, 0L);
    }

    private synchronized void handleError(String url, boolean wsError, long curTime) {
        if (!wsError) {
            this.mErrorTimesJudger.deleteItem(url);
        }
        this.mErrorTimesJudger.addItem(url, wsError, curTime, null);
        if (this.mErrorTimesJudger.isContinuityErrorInTimeGap()) {
            this.testNet();
            this.clearErrorList();
        }
    }

    private synchronized void clearErrorList() {
        this.mErrorTimesJudger.clearErrorList();
    }

    private void testNet() {
        if (this.mHasTested) {
            return;
        }
        YYTaskExecutor.execute((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
                    return;
                }
                if (NetWorkWrapper.this.mHasTested) {
                    return;
                }
                boolean sPingFacebook = NetworkUtils.pingHost((String)"m.facebook.com");
                boolean sPingGoogle = NetworkUtils.pingHost((String)"www.google.com");
                if (sPingFacebook && sPingGoogle) {
                    YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                        public void run() {
                            if (NetWorkWrapper.this.mHasTested) {
                                return;
                            }
                            NetWorkWrapper.this.mHasTested = true;
                            NetWorkWrapper.this.loadTestUrl();
                        }
                    });
                }
            }
        });
    }

    public YYFrameLayout getWebViewContiner() {
        if (this.mWebViewContiner == null) {
            this.mWebViewContiner = new YYFrameLayout(this.mContext);
        }
        return this.mWebViewContiner;
    }

    private void loadTestUrl() {
        this.mWebView = new YYWebView(this.mContext);
        YYFrameLayout frameLayout = this.getWebViewContiner();
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(5, 5);
        frameLayout.removeAllViews();
        frameLayout.addView((View)this.mWebView, (ViewGroup.LayoutParams)layoutParams);
        this.getEnvironment().getWindowManager().addExtLayerContent((View)frameLayout);
        this.mWebManager = ServiceManager.getInstance().getService(IWebService.class).createWebManager(new IWebManagerCallBack(){

            public void enablePullRefreshMode(boolean enable) {
            }

            public void showProgressDialog(String label, boolean cancelable, int timeOut) {
            }

            public void hideProgress() {
            }

            public void onRefreshComplete(String originUrl, String url) {
            }

            public void showNetError(String originUrl, int errorCode, String description, String url) {
            }

            public void showLoading() {
            }

            public void hideStatusView() {
            }

            public void handleExitByWeb() {
            }

            public Activity getActivity() {
                return NetWorkWrapper.this.getActivity();
            }

            public void toNewJSSupportedWebView(String url) {
            }

            public void showAlertDialog(String title, String message, String positiveButton, String neutralButton, String negativeButton, boolean cancelable, Utils.IAlertDialogCallBack callBack) {
            }

            public DialogLinkManager getDialogManager() {
                return this.getDialogManager();
            }

            public boolean nativeGetGameIsInstall(String gameId) {
                return false;
            }

            public int from() {
                return 0;
            }
        }, this.mWebView);
        this.mWebManager.loadUrl("https://cdn.dns-detect.alicdn.com/https/doc.html");
        this.mWebManager.onResume();
        YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

            public void run() {
                NetWorkWrapper.this.mWebManager.loadUrl("https://www.google.cn");
                YYTaskExecutor.postToMainThread((Runnable)new YYTaskExecutor.RunnableEx(){

                    public void run() {
                        NetWorkWrapper.this.destroyView();
                    }
                }, (long)10000L);
            }
        }, (long)30000L);
        HiidoStatis.reportAppMonitorReturnCode((String)"hyNetCheck/", (long)0L, (String)"1");
    }

    public void destroyView() {
        if (this.mWebManager != null) {
            this.mWebManager.onPause();
            this.mWebManager.destroy();
            this.mWebManager = null;
        }
        if (this.mWebView != null) {
            this.getEnvironment().getWindowManager().removeExtLayerContent((View)this.getWebViewContiner());
            this.mWebView = null;
        }
    }
}

