/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.performancemonitor.perfcollect.global;

import android.os.SystemClock;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.grace.Request;
import java.util.ArrayList;

public class RepeatRequestsMonitor {
    private static final int TIME_GAP = 2000;
    private static ArrayList<RequestItem> sRpcRequestHashMap;

    public static void onRpcRequestStart(String wsUrl, String protoServiceName, String method, int uri, AndroidMessage proto) {
        if (!SystemUtils.isShowEnvSetting() || AccountUtil.getUid() < 0L || proto == null) {
            return;
        }
        String key = "wsUrl:" + wsUrl + ",serviceName:" + protoServiceName + ",method" + method + ",uri:" + uri;
        RepeatRequestsMonitor.chekSameRequest(key, null, proto);
    }

    public static void onHttpRpcRequestStart(String roomId, String url, String protoServiceName, String method, AndroidMessage proto) {
        if (!SystemUtils.isShowEnvSetting() || AccountUtil.getUid() < 0L || proto == null) {
            return;
        }
        String key = url + "roomId:" + roomId + ",serviceName:" + protoServiceName + ",method" + method;
        RepeatRequestsMonitor.chekSameRequest(key, null, proto);
    }

    public static void onHttpRequestStart(Request chain) {
        if (!SystemUtils.isShowEnvSetting() || AccountUtil.getUid() < 0L || chain == null) {
            return;
        }
        if (chain == null || chain.url() == null) {
            return;
        }
        String key = chain.url().toString();
        if (key.contains("?x-oss-process") || key.contains(".png") || key.contains(".jpg") || key.contains(".jpeg") || key.contains(".webp") || key.contains(".gif") || key.contains("/ymicro/api")) {
            return;
        }
        RepeatRequestsMonitor.chekSameRequest(key, chain, null);
    }

    private static synchronized void chekSameRequest(String key, Request chain, AndroidMessage proto) {
        if (sRpcRequestHashMap == null) {
            sRpcRequestHashMap = new ArrayList(50);
        }
        RequestItem requestItem = chain != null ? new RequestItem(chain, key) : new RequestItem(proto, key);
        RequestItem sameRequestByKey = null;
        ArrayList<RequestItem> timeoutRequests = new ArrayList<RequestItem>();
        for (int i = 0; i < sRpcRequestHashMap.size(); ++i) {
            sameRequestByKey = sRpcRequestHashMap.get(i);
            if (sameRequestByKey != null && SystemClock.elapsedRealtime() - sameRequestByKey.startTime > 2000L) {
                timeoutRequests.add(sameRequestByKey);
                continue;
            }
            if (sameRequestByKey == null || !StringUtils.equal((String)sameRequestByKey.uri, (String)key) || !sameRequestByKey.equalsRequestItem(requestItem)) continue;
            if (proto != null) {
                MLog.error((Object)"\u77ed\u65f6\u95f4\u5185\u7684\u91cd\u590d\u7f51\u7edc\u8bf7\u6c42Rpc", (String)"\u51fa\u73b0\u91cd\u590d\u8bf7\u6c42\uff1aservice:%s, req:%s, timeGap:%s", (Object[])new Object[]{key, proto, String.valueOf(requestItem.startTime - sameRequestByKey.startTime)});
                break;
            }
            MLog.error((Object)"\u77ed\u65f6\u95f4\u5185\u7684\u91cd\u590d\u7f51\u7edc\u8bf7\u6c42Http", (String)"\u51fa\u73b0\u91cd\u590d\u8bf7\u6c42\uff1aurl:%s, req:%s, timeGap:%s", (Object[])new Object[]{key, chain, String.valueOf(requestItem.startTime - sameRequestByKey.startTime)});
            break;
        }
        sRpcRequestHashMap.removeAll(timeoutRequests);
        sRpcRequestHashMap.add(requestItem);
    }

    private static class RequestItem {
        String uri = "";
        long startTime = SystemClock.elapsedRealtime();
        AndroidMessage rpcRequest;
        Request httpRequest;

        RequestItem(AndroidMessage message, String uri) {
            this.rpcRequest = message;
            this.uri = uri;
        }

        RequestItem(Request httpRequest, String uri) {
            this.httpRequest = httpRequest;
            this.uri = uri;
        }

        public boolean equalsRequestItem(RequestItem message) {
            if (message.httpRequest != null && this.httpRequest != null) {
                Request one = this.httpRequest;
                Request two = message.httpRequest;
                if (one == null || two == null) {
                    return false;
                }
                if (!StringUtils.equal((String)one.method(), (String)two.method())) {
                    return false;
                }
                MLog.debug((Object)"\u77ed\u65f6\u95f4\u5185\u7684\u91cd\u590d\u7f51\u7edc\u8bf7\u6c42", (String)"http equalsRequestItem:%s,\n    Req:%s, \ncompare:%s", (Object[])new Object[]{message.uri, one.headers(), two.headers()});
                if (one.headers() == null || !one.headers().equals((Object)two.headers())) {
                    return false;
                }
                if (one.body() == null) {
                    return two.body() == null;
                }
                if (two.body() != null) {
                    if (one.body().contentType() != two.body().contentType()) {
                        return false;
                    }
                    try {
                        return one.body().contentLength() == two.body().contentLength();
                    }
                    catch (Throwable e) {
                        return false;
                    }
                }
                return false;
            }
            if (message.rpcRequest != null && this.rpcRequest != null) {
                String[] strTwos;
                MLog.debug((Object)"\u77ed\u65f6\u95f4\u5185\u7684\u91cd\u590d\u7f51\u7edc\u8bf7\u6c42", (String)"WsRpc equalsRequestItem:%s, \n protoReq:%s, \n compare :%s", (Object[])new Object[]{message.uri, message.rpcRequest, this.rpcRequest});
                String str = message.rpcRequest.toString();
                String strTwo = this.rpcRequest.toString();
                if (str.length() <= 0) {
                    return false;
                }
                String[] strs = str.split(",");
                if (strs.length != (strTwos = strTwo.split(",")).length) {
                    return false;
                }
                for (int i = 0; i < strs.length; ++i) {
                    if (StringUtils.equal((String)strs[i], (String)strTwos[i]) || strs[i].replaceAll(" ", "").startsWith("seqid=")) continue;
                    return false;
                }
                if (!message.rpcRequest.unknownFields().equals((Object)this.rpcRequest.unknownFields())) {
                    MLog.error((Object)"\u77ed\u65f6\u95f4\u5185\u7684\u91cd\u590d\u7f51\u7edc\u8bf7\u6c42Rpc", (String)"unknownFields:%s, \n unknownFieldsTwo:%s!", (Object[])new Object[]{message.rpcRequest.unknownFields(), this.rpcRequest.unknownFields()});
                }
                if (!message.rpcRequest.equals(this.rpcRequest)) {
                    MLog.error((Object)"\u77ed\u65f6\u95f4\u5185\u7684\u91cd\u590d\u7f51\u7edc\u8bf7\u6c42Rpc", (String)"rpcRequest:%s, \n rpcRequestTwo:%s!", (Object[])new Object[]{message.rpcRequest, this.rpcRequest});
                } else {
                    MLog.error((Object)"\u77ed\u65f6\u95f4\u5185\u7684\u91cd\u590d\u7f51\u7edc\u8bf7\u6c42Rpc", (String)"message.rpcRequest.equals(rpcRequest) work!", (Object[])new Object[0]);
                }
                return true;
            }
            return false;
        }
    }
}

