/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.handlefileIntent.view;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.PopupWindow;
import android.widget.TextView;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.R;
import com.yy.appbase.ui.widget.bar.SimpleTitleBar;
import com.yy.appbase.ui.widget.status.LoadingStatusLayout;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.mvp.MvpPresenter;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.framework.core.ui.UICallBacks;
import com.yy.hiyo.camera.base.ImageVideoScanStat;
import com.yy.hiyo.main.R;
import com.yy.hiyo.module.handlefileIntent.ContactsListAdapter;
import com.yy.hiyo.module.handlefileIntent.Contract;
import com.yy.hiyo.module.handlefileIntent.HandleFileIntentMsgDef;
import com.yy.hiyo.module.handlefileIntent.ShareContactsBean;
import com.yy.hiyo.module.handlefileIntent.common.FloatingBarItemDecoration;
import com.yy.hiyo.module.handlefileIntent.common.IndexBar;
import com.yy.hiyo.module.handlefileIntent.view.SelectFriendEmptyView;
import java.util.ArrayList;
import java.util.LinkedHashMap;

public class SelectFriendWindow
extends DefaultWindow
implements Contract.View {
    private SimpleTitleBar mSimpleTitleBar;
    private RecyclerView mRecyclerView;
    private LinearLayoutManager mLayoutManager;
    private LinkedHashMap<Integer, String> mHeaderList = new LinkedHashMap();
    private ArrayList<ShareContactsBean> mContactList;
    private ContactsListAdapter mAdapter;
    private PopupWindow mOperationInfoDialog;
    private View mLetterHintView;
    private Contract.Presenter mPresenter;
    private LoadingStatusLayout mLoadingStatusLayout;
    private SelectFriendEmptyView mSelectFriendEmptyView;
    private boolean mHasRecentContract = false;

    public SelectFriendWindow(Context context, UICallBacks callBacks, String name) {
        super(context, callBacks, name);
        this.init();
    }

    private void init() {
        this.setBackgroundColor(this.getResources().getColor(R.color.common_widget_bg));
        this.mSimpleTitleBar = new SimpleTitleBar(this.getContext());
        this.mSimpleTitleBar.setLeftTitle(ResourceUtils.getString((int)R.string.select_a_friend));
        this.mSimpleTitleBar.setLeftBtn(R.drawable.icon_nav_back, v -> MsgDispatcher.getInstance().sendMessage(HandleFileIntentMsgDef.MSG_CLOSE_SHOW_HANDLE_FILE_INTENT, (Object)true));
        this.getBarLayer().addView((View)this.mSimpleTitleBar, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, ResolutionUtils.dip2Px((float)48.0f)));
        this.mLoadingStatusLayout = new LoadingStatusLayout(this.getContext());
        FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
        params.gravity = 17;
        this.getBarLayer().addView((View)this.mLoadingStatusLayout, (ViewGroup.LayoutParams)params);
    }

    private void initList() {
        String value;
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.handle_image_friends_list, null);
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.share_add_contact_recyclerview);
        this.mLayoutManager = new LinearLayoutManager(this.getContext());
        this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)this.mLayoutManager);
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration(this.getContext(), 1));
        IndexBar indexBar = (IndexBar)view.findViewById(R.id.share_add_contact_sidebar);
        indexBar.setNavigators(new ArrayList<String>(this.mHeaderList.values()));
        final String recentString = ResourceUtils.getString((int)R.string.select_recently_chat_friend);
        if (this.mHeaderList.size() > 0 && StringUtils.equalsIgnoreCase((String)(value = this.mHeaderList.get(0)), (String)"*")) {
            this.mHasRecentContract = true;
            this.mHeaderList.put(0, recentString);
        }
        this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new FloatingBarItemDecoration(this.getContext(), this.mHeaderList));
        this.initAdapter();
        this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
        indexBar.setOnTouchingLetterChangedListener(new IndexBar.OnTouchingLetterChangeListener(){

            @Override
            public void onTouchingLetterChanged(String s) {
                SelectFriendWindow.this.showLetterHintDialog(s);
                if (StringUtils.equalsIgnoreCase((String)s, (String)"*")) {
                    s = recentString;
                }
                for (Integer position : SelectFriendWindow.this.mHeaderList.keySet()) {
                    if (!StringUtils.equalsIgnoreCase((String)((String)SelectFriendWindow.this.mHeaderList.get(position)), (String)s)) continue;
                    SelectFriendWindow.this.mLayoutManager.scrollToPositionWithOffset(position.intValue(), 0);
                    return;
                }
            }

            @Override
            public void onTouchingStart(String s) {
                SelectFriendWindow.this.showLetterHintDialog(s);
            }

            @Override
            public void onTouchingEnd(String s) {
                SelectFriendWindow.this.hideLetterHintDialog();
            }
        });
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        layoutParams.topMargin = ResolutionUtils.dip2Px((float)48.0f);
        this.getBarLayer().addView(view, (ViewGroup.LayoutParams)layoutParams);
    }

    private void initAdapter() {
        this.mAdapter = new ContactsListAdapter(LayoutInflater.from((Context)this.getContext()), this.mContactList);
        this.mAdapter.setOnContactsBeanClickListener(bean -> {
            if (this.mPresenter != null) {
                if (this.mPresenter.isSendFile()) {
                    this.mPresenter.sendFileToIM(bean);
                } else {
                    this.mPresenter.sendTextToIM(bean);
                }
            }
        });
    }

    private void preOperation() {
        this.mHeaderList.clear();
        if (this.mContactList.size() == 0) {
            return;
        }
        this.addHeaderToList(0, this.mContactList.get(0).getInitial());
        for (int i = 1; i < this.mContactList.size(); ++i) {
            if (this.mContactList.get(i - 1).getInitial().equalsIgnoreCase(this.mContactList.get(i).getInitial())) continue;
            this.addHeaderToList(i, this.mContactList.get(i).getInitial());
        }
    }

    private void addHeaderToList(int index, String header) {
        this.mHeaderList.put(index, header);
    }

    private void showLetterHintDialog(String s) {
        if (this.mOperationInfoDialog == null) {
            this.mLetterHintView = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.dialog_letter_hint, null);
            this.mOperationInfoDialog = new PopupWindow(this.mLetterHintView, -2, -2, false);
            this.mOperationInfoDialog.setOutsideTouchable(true);
        }
        ((TextView)this.mLetterHintView.findViewById(R.id.dialog_letter_hint_textview)).setText((CharSequence)s);
        ((Activity)this.getContext()).getWindow().getDecorView().post(new Runnable(){

            @Override
            public void run() {
                SelectFriendWindow.this.mOperationInfoDialog.showAtLocation(((Activity)SelectFriendWindow.this.getContext()).getWindow().getDecorView().findViewById(0x1020002), 17, 0, 0);
            }
        });
    }

    private void hideLetterHintDialog() {
        this.mOperationInfoDialog.dismiss();
    }

    @Override
    public void update(ArrayList<ShareContactsBean> shareContactsBeans) {
        if (this.mLoadingStatusLayout != null) {
            this.getBarLayer().removeView((View)this.mLoadingStatusLayout);
            this.mLoadingStatusLayout = null;
        }
        this.mContactList = shareContactsBeans;
        if (this.mContactList == null || this.mContactList.size() == 0) {
            this.mSelectFriendEmptyView = new SelectFriendEmptyView(this.getContext());
            FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -1);
            params.gravity = 1;
            params.topMargin = ResolutionUtils.dip2Px((float)58.0f);
            this.getBarLayer().addView((View)this.mSelectFriendEmptyView, (ViewGroup.LayoutParams)params);
        } else {
            this.preOperation();
            this.initList();
        }
        ImageVideoScanStat.INSTANCE.statShowFriendPage();
    }

    @Override
    public Context getContextD() {
        return this.getContext();
    }

    public void setPresenter(MvpPresenter presenter) {
        this.mPresenter = (Contract.Presenter)presenter;
    }
}

