/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.handlefileIntent.common;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.hiyo.main.R;
import java.util.Map;

public class FloatingBarItemDecoration
extends RecyclerView.ItemDecoration {
    private Context mContext;
    private int mTitleHeight;
    private Paint mBackgroundPaint;
    private Paint mTextPaint;
    private int mTextHeight;
    private int mTextBaselineOffset;
    private int mTextStartMargin;
    private Map<Integer, String> mList;

    public FloatingBarItemDecoration(Context context, Map<Integer, String> list) {
        this.mContext = context;
        Resources resources = this.mContext.getResources();
        this.mList = list;
        this.mTitleHeight = resources.getDimensionPixelSize(R.dimen.item_decoration_title_height);
        this.mBackgroundPaint = new Paint();
        this.mBackgroundPaint.setColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.item_decoration_title_background));
        this.mTextPaint = new Paint();
        this.mTextPaint.setColor(ContextCompat.getColor((Context)this.mContext, (int)R.color.item_decoration_title_fontcolor));
        this.mTextPaint.setTextSize((float)this.mContext.getResources().getDimensionPixelSize(R.dimen.item_decoration_title_fontsize));
        Paint.FontMetrics fm = this.mTextPaint.getFontMetrics();
        this.mTextHeight = (int)(fm.bottom - fm.top);
        this.mTextBaselineOffset = (int)fm.bottom;
        this.mTextStartMargin = resources.getDimensionPixelOffset(R.dimen.item_decoration_title_start_margin);
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
        super.getItemOffsets(outRect, view, parent, state);
        int position = ((RecyclerView.LayoutParams)view.getLayoutParams()).getViewAdapterPosition();
        outRect.set(0, this.mList.containsKey(position) ? this.mTitleHeight : 0, 0, 0);
    }

    public void onDraw(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDraw(c, parent, state);
        int left = parent.getPaddingLeft();
        int right = parent.getWidth() - parent.getPaddingRight();
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            View child = parent.getChildAt(i);
            RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)child.getLayoutParams();
            int position = params.getViewAdapterPosition();
            if (!this.mList.containsKey(position)) continue;
            this.drawTitleArea(c, left, right, child, params, position);
        }
    }

    private void drawTitleArea(Canvas c, int left, int right, View child, RecyclerView.LayoutParams params, int position) {
        int rectBottom = child.getTop() - params.topMargin;
        c.drawRect((float)left, (float)(rectBottom - this.mTitleHeight), (float)right, (float)rectBottom, this.mBackgroundPaint);
        c.drawText(this.mList.get(position), (float)(child.getPaddingLeft() + this.mTextStartMargin), (float)(rectBottom - (this.mTitleHeight - this.mTextHeight) / 2 - this.mTextBaselineOffset), this.mTextPaint);
    }

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        super.onDrawOver(c, parent, state);
        int position = ((LinearLayoutManager)parent.getLayoutManager()).findFirstVisibleItemPosition();
        if (position == -1) {
            return;
        }
        View child = parent.findViewHolderForAdapterPosition((int)position).itemView;
        String initial = this.getTag(position);
        if (initial == null) {
            return;
        }
        boolean flag = false;
        if (this.getTag(position + 1) != null && !initial.equals(this.getTag(position + 1)) && child.getHeight() + child.getTop() < this.mTitleHeight) {
            c.save();
            flag = true;
            c.translate(0.0f, (float)(child.getHeight() + child.getTop() - this.mTitleHeight));
        }
        c.drawRect((float)parent.getPaddingLeft(), (float)parent.getPaddingTop(), (float)(parent.getRight() - parent.getPaddingRight()), (float)(parent.getPaddingTop() + this.mTitleHeight), this.mBackgroundPaint);
        c.drawText(initial, (float)(child.getPaddingLeft() + this.mTextStartMargin), (float)(parent.getPaddingTop() + this.mTitleHeight - (this.mTitleHeight - this.mTextHeight) / 2 - this.mTextBaselineOffset), this.mTextPaint);
        if (flag) {
            c.restore();
        }
    }

    private String getTag(int position) {
        while (position >= 0) {
            if (this.mList.containsKey(position)) {
                return this.mList.get(position);
            }
            --position;
        }
        return null;
    }
}

