/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.handlefileIntent;

import android.util.Pair;
import androidx.annotation.Nullable;
import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.im.ImPageSourceData;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.kvomodule.KvoModuleManager;
import com.yy.appbase.kvomodule.module.ImModule;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.camera.base.ImageVideoScanStat;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.base.IChatSession;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.module.handlefileIntent.Contract;
import com.yy.hiyo.module.handlefileIntent.HandleFileIntentMsgDef;
import com.yy.hiyo.module.handlefileIntent.ImgShareData;
import com.yy.hiyo.module.handlefileIntent.ShareContactsBean;
import com.yy.hiyo.module.handlefileIntent.ShareData;
import com.yy.hiyo.module.handlefileIntent.TextShareData;
import com.yy.hiyo.module.handlefileIntent.dialog.ShareImageImDialog;
import com.yy.hiyo.relation.base.friend.IFriendServices;
import com.yy.hiyo.relation.base.friend.data.FriendInfo;
import com.yy.hiyo.relation.base.friend.data.FriendInfoList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SelectFriendsPresenter
implements Contract.Presenter {
    private IServiceManager iServiceManager;
    private Contract.View mView;
    private ArrayList<ShareContactsBean> mContactList = new ArrayList();
    private ShareData mShareData;
    private ShareImageImDialog mShareImageToImDialog;
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    SelectFriendsPresenter(Contract.View view, ShareData shareData) {
        this.iServiceManager = ServiceManagerProxy.getServiceManager();
        this.mView = view;
        this.mShareData = shareData;
    }

    @Override
    public void load() {
        this.mContactList.clear();
        final MutableLiveData mutableLiveData = ((ImModule)KvoModuleManager.getModule(ImModule.class)).getNormalChatSessions();
        mutableLiveData.observeForever(new Observer<List<?>>(){

            public void onChanged(@Nullable List<?> chatSessions) {
                if (chatSessions != null) {
                    for (Object s : chatSessions) {
                        IChatSession chatSession = (IChatSession)s;
                        if (chatSession.getSessionType() != 0) continue;
                        List listAvatar = chatSession.getAvatarUrls();
                        String avatarUrl = "";
                        if (listAvatar != null && listAvatar.size() > 0) {
                            avatarUrl = String.valueOf(listAvatar.get(0));
                        }
                        ShareContactsBean shareContactsBean = new ShareContactsBean(chatSession.getTitle(), avatarUrl, chatSession.getUid(), "*");
                        SelectFriendsPresenter.this.mContactList.add(shareContactsBean);
                    }
                }
                mutableLiveData.removeObserver((Observer)this);
                SelectFriendsPresenter.this.mBinder.clearAllKvoConnections();
                FriendInfoList friendInfoList = ServiceManager.getInstance().getService(IFriendServices.class).reqFriendList(false);
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)"vanda", (String)("getFriendList = " + friendInfoList.getUidList()), (Object[])new Object[0]);
                }
                SelectFriendsPresenter.this.updateInfoList(friendInfoList.getFriendList());
                SelectFriendsPresenter.this.mBinder.singleBindSourceTo((KvoSource)friendInfoList);
            }
        });
    }

    @KvoMethodAnnotation(name="friendList", sourceClass=FriendInfoList.class, thread=1)
    public void onFriendsList(KvoEventIntent event) {
        FriendInfoList friendInfoList = (FriendInfoList)event.source();
        this.updateInfoList(friendInfoList.getFriendList());
    }

    @Override
    public void cancelDialog() {
        if (this.mShareImageToImDialog != null) {
            this.mShareImageToImDialog.cancel();
        }
    }

    @Override
    public void sendFileToIM(ShareContactsBean shareContactsBean) {
        ImageVideoScanStat.INSTANCE.statClickShareFriend();
        this.mShareImageToImDialog = new ShareImageImDialog(shareContactsBean, this.mShareData, text -> this.sendImageMsg(shareContactsBean, (ImgShareData)this.mShareData, text));
        this.mShareImageToImDialog.show(this.mView.getContextD());
    }

    @Override
    public void sendTextToIM(ShareContactsBean shareContactsBean) {
        this.mShareImageToImDialog = new ShareImageImDialog(shareContactsBean, this.mShareData, text -> this.sendTextMsg(shareContactsBean, (TextShareData)this.mShareData, text));
        this.mShareImageToImDialog.show(this.mView.getContextD());
    }

    @Override
    public boolean isSendFile() {
        return this.mShareData instanceof ImgShareData;
    }

    private void updateInfoList(List<FriendInfo> friendInfos) {
        ArrayList<ShareContactsBean> list = new ArrayList<ShareContactsBean>();
        for (FriendInfo userInfoKS : friendInfos) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.info((Object)"vanda", (String)("getFriendListDetail = " + userInfoKS.toString()), (Object[])new Object[0]);
            }
            UserInfoKS userInfo = userInfoKS.getUserInfo();
            ShareContactsBean bean = new ShareContactsBean(userInfo.nick, userInfo.avatar, userInfo.uid, "");
            list.add(bean);
        }
        Collections.sort(list, ShareContactsBean::compareTo);
        this.mContactList.addAll(list);
        this.mView.update(this.mContactList);
    }

    private void sendImageMsg(ShareContactsBean shareContactsBean, ImgShareData imgShareData, String text) {
        ImageVideoScanStat.INSTANCE.statSendToFriend();
        if (RuntimeContext.sIsDebuggable) {
            MLog.info((Object)"vanda", (String)("sendImageMsg text = " + text), (Object[])new Object[0]);
        }
        if (this.iServiceManager != null) {
            YYTaskExecutor.execute(() -> {
                Pair pair = ImDataFactory.INSTANCE.sendImageMsg(imgShareData.getSharePath(), "", true, imgShareData.getSharePath() + System.currentTimeMillis(), shareContactsBean.mUid, shareContactsBean.getImageUrl(), shareContactsBean.getName(), 0, 0, 0, null, 0, false, null, false);
                if (ServiceManagerProxy.getServiceManager() != null) {
                    ((ImService)ServiceManagerProxy.getServiceManager().getService(ImService.class)).getSendService().sendOldIMToDbMsg((ImMsgReqParam)pair.first, (ImMessageDBBean)pair.second, null);
                }
            });
            this.sendTextMsg(shareContactsBean, text);
            this.goImPage(shareContactsBean);
        }
    }

    private void sendTextMsg(ShareContactsBean shareContactsBean, TextShareData textShareData, String text) {
        this.sendTextMsg(shareContactsBean, textShareData.getText());
        this.sendTextMsg(shareContactsBean, text);
        this.goImPage(shareContactsBean);
    }

    private void sendTextMsg(ShareContactsBean shareContactsBean, String text) {
        if (StringUtils.isNotEmpty((String)text) && this.iServiceManager != null) {
            YYTaskExecutor.execute(() -> {
                Pair pair = ImDataFactory.INSTANCE.sendTextMsg(text, shareContactsBean.mUid, shareContactsBean.getImageUrl(), shareContactsBean.getName(), null, false);
                ((ImService)this.iServiceManager.getService(ImService.class)).getSendService().sendOldIMToDbMsg((ImMsgReqParam)pair.first, (ImMessageDBBean)pair.second, null);
            });
        }
    }

    private void goImPage(ShareContactsBean shareContactsBean) {
        if (this.iServiceManager == null) {
            return;
        }
        YYTaskExecutor.execute(() -> {
            ImPageSourceData imPageBean = new ImPageSourceData(shareContactsBean.mUid, 0);
            ((ImService)this.iServiceManager.getService(ImService.class)).openImPage(imPageBean);
            MsgDispatcher.getInstance().sendMessage(HandleFileIntentMsgDef.MSG_CLOSE_SHOW_HANDLE_FILE_INTENT, (Object)false);
        }, (long)300L);
    }

    public void distory() {
        this.mBinder.clearAllKvoConnections();
    }
}

