/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.module.handlefileIntent;

import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.hiyo.main.R;
import com.yy.hiyo.module.handlefileIntent.ShareContactsBean;
import java.util.ArrayList;

public class ContactsListAdapter
extends RecyclerView.Adapter {
    private ArrayList<ShareContactsBean> mList;
    private LayoutInflater mLayoutInflater;
    private OnContactsBeanClickListener mOnClickListener;

    public ContactsListAdapter(LayoutInflater layoutInflater, ArrayList<ShareContactsBean> list) {
        this.mList = list;
        this.mLayoutInflater = layoutInflater;
    }

    public void setOnContactsBeanClickListener(OnContactsBeanClickListener listener) {
        this.mOnClickListener = listener;
    }

    private ShareContactsBean getItem(int position) {
        return this.mList.get(position);
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new ContactsViewHolder(this.mLayoutInflater.inflate(R.layout.handle_image_friends_list_item, parent, false));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        ShareContactsBean target = this.getItem(position);
        if (!(holder instanceof ContactsViewHolder)) {
            throw new IllegalStateException("Illegal state Exception onBindviewHolder");
        }
        ((ContactsViewHolder)holder).bindBean(target);
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public static interface OnContactsBeanClickListener {
        public void onContactsBeanClicked(ShareContactsBean var1);
    }

    private class ContactsViewHolder
    extends RecyclerView.ViewHolder {
        private YYTextView mYYTextViewNick;
        private CircleImageView mCircleImageView;

        ContactsViewHolder(View itemView) {
            super(itemView);
            this.mYYTextViewNick = (YYTextView)itemView.findViewById(R.id.tv_name);
            this.mCircleImageView = (CircleImageView)itemView.findViewById(R.id.iv_avatar);
        }

        void bindBean(final ShareContactsBean bean) {
            this.mYYTextViewNick.setText((CharSequence)bean.getName());
            ImageLoader.loadImage((ImageView)this.mCircleImageView, (String)bean.getImageUrl());
            this.itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ContactsListAdapter.this.mOnClickListener.onContactsBeanClicked(bean);
                }
            });
        }
    }
}

