/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.home.base.startup;

import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.net.Uri;
import android.os.Build;
import android.os.Process;
import com.yy.appbase.db.DataBox;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.hiidostatis.api.StatisContent;
import com.yy.hiyo.main.R;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SoCheckUtil {
    private static final String TAG = "SoCheckUtil";
    private static final String sSoList = "libglide-webp.so";
    private static final int MAX_TRIES = 2;

    public static boolean findNativeLibraryPath(Context context) {
        ZipFileInZipEntry zipFileInZipEntry = SoCheckUtil.findAPKWithLibrary(context, SoCheckUtil.supportedAbis(), sSoList);
        if (zipFileInZipEntry == null) {
            boolean noSo = true;
            try {
                DataBox.loadLibrary();
                noSo = false;
            }
            catch (Throwable e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
            if (!noSo) {
                if (SettingFlags.getBoolean((String)"aab_so_error", (boolean)false)) {
                    SettingFlags.setBoolean((String)"aab_so_error", (boolean)false);
                }
                return true;
            }
            SettingFlags.setBoolean((String)"aab_so_error", (boolean)true);
            new AlertDialog.Builder(context).setTitle(R.string.install_error_title).setMessage(R.string.install_error_msg).setCancelable(false).setPositiveButton(R.string.install_error_go_googleplay, (dialog, which) -> {
                SoCheckUtil.openGooglePlayStat();
                String appPackageName = context.getPackageName();
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)("https://play.google.com/store/apps/details?id=" + appPackageName)));
                intent.setPackage("com.android.vending");
                try {
                    context.startActivity(intent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                YYTaskExecutor.execute(() -> Process.killProcess((int)Process.myPid()), (long)2000L);
            }).show();
            return false;
        }
        if (zipFileInZipEntry.zipFile != null) {
            try {
                zipFileInZipEntry.zipFile.close();
            }
            catch (Exception e) {
                MLog.error((Object)TAG, (Throwable)e);
            }
        }
        return true;
    }

    public static boolean isAabSoError() {
        return SettingFlags.getBoolean((String)"aab_so_error", (boolean)false);
    }

    public static String[] supportedAbis() {
        if (Build.VERSION.SDK_INT >= 21 && Build.SUPPORTED_ABIS.length > 0) {
            return Build.SUPPORTED_ABIS;
        }
        if (!StringUtils.isEmpty((String)Build.CPU_ABI2)) {
            return new String[]{Build.CPU_ABI, Build.CPU_ABI2};
        }
        return new String[]{Build.CPU_ABI};
    }

    private static String[] sourceDirectories(Context context) {
        ApplicationInfo appInfo = context.getApplicationInfo();
        if (Build.VERSION.SDK_INT >= 21 && appInfo.splitSourceDirs != null && appInfo.splitSourceDirs.length != 0) {
            String[] apks = new String[appInfo.splitSourceDirs.length + 1];
            apks[0] = appInfo.sourceDir;
            System.arraycopy(appInfo.splitSourceDirs, 0, apks, 1, appInfo.splitSourceDirs.length);
            return apks;
        }
        return new String[]{appInfo.sourceDir};
    }

    private static ZipFileInZipEntry findAPKWithLibrary(Context context, String[] abis, String mappedLibraryName) {
        ZipFile zipFile = null;
        for (String sourceDir : SoCheckUtil.sourceDirectories(context)) {
            int tries = 0;
            while (tries++ < 2) {
                try {
                    zipFile = new ZipFile(new File(sourceDir), 1);
                    break;
                }
                catch (IOException ignored) {
                    ignored.printStackTrace();
                }
            }
            if (zipFile == null) continue;
            tries = 0;
            while (tries++ < 2) {
                String jniNameInApk = null;
                ZipEntry libraryEntry = null;
                for (String abi : abis) {
                    jniNameInApk = "lib" + File.separatorChar + abi + File.separatorChar + mappedLibraryName;
                    MLog.error((Object)TAG, (String)("Looking for jniNameInApk = " + jniNameInApk + "  sourceDir =  " + sourceDir), (Object[])new Object[0]);
                    libraryEntry = zipFile.getEntry(jniNameInApk);
                    if (libraryEntry == null) continue;
                    return new ZipFileInZipEntry(zipFile, libraryEntry);
                }
            }
            try {
                zipFile.close();
            }
            catch (IOException ignored) {
                ignored.printStackTrace();
            }
        }
        return null;
    }

    public static void openGooglePlayStat() {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("perftype", "go_gp");
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    private static void statCpuInfoAndSoDetail(String cpuInfo, String soDetail, String errMsg) {
        StatisContent statContent = new StatisContent();
        statContent.put("act", "hagoperf");
        statContent.put("sfield", cpuInfo);
        statContent.put("sfieldtwo", soDetail);
        statContent.put("sfieldthree", errMsg);
        statContent.put("perftype", "so_detail");
        HiidoStatis.reportContent((StatisContent)statContent);
    }

    public static void handleSoErrorToHiidoStat(Context context, String errMsg) {
        if (RuntimeContext.sIsDebuggable) {
            MLog.error((Object)TAG, (String)("so error e = " + errMsg), (Object[])new Object[0]);
        }
        ArrayList<String> libsName = new ArrayList<String>();
        ZipFile zipFile = null;
        for (String sourceDir : SoCheckUtil.sourceDirectories(context)) {
            int tries = 0;
            while (tries++ < 2) {
                try {
                    zipFile = new ZipFile(new File(sourceDir), 1);
                    break;
                }
                catch (IOException ignored) {
                    ignored.printStackTrace();
                }
            }
            if (zipFile == null) continue;
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = enumeration.nextElement();
                String name = entry.getName();
                if (!StringUtils.isNotEmpty((String)name) || !name.startsWith("lib/arm")) continue;
                libsName.add(name);
            }
        }
        SoCheckUtil.statCpuInfoAndSoDetail(SoCheckUtil.forString(SoCheckUtil.supportedAbis()), ((Object)libsName).toString(), errMsg);
    }

    private static String forString(String[] abis) {
        String temp = "";
        if (abis != null) {
            for (String abi : abis) {
                temp = temp + abi + "/";
            }
        }
        return temp;
    }

    private static class ZipFileInZipEntry {
        public ZipFile zipFile;
        public ZipEntry zipEntry;

        public ZipFileInZipEntry(ZipFile zipFile, ZipEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        public String toString() {
            return this.zipFile != null ? this.zipFile.toString() : "  " + (this.zipEntry != null ? this.zipEntry.toString() : "");
        }
    }
}

