/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.home.base.startup;

import android.content.Context;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.unifyconfig.config.BackupHostConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.hiyo.crashprotect.CrashPreProtecter;
import com.yy.hiyo.crashprotect.CrashProtecter;
import com.yy.hiyo.home.base.startup.LoadSecurityHardeningSo;
import com.yy.hiyo.home.base.startup.SoCheckUtil;
import com.yy.yylite.commonbase.crash.CrashSdk;
import com.yy.yylite.commonbase.hiido.HiidoUtils;

public class CrashInitUtil {
    private static boolean sInited = false;

    public static void init() {
        if (sInited) {
            return;
        }
        sInited = true;
        CrashPreProtecter.init();
        if (CrashInitUtil.needInitCrashSdk()) {
            String curVersionName = VersionUtil.getLocalName((Context)RuntimeContext.sApplicationContext);
            String storeVersionName = SettingFlags.getStringValue((String)"startup_versionname", (String)"");
            if (SystemUtils.isShowEnvSetting() || !StringUtils.equalsIgnoreCase((String)curVersionName, (String)storeVersionName) || SoCheckUtil.isAabSoError()) {
                SettingFlags.setStringValue((String)"startup_versionname", (String)curVersionName);
                CrashInitUtil.initCrashSdk();
            } else if (RuntimeContext.isHagoPartySdk()) {
                YYTaskExecutor.execute((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        CrashInitUtil.initCrashSdk();
                    }
                }, (long)1000L);
            }
        } else {
            YYTaskExecutor.execute(CrashProtecter::init, (long)1000L);
        }
    }

    private static boolean needInitCrashSdk() {
        return true;
    }

    public static void initCrashSdk() {
        if (!CrashInitUtil.needInitCrashSdk()) {
            return;
        }
        String url = BackupHostConfig.getOurSDKURI((String)"Crash");
        if (StringUtils.isNotEmpty((String)url)) {
            CrashSdk.INSTANCE.setCrashUrl(url);
        }
        if (StringUtils.isNotEmpty((String)(url = BackupHostConfig.getOurSDKURI((String)"CrashAnr")))) {
            CrashSdk.INSTANCE.setAnrUrl(url);
        }
        if (StringUtils.isNotEmpty((String)(url = BackupHostConfig.getOurSDKURI((String)"CrashDau")))) {
            CrashSdk.INSTANCE.setDauUrl(url);
        }
        if (StringUtils.isNotEmpty((String)(url = BackupHostConfig.getOurSDKURI((String)"CrashFeedBack")))) {
            CrashSdk.INSTANCE.setFeedbackUrl(url);
        }
        int interval = SettingFlags.getIntValue((String)"crash_sdk_anr_check_interval", (int)-1);
        CrashSdk.INSTANCE.init(true, AccountUtil.getUid(), HiidoUtils.getHdid(), interval);
        LoadSecurityHardeningSo.loadSecurityHardeningSo();
        YYTaskExecutor.execute(CrashProtecter::init, (long)500L);
    }
}

