/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.crashprotect;

import android.os.Looper;
import android.text.TextUtils;
import android.util.Log;

public class PushCrashProtecter {
    private static final String TAG = "PushCrashProtecter";
    private static volatile boolean sInited = false;
    private static volatile int sProtectTimes = 0;
    private static Thread.UncaughtExceptionHandler sDefaultHandler;
    private static boolean switchOn;

    public static synchronized void init() {
        PushCrashProtecter.initUnCaughtHandler();
    }

    private static void initUnCaughtHandler() {
        if (sInited) {
            return;
        }
        Log.e((String)TAG, (String)"init!");
        sInited = true;
        sDefaultHandler = Thread.getDefaultUncaughtExceptionHandler();
        Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                if (t == Looper.getMainLooper().getThread()) {
                    if (PushCrashProtecter.needCatch(e, true)) {
                        Log.e((String)PushCrashProtecter.TAG, (String)"catch: ", (Throwable)e);
                        PushCrashProtecter.loopAgain();
                    } else {
                        sDefaultHandler.uncaughtException(t, e);
                    }
                } else {
                    if (PushCrashProtecter.needCatch(e, false)) {
                        Log.e((String)PushCrashProtecter.TAG, (String)"catch:", (Throwable)e);
                        return;
                    }
                    sDefaultHandler.uncaughtException(t, e);
                }
            }
        });
    }

    private static void loopAgain() {
        ++sProtectTimes;
        try {
            Looper.loop();
        }
        catch (Throwable e) {
            if (PushCrashProtecter.needCatch(e, true)) {
                PushCrashProtecter.loopAgain();
            }
            if (sDefaultHandler != null) {
                sDefaultHandler.uncaughtException(Looper.getMainLooper().getThread(), e);
            }
            PushCrashProtecter.throwException(e);
        }
    }

    private static boolean inCatchHardcodeList(Throwable e) {
        if (e == null) {
            return false;
        }
        String errorMsg = e.getMessage();
        if (errorMsg == null || errorMsg.isEmpty()) {
            return false;
        }
        if (errorMsg.contains("Using WebView from more than one process at once with the same data directory") || e instanceof RuntimeException && errorMsg.contains("at org.chromium.android_webview.AwBrowserProcess.b(PG:11)")) {
            return true;
        }
        return errorMsg.contains("android.app.RemoteServiceException") && errorMsg.contains("Bad notification posted from package");
    }

    private static boolean needCatch(Throwable e, boolean uiThread) {
        if (e == null) {
            return false;
        }
        if (sProtectTimes >= 3 || !switchOn) {
            return false;
        }
        if (PushCrashProtecter.inCatchHardcodeList(e)) {
            return true;
        }
        return true;
    }

    public static void throwException(String message, Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            Log.e((String)TAG, (String)message);
            throw (RuntimeException)throwable;
        }
        if (TextUtils.isEmpty((CharSequence)message)) {
            throw new RuntimeException(message, throwable);
        }
        throw new RuntimeException(throwable);
    }

    public static void throwException(Throwable throwable) throws RuntimeException {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        throw new RuntimeException(throwable);
    }

    static {
        switchOn = true;
    }
}

