/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.auto;

import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.os.Debug;
import android.os.Looper;
import android.os.MessageQueue;
import android.os.Process;
import android.os.SystemClock;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SystemServiceUtils;

public class StartupMonitor {
    private static final String STARTUP_BROADCAST_FLAG = "com.yy.hiyo.startup.broadcast";
    public static long mStartTime = 0L;
    private static boolean isCmdMonitor = false;

    public static void checkStartByMonitor(Intent intent) {
        if (!RuntimeContext.sIsDebuggable) {
            return;
        }
        try {
            if (intent != null && intent.getIntExtra("cmdMonitor", 0) == 1) {
                MLog.info((Object)"StartupMonitor", (String)"start app is cmd monitor", (Object[])new Object[0]);
                isCmdMonitor = true;
            } else {
                isCmdMonitor = false;
            }
        }
        catch (Throwable e) {
            isCmdMonitor = false;
        }
    }

    public static void calculateStartUpTime(final Context context) {
        if (StartupMonitor.isCmdMonitor() && mStartTime > 0L) {
            Looper.myQueue().addIdleHandler(new MessageQueue.IdleHandler(){

                public boolean queueIdle() {
                    long startTime = SystemClock.uptimeMillis() - mStartTime;
                    mStartTime = 0L;
                    StartupMonitor.getMemoryTask(context, startTime);
                    return false;
                }
            });
        }
    }

    private static void getMemoryTask(final Context context, final long startTime) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ActivityManager am = SystemServiceUtils.getActivityManager((Context)context);
                int pid = Process.myPid();
                int[] myPid = new int[]{pid};
                Debug.MemoryInfo[] memoryInfoList = am.getProcessMemoryInfo(myPid);
                int memory = 0;
                if (memoryInfoList != null && memoryInfoList.length > 0 && memoryInfoList[0] != null) {
                    memory = memoryInfoList[0].getTotalPss() / 1024;
                } else {
                    MLog.info((Object)"StartupMonitor", (String)"memoryInfoList error", (Object[])new Object[0]);
                }
                MLog.info((Object)"StartupMonitor", (String)"startTime: %s  memory: %sM", (Object[])new Object[]{startTime, memory});
                Intent intent = new Intent(StartupMonitor.STARTUP_BROADCAST_FLAG);
                intent.putExtra("startupTime", startTime);
                intent.putExtra("startupMemory", memory);
                intent.putExtra("isDebug", RuntimeContext.sIsDebuggable);
                context.sendBroadcast(intent);
                System.exit(0);
                Process.killProcess((int)pid);
            }
        }, (long)12000L);
    }

    public static boolean isCmdMonitor() {
        return isCmdMonitor;
    }
}

