/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.applicationroute;

import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.SystemClock;
import android.util.Log;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.AppKeysDef;
import com.yy.appbase.DiskCacheChecker;
import com.yy.appbase.abtest.ABTestManager;
import com.yy.appbase.abtest.IAB;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.IAppsFlayerMediaSource;
import com.yy.appbase.envsetting.EnvSettings;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.http.CommonHttpHeader;
import com.yy.appbase.http.HttpUtil;
import com.yy.appbase.http.IHttpRequestPreventDuplicater;
import com.yy.appbase.http.IHttpRequestSender;
import com.yy.appbase.http.IHttpRetryCallback;
import com.yy.appbase.http.INetRespCallback;
import com.yy.appbase.ui.toast.GlobalBottomToastUtils;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.unifyconfig.config.CommonConfig;
import com.yy.appbase.unifyconfig.config.CommonConfigData;
import com.yy.appbase.util.Hiido2TrackStatHandler;
import com.yy.appbase.util.HiidoEventInterceptor;
import com.yy.base.env.MyApplication;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.logger.perf.PerfActionLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.timing.TimingTracer;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.VersionUtil;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.YYDialog.YYDialog;
import com.yy.hiyo.FireBaseDomain;
import com.yy.hiyo.MainActivity;
import com.yy.hiyo.apm.SwordBridge;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.app.perf.PerfManager;
import com.yy.hiyo.app.wrapper.CommonModuleBridger;
import com.yy.hiyo.applicationroute.StartUpSourceUtil;
import com.yy.hiyo.applicationroute.statfunction.ReportProcessAlive;
import com.yy.hiyo.auto.StartupMonitor;
import com.yy.hiyo.game.base.helper.ModifyJsGameHelper;
import com.yy.hiyo.home.base.perforstat.StartupStatHelper;
import com.yy.hiyo.home.base.startup.BlockCanaryUtil;
import com.yy.hiyo.home.base.startup.CrashInitUtil;
import com.yy.hiyo.home.base.startup.ExecutorAdapter;
import com.yy.hiyo.home.base.startup.StartUpBridgeHelper;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.hiyo.main.BuildConfig;
import com.yy.hiyo.metric.IReportMetricSampleImpl;
import com.yy.hiyo.module.appsflyer.AppsFlayerMediaSource;
import com.yy.hiyo.module.performancemonitor.perfcollect.PerfCollecter;
import com.yy.hiyo.module.performancemonitor.perfcollect.network.prevent.RequestPreventDuplicater;
import com.yy.hiyo.module.preconnect.HostPreConnectManager;
import com.yy.hiyo.module.push.localpush.LocalPushManager;
import com.yy.hiyo.module.splash.SplashManager;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.preventduplicater.IProtoRequestPreventDuplicater;
import com.yy.hiyo.proto.preventduplicater.IProtoRequestRealSender;
import com.yy.hiyo.proto.rpc.RpcMethod;
import com.yy.hiyo.restart.RestartHelper;
import com.yy.hiyo.url.UriHandler;
import com.yy.mobile.backgroundprocess.RemoteProcess;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import com.yy.yylite.commonbase.hiido.HiidoStatisInit;
import com.yy.yylite.commonbase.hiido.IReportMetricSample;
import com.yy.yylite.hiido.HiidoABTestJson;
import java.util.Map;

public class MainApplication
extends MyApplication {
    public void onCreate(Application application) {
        if (RestartHelper.isRestartProcess((Context)application)) {
            super.onCreate(application);
        } else {
            boolean isLowPhoneType;
            SettingFlags.init((Context)application);
            boolean isApplicationInit = true;
            int phoneType = SettingFlags.getIntValue((String)"phoneType");
            boolean bl = isLowPhoneType = phoneType == 1;
            if (isLowPhoneType) {
                isApplicationInit = StartUpSourceUtil.isLaunchActivity((Context)application);
            }
            if (isApplicationInit) {
                MainApplication.beforeAppCreate(application);
                super.onCreate(application);
                MainApplication.afterAppCreate(application, false);
            }
            MainApplication.initPushSdk(isApplicationInit);
        }
    }

    private static void initPushSdk(boolean isStartUpFromActivity) {
        StartUpBridgeHelper.INSTANCE.getStartUpBridge().onMainAppInitPushSdk(MainActivity.class, isStartUpFromActivity);
    }

    public static void onCreate(Application application, boolean byActivity) {
        if (RuntimeContext.sApplicationContext == null) {
            RuntimeContext.sApplicationContext = application;
        }
        SettingFlags.init((Context)application);
        MainApplication.beforeAppCreate(application);
        MainApplication.afterAppCreate(application, true);
        if (!RuntimeContext.isHagoPartySdk()) {
            FireBaseDomain.requestIfNeed();
        }
    }

    public static void beforeAppCreate(Application application) {
        TimingTracer.addSplit((String)"startup", (String)"beforeAppCreate");
        if (sCreateBeforeInited) {
            return;
        }
        MainApplication.beforeAppCreateInner(application);
    }

    private static synchronized void beforeAppCreateInner(Application application) {
        if (!sCreateBeforeInited) {
            PerfActionLog.setSwitch((boolean)false);
            PerfActionLog.start((String)"StarupPerfActionLog", (String)"", (Object[])new Object[0]);
            sCreateBeforeInited = true;
            MainApplication.liteAppBeforeCreate();
            SettingFlags.init((Context)application);
            MainApplication.initYYTaskExecutorMonitor();
            PerfCollecter.onApplicationCreate(application);
            StartupStatHelper.start();
            MainApplication.myAppBeforeCreate((Application)application);
            CrashInitUtil.init();
            StartupStatHelper.getStartPathLogger().add("MainApplication beforeAppCreate end", new Object[0]);
            if (RuntimeContext.isStartAtFirstInstalled()) {
                StartUpBridgeHelper.INSTANCE.getStartUpBridge().fbSdkInitialize(application);
            }
        }
    }

    public static void afterAppCreate(Application application, Boolean isFromMainActivity) {
        TimingTracer.addSplit((String)"startup", (String)"afterAppCreate");
        if (!sCreateAfterInited) {
            StartupStatHelper.getStartPathLogger().add("MainApplication afterAppCreate start", new Object[0]);
            sCreateAfterInited = true;
            if (RuntimeContext.sIsDebuggable) {
                RuntimeContext.setUseOldRoom((boolean)SettingFlags.getBoolean((String)"debug_oldroom", (boolean)false));
                RuntimeContext.setShowToast((boolean)SettingFlags.getBoolean((String)"toast_watch", (boolean)true));
            } else {
                RuntimeContext.setUseOldRoom((boolean)false);
            }
            MainApplication.initPhoneType();
            StartupStatHelper.getStartPathLogger().add("MainApplication initPhoneType", new Object[0]);
            MainApplication.myAppAfterCreate((Application)application);
            StartupStatHelper.getStartPathLogger().add("MainApplication myAppAfterCreate", new Object[0]);
            MainApplication.liteAppAfterCreate(application);
            StartupStatHelper.getStartPathLogger().add("MainApplication liteAppAfterCreate", new Object[0]);
            if (RuntimeContext.sIsMainProcess) {
                YYTaskExecutor.execute(() -> {
                    if (RuntimeContext.isHagoPartySdk()) {
                        ServiceManager.initDbService(false);
                    } else if (!DiskCacheChecker.isAvailableInternalStorgeNotEnough() && SettingFlags.getBoolean((String)"hasstorageper", (boolean)false)) {
                        ServiceManager.initDbService(false);
                    }
                });
            }
            StartupStatHelper.getStartPathLogger().add("MainApplication FileStorage init before", new Object[0]);
            StartupStatHelper.getStartPathLogger().add("MainApplication FileStorage inited", new Object[0]);
            if (RuntimeContext.sIsMainProcess) {
                MainApplication.updateInGrayFlag();
                FileStorageUtils.getInstance().setUIDFetcher(AccountUtil::getUid);
            }
            MainApplication.initPushSdk(isFromMainActivity == false);
            StartupStatHelper.getStartPathLogger().add("MainApplication afterAppCreate end", new Object[0]);
            SwordBridge.install();
        }
    }

    public static void updateInGrayFlag() {
        if (SettingFlags.containKey((String)"ingrayver")) {
            String inGrayVer = SettingFlags.getStringValue((String)"ingrayver", (String)"");
            if (StringUtils.isNotEmpty((String)inGrayVer)) {
                RuntimeContext.setInGrayFlag((boolean)StringUtils.equal((String)VersionUtil.getLocalName((Context)RuntimeContext.sApplicationContext), (String)inGrayVer));
            } else {
                RuntimeContext.setInGrayFlag((boolean)false);
            }
        } else {
            RuntimeContext.setInGrayFlag((boolean)BuildConfig.isBeatPackage);
        }
    }

    private static void liteAppBeforeCreate() {
        FileStorageUtils.APP_PACKAGE_NAME = AppKeysDef.getAppPackageName();
        RuntimeContext.sAppOncreateTime = SystemClock.uptimeMillis();
        RuntimeContext.sCrashTestLiteAppRun = true;
        StartupMonitor.mStartTime = RuntimeContext.sAppOncreateTime;
        RuntimeContext.sIsHagoApp = AppKeysDef.isHago();
        RuntimeContext.sAppid = AppKeysDef.getAppId();
        RuntimeContext.sCrashAppId = "HagoPartyNt-android";
    }

    private static void liteAppAfterCreate(Application application) {
        NetworkUtils.addNetworkChangeListener((networkTyp, info) -> MainApplication.onNetworkChange(networkTyp));
        if (SystemUtils.isShowEnvSetting()) {
            StartupStatHelper.getStartPathLogger().add("MainApplication NetworkUtils addNetworkChange", new Object[0]);
        }
        BlockCanaryUtil.initBlockCanary((Context)application);
        CommonModuleBridger.onApplicationCreate();
        if (!RuntimeContext.isHagoPartySdk()) {
            ModifyJsGameHelper.Companion.isX86Modler(true);
        }
        if (SystemUtils.isShowEnvSetting()) {
            StartupStatHelper.getStartPathLogger().add("MainApplication X86Modler init", new Object[0]);
        }
        MainApplication.initEnv();
        MainApplication.updateSP((Context)application);
        if (SystemUtils.isShowEnvSetting()) {
            StartupStatHelper.getStartPathLogger().add("MainApplication updateSP", new Object[0]);
        }
        MainApplication.initHttp();
        if (SystemUtils.isShowEnvSetting()) {
            StartupStatHelper.getStartPathLogger().add("MainApplication initHttp", new Object[0]);
        }
        String appId = AppKeysDef.getAppId();
        String version = "";
        if (RuntimeContext.isHagoPartySdk()) {
            appId = AppKeysDef.getAppName() + "#" + VersionUtil.getLocalVer((Context)RuntimeContext.sApplicationContext).getOriginalVersion();
            version = CommonHttpHeader.getHagoAppVerStr();
        }
        HiidoStatisInit.INSTANCE.initHiidoOptions(appId, version);
        MainApplication.initAccount();
        if (SystemUtils.isShowEnvSetting()) {
            StartupStatHelper.getStartPathLogger().add("MainApplication initAccount", new Object[0]);
        }
        MainApplication.initAbtest();
        if (SystemUtils.isShowEnvSetting()) {
            StartupStatHelper.getStartPathLogger().add("MainApplication initAB", new Object[0]);
        }
        StartUpBridgeHelper.INSTANCE.getStartUpBridge().onLiteAppAfterCreate(application, (IAppsFlayerMediaSource)new AppsFlayerMediaSource());
        ImageLoader.attachApplicationContext((Context)application);
        if (SystemUtils.isShowEnvSetting()) {
            StartupStatHelper.getStartPathLogger().add("MainApplication AppsFlayer init", new Object[0]);
        }
        if (RuntimeContext.sIsMainProcess) {
            if (!RuntimeContext.isHagoPartySdk()) {
                SplashManager.INSTANCE.preloadSplashIcon();
            }
            if (SystemUtils.isShowEnvSetting()) {
                StartupStatHelper.getStartPathLogger().add("MainApplication DeepLink init", new Object[0]);
            }
        }
        if (RuntimeContext.sIsMainProcess && !RuntimeContext.isHagoPartySdk()) {
            ExecutorAdapter.onAppCreated(application);
        }
        RuntimeContext.sProcessStartConsumeTime = SystemClock.uptimeMillis() - RuntimeContext.sAppOncreateTime;
        if (!RuntimeContext.sIsMainProcess) {
            RemoteProcess.onMobileAppCreate((Application)application, (String)RuntimeContext.sCurProcessName);
        }
        ToastUtils.setCustomToast((ToastUtils.ICustomToast)new ToastUtils.ICustomToast(){

            public void showToast(CharSequence toast, int length) {
                GlobalBottomToastUtils.showToast((CharSequence)toast, (int)length);
            }

            public boolean isCustomStyle() {
                return NAB.B.equals((Object)NewABDefine.GLOBAL_TOAST_TEST.getTest());
            }

            public boolean canHack() {
                return !YYDialog.hasDialogShowing();
            }
        });
        if (RuntimeContext.sIsDebuggable && !MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"LiteApplication", (String)("onCreate() " + (SystemClock.uptimeMillis() - RuntimeContext.sAppOncreateTime)), (Object[])new Object[0]);
        }
        RuntimeContext.sCrashTestLiteAppRunEnd = true;
        if (SettingFlags.getBoolean((String)"hiidoinitapp", (boolean)true)) {
            YYTaskExecutor.execute((Runnable)new Runnable(){

                @Override
                public void run() {
                    IAB iab = NewABDefine.HIIDO_AND_HAGO_NEWPACKERMODULE.getTest();
                    String json = HiidoABTestJson.parseHiidoAbTestJson((int)NewABDefine.HIIDO_AND_HAGO_NEWPACKERMODULE.getAbType().value(), (String)(iab != null ? iab.getValue("action") : ""));
                    MLog.debug((Object)"vanda", (String)("json " + json), (Object[])new Object[0]);
                    HiidoStatisInit.INSTANCE.iniHiidoSdk(true, json, (HiidoStatis.IHiidoEventInterceptor)new HiidoEventInterceptor(), (HiidoStatis.ITrackStatEventHandler)new Hiido2TrackStatHandler(), (IReportMetricSample)new IReportMetricSampleImpl());
                    ReportProcessAlive.handleStat();
                }
            }, (long)10000L);
        }
        RuntimeContext.sAppOncreateEndTime = SystemClock.uptimeMillis();
        YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(){

            @Override
            public void run() {
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        LocalPushManager.INSTANCE.initLocalPush();
                    }
                });
            }
        }, 20000L);
    }

    public void attachBaseContext(Application base) {
        RuntimeContext.sApplicationContext = base;
        SettingFlags.init((Context)base);
        MainApplication.initPhoneType();
    }

    public String procName(Application application) {
        return AppKeysDef.getAppPackageName();
    }

    public static void onNetworkChange(int type2) {
        YYTaskExecutor.postToMainThread(() -> {
            Notification notification = Notification.obtain((int)NotificationDef.N_NETWORK_STATE_CHANGE);
            notification.extObj = type2;
            NotificationCenter.getGlobalInstance().notify(notification);
            CommonHttpHeader.setNetTye((int)NetworkUtils.getNetworkType((Context)RuntimeContext.sApplicationContext));
        });
    }

    private static void initHttp() {
        MLog.debug((Object)"MainApplication", (String)"initHttp begin", (Object[])new Object[0]);
        ProtoManager.setProtoRequestPreventDuplicater((IProtoRequestPreventDuplicater)new IProtoRequestPreventDuplicater(){

            public <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> void sendProtoRequest(String roomId, REQ proto, RpcMethod<REQ, RES> rpcMethod, @Nullable IProtoCallback<RES> callback, boolean isWsRequest, IProtoRequestRealSender sender) {
                RequestPreventDuplicater.sendProtoRequest(roomId, proto, rpcMethod, callback, isWsRequest, sender);
            }

            public <REQ extends AndroidMessage<REQ, ?>, RES extends AndroidMessage<RES, ?>> boolean isProtoRequestNeedPrevent(String roomId, REQ proto, RpcMethod<REQ, RES> rpcMethod, @Nullable IProtoCallback<RES> callback, boolean isWsRequest) {
                return RequestPreventDuplicater.isProtoRequestNeedPrevent(roomId, proto, rpcMethod, callback, isWsRequest);
            }
        });
        if (SettingFlags.getBoolean((String)"openserverproxy", (boolean)true)) {
            HttpUtil.setHttpRetryCallback((IHttpRetryCallback)new IHttpRetryCallback(){

                public String getBackUpUrl(String originUrl) {
                    return UriProvider.getBackupUrl((String)originUrl);
                }

                public void onRetrySuccess(String url) {
                    PerfManager.statProxyBackSuccess(true, url, null);
                }

                public void onRetryError(String url, Exception e) {
                    PerfManager.statProxyBackSuccess(false, url, e);
                }

                public void onOriginError(String url, Exception e) {
                    PerfManager.statHttpOriginError(url, e);
                }
            });
        }
        HttpUtil.setRequestPreventDuplicater((IHttpRequestPreventDuplicater)new IHttpRequestPreventDuplicater(){

            public <T> void httpReq(String url, byte[] postContent, Map<String, String> param, int type2, INetRespCallback<T> callback, Map<String, String> headDataToAdd, IHttpRequestSender sender) {
                RequestPreventDuplicater.httpReq(url, postContent, param, type2, callback, headDataToAdd, sender);
            }
        });
        HttpUtil.init();
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                CommonHttpHeader.setHttpUtilCheckTokenListener();
                HostPreConnectManager.getInstance().preConnectLogin();
            }
        });
        PerfCollecter.tryDownloadUseHttp();
        if (RuntimeContext.sIsMainProcess) {
            UriHandler.init();
        }
        MLog.debug((Object)"MainApplication", (String)"initHttp end", (Object[])new Object[0]);
    }

    private static void initAbtest() {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                if (RuntimeContext.sIsDebuggable) {
                    Log.i((String)"ABTestManager", (String)"init");
                    ABTestManager.getInstance().init();
                    Log.i((String)"ABTestManager", (String)"init end!");
                } else {
                    ABTestManager.getInstance().init();
                }
            }
        });
    }

    private static void initEnv() {
        EnvSettings.instance().init();
    }

    private static void initAccount() {
        AccountModel.getInstance().init();
    }

    public void onTrimMemory(Application application, int level) {
        super.onTrimMemory(application, level);
        Notification notification = Notification.obtain((int)NotificationDef.N_ON_TRIM_MEMORY);
        notification.extObj = level;
        NotificationCenter.getGlobalInstance().notify(notification);
    }

    public void onLowMemory(Application application) {
        super.onLowMemory(application);
        Notification notification = Notification.obtain((int)NotificationDef.N_ON_LOW_MEMORY);
        NotificationCenter.getGlobalInstance().notify(notification);
    }

    private static void updateSP(final Context context) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                SharedPreferencesUtils.INSTANCE.copySystemSPFile(context);
            }
        });
    }

    private static void initPhoneType() {
        if (sPhoneTypeInited) {
            return;
        }
        sPhoneTypeInited = true;
        if (SettingFlags.containKey((String)"phoneType") && SettingFlags.containKey((String)"phonesuperlow")) {
            RuntimeContext.sPhoneType = SettingFlags.getIntValue((String)"phoneType");
            RuntimeContext.sPhoneSuperLow = SettingFlags.getBoolean((String)"phonesuperlow", (boolean)false);
            YYTaskExecutor.getDefaultIdleExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    MainApplication.updatePhoneType();
                }
            }, 20000L);
            return;
        }
        MainApplication.updatePhoneType();
    }

    private static void updatePhoneType() {
        long totalMem = (long)CommonUtils.getTotalMemory() * 1024L * 1024L;
        long memorySuperLow = 0x73333300L;
        long memoryLow = MainApplication.getPhoneLowMemory();
        long memoryMiddle = 0x140000000L;
        MLog.debug((Object)"MainApplication", (String)"totalMem: %d, memorySuperLow: %d, memoryLow: %d, memoryMiddle: %d", (Object[])new Object[]{totalMem, memorySuperLow, memoryLow, memoryMiddle});
        int lowSystemVersion = 24;
        int superLowSystemVersion = 22;
        try {
            int sdkVer = Build.VERSION.SDK_INT;
            if (sdkVer < superLowSystemVersion || totalMem <= memorySuperLow) {
                RuntimeContext.sPhoneType = 1;
                RuntimeContext.sPhoneSuperLow = true;
            } else {
                RuntimeContext.sPhoneType = sdkVer < lowSystemVersion || totalMem <= memoryLow ? 1 : (totalMem < memoryMiddle ? 2 : 3);
            }
            int testSwitch = SettingFlags.getIntValue((String)"ENV_DEBUG_PHONE_TYPE", (int)0);
            MLog.debug((Object)"MyApplication", (String)"testSwitch %s", (Object[])new Object[]{testSwitch});
            if (SystemUtils.isShowEnvSetting() && testSwitch > 0) {
                RuntimeContext.sPhoneType = testSwitch;
            }
            SettingFlags.setBoolean((String)"phonesuperlow", (boolean)RuntimeContext.sPhoneSuperLow);
            SettingFlags.setIntValue((String)"phoneType", (int)RuntimeContext.sPhoneType);
            MLog.error((Object)"MyApplication", (String)"PhoneType type:%d", (Object[])new Object[]{RuntimeContext.sPhoneType});
        }
        catch (Exception e) {
            MLog.error((Object)"MyApplication", (Throwable)e);
        }
    }

    private static long getPhoneLowMemory() {
        CommonConfigData data;
        AConfigData config = UnifyConfig.INSTANCE.getConfigData(BssCode.COMMON_CONFIG);
        if (config instanceof CommonConfig && (data = ((CommonConfig)config).getData()) != null) {
            MLog.debug((Object)"MainApplication", (String)"CommonConfigData phoneLowMemory\uff1a%d", (Object[])new Object[]{data.phoneLowMemory});
            return data.phoneLowMemory;
        }
        return 0x80000000L;
    }

    private static void initYYTaskExecutorMonitor() {
        PerfCollecter.initYYTaskExecutorMonitor();
    }
}

