/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.wrapper;

import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.constant.WindowNameDef;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.pagechange.PageStateReportService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.useractionstat.UserEnterActionStat;
import com.yy.base.memoryrecycle.views.IRecycleView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.framework.core.ui.DefaultWindow;
import com.yy.hiyo.app.wrapper.BaseWrapper;
import com.yy.hiyo.login.account.AccountInfo;
import com.yy.hiyo.login.account.AccountListManager;
import com.yy.hiyo.login.account.AccountModel;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;
import java.util.List;

class WindowPathWrapper
extends BaseWrapper {
    private final DefaultWindow.IGlobalWindowMonitor mWindowPathMonitor = new DefaultWindow.IGlobalWindowMonitor(){

        public void onWindowCreate(DefaultWindow window) {
            String name;
            if (window != null && !WindowNameDef.isHomePage((String)(name = window.getName()))) {
                HiidoStatis.onWindowShown((String)name);
                PageStateReportService.INSTANCE.onWindowShown(name);
            }
        }

        public void beforeShow(final DefaultWindow window) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (WindowPathWrapper.this.getWindowManager().getCurrentWindow() == window) {
                        if (DefaultWindow.isHisWindowRealVisble((IRecycleView)window)) {
                            return;
                        }
                        window.onWindowRealVisible();
                    }
                }
            });
        }

        public void onShown(DefaultWindow window) {
            if (window != null) {
                String name = window.getName();
                if (!WindowNameDef.isHomePage((String)name)) {
                    HiidoStatis.onWindowShown((String)name);
                    PageStateReportService.INSTANCE.onWindowShown(name);
                } else if ("Setting".equals(name)) {
                    WindowPathWrapper.this.updateAccountsHistoryInfo();
                }
                WindowPathWrapper.this.notifyWindowRealVisible(window);
                if (!WindowNameDef.isHomePage((String)window.getName()) && !StringUtils.equal((String)"Splash", (String)window.getName())) {
                    UserEnterActionStat.onNextWindowEnter((String)window.getName());
                }
            }
        }
    };

    WindowPathWrapper() {
    }

    @Override
    public void onBaseEnvInit(Environment baseEnv) {
        super.onBaseEnvInit(baseEnv);
        this.addGlobalWindowIntercept();
    }

    @Override
    public void onUserInfoUpdated() {
        this.updateAccountsHistoryInfo();
    }

    @Override
    public void onStartUpFinishAfterTenSecond() {
        this.updateAccountsHistoryInfo();
    }

    public void addGlobalWindowIntercept() {
        DefaultWindow.addGlobalMonitor((DefaultWindow.IGlobalWindowMonitor)this.mWindowPathMonitor);
        AbstractWindow currentWindow = this.baseEnv.getWindowManager().getCurrentWindow();
        if (currentWindow instanceof DefaultWindow) {
            this.mWindowPathMonitor.onShown((DefaultWindow)currentWindow);
        }
    }

    private void notifyWindowRealVisible(DefaultWindow window) {
        block10: {
            block9: {
                if (!DefaultWindow.isHisWindowRealVisble((IRecycleView)window)) {
                    window.onWindowRealVisible();
                }
                if (!window.isTransparent()) break block9;
                DefaultWindow transparentWindow = window;
                AbstractWindow behindWin = null;
                ArrayList<AbstractWindow> windows = new ArrayList<AbstractWindow>(3);
                do {
                    if ((behindWin = this.getWindowManager().getWindowBehind((AbstractWindow)transparentWindow)) != null) {
                        windows.add(behindWin);
                        if (behindWin.isTransparent()) {
                            transparentWindow = behindWin;
                            continue;
                        }
                        transparentWindow = null;
                        continue;
                    }
                    transparentWindow = null;
                } while (transparentWindow != null);
                if (windows.size() <= 0) break block10;
                for (AbstractWindow item : windows) {
                    item.onWindowRealVisible();
                }
                break block10;
            }
            ArrayList<AbstractWindow> windows = new ArrayList<AbstractWindow>();
            AbstractWindow behindWin = this.getWindowManager().getWindowBehind((AbstractWindow)window);
            if (behindWin != null) {
                do {
                    windows.add(behindWin);
                } while ((behindWin = this.getWindowManager().getWindowBehind(behindWin)) != null);
            }
            if (windows.size() > 0) {
                for (AbstractWindow item : windows) {
                    item.onWindowInvisible();
                }
            }
        }
    }

    private void updateAccountsHistoryInfo() {
        if (AccountUtil.getUid() > 0L) {
            AccountModel.getInstance().getAccountsHasLogined(new AccountListManager.IObtainCallBack(){

                public void onCallBackOnUiThread(List<AccountInfo> list) {
                    if (list != null && list.size() >= 1) {
                        ArrayList<Long> uids = new ArrayList<Long>(list.size());
                        IUserInfoService userInfoService = (IUserInfoService)WindowPathWrapper.this.getServiceManager().getService(IUserInfoService.class);
                        final ArrayList<UserInfoKS> userInfoKSList = new ArrayList<UserInfoKS>();
                        for (AccountInfo info : list) {
                            if (info.uuid <= 0L || info.loginType <= 0) continue;
                            uids.add(info.uuid);
                            UserInfoKS userInfoKS = userInfoService.getUserInfo(info.uuid);
                            if (userInfoKS.ver <= 0L) continue;
                            userInfoKSList.add(userInfoKS);
                        }
                        if (userInfoKSList.size() == uids.size()) {
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    AccountModel.getInstance().updateLoginedAccountUserInfo(userInfoKSList);
                                }
                            });
                        } else {
                            ((IUserInfoService)WindowPathWrapper.this.getServiceManager().getService(IUserInfoService.class)).requestUserInfosFromServer(uids, new OnKSProfileListCallback(){

                                public void onUISuccess(List<UserInfoKS> userInfo) {
                                    AccountModel.getInstance().updateLoginedAccountUserInfo(userInfo);
                                }

                                public void onError(String reason, long code) {
                                }
                            });
                        }
                    }
                }
            });
        }
    }
}

