/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.web.preload.webresource;

import android.net.Uri;
import android.webkit.MimeTypeMap;
import android.webkit.WebResourceResponse;
import androidx.annotation.Nullable;
import com.yy.appbase.abtest.newab.NAB;
import com.yy.appbase.abtest.newab.NewABDefine;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.MimeUtils;
import com.yy.hiyo.app.web.preload.MyFileUtil;
import com.yy.hiyo.app.web.preload.WebPreloadUtil;
import com.yy.hiyo.app.web.preload.config.ProjectConfigItem;
import com.yy.hiyo.game.base.config.WebPreloadConfig;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;

public class WebResourceManager {
    private static final String TAG = "Web_Preload_ResourceManager";
    private ICallBack mCallBack;
    private int mIsPreRenderOpen = -1;

    public WebResourceManager(ICallBack callBack) {
        this.mCallBack = callBack;
    }

    public boolean isOpenPreRenderByAbTest() {
        if (this.mIsPreRenderOpen == -1) {
            this.mIsPreRenderOpen = NAB.A.equals((Object)NewABDefine.WEB_PRERENDER.getTest()) ? 1 : 0;
        }
        return this.mIsPreRenderOpen == 1;
    }

    public MyWebResourceResponse getWebResourceResponse(Uri uri, IWebBusinessHandler myBusinessHandler) {
        String url = uri.toString();
        if (StringUtils.isEmpty((String)url)) {
            return null;
        }
        String[] strs = url.split("\\?", 2);
        if (strs == null || strs.length <= 0) {
            MLog.error((Object)TAG, (String)"url fomat error1", (Object[])new Object[0]);
            return null;
        }
        url = strs[0];
        if ((strs = url.split("#", 2)) == null || strs.length <= 0) {
            MLog.error((Object)TAG, (String)"url fomat error1.2", (Object[])new Object[0]);
            return null;
        }
        url = strs[0];
        String projectInfo = null;
        AConfigData configData = UnifyConfig.INSTANCE.getConfigData(BssCode.WEB_PRELOAD_CONFIG);
        if (configData instanceof WebPreloadConfig) {
            List list = ((WebPreloadConfig)configData).getPreloadConfig();
            for (String key : list) {
                if (projectInfo != null) break;
                projectInfo = this.getProjectInfo(url, key);
            }
        }
        if (projectInfo == null) {
            if (WebPreloadUtil.isLogEnable()) {
                MLog.info((Object)TAG, (String)"url not in whitelist!", (Object[])new Object[0]);
            }
            return null;
        }
        String[] strings = projectInfo.split("/", 2);
        if (strings == null || strings.length != 2) {
            MLog.error((Object)TAG, (String)"url fomat error2", (Object[])new Object[0]);
            return null;
        }
        String projectName = strings[0];
        String resPath = strings[1];
        if (this.mCallBack != null) {
            WebResourceResponse webResourceResponse;
            if (WebPreloadUtil.isLogEnable()) {
                MLog.info((Object)TAG, (String)"url in whitelist %s!", (Object[])new Object[]{url});
            }
            MyWebResourceResponse myWebResourceResponse = new MyWebResourceResponse();
            myWebResourceResponse.item = this.mCallBack.getProject(projectName);
            myWebResourceResponse.webResourceResponse = webResourceResponse = this.getWebResourceResponse(resPath, myWebResourceResponse.item);
            if (resPath != null && resPath.endsWith(".html") && !StringUtils.isEmpty((String)projectName)) {
                if (WebPreloadUtil.isLogEnable()) {
                    MLog.info((Object)TAG, (String)"onProjectHitCache report item %s, hit %s!", (Object[])new Object[]{url, String.valueOf(webResourceResponse != null)});
                }
                WebEnvSettings webEnvSettings = myBusinessHandler == null ? null : myBusinessHandler.getWebEnvSettings();
                this.onProjectHitCache(projectName, webResourceResponse != null, webEnvSettings);
                if (myWebResourceResponse.webResourceResponse != null && webEnvSettings != null) {
                    if (!webEnvSettings.statParams.localZipCacheHit) {
                        webEnvSettings.statParams.localZipMd5 = myWebResourceResponse.item != null ? myWebResourceResponse.item.zipMd5 : "";
                    }
                    webEnvSettings.statParams.localZipCacheHit = true;
                }
            }
            return myWebResourceResponse;
        }
        return null;
    }

    private void onProjectHitCache(String projectName, boolean hit, @Nullable WebEnvSettings webEnvSettings) {
        if (SettingFlagBaseKeys.isNormalMetricSwitchOn()) {
            HashMap<String, String> extra = new HashMap<String, String>(1);
            extra.put("is_from_deeplink", webEnvSettings != null && webEnvSettings.isFromDeepLink ? "1" : "0");
            HiidoStatis.reportAppMonitorReturnCode((String)("hyWebCacheHit/" + projectName), (long)0L, (String)String.valueOf(hit ? 0 : 1), extra);
        }
    }

    private String getProjectInfo(String url, String startPrefix) {
        if (url.startsWith(startPrefix)) {
            return url.substring(startPrefix.length());
        }
        return null;
    }

    private static String getMimeType(String filePath) {
        String ext = MimeTypeMap.getFileExtensionFromUrl((String)filePath);
        String mimeType = MimeTypeMap.getSingleton().getMimeTypeFromExtension(ext);
        if (StringUtils.isEmpty((String)mimeType)) {
            if (filePath.endsWith(".js")) {
                return "application/javascript";
            }
            if (filePath.endsWith(".html")) {
                return "text/html";
            }
            if (filePath.endsWith(".css")) {
                return "text/css";
            }
            if (filePath.endsWith(".json")) {
                return "application/json";
            }
            String extTwo = YYFileUtils.getExtension((String)filePath);
            mimeType = MimeUtils.guessMimeTypeFromExtension((String)extTwo);
            if (SystemUtils.isShowEnvSetting() && RuntimeContext.sIsDebuggable && StringUtils.isEmpty((String)mimeType) && StringUtils.isNotEmpty((String)extTwo)) {
                MLog.error((Object)TAG, (String)"resPath file MimeType is Empty, extTwo:%s, mimeType:%s, filePath:%s", (Object[])new Object[]{extTwo, mimeType, filePath});
            }
        }
        return mimeType;
    }

    private WebResourceResponse getWebResourceResponse(String resPath, ProjectConfigItem item) {
        if (item == null || StringUtils.isEmpty((String)resPath) || StringUtils.isEmpty((String)item.zipMd5)) {
            return null;
        }
        File path = new File(MyFileUtil.getProjectsDir().getAbsolutePath(), item.zipMd5);
        if (item.renderMode != 1 || !resPath.endsWith(".html") || !SettingFlags.getBoolean((String)"webprerender", (boolean)true)) {
            return this.getWebResourceResponse(resPath, item.zipMd5, path);
        }
        String preRenderLanguage = item.getPreRenderLanguage(SystemUtils.getLang());
        if (StringUtils.isEmpty((String)preRenderLanguage)) {
            return this.getWebResourceResponse(resPath, item.zipMd5, path);
        }
        if (!this.isOpenPreRenderByAbTest()) {
            return this.getWebResourceResponse(resPath, item.zipMd5, path);
        }
        String resPathReplace = resPath.substring(0, resPath.length() - 4) + preRenderLanguage + ".html";
        WebResourceResponse resourceResponse = this.getWebResourceResponse(resPathReplace, item.zipMd5, path);
        if (resourceResponse != null) {
            if (RuntimeContext.isInGray()) {
                MLog.info((Object)TAG, (String)"\u547d\u4e2d\u9884\u6e32\u67d3\u6a21\u5f0f\uff1a\u52a0\u8f7d%s\u6362\u6210\u52a0\u8f7d%s\u6210\u529f!", (Object[])new Object[]{resPath, resPathReplace});
            }
            return resourceResponse;
        }
        if (RuntimeContext.isInGray()) {
            MLog.info((Object)TAG, (String)"\u547d\u4e2d\u9884\u6e32\u67d3\u6a21\u5f0f\uff1a\u52a0\u8f7d%s\u6362\u6210\u52a0\u8f7d%s\u5931\u8d25!", (Object[])new Object[]{resPath, resPathReplace});
        }
        return this.getWebResourceResponse(resPath, item.zipMd5, path);
    }

    private WebResourceResponse getWebResourceResponse(String resPath, String projectNameMd5, File dirPath) {
        File path = dirPath;
        if (MyFileUtil.isFileNotInFileList(projectNameMd5, resPath)) {
            if (RuntimeContext.sIsDebuggable) {
                MLog.debug((Object)TAG, (String)"res notInFileList:%s", (Object[])new Object[]{resPath});
            }
            return null;
        }
        File file = new File(path.getAbsolutePath(), resPath);
        return this.getWebResourceResponseFromFile(resPath, projectNameMd5, path, file);
    }

    private WebResourceResponse getWebResourceResponseFromFile(String resPath, String projectNameMd5, File path, File file) {
        if (file == null) {
            return null;
        }
        if (!file.exists()) {
            if (WebPreloadUtil.isLogEnable()) {
                MLog.info((Object)TAG, (String)"res file not exist!", (Object[])new Object[0]);
            }
            return null;
        }
        if (!MyFileUtil.judgeFileSize(projectNameMd5, path, file, resPath)) {
            if (WebPreloadUtil.isLogEnable()) {
                MLog.info((Object)TAG, (String)"res file size is not right!", (Object[])new Object[0]);
            }
            return null;
        }
        String mimeType = WebResourceManager.getMimeType(file.getAbsolutePath());
        try {
            FileInputStream fis = new FileInputStream(file);
            return new WebResourceResponse(mimeType, "utf-8", (InputStream)fis);
        }
        catch (FileNotFoundException e) {
            MLog.error((Object)TAG, (Throwable)e);
            return null;
        }
    }

    public static interface ICallBack {
        public ProjectConfigItem getProject(String var1);
    }

    public static class MyWebResourceResponse {
        public WebResourceResponse webResourceResponse;
        public ProjectConfigItem item;
    }
}

