/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.web.preload;

import android.content.DialogInterface;
import android.net.Uri;
import android.os.Build;
import android.os.Message;
import android.os.SystemClock;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.IConfigListener;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.AConfigData;
import com.yy.appbase.util.FunctionReporter;
import com.yy.appbase.web.JsEventDefine;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.SystemUtils;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.app.web.IWebBusinessCallBackEx;
import com.yy.hiyo.app.web.preload.MyFileUtil;
import com.yy.hiyo.app.web.preload.WebPreloadUtil;
import com.yy.hiyo.app.web.preload.config.ConfigManager;
import com.yy.hiyo.app.web.preload.config.PreloadConfig;
import com.yy.hiyo.app.web.preload.config.ProjectConfigItem;
import com.yy.hiyo.app.web.preload.config.download.WebIncrementItem;
import com.yy.hiyo.app.web.preload.downloader.WebResDownloader;
import com.yy.hiyo.app.web.preload.webresource.WebResourceManager;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.webservice.WebEnvSettings;
import com.yy.webservice.client.IWebBusinessCallBack;
import com.yy.webservice.client.IWebBusinessHandler;
import com.yy.webservice.event.IJsEventCallback;
import com.yy.webservice.event.JsEvent;
import com.yy.webservice.event.JsMethod;
import com.yy.webservice.preload.ILoadInterceptorCallBack;
import com.yy.webservice.webwindow.webview.WebBusinessHandlerCallback;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.util.HashMap;

public class WebPreloadController
extends DefaultController
implements IWebBusinessCallBackEx,
ConfigManager.ICallBack,
WebResourceManager.ICallBack,
WebResDownloader.IWebResDownloadCallBack {
    private static final String TAG = "Web_Preload";
    private static String TAG_INTEREPCT = null;
    private DialogLinkManager mMyDialogManager;
    private HashMap<IWebBusinessHandler, WebBusinessHandlerCallback> mWebCallBacks;
    private ConfigManager mConfigManager;
    private WebResDownloader mResDownloader;
    private WebResourceManager mResManager;
    private JsEvent mJsEvent;
    private boolean mInited = false;
    private String loadUrl;
    private ILoadInterceptorCallBack loadCallBack;
    private WebEnvSettings webEnvSettings;

    public WebPreloadController(Environment env) {
        super(env);
    }

    public Object handleMessageSync(Message msg) {
        if (msg.what == MsgDef.MSG_WEB_PRELOAD_INIT) {
            if (Build.VERSION.SDK_INT >= 21) {
                this.initIfNeed();
            } else {
                MLog.info((Object)TAG, (String)"init ignore, version is lower than lollipop", (Object[])new Object[0]);
            }
        }
        return this.mInited;
    }

    private boolean isSwitchOn() {
        if (Build.VERSION.SDK_INT < 21) {
            return false;
        }
        if (SystemUtils.isShowEnvSetting() && !SettingFlags.getBoolean((String)"debug_WEB_OPT_SWITCH_KEY", (boolean)true)) {
            return false;
        }
        if (RuntimeContext.sIsDebuggable) {
            return true;
        }
        return SettingFlags.getBoolean((String)"hywebpre", (boolean)true);
    }

    private static String getTagIntercept() {
        if (TAG_INTEREPCT == null) {
            TAG_INTEREPCT = "Web_Preload_Interepct";
        }
        return TAG_INTEREPCT;
    }

    public void initIfNeed() {
        if (!this.isSwitchOn()) {
            MLog.info((Object)TAG, (String)"switch off!", (Object[])new Object[0]);
            return;
        }
        if (this.mInited) {
            MLog.info((Object)TAG, (String)"has inited!", (Object[])new Object[0]);
            return;
        }
        IWebService service = (IWebService)this.getServiceManager().getService(IWebService.class);
        if (service == null) {
            MLog.warn((Object)TAG, (String)"initIfNeed fail, no webService", (Object[])new Object[0]);
            return;
        }
        MLog.info((Object)TAG, (String)"initIfNeed register web business", (Object[])new Object[0]);
        service.registerWebBusiness((IWebBusinessCallBack)this);
        this.mConfigManager = new ConfigManager(this);
        this.mConfigManager.loadPreloadConfig(0L);
        this.mResDownloader = new WebResDownloader(this.getEnvironment(), this);
        this.mResManager = new WebResourceManager(this);
        UnifyConfig.INSTANCE.registerListener(BssCode.PERFORMANCE_CONFIG, (IConfigListener)new IConfigListener<AConfigData>(){

            public void onUpdateConfig(@Nullable AConfigData data) {
                if (!WebPreloadController.this.isSwitchOn()) {
                    MLog.info((Object)WebPreloadController.TAG, (String)"switch change to ON!", (Object[])new Object[0]);
                    WebPreloadController.this.mConfigManager.stopUpdate();
                    WebPreloadController.this.mResDownloader.stop();
                }
            }
        });
        this.mInited = true;
    }

    private WebBusinessHandlerCallback getWebCallBack(final IWebBusinessHandler businessHandler) {
        return new WebBusinessHandlerCallback(){
            private IWebBusinessHandler myBusinessHandler;
            private boolean firstHitCache;
            {
                this.myBusinessHandler = businessHandler;
                this.firstHitCache = false;
            }

            @RequiresApi(api=21)
            public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
                if (request == null) {
                    return null;
                }
                Uri url = request.getUrl();
                if (url == null) {
                    return null;
                }
                if (!WebPreloadController.this.isSwitchOn() || WebPreloadController.this.mConfigManager == null || !WebPreloadController.this.mConfigManager.isConfigValid()) {
                    return null;
                }
                WebResourceManager.MyWebResourceResponse resourceResponse = WebPreloadController.this.mResManager.getWebResourceResponse(url, this.myBusinessHandler);
                if (resourceResponse != null && resourceResponse.webResourceResponse != null) {
                    if (WebPreloadUtil.isLogEnable() || !this.firstHitCache) {
                        if (!this.firstHitCache) {
                            MLog.error((Object)WebPreloadController.TAG, (String)"res has intercepted %s!", (Object[])new Object[]{url.toString()});
                        } else {
                            MLog.info((Object)WebPreloadController.TAG, (String)"res has intercepted %s!", (Object[])new Object[]{url.toString()});
                        }
                        this.firstHitCache = true;
                    }
                    if (resourceResponse.webResourceResponse != null) {
                        FunctionReporter.statFunctionWorked((String)"WebResIntercept");
                    }
                    return resourceResponse.webResourceResponse;
                }
                if (RuntimeContext.sIsDebuggable) {
                    MLog.info((Object)WebPreloadController.TAG, (String)"res not intercept %s", (Object[])new Object[]{url.toString()});
                }
                return null;
            }

            public void beforeLoadUrl(String originUrl) {
                ProjectConfigItem item;
                if (this.myBusinessHandler == null || !SettingFlags.getBoolean((String)"webprerender", (boolean)true)) {
                    return;
                }
                WebEnvSettings settings = this.myBusinessHandler.getWebEnvSettings();
                if (settings != null && (item = WebPreloadController.this.mConfigManager.findProjectByUrl(settings.url)) != null && WebPreloadController.this.mResManager != null && WebPreloadController.this.mResManager.isOpenPreRenderByAbTest()) {
                    settings.renderMode = item.renderMode;
                    this.myBusinessHandler.updateRenderMode(item.renderMode);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebBusinessCreated(IWebBusinessHandler businessHandler) {
        if (!this.isSwitchOn()) {
            MLog.info((Object)TAG, (String)"onWebBusinessCreated switch off!", (Object[])new Object[0]);
            return;
        }
        if (businessHandler != null) {
            if (this.mJsEvent == null) {
                this.mJsEvent = new JsEvent(){

                    @NonNull
                    public JsMethod method() {
                        return JsEventDefine.BASE.webPreloadConfigUpdate;
                    }

                    public void jsCall(@NonNull IWebBusinessHandler webHandler, @NonNull String param, @Nullable IJsEventCallback callback) {
                        MLog.info((Object)WebPreloadController.TAG, (String)"js event update config!", (Object[])new Object[0]);
                        if (WebPreloadController.this.mConfigManager != null) {
                            WebPreloadController.this.mConfigManager.loadPreloadConfig(0L);
                        }
                    }
                };
            }
            WebBusinessHandlerCallback webBusinessHandlerCallback = this.getWebCallBack(businessHandler);
            WebPreloadController webPreloadController = this;
            synchronized (webPreloadController) {
                if (this.mWebCallBacks == null) {
                    this.mWebCallBacks = new HashMap(3);
                }
                this.mWebCallBacks.put(businessHandler, webBusinessHandlerCallback);
            }
            businessHandler.addWebViewListener(webBusinessHandlerCallback);
            businessHandler.addJsEvent(this.mJsEvent);
            MLog.info((Object)TAG, (String)"onWebBusinessCreated url %s!", (Object[])new Object[]{businessHandler.getWebEnvSettings() != null ? businessHandler.getWebEnvSettings().url : ""});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebBusinessDestroyed(IWebBusinessHandler businessHandler) {
        if (businessHandler != null) {
            if (this.mJsEvent != null) {
                businessHandler.removeJsEvent(this.mJsEvent);
            }
            WebBusinessHandlerCallback webBusinessHandlerCallback = null;
            WebPreloadController webPreloadController = this;
            synchronized (webPreloadController) {
                if (this.mWebCallBacks != null) {
                    webBusinessHandlerCallback = this.mWebCallBacks.get(businessHandler);
                    this.mWebCallBacks.remove(businessHandler);
                }
            }
            if (webBusinessHandlerCallback != null) {
                businessHandler.removeWebViewListener(webBusinessHandlerCallback);
            }
            MLog.info((Object)TAG, (String)"onWebBusinessDestroyed url %s!", (Object[])new Object[]{businessHandler.getWebEnvSettings() != null ? businessHandler.getWebEnvSettings().url : ""});
        }
    }

    @Override
    public void onConfigUpdated(final PreloadConfig config) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                if (WebPreloadController.this.mResDownloader != null) {
                    if (config != null && config.projects != null && config.projects.size() > 0) {
                        WebPreloadController.this.mResDownloader.preload(config.projects);
                    } else {
                        WebPreloadController.this.mResDownloader.stop();
                    }
                }
            }
        };
        if (YYTaskExecutor.isMainThread()) {
            command.run();
        } else {
            YYTaskExecutor.postToMainThread((Runnable)command);
        }
    }

    @Override
    public WebIncrementItem getDownloadIncrement(ProjectConfigItem item) {
        if (this.mConfigManager != null) {
            return this.mConfigManager.getDownloadIncrement(item);
        }
        return null;
    }

    @Override
    public ProjectConfigItem getProject(String projectName) {
        return this.mConfigManager != null ? this.mConfigManager.findProjectByName(projectName) : null;
    }

    @Override
    public void onConfigLoaded() {
        if (StringUtils.isNotEmpty((String)this.loadUrl) && this.loadCallBack != null) {
            boolean result = this.onLoadInterceptor(this.loadUrl, this.webEnvSettings, this.loadCallBack);
            if (!result) {
                this.loadCallBack.continueLoad();
            }
            if (this.webEnvSettings != null) {
                this.webEnvSettings.statParams.configLoadedTime = System.currentTimeMillis();
            }
            this.loadUrl = null;
            this.loadCallBack = null;
            this.webEnvSettings = null;
        }
    }

    @Override
    public boolean onLoadInterceptor(final String url, final WebEnvSettings settings, final ILoadInterceptorCallBack callBack) {
        if (!this.mInited || this.mConfigManager == null) {
            if (settings != null) {
                settings.statParams.configHit = -1;
            }
            return false;
        }
        long timeNow = System.currentTimeMillis();
        if (!this.mConfigManager.hasLoaded() && AccountUtil.getUid() > 0L) {
            this.loadUrl = url;
            this.loadCallBack = callBack;
            this.webEnvSettings = settings;
            if (settings != null) {
                settings.statParams.configHit = 0;
            }
            return true;
        }
        if (this.mConfigManager.hasLoaded()) {
            if (settings != null && !this.mConfigManager.isConfigEmpty()) {
                settings.statParams.configHit = 1;
                settings.statParams.configLoadedTime = timeNow;
            } else if (settings != null) {
                settings.statParams.configHit = 0;
            }
        } else if (settings != null) {
            settings.statParams.configHit = 2;
        }
        if (StringUtils.isEmpty((String)url) || this.mConfigManager == null || this.mResDownloader == null || callBack == null) {
            return false;
        }
        if (!SettingFlags.getBoolean((String)"hywebinterept", (boolean)true)) {
            return false;
        }
        int from = callBack.from();
        if (from != 2 && from != 1 && from != 4 && !SettingFlags.getBoolean((String)"hywebpendantinterept", (boolean)true)) {
            return false;
        }
        final ProjectConfigItem item = this.mConfigManager.isUrlInForceLoad(url);
        if (item == null) {
            MLog.info((Object)WebPreloadController.getTagIntercept(), (String)"onLoadInterceptor retrun by url not in config!", (Object[])new Object[0]);
            return false;
        }
        boolean intercepted = false;
        if (!MyFileUtil.isPreloaded(item)) {
            Runnable command = new Runnable(){

                @Override
                public void run() {
                    if (WebPreloadController.this.mMyDialogManager != null) {
                        WebPreloadController.this.mMyDialogManager.dismissDialog();
                    }
                    final long startime = SystemClock.elapsedRealtime();
                    MLog.info((Object)WebPreloadController.getTagIntercept(), (String)"onLoadInterceptor start url:%s projectName:%s projectUrl:%s!", (Object[])new Object[]{url, item.name, item.zipUrl});
                    final MyLoadInterceptorDownloadCallback downloadCallback = new MyLoadInterceptorDownloadCallback(callBack){

                        public void onComplete(Downloader downloader) {
                            ProjectConfigItem coreItem;
                            MLog.info((Object)WebPreloadController.getTagIntercept(), (String)"onLoadInterceptor downloadSuccess\uff0ciscorejslib:%s!", (Object[])new Object[]{this.loadCoreLibs});
                            if (WebPreloadController.this.mConfigManager != null && this.interceptorCallBack != null && !this.loadCoreLibs && (coreItem = WebPreloadController.this.mConfigManager.findProjectByName("corejslib")) != null && !MyFileUtil.isPreloaded(coreItem)) {
                                WebPreloadController.this.preloadCorelibs(coreItem, this);
                                return;
                            }
                            if (this.interceptorCallBack != null) {
                                if (settings != null) {
                                    settings.statParams.resDownloadedTimeAfterStartLoad = System.currentTimeMillis();
                                }
                                this.interceptorCallBack.continueLoad();
                                WebPreloadController.this.onLoadInterceptorResult(url, 0, SystemClock.elapsedRealtime() - startime);
                            }
                            if (WebPreloadController.this.mMyDialogManager != null) {
                                WebPreloadController.this.mMyDialogManager.dismissDialog();
                            }
                            this.interceptorCallBack = null;
                        }

                        public void onError(Downloader downloader, int errorType, String errorInfo) {
                            MLog.info((Object)WebPreloadController.getTagIntercept(), (String)"onLoadInterceptor error\uff0ciscorejslib:%s!", (Object[])new Object[]{this.loadCoreLibs});
                            if (this.interceptorCallBack != null) {
                                if (settings != null) {
                                    settings.statParams.resDownloadedTimeAfterStartLoad = System.currentTimeMillis();
                                }
                                this.interceptorCallBack.continueLoad();
                                WebPreloadController.this.onLoadInterceptorResult(url, 1, SystemClock.elapsedRealtime() - startime);
                            }
                            if (WebPreloadController.this.mMyDialogManager != null) {
                                WebPreloadController.this.mMyDialogManager.dismissDialog();
                            }
                            this.interceptorCallBack = null;
                        }

                        public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
                            if (!RuntimeContext.sIsDebuggable) {
                                return;
                            }
                            MLog.info((Object)WebPreloadController.getTagIntercept(), (String)"onLoadInterceptor onProgressChange total:%s, cursize:%s!", (Object[])new Object[]{String.valueOf(totalSize), String.valueOf(curSize)});
                        }

                        public void onStart(Downloader downloader) {
                            MLog.info((Object)WebPreloadController.getTagIntercept(), (String)"onLoadInterceptor startDownload\uff0ciscorejslib:%s!", (Object[])new Object[]{this.loadCoreLibs});
                        }

                        public void onCreate(Downloader downloader) {
                            MLog.info((Object)WebPreloadController.getTagIntercept(), (String)"onLoadInterceptor onDownloadCreate downloadType:%d", (Object[])new Object[]{downloader.getTaskGroup()});
                            if (settings != null) {
                                settings.statParams.resPatchDownloadTypeAfterStartLoad = downloader.getTaskGroup() == DownloadBussinessGroup.WEB_PRELOAD_PATCH_FILE;
                            }
                        }
                    };
                    WebPreloadController.this.mResDownloader.preloadItemNow(item, downloadCallback);
                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if (WebPreloadController.this.mMyDialogManager != null) {
                                WebPreloadController.this.mMyDialogManager.dismissDialog();
                            }
                            if (downloadCallback.interceptorCallBack != null) {
                                MLog.info((Object)WebPreloadController.getTagIntercept(), (String)"onLoadInterceptor timeOut!", (Object[])new Object[0]);
                                if (settings != null) {
                                    settings.statParams.resDownloadedTimeAfterStartLoad = System.currentTimeMillis();
                                }
                                downloadCallback.interceptorCallBack.continueLoad();
                                downloadCallback.interceptorCallBack = null;
                                if (WebPreloadController.this.mResDownloader != null) {
                                    WebPreloadController.this.mResDownloader.stopPreloadItem(item);
                                }
                                WebPreloadController.this.onLoadInterceptorResult(url, 2, SystemClock.elapsedRealtime() - startime);
                            }
                        }
                    }, (long)8000L);
                    if (callBack.from() == 1) {
                        WebPreloadController.this.getMyDialogManager().showDialog((BaseDialog)new ProgressDialog("", true, false, new DialogInterface.OnDismissListener(){

                            public void onDismiss(DialogInterface dialog) {
                                if (downloadCallback.interceptorCallBack != null) {
                                    MLog.info((Object)WebPreloadController.getTagIntercept(), (String)"onLoadInterceptor user canceled!", (Object[])new Object[0]);
                                    if (settings != null) {
                                        settings.statParams.resDownloadedTimeAfterStartLoad = System.currentTimeMillis();
                                    }
                                    downloadCallback.interceptorCallBack.continueLoad();
                                    downloadCallback.interceptorCallBack = null;
                                    if (WebPreloadController.this.mResDownloader != null) {
                                        WebPreloadController.this.mResDownloader.stopPreloadItem(item);
                                    }
                                    WebPreloadController.this.onLoadInterceptorResult(url, 3, SystemClock.elapsedRealtime() - startime);
                                }
                            }
                        }));
                    }
                }
            };
            if (!YYTaskExecutor.isMainThread()) {
                YYTaskExecutor.postToMainThread((Runnable)command);
            } else {
                command.run();
            }
            if (settings != null) {
                settings.statParams.resCacheHitWhenStartLoad = 0;
            }
            intercepted = true;
            FunctionReporter.statFunctionWorked((String)"WebLoadIntercept");
        } else {
            if (settings != null) {
                settings.statParams.resCacheHitWhenStartLoad = 1;
                settings.statParams.resDownloadedTimeAfterStartLoad = timeNow;
            }
            MLog.info((Object)WebPreloadController.getTagIntercept(), (String)"onLoadInterceptor not intercepted!", (Object[])new Object[0]);
        }
        return intercepted;
    }

    private void preloadCorelibs(ProjectConfigItem coreItem, MyLoadInterceptorDownloadCallback downloadCallback) {
        downloadCallback.loadCoreLibs = true;
        MLog.info((Object)WebPreloadController.getTagIntercept(), (String)"onLoadInterceptor preloadCorelibs start projectName:%s projectUrl:%s!", (Object[])new Object[]{coreItem.zipUrl, coreItem.name});
        this.mResDownloader.preloadItemNow(coreItem, downloadCallback);
    }

    private void onLoadInterceptorResult(final String urlOrigin, final int resultType, final long time) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                String url = urlOrigin;
                if (StringUtils.isNotEmpty((String)url)) {
                    url = url.replaceFirst("https://", "");
                    int index = (url = url.replaceFirst("http://", "")).indexOf("?");
                    if (index > 0) {
                        url = url.substring(0, index);
                    }
                }
                HiidoStatis.reportAppMonitorReturnCode((String)("hyWebInterceptor/" + url), (long)time, (String)String.valueOf(resultType));
            }
        });
    }

    private DialogLinkManager getMyDialogManager() {
        this.mMyDialogManager = new DialogLinkManager(this.mContext);
        return this.mMyDialogManager;
    }

    private static abstract class MyLoadInterceptorDownloadCallback
    implements IDownloadCallback {
        ILoadInterceptorCallBack interceptorCallBack;
        boolean loadCoreLibs = false;

        MyLoadInterceptorDownloadCallback(ILoadInterceptorCallBack callBack) {
            this.interceptorCallBack = callBack;
        }
    }
}

