/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.serverwrapper.room;

import android.os.Message;
import androidx.annotation.NonNull;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.service.IServiceManager;
import com.yy.framework.core.Environment;
import com.yy.framework.core.MsgDispatcher;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.IRoomService;

public class ChannelRoomServiceCreator
implements IServiceManager.IServiceCreator<IRoomService> {
    private IRoomService mRoomService;

    public IRoomService createService(Environment env, IServiceManager manager) {
        if (this.mRoomService == null) {
            this.mRoomService = new MyRoomServiceImpl(env, manager);
        }
        return this.mRoomService;
    }

    private class MyRoomServiceImpl
    implements IRoomService {
        private Environment env;
        private IServiceManager manager;

        public MyRoomServiceImpl(Environment env, IServiceManager manager) {
            this.env = env;
            this.manager = manager;
        }

        public void enterRoom(EnterParam param) {
            if (param == null) {
                return;
            }
            Message message = Message.obtain();
            message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
            message.obj = param;
            MsgDispatcher.getInstance().sendMessage(message);
        }

        public void exitRoom() {
            Message message = Message.obtain();
            message.what = AppbaseMsgDef.ChannelMsgDef.EXIT_CHANNEL;
            MsgDispatcher.getInstance().sendMessage(message);
        }

        public void exitRoom(@NonNull String roomId) {
            Message message = Message.obtain();
            message.what = AppbaseMsgDef.ChannelMsgDef.EXIT_CHANNEL;
            message.obj = roomId;
            MsgDispatcher.getInstance().sendMessage(message);
        }
    }
}

