/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.push;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.os.Message;
import android.text.TextUtils;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.analogai.AnalogAiModel;
import com.yy.appbase.common.Callback;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.BbsNoticeDBBean;
import com.yy.appbase.data.ImMessageDBBean;
import com.yy.appbase.envsetting.uriprovider.UriProvider;
import com.yy.appbase.growth.GrowthMsgDef;
import com.yy.appbase.im.GameMessageModel;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.push.NotificationManager;
import com.yy.appbase.push.NotificationTrack;
import com.yy.appbase.push.PushNotification;
import com.yy.appbase.push.PushNotificationData;
import com.yy.appbase.push.PushShowLimitManager;
import com.yy.appbase.service.IChannelPushStatService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.IWebService;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.service.home.DiscoverPageType;
import com.yy.appbase.service.home.IHomeService;
import com.yy.appbase.service.home.PlayTabType;
import com.yy.appbase.ui.dialog.ProgressDialog;
import com.yy.appbase.ui.toast.TopToastUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ColorUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.URLUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.app.push.HandleAiPush;
import com.yy.hiyo.app.push.PushJumpHelper;
import com.yy.hiyo.bbs.base.service.IPostService;
import com.yy.hiyo.channel.base.EnterParam;
import com.yy.hiyo.channel.base.EntryInfo;
import com.yy.hiyo.channel.base.FirstEntType;
import com.yy.hiyo.channel.base.IChannelCenterService;
import com.yy.hiyo.channel.base.IRoomService;
import com.yy.hiyo.channel.base.hiido.ChannelBaseTrack;
import com.yy.hiyo.game.base.IMPKAcceptReqBean;
import com.yy.hiyo.game.base.bean.GameDownloadInfo;
import com.yy.hiyo.game.base.bean.GameInfo;
import com.yy.hiyo.game.base.singlegame.indie.IndieGamePlayContext;
import com.yy.hiyo.game.base.teamgame.TeamInviteResCodeHelper;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameInviteService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.game.service.bean.GameContextDef;
import com.yy.hiyo.game.service.bean.GameMatchContext;
import com.yy.hiyo.game.service.bean.GamePlayContext;
import com.yy.hiyo.game.service.bean.GameSelectContext;
import com.yy.hiyo.game.service.bean.GameTeamMatchContext;
import com.yy.hiyo.game.service.callback.IIMTeamGameListener;
import com.yy.hiyo.game.service.callback.IIndepGameAcceptCallback;
import com.yy.hiyo.im.ImBaseMsgDef;
import com.yy.hiyo.im.ImDataFactory;
import com.yy.hiyo.im.ImMsgUtils;
import com.yy.hiyo.im.ImNotificationBaseDef;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.im.Utils;
import com.yy.hiyo.im.base.IMsgSendListener;
import com.yy.hiyo.im.base.ImMsgReqParam;
import com.yy.hiyo.im.base.data.INewImData;
import com.yy.hiyo.login.base.IGuestAutoLoginCallback;
import com.yy.hiyo.main.R;
import com.yy.hiyo.main.msg.MsgDef;
import com.yy.hiyo.module.splash.SplashManager;
import com.yy.hiyo.push.base.PushSDKHelper;
import com.yy.hiyo.user.base.UserMsgDef;
import com.yy.hiyo.user.base.profilesource.ProfileReportBean;
import com.yy.webservice.WebEnvSettings;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import ikxd.msg.PushPayloadType;
import ikxd.msg.PushSourceType;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import net.ihago.social.api.aiencourage.InvokeType;
import org.json.JSONObject;

public class PushJumpController
extends DefaultController {
    private static final String TAG = "PushJumpController";
    private static final String FRIEND_LIST_URL = "hago://friend/list";
    private static final String FANS_LIST_URL = "hago://fans/list";
    private GameMessageModel mGameMessageModel;
    private INotify mHomeShowNotify;
    private IIMTeamGameListener mImTeamGameListener = new IIMTeamGameListener(){

        public void onTeamGameImInviteSuccessRes(String gameId, String teamId, int gameTemplate) {
        }

        public void onTeamGameImInviteFailRes(long code, String gameId) {
        }

        public void onTeamGameImCancelSuccessRes(String teamId, long targetUid) {
        }

        public void onTeamGameImCancelFailRes(long code) {
        }

        public void onTeamGameImInviteAcceptRes(String gameId, String teamId, boolean accept, int teamTemplete) {
            PushJumpController.this.onImInviteAcceptRes(gameId, true, null, null, teamId, teamTemplete);
        }

        public void onTeamGameImInviteAcceptFailRes(final String gameId, String teamId, boolean accept, final long code) {
            PushJumpController.this.getServiceManager().observeService(IGameInfoService.class, (Callback)new Callback<IGameInfoService>(){

                public void onResponse(IGameInfoService gameInfoService) {
                    GameInfo gameInfo = gameInfoService.getGameInfoByGid(gameId);
                    if (gameInfo == null) {
                        return;
                    }
                    TeamInviteResCodeHelper.handleResCode((long)code, (Context)PushJumpController.this.mContext, (GameInfo)gameInfo);
                }
            });
        }

        public void onTeamGameImAcceptNotify(String gameId, String teamId, int template, boolean isAccept) {
        }
    };

    public PushJumpController(Environment env) {
        super(env);
    }

    public void handlePayload(final String payload, final String msgId, final boolean isFcmType, final boolean isPushSdkStyle, final boolean isOfflineMsg) {
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    MLog.info((Object)PushJumpController.TAG, (String)"handlePushData payload: %s, msgId: %s, isFcmType: %b, isPushSdkStyle: %b, isOffline: %b", (Object[])new Object[]{payload, msgId, isFcmType, isPushSdkStyle, isOfflineMsg});
                    JSONObject payloadJson = JsonParser.obtainJSONObject((String)payload);
                    String fromChannel = payloadJson.optString("push_channel");
                    if (StringUtils.isEmpty((String)fromChannel) && isFcmType) {
                        fromChannel = "128";
                    }
                    String pushSourceString = payloadJson.optString("push_source");
                    PushSourceType pushSource = NotificationManager.Instance.getPushSourceType(pushSourceString);
                    PushNotificationData pushNotificationData = new PushNotificationData(0L, fromChannel, pushSource, payloadJson);
                    pushNotificationData.setOffline(isOfflineMsg);
                    NotificationManager.Instance.cancelNotification(pushNotificationData);
                    if (pushNotificationData.getPayloadType() == -1) {
                        MLog.warn((Object)PushJumpController.TAG, (String)"handlePushData ignore, payloadType == -1", (Object[])new Object[0]);
                        return;
                    }
                    if (isFcmType && !isPushSdkStyle && !RuntimeContext.isHagoPartySdk()) {
                        long pushMsgId = 0L;
                        if (StringUtils.isNotEmpty((String)msgId)) {
                            try {
                                pushMsgId = Long.parseLong(msgId);
                            }
                            catch (Exception e) {
                                MLog.error((Object)PushJumpController.TAG, (String)"parsePushMsgId error", (Throwable)e, (Object[])new Object[0]);
                            }
                        }
                        PushSDKHelper.getPushService().uploadFcmClickEvtToHiido((Activity)PushJumpController.this.getActivity(), pushMsgId, pushNotificationData.getPushId());
                    }
                    PushJumpController.this.handlePushData(pushNotificationData);
                }
                catch (Exception ex) {
                    MLog.error((Object)PushJumpController.TAG, (String)"handlePayload error", (Throwable)ex, (Object[])new Object[0]);
                }
            }
        });
    }

    private void handlePushData(PushNotificationData pushData) {
        if (pushData == null) {
            return;
        }
        MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.PUSH_CHANNEL_TRACK_ENTER, (Object)String.valueOf(pushData.getPushId()));
        PushShowLimitManager.updateForPushClick();
        if (pushData.getPushSource() != PushSourceType.UNRECOGNIZED) {
            final int pushSourceFinal = pushData.getPushSource().getValue();
            ServiceManager.getInstance().observeService(IPostService.class, new Callback<IPostService>(){

                public void onResponse(IPostService service) {
                    if (service != null) {
                        service.clickPush(pushSourceFinal);
                    }
                }
            });
            if (pushData.getPushSource() == PushSourceType.kPushSourceUnregUserSocial) {
                MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.UNREGISTER_PUSH_PUSH, (Object)pushData.getPayloadCopy());
            }
        }
        NotificationTrack.INSTANCE.reportPushClick(this.mContext, pushData);
        this.handlePushJump(pushData);
        this.diyPushReport(pushData);
    }

    private void handlePushJump(PushNotificationData pushData) {
        JSONObject gameJson;
        if (pushData == null) {
            return;
        }
        if (pushData.getPushSource() == PushSourceType.kPushSourceChannel) {
            String cid = pushData.getCid();
            IChannelPushStatService channelPushStatService = (IChannelPushStatService)ServiceManagerProxy.getService(IChannelPushStatService.class);
            if (channelPushStatService != null && !TextUtils.isEmpty((CharSequence)cid)) {
                channelPushStatService.onPushClick(cid);
            }
        }
        int payloadType = pushData.getPayloadType();
        MLog.info((Object)TAG, (String)("handlePushJump payloadType: " + payloadType), (Object[])new Object[0]);
        if (payloadType == PushPayloadType.kPushPayloadWolf.getValue()) {
            this.jumpToWolf();
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "click").put("message_type", "official_message").put("location", "6"));
        } else if (payloadType == PushPayloadType.kPushPayloadIm.getValue()) {
            this.handleImJump(pushData);
        } else if (payloadType == PushPayloadType.kPushPayloadWebJump.getValue()) {
            this.handleWebJump(pushData);
        } else if (payloadType == PushPayloadType.kPushPayloadAppJump.getValue()) {
            this.handleAppJump(pushData);
        } else if (payloadType == PushPayloadType.kPushPayloadUInfo.getValue()) {
            this.handleProfileJump(pushData);
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "click").put("message_type", "contact_message").put("location", "6"));
        } else if (payloadType == PushPayloadType.kPushPayloadIndependentGame.getValue()) {
            gameJson = pushData.getPayloadJson().optJSONObject("game");
            if (gameJson != null) {
                String gameId = gameJson.optString("gameid");
                this.jumpToGame(gameId, true);
            }
        } else if (payloadType == PushPayloadType.kPushPayloadGame.getValue()) {
            this.joinGameAfterSplash(pushData.getPayloadJson(), payloadType);
        } else if (payloadType == PushPayloadType.kPushPayloadGameRank.getValue()) {
            gameJson = pushData.getPayloadJson().optJSONObject("game");
            if (gameJson != null) {
                String gameId = gameJson.optString("gameid");
                this.jumpToGameRank(gameId);
            }
        } else if (payloadType == PushPayloadType.kPushPayloadMain.getValue()) {
            this.jumpToHome();
        } else if (payloadType == PushPayloadType.kPushPayloadSingleGame.getValue()) {
            gameJson = pushData.getPayloadJson().optJSONObject("game");
            if (gameJson != null) {
                String gameId = gameJson.optString("gameid");
                this.jumpToSingleGame(gameId);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025737").put("gid", gameId).put("function_id", "msg_click").put("page_id", "middle_page"));
            }
        } else if (payloadType == PushPayloadType.kPushPayloadSScreenGame.getValue()) {
            gameJson = pushData.getPayloadJson().optJSONObject("game");
            if (gameJson != null) {
                String gameId = gameJson.optString("gameid");
                this.jumpToScreenGame(gameId);
            }
        } else if (payloadType == PushPayloadType.kPushPayloadImMain.getValue()) {
            this.jumpToSession();
        } else if (payloadType == PushPayloadType.kPushPayloadContactsQuizRegisterNotify.getValue()) {
            JSONObject messageRecord;
            JSONObject registerObject = pushData.getPayloadJson().optJSONObject("RegisterNotify");
            if (registerObject != null && (messageRecord = registerObject.optJSONObject("message_record")) != null) {
                long toChatUid = messageRecord.optLong("contact_hago_uid");
                this.jumpToIm(toChatUid);
            }
        } else if (payloadType == PushPayloadType.kPushPayloadContactsQuizOfficialWelcome.getValue()) {
            this.jumpToWolf();
        } else if (payloadType == PushPayloadType.kPushPayloadVoiceChatInvite.getValue()) {
            this.handleVoiceChatInviteJump(pushData);
        } else if (payloadType == PushPayloadType.kPushPayloadVoiceChat.getValue()) {
            this.jumpToVoiceChatList();
        } else if (payloadType == PushPayloadType.kPushPayloadChannel.getValue()) {
            this.handleVoiceChatJump(pushData);
        } else if (payloadType == PushPayloadType.kPushPayloadPopUp.getValue()) {
            this.handlePopUpJump(pushData);
        } else if (payloadType == PushPayloadType.kPushPayloadJump.getValue()) {
            JSONObject jumpJson = pushData.getPayloadJson().optJSONObject("jump");
            if (jumpJson != null) {
                String firstUri = jumpJson.optString("first_uri");
                String secondUri = jumpJson.optString("second_uri");
                this.jumpToHomeValidateUrls(firstUri, secondUri);
            }
        } else if (payloadType == PushPayloadType.kPushPayloadGamePublic.getValue()) {
            this.joinGameAfterSplash(pushData.getPayloadJson(), payloadType);
        } else if (payloadType == PushPayloadType.kPushPayloadBBS.getValue()) {
            this.handleBBSJump(pushData);
        } else if (payloadType == PushPayloadType.kPushPayloadOfficialAccount.getValue()) {
            this.handleOfficialJump(pushData);
        } else if (payloadType == PushPayloadType.kPushPayloadPKOverdue.getValue()) {
            JSONObject jsonObject = pushData.getPayloadJson().optJSONObject("pk");
            if (jsonObject != null) {
                String gameId = jsonObject.optString("gameid");
                long fromUid = jsonObject.optLong("from_uid");
                this.jumpToImAndPrecipitateGameInvite(gameId, fromUid);
            }
        } else if (payloadType == PushPayloadType.kPushPayloadFans.getValue()) {
            this.jumpToApp(FANS_LIST_URL);
        } else if (payloadType == PushPayloadType.kPushPayloadBifollow.getValue()) {
            this.jumpToApp(FRIEND_LIST_URL);
        } else if (payloadType == PushPayloadType.PushPayloadCertificationInvite.getValue()) {
            JSONObject jsonObj = pushData.getPayloadJson().optJSONObject("certification");
            if (jsonObj != null) {
                String url = jsonObj.optString("jump_url");
                this.jumpToWeb(URLUtils.addParam((String)url, (String)"uid", (String)(AccountUtil.getUid() + "")), false);
            }
        } else if (payloadType == PushPayloadType.kPushPayloadFirstRadioRoom.getValue()) {
            PushJumpHelper.jumpRadioVoiceRoom();
        } else if (payloadType == PushPayloadType.kPushPayloadDiscoverPeople.getValue()) {
            this.getServiceManager().observeService(IHomeService.class, (Callback)new Callback<IHomeService>(){

                public void onResponse(IHomeService service) {
                    if (service != null) {
                        service.toDiscover(DiscoverPageType.PEOPLE, false, 2, "", 0);
                    }
                }
            });
        } else if (payloadType == PushPayloadType.kPushPayloadAutoGuestLogin.getValue()) {
            this.handleGuestAutoLogin(pushData);
        } else if (payloadType == PushPayloadType.kPushPayloadGroupNotify.getValue()) {
            MsgDispatcher.getInstance().sendMessage(BaseMsgDef.OPEN_CHANNEL_NOTICE_PAGE);
        }
    }

    private void handleImJump(PushNotificationData pushData) {
        long uid = 0L;
        JSONObject payloadJson = pushData.getPayloadJson();
        if (payloadJson.has("im")) {
            JSONObject imJson = payloadJson.optJSONObject("im");
            boolean newUserInvite = imJson.optBoolean("is_match", false);
            MLog.debug((Object)TAG, (String)("push jump newUserInvite: " + newUserInvite), (Object[])new Object[0]);
            uid = imJson.optLong("from_uid");
            if (newUserInvite) {
                GameMessageModel gameMessageModel = ImMsgUtils.initGameMessageModel((JSONObject)imJson, (int)0);
                MsgDispatcher.getInstance().sendMessage(GrowthMsgDef.NEW_USER_SHADOW_AI_GAME_INVITE, (Object)gameMessageModel);
            } else if (!HandleAiPush.handleAiPush(uid, imJson)) {
                int inviteType = imJson.optInt("inviteType", 1);
                if (inviteType == 2) {
                    this.jumpToTeamRoom(imJson, uid);
                } else if (inviteType == 1) {
                    this.jumpToIm(uid);
                }
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "click").put("message_type", "im_message").put("location", "6").put("push_uid", String.valueOf(uid)));
        }
        if (payloadJson.has("task")) {
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20025571").put("function_id", "im_push_click").put("push_source", String.valueOf(pushData.getPushSource().getValue())));
            JSONObject taskJson = payloadJson.optJSONObject("task");
            if (taskJson == null) {
                return;
            }
            final String txt = taskJson.optString("txt");
            final long finalUid = uid;
            this.getServiceManager().observeService(ImService.class, (Callback)new Callback<ImService>(){

                public void onResponse(ImService service) {
                    service.getSendService().addListener(new IMsgSendListener(){

                        public void onSendMsg(INewImData imMsgResParam) {
                        }

                        public void onSendOldMsg(ImMsgReqParam param, ImMessageDBBean imMessage) {
                            final 1 listener = this;
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    ((ImService)PushJumpController.this.getServiceManager().getService(ImService.class)).getSendService().removeListener(listener);
                                }
                            });
                            YYTaskExecutor.execute(() -> {
                                ImMsgReqParam pair = ImDataFactory.INSTANCE.pushTxtMessage(finalUid, txt);
                                ((ImService)PushJumpController.this.getServiceManager().getService(ImService.class)).getSendService().sendOldIMHttpMsg(pair, null);
                            });
                        }
                    });
                }
            });
        } else if (payloadJson.has("msgType")) {
            int msgType = payloadJson.optInt("msgType");
            if (msgType == 0) {
                int gameTimeLimitType;
                if (payloadJson.has("gameTimeLimitType") && (gameTimeLimitType = payloadJson.optInt("gameTimeLimitType")) == 2) {
                    String gameId = payloadJson.optString("gameId");
                    String roomId = payloadJson.optString("roomId");
                    String infoPayload = payloadJson.optString("infoPayload");
                    this.jumpToIndependentGame(gameId, roomId, infoPayload);
                }
            } else if (msgType == 1 && payloadJson.has("fromUserId")) {
                long userId = payloadJson.optLong("fromUserId");
                this.jumpToIm(userId);
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "click").put("message_type", "im_message").put("location", "6").put("push_uid", String.valueOf(userId)));
            }
        }
    }

    private void handleWebJump(PushNotificationData pushData) {
        JSONObject webJson = pushData.getPayloadJson().optJSONObject("webjump");
        if (webJson != null) {
            String url = webJson.optString("url");
            boolean useYyJs = webJson.optBoolean("yyjs", false);
            this.jumpToWeb(url, useYyJs);
        }
    }

    private void handleAppJump(PushNotificationData pushData) {
        JSONObject webJson = pushData.getPayloadJson().optJSONObject("appjump");
        if (webJson != null) {
            String url = webJson.optString("url");
            if (pushData.getPushSource() == PushSourceType.kPushSourcePlatformFollowBBS && !url.contains("backSquare=")) {
                url = url.contains("?") ? url + "&backSquare=true" : url + "?backSquare=true";
            }
            this.jumpToApp(url);
        }
    }

    private void handleVoiceChatInviteJump(PushNotificationData pushData) {
        String familyUrl;
        JSONObject familyObject = pushData.getPayloadJson().optJSONObject("family");
        String string2 = familyUrl = familyObject != null ? familyObject.optString("inviteUrl", " ") : "";
        if (StringUtils.isNotEmpty((String)familyUrl)) {
            this.getServiceManager().observeService(IWebService.class, (Callback)new Callback<IWebService>(){

                public void onResponse(IWebService service) {
                    service.loadUrl(familyUrl, "");
                }
            });
        } else {
            JSONObject registerObject = pushData.getPayloadJson().optJSONObject("vchat");
            if (registerObject != null && registerObject.has("roomid")) {
                String goback = "";
                if (registerObject.has("goback")) {
                    goback = registerObject.optString("goback");
                    MLog.info((Object)TAG, (String)("goback: " + goback), (Object[])new Object[0]);
                }
                String roomId = registerObject.optString("roomid");
                final EnterParam param = EnterParam.of((String)roomId).entry(14).entryInfo(new EntryInfo(FirstEntType.PUSH, String.valueOf(pushData.getPushSource().getValue()), null)).isBackToList(true).pwdToken(registerObject.has("room_token") ? registerObject.optString("room_token") : "").putExtra("goback", (Object)goback).preSource(String.valueOf(pushData.getPushSource().getValue())).build();
                this.getServiceManager().observeService(IRoomService.class, (Callback)new Callback<IRoomService>(){

                    public void onResponse(IRoomService service) {
                        if (service != null) {
                            service.enterRoom(param);
                        }
                    }
                });
                if (registerObject.has("from_uid")) {
                    HiidoEvent event = HiidoEvent.obtain().eventId("20023799").put("function_id", "chat_invite_click").put("act_uid", String.valueOf(registerObject.optLong("from_uid"))).put("room_id", roomId);
                    HiidoStatis.reportEvent((HiidoEvent)event);
                }
            }
        }
    }

    private void handleVoiceChatJump(PushNotificationData pushData) {
        JSONObject channelJson = pushData.getPayloadJson().optJSONObject("channel");
        if (channelJson != null) {
            String roomId = channelJson.optString("cid");
            String goback = "";
            if (channelJson.has("goback")) {
                goback = channelJson.optString("goback");
                MLog.info((Object)TAG, (String)("goback: " + goback), (Object[])new Object[0]);
            }
            EnterParam.Builder enterChannelParams2 = EnterParam.of((String)roomId);
            enterChannelParams2.entry(14);
            enterChannelParams2.entryInfo(new EntryInfo(FirstEntType.PUSH, String.valueOf(pushData.getPushSource().getValue()), null));
            enterChannelParams2.password("");
            enterChannelParams2.pwdToken(channelJson.has("token") ? channelJson.optString("token") : "");
            enterChannelParams2.putExtra("goback", (Object)goback);
            enterChannelParams2.preSource(String.valueOf(pushData.getPushSource().getValue()));
            EnterParam param = enterChannelParams2.build();
            if (pushData.getPushSource() == PushSourceType.kPushSourceChannelDIYPush) {
                param.setExtra("needPushReport", (Object)true);
                param.setExtra("pushId", (Object)String.valueOf(pushData.getPushId()));
                param.setExtra("pushState", (Object)"1");
            }
            Message message = Message.obtain();
            message.what = AppbaseMsgDef.ChannelMsgDef.ENTRY_CHANNEL;
            message.obj = enterChannelParams2.build();
            this.sendMessage(message);
        }
    }

    private void handlePopUpJump(PushNotificationData pushData) {
        JSONObject popupObject = pushData.getPayloadJson().optJSONObject("popup");
        if (popupObject != null) {
            final String uri = popupObject.optString("uri");
            final String webUri = popupObject.optString("web_uri");
            final String bgColor = popupObject.optString("bg_color");
            this.getServiceManager().observeService(IYYUriService.class, (Callback)new Callback<IYYUriService>(){

                public void onResponse(IYYUriService service) {
                    service.handleUriString(uri);
                }
            });
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    final WebEnvSettings webEnvSettings = new WebEnvSettings();
                    webEnvSettings.isFullScreen = true;
                    webEnvSettings.isShowBackBtn = false;
                    webEnvSettings.usePageTitle = false;
                    webEnvSettings.url = webUri;
                    webEnvSettings.webViewBackgroundColor = ColorUtils.parseColor((String)("#" + bgColor), (int)-872415232);
                    webEnvSettings.webWindowAnimator = false;
                    webEnvSettings.hideLastWindow = false;
                    PushJumpController.this.getServiceManager().observeService(IWebService.class, (Callback)new Callback<IWebService>(){

                        public void onResponse(IWebService service) {
                            service.loadUrl(webEnvSettings);
                        }
                    });
                }
            }, (long)2000L);
        }
    }

    private void handleBBSJump(PushNotificationData pushData) {
        JSONObject jsonObject = pushData.getPayloadJson().optJSONObject("post");
        if (jsonObject == null) {
            return;
        }
        String ppostId = jsonObject.optString("ppostid", "");
        String postId = jsonObject.optString("postid", "");
        int cType = jsonObject.optInt("type");
        int postType = jsonObject.optInt("posttype");
        boolean isBatch = jsonObject.optBoolean("is_batch");
        int ppostsource = jsonObject.optInt("ppostsource");
        String channelId = jsonObject.optString("channelid");
        int ptype = jsonObject.optInt("ptype", 0);
        List<Integer> backToSquare = Arrays.asList(82, 83, 84, 85, 1009);
        boolean needBack = backToSquare.contains(pushData.getPushSource().getValue());
        if (pushData.getPushSource() == PushSourceType.kPushSourceBBSPostLike || pushData.getPushSource() == PushSourceType.kPushSourceBBSCommentLike) {
            PushNotification.Companion.removePostNotifyInfo(postId);
        }
        if (pushData.getPushSource() == PushSourceType.kPushSourceBBSCommentHighQuality) {
            int doAction = this.parsePostPType(ptype);
            this.jumpToPostDetailPage(ppostId, postId, cType, postType, needBack, -1, ppostsource, channelId, doAction);
        } else if (pushData.getPushSource() == PushSourceType.kPushSourceBBSPostLike && postType == 1) {
            this.jumpToPostDetailPage(ppostId, postId, cType, postType, needBack, 0, ppostsource, channelId, 0);
        } else if (isBatch || cType == 0) {
            this.jumpToNoticeList(isBatch, ppostsource, channelId);
        } else {
            this.jumpToPostDetailPage(ppostId, postId, cType, postType, needBack, -1, ppostsource, channelId, 0);
        }
    }

    private void handleOfficialJump(PushNotificationData pushData) {
        JSONObject jsonObject = pushData.getPayloadJson().optJSONObject("info");
        if (jsonObject == null) {
            return;
        }
        final String said = jsonObject.optString("said", "");
        final String jumpUrl = jsonObject.optString("jump_url", "");
        if (!StringUtils.isEmpty((String)said) && !StringUtils.isEmpty((String)jumpUrl)) {
            this.getServiceManager().observeService(IYYUriService.class, (Callback)new Callback<IYYUriService>(){

                public void onResponse(IYYUriService service) {
                    service.handleUriString(jumpUrl, (Object)said);
                }
            });
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationBaseDef.IM_IGNORE_SINGLE_SESSION_UNREAD, (Object)Utils.getMyGamePublicSessionId((String)said)));
        }
    }

    private void handleGuestAutoLogin(PushNotificationData pushData) {
        this.showLoadingDialog();
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MsgDispatcher.getInstance().sendMessageSync(MsgDef.ROOT_START_GUEST_LOGIN, (Object)new IGuestAutoLoginCallback(){

                    public void onSuccess() {
                        PushJumpController.this.disMissDialog();
                    }

                    public void onCancel() {
                        PushJumpController.this.disMissDialog();
                    }

                    public void onError(String errorCode, String des) {
                        PushJumpController.this.disMissDialog();
                    }
                });
            }
        });
    }

    private void diyPushReport(PushNotificationData pushData) {
        try {
            JSONObject channel;
            if (pushData.getPushSource() == PushSourceType.kPushSourceChannelDIYPush && (channel = pushData.getPayloadJson().optJSONObject("channel")) != null) {
                String cid = channel.optString("cid");
                ChannelBaseTrack.INSTANCE.reportPush("push_click", String.valueOf(pushData.getPushId()), "1", cid);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private int parsePostPType(int ptype) {
        int action;
        switch (ptype) {
            case 1: 
            case 2: 
            case 4: 
            case 5: {
                action = 1;
                break;
            }
            case 3: {
                action = 2;
                break;
            }
            default: {
                action = 0;
            }
        }
        return action;
    }

    private void handlePushChannelRecall(JSONObject payloadJson) {
        IChannelCenterService channelCenterService = (IChannelCenterService)ServiceManagerProxy.getService(IChannelCenterService.class);
        if (channelCenterService != null) {
            channelCenterService.getNewGuideManager().handleLowActivePush(payloadJson);
        } else {
            MLog.warn((Object)TAG, (String)"handlePushChannelRecall fail, get channelCenterService null", (Object[])new Object[0]);
        }
    }

    private void showLoadingDialog() {
        if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext)) {
            TopToastUtils.showErrorToast((CharSequence)ResourceUtils.getString((int)R.string.str_network_not_capable), (int)0);
            return;
        }
        if (this.mDialogLinkManager == null) {
            return;
        }
        YYTaskExecutor.postToMainThread(() -> this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog(ResourceUtils.getString((int)R.string.logining), false, false, null)));
    }

    private void disMissDialog() {
        if (this.mDialogLinkManager == null) {
            return;
        }
        YYTaskExecutor.postToMainThread(() -> this.mDialogLinkManager.dismissDialog());
    }

    private void jumpToImAndPrecipitateGameInvite(final String gameId, final long fromUid) {
        this.jumpToIm(fromUid);
        this.getServiceManager().observeService(IUserInfoService.class, (Callback)new Callback<IUserInfoService>(){

            public void onResponse(IUserInfoService userInfoService) {
                userInfoService.requestUserInfoFromServer(fromUid, new OnKSProfileListCallback(){

                    public void onUISuccess(List<UserInfoKS> userInfo) {
                        if (userInfo != null && !userInfo.isEmpty()) {
                            UserInfoKS otherUserInfo = userInfo.get(0);
                            IGameInfoService gameInfoService = (IGameInfoService)PushJumpController.this.getServiceManager().getService(IGameInfoService.class);
                            if (gameInfoService == null) {
                                return;
                            }
                            GameInfo gameInfo = gameInfoService.getGameInfoByGid(gameId);
                            if (gameInfo == null) {
                                return;
                            }
                            GameMessageModel messageModel = new GameMessageModel();
                            messageModel.setToUserId(fromUid);
                            messageModel.setToUserName(otherUserInfo.nick);
                            messageModel.setGameId(gameId);
                            messageModel.setGameName(gameInfo.getGname());
                            messageModel.setFrom(1);
                            messageModel.setType(0);
                            messageModel.setContent("");
                            Message msg = Message.obtain();
                            msg.what = ImBaseMsgDef.IM_SEND_LOCAL_GAME_INVITE;
                            msg.arg1 = 1;
                            msg.obj = messageModel;
                            MsgDispatcher.getInstance().sendMessage(msg);
                            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                @Override
                                public void run() {
                                    boolean isInGameOrVoiceRoom;
                                    boolean bl = isInGameOrVoiceRoom = ((IGameCenterService)PushJumpController.this.getServiceManager().getService(IGameCenterService.class)).isPlaying() || StringUtils.isNotEmpty((String)RuntimeContext.getChannelId());
                                    if (!isInGameOrVoiceRoom) {
                                        AnalogAiModel.getInstance().requestAiBehavior(InvokeType.AiInviteGame.getValue(), fromUid, null, null);
                                    }
                                    MLog.info((Object)PushJumpController.TAG, (String)("isInGameOrVoiceRoom" + isInGameOrVoiceRoom), (Object[])new Object[0]);
                                }
                            }, (long)60000L);
                        }
                    }

                    public void onError(String reason, long code) {
                    }
                });
            }
        });
    }

    private void jumpToNoticeList(boolean needBack, int ppostsource, String channelId) {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.OPEN_WINDOW_BBS_NOTICE_LIST;
        Bundle bundle = new Bundle();
        msg.setData(bundle);
        bundle.putBoolean("needBackToSquare", needBack);
        bundle.putInt("needBackToChannelPost", ppostsource);
        bundle.putString("needBackToChannelid", channelId);
        MsgDispatcher.getInstance().sendMessage(msg);
    }

    private void joinGameAfterSplash(JSONObject jsonObject, int type2) {
        if (SplashManager.INSTANCE.isSplashViewShowIng()) {
            if (this.mHomeShowNotify == null) {
                this.mHomeShowNotify = notification -> {
                    if (notification != null && notification.id == NotificationDef.N_SHOW_HOME_PAGE) {
                        this.onSplashFinish(jsonObject, type2);
                    }
                    NotificationCenter.getGlobalInstance().unregister(NotificationDef.N_SHOW_HOME_PAGE, this.mHomeShowNotify);
                    this.mHomeShowNotify = null;
                };
                NotificationCenter.getGlobalInstance().register(NotificationDef.N_SHOW_HOME_PAGE, this.mHomeShowNotify);
            }
        } else {
            this.onSplashFinish(jsonObject, type2);
        }
    }

    private void onSplashFinish(JSONObject jsonObject, int type2) {
        if (type2 == PushPayloadType.kPushPayloadGamePublic.getValue()) {
            String gameId = "";
            JSONObject json = jsonObject.optJSONObject("jump");
            if (json != null) {
                gameId = json.optString("gameid");
                MLog.info((Object)TAG, (String)"jumpToGame gameId=%s", (Object[])new Object[]{gameId});
                if (StringUtils.isEmpty((String)gameId)) {
                    return;
                }
                NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationBaseDef.IM_IGNORE_SINGLE_SESSION_UNREAD, (Object)Utils.getMyGamePublicSessionId((String)gameId)));
                this.jumpToGame(gameId);
            }
        } else if (type2 == PushPayloadType.kPushPayloadGame.getValue()) {
            this.jumpToGameMatch(jsonObject);
        }
    }

    private void jumpToGame(String gameId) {
        this.jumpToGame(gameId, false);
    }

    private void jumpToGame(String gameId, boolean jumpHome) {
        Message msg = Message.obtain();
        msg.what = BaseMsgDef.MSG_GAME_JUMP_MAIN_PAGE;
        msg.obj = gameId;
        Bundle bundle = new Bundle();
        bundle.putBoolean("scrollTo", true);
        bundle.putBoolean("jumpHome", jumpHome);
        msg.setData(bundle);
        this.sendMessage(msg);
    }

    private void jumpToVoiceChatList() {
        this.sendMessage(AppbaseMsgDef.ChannelOrRoomListMsgDef.OPEN_ROOM_LIST);
    }

    private void jumpToHomeValidateUrls(final String firstUrl, final String secondUrl) {
        this.getServiceManager().observeService(IYYUriService.class, (Callback)new Callback<IYYUriService>(){

            public void onResponse(IYYUriService service) {
                service.handleUriString(firstUrl, isValidate -> {
                    if (!isValidate) {
                        service.handleUriString(secondUrl);
                    }
                });
            }
        });
    }

    private void jumpToGameMatch(JSONObject payloadJson) {
        if (payloadJson.has("game")) {
            JSONObject gameJson = payloadJson.optJSONObject("game");
            String gameId = gameJson.optString("gameid");
            boolean ai = false;
            int matchSex = 0;
            long targetUid = 0L;
            if (gameJson.has("target_sex")) {
                matchSex = gameJson.optInt("target_sex");
            }
            if (gameJson.has("act_uid")) {
                targetUid = gameJson.optLong("act_uid");
            }
            if (gameJson.has("ai")) {
                int isAi = gameJson.optInt("ai");
                ai = isAi == 1;
            }
            this.jumpToGameMatch(gameId, ai, matchSex, targetUid);
        }
    }

    private void jumpToSession() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                PushJumpController.this.sendMessage(BaseMsgDef.GOTO_SESSION_PAGE);
            }
        });
    }

    private void jumpToScreenGame(final String gameId) {
        this.getServiceManager().observeService(IGameCenterService.class, (Callback)new Callback<IGameCenterService>(){

            public void onResponse(IGameCenterService service) {
                GameSelectContext selectContext = new GameSelectContext(GameContextDef.JoinFrom.FROM_PUSH);
                selectContext.setGameId(gameId);
                service.toSelectPage(selectContext, 2);
            }
        });
    }

    private void jumpToSingleGame(final String gameId) {
        this.getServiceManager().observeService(IGameCenterService.class, (Callback)new Callback<IGameCenterService>(){

            public void onResponse(IGameCenterService service) {
                GameSelectContext selectContext = new GameSelectContext(GameContextDef.JoinFrom.FROM_PUSH);
                selectContext.setGameId(gameId);
                selectContext.setGameSelectMode("default");
                service.toSelectPage(selectContext, 3);
            }
        });
    }

    private void jumpToGameRank(final String gameId) {
        this.getServiceManager().observeService(IWebService.class, (Callback)new Callback<IWebService>(){

            public void onResponse(IWebService service) {
                WebEnvSettings wes = new WebEnvSettings();
                wes.url = UriProvider.getSingleGameRankUrl((String)gameId, (String)"", (String)"");
                wes.usePageTitle = false;
                wes.isFullScreen = true;
                wes.disablePullRefresh = true;
                wes.backBtnResId = R.drawable.nav_back_white;
                wes.webviewFeature = 1;
                service.loadUrl(wes);
            }
        });
    }

    private void jumpToGameMatch(final String gameId, final boolean isAi, final int matchSex, final long targetUid) {
        this.getServiceManager().observeService(IGameInfoService.class, (Callback)new Callback<IGameInfoService>(){

            public void onResponse(IGameInfoService gameInfoService) {
                final GameInfo gameInfo = gameInfoService.getGameInfoByGid(gameId);
                if (gameInfo == null) {
                    return;
                }
                PushJumpController.this.getServiceManager().observeService(IGameService.class, (Callback)new Callback<IGameService>(){

                    public void onResponse(IGameService gameService) {
                        boolean isGameValid = gameService.isGameValid(gameInfo);
                        if (isGameValid) {
                            GameMatchContext gameMatchContext = new GameMatchContext(GameContextDef.JoinFrom.FROM_PUSH);
                            gameMatchContext.addExtendValue("isMatchAi", (Object)isAi);
                            gameMatchContext.addExtendValue("matchAiSex", (Object)matchSex);
                            gameMatchContext.addExtendValue("matchTargetUid", (Object)targetUid);
                            gameMatchContext.addExtendValue("game_from", (Object)GameContextDef.GameFrom.PUSH_START_GAME.getId());
                            ((IGameCenterService)PushJumpController.this.getServiceManager().getService(IGameCenterService.class)).matchGame(gameInfo, gameMatchContext, null);
                        } else {
                            Message msg = Message.obtain();
                            msg.what = BaseMsgDef.MSG_GAME_JUMP_MAIN_PAGE;
                            msg.obj = gameId;
                            Bundle bundle = new Bundle();
                            bundle.putBoolean("isMatchAi", isAi);
                            bundle.putInt("matchAiSex", matchSex);
                            bundle.putLong("matchTargetUid", targetUid);
                            msg.setData(bundle);
                            PushJumpController.this.sendMessage(msg);
                        }
                    }
                });
            }
        });
    }

    private void jumpToApp(final String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        this.getServiceManager().observeService(IYYUriService.class, (Callback)new Callback<IYYUriService>(){

            public void onResponse(IYYUriService service) {
                service.handleUriString(url);
            }
        });
    }

    private void jumpToWeb(final String url, boolean useYyJs) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return;
        }
        if (url.startsWith("http")) {
            final WebEnvSettings wes = new WebEnvSettings();
            wes.url = url;
            wes.webviewFeature = 1;
            wes.useYYJsInterface = useYyJs;
            this.getServiceManager().observeService(IWebService.class, (Callback)new Callback<IWebService>(){

                public void onResponse(IWebService service) {
                    service.loadUrl(wes);
                }
            });
        } else {
            this.getServiceManager().observeService(IYYUriService.class, (Callback)new Callback<IYYUriService>(){

                public void onResponse(IYYUriService service) {
                    service.handleUriString(url);
                }
            });
        }
    }

    private void jumpToWolf() {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Message message = Message.obtain();
                Bundle bundle = new Bundle();
                bundle.putLong("target_uid", 10L);
                bundle.putBoolean("xiaolang_from_push", true);
                message.setData(bundle);
                message.what = AppbaseMsgDef.GOTO_OFFICIAL_MESSAGE_PAGE;
                PushJumpController.this.sendMessage(message);
            }
        });
        HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20024017").put("function_id", "click").put("message_type", "official_message").put("location", "6"));
    }

    private void jumpToIndependentGame(final String gameId, final String roomId, final String infoPayload) {
        if (StringUtils.isEmpty((String)gameId)) {
            return;
        }
        this.getServiceManager().observeService(IGameInfoService.class, (Callback)new Callback<IGameInfoService>(){

            public void onResponse(IGameInfoService iGameInfoService) {
                final GameInfo gameInfo = iGameInfoService.getGameInfoByGid(gameId);
                if (gameInfo == null) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_game_not_support), (int)0);
                    return;
                }
                IGameService iGameService = (IGameService)PushJumpController.this.getServiceManager().getService(IGameService.class);
                if (iGameService == null) {
                    return;
                }
                boolean isGameValid = iGameService.isGameValid(gameInfo);
                if (isGameValid) {
                    PushJumpController.this.getServiceManager().observeService(IGameInviteService.class, (Callback)new Callback<IGameInviteService>(){

                        public void onResponse(IGameInviteService inviteService) {
                            inviteService.getMsgInviteService().indepGameAccept(roomId, new IIndepGameAcceptCallback(){

                                public void onIndepGameAcceptSuccess(String roomId) {
                                    IndieGamePlayContext playContext = new IndieGamePlayContext.Builder(GameContextDef.JoinFrom.FROM_PUSH).roomId(roomId).payload(infoPayload).build();
                                    playContext.addExtendValue("game_from", (Object)GameContextDef.GameFrom.PUSH_START_GAME.getId());
                                    ((IGameCenterService)PushJumpController.this.getServiceManager().getService(IGameCenterService.class)).joinGame(gameInfo, (GamePlayContext)playContext);
                                    HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20028013").put("function_id", "4").put("gid", gameId));
                                }

                                public void onIndepGameAcceptFail(long code, String roomId) {
                                    TeamInviteResCodeHelper.showToast((long)code);
                                }
                            });
                        }
                    });
                } else {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)ResourceUtils.getString((int)R.string.tips_game_start_download), (int)1);
                    iGameService.downloadGame(gameInfo);
                }
            }
        });
    }

    private void jumpToIm(final long uid) {
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Message message = Message.obtain();
                Bundle bundle = new Bundle();
                if (uid == 10L || uid == 14L) {
                    bundle.putLong("target_uid", uid);
                    message.setData(bundle);
                    message.what = BaseMsgDef.OFFICIAL_IM_SHOW;
                    PushJumpController.this.sendMessageSync(message);
                } else {
                    bundle.putLong("target_uid", uid);
                    bundle.putInt("im_page_source", 9);
                    message.setData(bundle);
                    message.what = BaseMsgDef.IM_ROOM_SHOW;
                    PushJumpController.this.sendMessageSync(message);
                }
            }
        });
    }

    private void handleProfileJump(PushNotificationData pushData) {
        boolean playLikeSvga;
        long uid;
        JSONObject profileJson = pushData.getPayloadJson().optJSONObject("uinfo");
        if (profileJson != null) {
            uid = profileJson.optLong("uid", AccountUtil.getUid());
            playLikeSvga = profileJson.optBoolean("like");
        } else {
            uid = AccountUtil.getUid();
            playLikeSvga = false;
        }
        MLog.info((Object)TAG, (String)"jumpToProfile uid:%s,playLikeSvga:%s", (Object[])new Object[]{String.valueOf(uid), playLikeSvga ? "1" : "0"});
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                Message message = Message.obtain();
                ProfileReportBean bean = new ProfileReportBean();
                bean.setUid(Long.valueOf(uid));
                bean.setShowSource(Integer.valueOf(ProfileReportBean.ShowSource.getDefault()));
                bean.setSource(0);
                message.what = UserMsgDef.OPEN_WINDOW_NEW_PROFILE;
                message.arg1 = 0;
                message.arg2 = -1;
                message.obj = bean;
                Bundle bundle = new Bundle();
                bundle.putBoolean("like_animation", playLikeSvga);
                message.setData(bundle);
                PushJumpController.this.sendMessage(message);
            }
        });
    }

    private void jumpToTeamRoom(JSONObject imJson, long uid) {
        this.mGameMessageModel = ImMsgUtils.initGameMessageModel((JSONObject)imJson, (int)0);
        this.mGameMessageModel.setFromUserId(uid);
        if (this.mGameMessageModel == null) {
            return;
        }
        this.getServiceManager().observeService(IGameInfoService.class, (Callback)new Callback<IGameInfoService>(){

            public void onResponse(IGameInfoService iGameInfoService) {
                final GameInfo gameInfo = iGameInfoService.getGameInfoByGid(PushJumpController.this.mGameMessageModel.getGameId());
                if (gameInfo == null) {
                    return;
                }
                PushJumpController.this.getServiceManager().observeService(IUserInfoService.class, (Callback)new Callback<IUserInfoService>(){

                    public void onResponse(IUserInfoService iUserInfoService) {
                        UserInfoKS userInfoBean = iUserInfoService.getUserInfo(AccountUtil.getUid());
                        if (userInfoBean == null) {
                            return;
                        }
                        IGameService iGameService = (IGameService)PushJumpController.this.getServiceManager().getService(IGameService.class);
                        IGameInviteService gameInviteService = (IGameInviteService)PushJumpController.this.getServiceManager().getService(IGameInviteService.class);
                        if (iGameService == null) {
                            return;
                        }
                        if (gameInviteService == null) {
                            return;
                        }
                        boolean isGameValid = iGameService.isGameValid(gameInfo);
                        if (isGameValid) {
                            IMPKAcceptReqBean reqBean = IMPKAcceptReqBean.newBuilder().pk_id(PushJumpController.this.mGameMessageModel.getPkId()).accept(true).my_sex(userInfoBean.sex).my_nick(userInfoBean.nick).my_pic_url(userInfoBean.avatar).build();
                            if (!IMPKAcceptReqBean.checkBean((IMPKAcceptReqBean)reqBean)) {
                                return;
                            }
                            if (PushJumpController.this.mGameMessageModel.isFromTeamInvite() && gameInviteService.getGameTeamInviteService() != null) {
                                gameInviteService.getGameTeamInviteService().teamImInviteAccept(gameInfo.getGid(), PushJumpController.this.mGameMessageModel.getGameTemplate(), PushJumpController.this.mGameMessageModel.getTeamId(), true, PushJumpController.this.mGameMessageModel.getFromUserId(), PushJumpController.this.mImTeamGameListener);
                            }
                            gameInviteService.removeGameInvite(PushJumpController.this.mGameMessageModel.getPkId());
                        } else {
                            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)ImNotificationBaseDef.IM_ENTER_FROM_PUSH, (Object)PushJumpController.this.mGameMessageModel));
                            gameInfo.downloadInfo.setFrom(GameDownloadInfo.DownloadFrom.im);
                            iGameService.downloadGame(gameInfo);
                        }
                    }
                });
            }
        });
    }

    private void onImInviteAcceptRes(final String gameId, final boolean isAccept, String gameUrl, String roomId, final String teamId, final int teamTemplete) {
        this.getServiceManager().observeService(IGameInfoService.class, (Callback)new Callback<IGameInfoService>(){

            public void onResponse(IGameInfoService iGameInfoService) {
                final GameInfo gameInfo = iGameInfoService.getGameInfoByGid(gameId);
                if (gameInfo == null) {
                    return;
                }
                if (isAccept) {
                    PushJumpController.this.getServiceManager().observeService(IUserInfoService.class, (Callback)new Callback<IUserInfoService>(){

                        public void onResponse(IUserInfoService userInfoService) {
                            UserInfoKS myUserInfo = userInfoService.getUserInfo(AccountUtil.getUid());
                            UserInfoKS otherUserInfo = userInfoService.getUserInfo(PushJumpController.this.mGameMessageModel.getFromUserId());
                            if (myUserInfo.ver == 0L || otherUserInfo.ver == 0L) {
                                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                    @Override
                                    public void run() {
                                        ToastUtils.showToast((Context)PushJumpController.this.mContext, (String)ResourceUtils.getString((int)R.string.game_invalid), (int)200);
                                    }
                                });
                                if (myUserInfo.ver == 0L) {
                                    userInfoService.requestUserInfoFromServer(AccountUtil.getUid(), null);
                                }
                                if (otherUserInfo.ver == 0L) {
                                    userInfoService.requestUserInfoFromServer(PushJumpController.this.mGameMessageModel.getFromUserId(), null);
                                }
                            }
                            if (PushJumpController.this.mGameMessageModel.isFromTeamInvite()) {
                                ((IGameInviteService)PushJumpController.this.getServiceManager().getService(IGameInviteService.class)).setPushPkId(PushJumpController.this.mGameMessageModel.getPkId());
                                GameTeamMatchContext teamMatchContext = new GameTeamMatchContext(GameContextDef.JoinFrom.FROM_NOTIFY);
                                teamMatchContext.setGameInfo(gameInfo);
                                teamMatchContext.setMultiModeCode(teamTemplete);
                                teamMatchContext.setTeamId(teamId);
                                teamMatchContext.setInviteUid(PushJumpController.this.mGameMessageModel.getFromUserId());
                                ((IGameCenterService)PushJumpController.this.getServiceManager().getService(IGameCenterService.class)).teamMatchGame(gameInfo, teamMatchContext);
                            }
                        }
                    });
                }
            }
        });
    }

    private void jumpToPostDetailPage(String ppostId, String postId, int type2, int postType, boolean needBack, int defaultTab, int ppostsource, String channelId, int doAction) {
        Message msg = Message.obtain();
        msg.what = AppbaseMsgDef.BBSMsgDef.OPEN_POST_DETAIL_NOTICE;
        Bundle bundle = new Bundle();
        if (doAction != 0) {
            bundle.putSerializable("bbs_post_detail_postid", (Serializable)((Object)ppostId));
            bundle.putInt("bbs_post_detail_do_action", doAction);
        } else {
            bundle.putSerializable("bbs_post_detail_postid", (Serializable)((Object)postId));
        }
        bundle.putInt("bbs_post_detail_from", 1);
        bundle.putInt("bbs_post_detail_type", postType);
        bundle.putBoolean("needBackToSquare", needBack);
        bundle.putInt("needBackToChannelPost", ppostsource);
        bundle.putString("needBackToChannelid", channelId);
        bundle.putInt("pg_source", 24);
        if (-1 != defaultTab) {
            bundle.putInt("default_tab", defaultTab);
        }
        msg.setData(bundle);
        this.sendMessage(msg);
        BbsNoticeDBBean bean = new BbsNoticeDBBean();
        bean.setPpostId(ppostId);
        bean.setPostId(postId);
        bean.setType(type2);
        bean.setPostType(postType);
        NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationIdDef.BBS_NOTICE_ENTER_FROM_PUSH_MSG, (Object)bean));
    }

    private void jumpToHome() {
        MLog.debug((Object)TAG, (String)"handlePushData jump to home", (Object[])new Object[0]);
        this.getServiceManager().observeService(IHomeService.class, (Callback)new Callback<IHomeService>(){

            public void onResponse(IHomeService homeService) {
                if (homeService != null) {
                    homeService.toPlay(PlayTabType.TODAY, null);
                } else {
                    MLog.debug((Object)PushJumpController.TAG, (String)"handlePushData homeService is null", (Object[])new Object[0]);
                }
            }
        });
    }
}

