/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app.deeplink;

import android.content.Context;
import android.net.Uri;
import android.os.Message;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.Pair;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.appsflyer.AppsflyerLinkData;
import com.yy.appbase.appsflyer.ThirdTrackHelper;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.deeplink.DeepLinkReportManager;
import com.yy.appbase.deeplink.DeepLinkService;
import com.yy.appbase.deeplink.DeepLinkStatistics;
import com.yy.appbase.deeplink.DeeplinkSource;
import com.yy.appbase.deeplink.data.DeepLinkBundle;
import com.yy.appbase.service.IYYUriService;
import com.yy.appbase.useractionstat.UserEnterActionStat;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.Kvo;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.AppMetaDataUtil;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.base.utils.json.JsonParser;
import com.yy.framework.core.Environment;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiidostatis.api.HiidoSDK;
import com.yy.hiyo.app.deeplink.CampaignDpHandler;
import com.yy.hiyo.app.deeplink.FindDeeplinkCallback;
import com.yy.hiyo.app.deeplink.GoogleDeeplinkFetcher;
import com.yy.hiyo.app.deeplink.OnPlayInstallListener;
import com.yy.hiyo.app.deeplink.PlayInstallData;
import com.yy.hiyo.app.deeplink.PlayInstallReferrer;
import com.yy.hiyo.main.R;
import com.yy.socialplatformbase.PlatformMsgDef;
import com.yy.socialplatformbase.ThirdPartyPlatformHelper;
import com.yy.socialplatformbase.data.YYAppLinkData;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.json.JSONObject;

public class DeferredDeepLinkManager
extends DefaultController
implements OnPlayInstallListener {
    private static final String TAG = "DeferredDeepLinkManager";
    private static final Object FILE_LOCK = new Object();
    private static final Pattern sDpIdPattern = Pattern.compile("\\$\\{[0-9]*\\}");
    private PlayInstallReferrer mInstallReferrer = null;
    private final CampaignDpHandler mCampaignDpHandler = new CampaignDpHandler();
    private final GoogleDeeplinkFetcher mS2sDeeplinkFetcher = new GoogleDeeplinkFetcher(this.mCampaignDpHandler);
    private final LinkedHashMap<DeeplinkSource, DeepLinkBundle> mCacheLinkMap = new LinkedHashMap();
    private DeepLinkBundle mTargetBundle = null;
    private volatile boolean mAccountLogin = false;
    private volatile boolean mDeeplinkConsumed = false;
    private long mPlayInstallStartTime = 0L;
    private final List<DeeplinkSource> mDDLFromList = new ArrayList<DeeplinkSource>(5);
    private int mDDLFromNum = 0;

    public DeferredDeepLinkManager(Environment env) {
        super(env);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (RuntimeContext.isStartAtFirstInstalled()) {
                    DeferredDeepLinkManager.this.mDDLFromNum = 5;
                    DeferredDeepLinkManager.this.mPlayInstallStartTime = SystemClock.uptimeMillis();
                    DeferredDeepLinkManager.this.mInstallReferrer = new PlayInstallReferrer(DeferredDeepLinkManager.this.mContext, DeferredDeepLinkManager.this);
                    DeferredDeepLinkManager.this.fetchFbLinkData();
                    DeferredDeepLinkManager.this.fetchS2sLinkData();
                    DeferredDeepLinkManager.this.fetchChannelDeeplink();
                } else {
                    DeferredDeepLinkManager.this.mDDLFromNum = 1;
                    DeferredDeepLinkManager.this.fetchCacheDpBundle();
                }
                AppsflyerLinkData linkData = ThirdTrackHelper.INSTANCE.getAppsFlyerLinkData();
                if (linkData != null) {
                    Kvo.autoBindingTo((KvoSource)linkData, (Object)DeferredDeepLinkManager.this);
                }
            }
        }, (long)100L);
        DeepLinkReportManager.INSTANCE.init();
    }

    public void notify(Notification notification) {
        super.notify(notification);
        if (notification.id == NotificationDef.N_SHOW_HOME_PAGE || notification.id == NotificationDef.N_LOGIN_SUCCESS) {
            this.mAccountLogin = true;
            this.handleDpAfterLogin();
        }
    }

    @Override
    public void onInstallReferrer(@NonNull PlayInstallData playInstallData) {
        MLog.info((Object)TAG, (String)("onInstallReferrer: " + playInstallData), (Object[])new Object[0]);
        try {
            Uri referrerUri = playInstallData.getReferrerUri();
            String mediaSource = null;
            String deeplink = null;
            String campaign = null;
            String dpId = "-1";
            if (referrerUri != null) {
                mediaSource = referrerUri.getQueryParameter("pid");
                deeplink = referrerUri.getQueryParameter("af_dp");
                campaign = referrerUri.getQueryParameter("c");
            }
            if (StringUtils.isNotEmpty(campaign)) {
                dpId = this.getDpId(campaign);
                DeepLinkService.INSTANCE.saveCampaign(campaign);
            }
            String finalMediaSource = mediaSource == null ? "" : mediaSource;
            String referrerString = "";
            if (playInstallData.getReferrerUrl() != null) {
                referrerString = playInstallData.getReferrerUrl();
            }
            DeepLinkStatistics.reportSdkResult((String)"4", (String)finalMediaSource, (String)String.valueOf(SystemClock.uptimeMillis() - this.mPlayInstallStartTime), (Map)HiidoEvent.map((Pair[])new Pair[]{new Pair((Object)"referrer", (Object)referrerString), new Pair((Object)"campaign", (Object)(campaign == null ? "" : campaign)), new Pair((Object)"campaign_code", (Object)dpId), new Pair((Object)"app_install_time", (Object)String.valueOf(playInstallData.getAppInstallTime())), new Pair((Object)"referer_click_time", (Object)String.valueOf(playInstallData.getAppClickTime())), new Pair((Object)"deeplink", (Object)DeepLinkStatistics.getReportDeepLinkString((String)deeplink)), new Pair((Object)"is_arrive_homepage", (Object)String.valueOf(this.mAccountLogin)), new Pair((Object)"is_null", (Object)(playInstallData.getContentUri() == null ? "1" : "0"))}));
            if (StringUtils.isNotEmpty((String)deeplink) && SettingFlags.getBoolean((String)"key_dp_google_play_use", (boolean)false)) {
                this.handleDeeplink(new DeepLinkBundle(DeeplinkSource.GOOGLE_PLAY, Uri.parse((String)deeplink), finalMediaSource), false);
            } else if (StringUtils.isNotEmpty((String)campaign) && StringUtils.isNotEmpty((String)dpId)) {
                long reqTime = SystemClock.uptimeMillis();
                DeepLinkStatistics.reportRequestCode((String)"4");
                this.mCampaignDpHandler.findDeeplinkWithDpId(dpId, uri -> {
                    DeepLinkStatistics.reportCodeResult((String)(uri == null ? null : uri.toString()), (String)"4", (String)String.valueOf(SystemClock.uptimeMillis() - reqTime));
                    if (uri != null) {
                        this.handleDeeplink(new DeepLinkBundle(DeeplinkSource.GOOGLE_PLAY, uri, finalMediaSource), false);
                    }
                });
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
        this.notifyDeeplinkFrom(DeeplinkSource.GOOGLE_PLAY);
    }

    private void notifyDeeplinkFrom(DeeplinkSource from) {
        MLog.info((Object)TAG, (String)("notifyDeeplinkFrom from: " + from), (Object[])new Object[0]);
        if (!this.mDDLFromList.contains(from)) {
            this.mDDLFromList.add(from);
        }
        if (this.mDDLFromList.size() >= this.mDDLFromNum) {
            MLog.info((Object)TAG, (String)"notify deeplink collect finish", (Object[])new Object[0]);
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_DEEPLINK_COLLECT_FINISH));
        }
    }

    private void showToast(DeeplinkSource from, Uri uri) {
        if (RuntimeContext.sIsDebuggable) {
            String content = uri == null ? "empty" : uri.toString();
            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)("fetch link by source : " + from + "-->" + content), (int)0);
        }
    }

    private void handleDpAfterLogin() {
        MLog.debug((Object)TAG, (String)"handleDpAfterLogin", (Object[])new Object[0]);
        if (this.mTargetBundle != null) {
            this.handleDeeplink(this.mTargetBundle, true);
        } else {
            MLog.warn((Object)TAG, (String)"handleDpAfterLogin fail, target bundle is null", (Object[])new Object[0]);
        }
    }

    private void handleDeeplink(DeepLinkBundle bundle, boolean processAnyway) {
        MLog.info((Object)TAG, (String)"handleDeeplink, bundle: %s, isLogin: %b, isConsume: %b", (Object[])new Object[]{bundle, this.mAccountLogin, this.mDeeplinkConsumed});
        if (bundle != null) {
            this.putCacheDpBundle(bundle);
            String deeplinkString = bundle.getUri().toString();
            DeepLinkService.INSTANCE.receiveAttributionDp(bundle);
            this.showToast(bundle.getFrom(), bundle.getUri());
            UserEnterActionStat.onDeepLinkJump((String)deeplinkString);
            DeepLinkStatistics.reportFirstDeeplink((Uri)bundle.getUri(), (String)this.getSdkType(bundle.getFrom()));
            if (!this.mAccountLogin) {
                return;
            }
            boolean ifRunAnytime = bundle.getUri().getBooleanQueryParameter("run_anytime", true);
            if ((processAnyway || ifRunAnytime) && !this.mDeeplinkConsumed) {
                this.consumeDeeplink(bundle);
            }
        }
    }

    private void consumeDeeplink(final DeepLinkBundle bundle) {
        this.mDeeplinkConsumed = true;
        this.setTargetBundle(null);
        if (YYTaskExecutor.isMainThread()) {
            ((IYYUriService)this.getServiceManager().getService(IYYUriService.class)).handleUri(bundle.getUri(), (Object)bundle);
        } else {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((IYYUriService)DeferredDeepLinkManager.this.getServiceManager().getService(IYYUriService.class)).handleUri(bundle.getUri(), (Object)bundle);
                }
            });
        }
        DeepLinkStatistics.reportConsumeDeeplink((Uri)bundle.getUri(), (String)this.getSdkType(bundle.getFrom()));
    }

    private String getSdkType(DeeplinkSource from) {
        String sdkType = "";
        if (from == DeeplinkSource.APP_FLYER) {
            sdkType = "2";
        } else if (from == DeeplinkSource.FACEBOOK) {
            sdkType = "1";
        } else if (from == DeeplinkSource.GOOGLE_S2S) {
            sdkType = "3";
        } else if (from == DeeplinkSource.GOOGLE_PLAY) {
            sdkType = "4";
        }
        return sdkType;
    }

    private void fetchCacheDpBundle() {
        if (this.mTargetBundle == null) {
            MLog.info((Object)TAG, (String)"fetchCacheDpBundle", (Object[])new Object[0]);
            YYTaskExecutor.execute((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean useCacheEnable = SettingFlags.getBoolean((String)"key_dp_cache_switch", (boolean)true);
                    if (!useCacheEnable) {
                        MLog.warn((Object)DeferredDeepLinkManager.TAG, (String)"fetchCacheDpBundle ignore, switch is not enable", (Object[])new Object[0]);
                        return;
                    }
                    Object object = FILE_LOCK;
                    synchronized (object) {
                        try {
                            String path = DeferredDeepLinkManager.this.getSavePath();
                            if (YYFileUtils.isPathExist((String)path)) {
                                byte[] bs = YYFileUtils.readBytes((String)path);
                                String saveString = StringUtils.byteToStringUtf8((byte[])bs);
                                JSONObject saveJson = new JSONObject(saveString);
                                long cacheBegin = saveJson.optLong("cache_begin", SystemClock.uptimeMillis());
                                long expire = SettingFlags.getLongValue((String)"key_dp_cache_expire", (long)86400L);
                                MLog.debug((Object)DeferredDeepLinkManager.TAG, (String)"fetch cache dp, begin: %d, expire: %d", (Object[])new Object[]{cacheBegin, expire});
                                if (cacheBegin + expire * 1000L <= SystemClock.uptimeMillis()) {
                                    MLog.warn((Object)DeferredDeepLinkManager.TAG, (String)"cache dp is expired", (Object[])new Object[0]);
                                    YYFileUtils.deleteFile((File)new File(path));
                                    return;
                                }
                                String from = saveJson.optString("from");
                                String mediaSource = saveJson.optString("media_source", "");
                                String uriString = saveJson.optString("uri");
                                MLog.info((Object)DeferredDeepLinkManager.TAG, (String)("fetchCacheDpBundle result: " + saveString), (Object[])new Object[0]);
                                DeeplinkSource deeplinkSource = DeeplinkSource.ofOrNull((String)from);
                                if (deeplinkSource != null && StringUtils.isNotEmpty((String)uriString)) {
                                    final DeepLinkBundle cacheBundle = new DeepLinkBundle(deeplinkSource, Uri.parse((String)uriString), mediaSource);
                                    YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                                        @Override
                                        public void run() {
                                            DeferredDeepLinkManager.this.handleDeeplink(cacheBundle, false);
                                        }
                                    });
                                }
                            } else {
                                MLog.error((Object)DeferredDeepLinkManager.TAG, (String)"fetchUnresolvedBundle but path is not exist : %s", (Object[])new Object[]{path});
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)DeferredDeepLinkManager.TAG, (String)"fetchUnresolvedBundle", (Throwable)e, (Object[])new Object[0]);
                        }
                    }
                }
            });
        }
    }

    private DeepLinkBundle findTarget() {
        DeepLinkBundle targetData;
        block6: {
            Iterator<Map.Entry<DeeplinkSource, DeepLinkBundle>> iterator;
            targetData = null;
            targetData = this.mCacheLinkMap.get(DeeplinkSource.APP_FLYER);
            if (targetData != null) {
                String mediaSource = targetData.getMediaSource();
                if (StringUtils.equal((String)mediaSource, (String)"Facebook Ads")) {
                    targetData = this.mCacheLinkMap.get(DeeplinkSource.FACEBOOK);
                } else if (StringUtils.equal((String)mediaSource, (String)"googleadwords_int")) {
                    targetData = this.mCacheLinkMap.get(DeeplinkSource.GOOGLE_S2S);
                } else if (StringUtils.equal((String)mediaSource, (String)"googleadwords_int")) {
                    targetData = this.mCacheLinkMap.get(DeeplinkSource.GOOGLE_PLAY);
                }
            }
            if (targetData != null || this.mCacheLinkMap.isEmpty() || !(iterator = this.mCacheLinkMap.entrySet().iterator()).hasNext()) break block6;
            Map.Entry<DeeplinkSource, DeepLinkBundle> entry = iterator.next();
            targetData = entry.getValue();
        }
        return targetData;
    }

    private void setTargetBundle(DeepLinkBundle bundle) {
        if (this.mTargetBundle != bundle) {
            MLog.info((Object)TAG, (String)("setTargetBundle: " + bundle), (Object[])new Object[0]);
            if (bundle != null && this.mTargetBundle != null) {
                this.mTargetBundle.setTarget(false);
            }
            this.mTargetBundle = bundle;
            if (this.mTargetBundle != null) {
                this.mTargetBundle.setTarget(true);
            }
            final DeepLinkBundle cacheBundle = this.mTargetBundle;
            YYTaskExecutor.execute((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        Object object = FILE_LOCK;
                        synchronized (object) {
                            if (cacheBundle == null) {
                                YYFileUtils.deleteFile((File)new File(DeferredDeepLinkManager.this.getSavePath()));
                            } else {
                                JSONObject cacheJson = new JSONObject();
                                cacheJson.put("from", (Object)cacheBundle.getFrom().toString());
                                cacheJson.put("media_source", (Object)cacheBundle.getMediaSource());
                                cacheJson.put("uri", (Object)cacheBundle.getUri().toString());
                                cacheJson.put("cache_begin", SystemClock.uptimeMillis());
                                String cacheJsonString = cacheJson.toString();
                                MLog.info((Object)DeferredDeepLinkManager.TAG, (String)("save cache bundle: " + cacheJsonString), (Object[])new Object[0]);
                                YYFileUtils.writeBytesToFile((File)YYFileUtils.createNewFile((String)DeferredDeepLinkManager.this.getSavePath(), (boolean)false), (byte[])cacheJsonString.getBytes(), (boolean)false);
                            }
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)DeferredDeepLinkManager.TAG, (Throwable)e);
                    }
                }
            });
        }
    }

    private void putCacheDpBundle(DeepLinkBundle bundle) {
        MLog.debug((Object)TAG, (String)("putCacheDpBundle: " + bundle), (Object[])new Object[0]);
        this.mCacheLinkMap.put(bundle.getFrom(), bundle);
        DeepLinkBundle target = this.findTarget();
        this.setTargetBundle(target);
        if (target != null) {
            SettingFlags.setStringValue((String)"key_deep_link", (String)target.getUri().toString());
            SettingFlags.setStringValue((String)"key_dp_media_source", (String)target.getMediaSource());
        }
    }

    private String getSavePath() {
        return FileStorageUtils.getInstance().getExternalCacheRootDir() + "/deeplink/last_unconsumed_bundle";
    }

    private void fetchChannelDeeplink() {
        MLog.info((Object)TAG, (String)"fetch package channel deeplink", (Object[])new Object[0]);
        YYTaskExecutor.execute((Runnable)new Runnable(){

            @Override
            public void run() {
                final long reqTime = SystemClock.uptimeMillis();
                DeepLinkStatistics.reportRequestCode((String)"5");
                final String channelId = AppMetaDataUtil.getChannelID((Context)DeferredDeepLinkManager.this.mContext);
                MLog.info((Object)DeferredDeepLinkManager.TAG, (String)("fetch package channel deeplink channelId: " + channelId), (Object[])new Object[0]);
                DeferredDeepLinkManager.this.mCampaignDpHandler.findDeeplinkWithChannel(channelId, new FindDeeplinkCallback(){

                    @Override
                    public void onResult(@Nullable Uri uri) {
                        MLog.info((Object)DeferredDeepLinkManager.TAG, (String)"fetch package channel deeplink end channelId: %s, deeplink: %s", (Object[])new Object[]{channelId, uri});
                        if (uri != null) {
                            DeepLinkStatistics.reportCodeResult((String)uri.toString(), (String)"5", (String)String.valueOf(SystemClock.uptimeMillis() - reqTime));
                            DeferredDeepLinkManager.this.handleDeeplink(new DeepLinkBundle(DeeplinkSource.APK_CHANNEL, uri, channelId), false);
                        }
                        DeferredDeepLinkManager.this.notifyDeeplinkFrom(DeeplinkSource.APK_CHANNEL);
                    }
                });
            }
        });
    }

    private void fetchS2sLinkData() {
        MLog.info((Object)TAG, (String)"fetch s2s deeplink", (Object[])new Object[0]);
        this.mS2sDeeplinkFetcher.fetchDeeplink((Function1<? super Uri, Unit>)new Function1<Uri, Unit>(){

            public Unit invoke(@Nullable Uri uri) {
                MLog.info((Object)DeferredDeepLinkManager.TAG, (String)"fetch s2s deeplink end", (Object[])new Object[0]);
                if (uri != null) {
                    DeferredDeepLinkManager.this.handleDeeplink(new DeepLinkBundle(DeeplinkSource.GOOGLE_S2S, uri, "googleadwords_int"), false);
                }
                DeferredDeepLinkManager.this.notifyDeeplinkFrom(DeeplinkSource.GOOGLE_S2S);
                return null;
            }
        });
    }

    private void fetchFbLinkData() {
        MLog.info((Object)TAG, (String)"fetch fb deeplink", (Object[])new Object[0]);
        final long reqTime = SystemClock.uptimeMillis();
        DeepLinkStatistics.reportRequestSdk((String)"1");
        Message message = Message.obtain();
        message.what = PlatformMsgDef.MSG_GET_APP_LINK_DATA;
        message.obj = new YYAppLinkData.IGetAppLinkDataCallback(){

            public void onSuccess(YYAppLinkData appLinkData) {
                MLog.info((Object)DeferredDeepLinkManager.TAG, (String)("fetch fb deeplink end: " + (appLinkData == null ? null : appLinkData.targetUri)), (Object[])new Object[0]);
                if (appLinkData != null) {
                    Uri uri = appLinkData.targetUri;
                    DeepLinkStatistics.reportSdkResult((String)"1", (String)"Facebook Ads", (String)String.valueOf(SystemClock.uptimeMillis() - reqTime), (Map)HiidoEvent.map((Pair[])new Pair[]{new Pair((Object)"deeplink", (Object)DeepLinkStatistics.getReportDeepLinkString((Uri)uri)), new Pair((Object)"is_arrive_homepage", (Object)String.valueOf(DeferredDeepLinkManager.this.mAccountLogin)), new Pair((Object)"is_null", (Object)(uri == null ? "1" : "0"))}));
                    String uriStr = null;
                    if (uri != null) {
                        uriStr = uri.toString();
                    }
                    if (!DeferredDeepLinkManager.this.isReasonableScheme(uriStr)) {
                        return;
                    }
                    Uri targetUri = uri = Uri.parse((String)(uriStr + "&" + "is_first_launch" + "=" + "true"));
                    HiidoStatis.reportAppMonitorReturnCode((String)"fetch_dp/fb/", (long)(SystemClock.uptimeMillis() - reqTime), (String)"0");
                    DeferredDeepLinkManager.this.handleDeeplink(new DeepLinkBundle(DeeplinkSource.FACEBOOK, targetUri, "Facebook Ads"), false);
                    SettingFlags.setStringValue((String)"facebook_deeplink", (String)uriStr);
                }
                DeferredDeepLinkManager.this.notifyDeeplinkFrom(DeeplinkSource.FACEBOOK);
            }
        };
        ThirdPartyPlatformHelper.getInstance().getPlatform(5).handleMessageSync(message);
    }

    @KvoMethodAnnotation(sourceClass=AppsflyerLinkData.class, name="linkDataChanged", thread=1)
    public void onAppsFlyerDpReceive(KvoEventIntent data) {
        MLog.debug((Object)TAG, (String)"fetch appsflyer deeplink end", (Object[])new Object[0]);
        if (data != null) {
            final Map map = ((AppsflyerLinkData)data.source()).getLinkData();
            final String campaign = (String)map.get("campaign");
            MLog.debug((Object)TAG, (String)("campaign = " + campaign), (Object[])new Object[0]);
            final String mediaSource = (String)map.get("media_source");
            String dpId = "-1";
            DeepLinkReportManager.INSTANCE.saveSource(mediaSource, campaign);
            this.notifyDeeplinkFrom(DeeplinkSource.APP_FLYER);
            FeatureLog.i((String)"FTUriHandleDeepLink", (String)"onAppsFlyerDpReceive map = %s", (Object[])new Object[]{map});
            if (!FP.empty((Map)map)) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20023769").put("media_source", mediaSource));
                DeepLinkService.INSTANCE.saveCampaign(campaign);
                String isFirst = (String)map.get("is_first_launch");
                MLog.debug((Object)TAG, (String)("isFirst = " + isFirst), (Object[])new Object[0]);
                if (StringUtils.equal((String)isFirst, (String)"true")) {
                    final String dp = (String)map.get("af_dp");
                    if (StringUtils.isNotEmpty((String)dp)) {
                        Uri uriOriginal = Uri.parse((String)dp);
                        Uri.Builder newUriBuilder = uriOriginal.buildUpon();
                        for (Map.Entry entry : map.entrySet()) {
                            if (!StringUtils.equal((String)((String)entry.getKey()), (String)"is_first_launch") && !StringUtils.equal((String)((String)entry.getKey()), (String)"af_dp")) {
                                FeatureLog.i((String)"FTUriHandleDeepLink", (String)"%s = %s", (Object[])new Object[]{entry.getKey(), entry.getValue()});
                            }
                            if (StringUtils.equal((String)((String)entry.getKey()), (String)"host") || StringUtils.equal((String)((String)entry.getKey()), (String)"path") || StringUtils.equal((String)((String)entry.getKey()), (String)"af_dp")) continue;
                            newUriBuilder.appendQueryParameter((String)entry.getKey(), (String)entry.getValue());
                        }
                        Uri uri2 = newUriBuilder.build();
                        this.handleDeeplink(new DeepLinkBundle(DeeplinkSource.APP_FLYER, uri2, mediaSource == null ? "" : mediaSource), false);
                    } else if (StringUtils.isNotEmpty((String)campaign) && StringUtils.isNotEmpty((String)(dpId = this.getDpId(campaign)))) {
                        long reqTime = SystemClock.uptimeMillis();
                        DeepLinkStatistics.reportRequestCode((String)"2");
                        this.mCampaignDpHandler.findDeeplinkWithDpId(dpId, uri -> {
                            DeepLinkStatistics.reportCodeResult((String)(uri == null ? null : uri.toString()), (String)"2", (String)String.valueOf(SystemClock.uptimeMillis() - reqTime));
                            if (uri != null) {
                                if (StringUtils.isNotEmpty((String)mediaSource)) {
                                    Uri.Builder newUriBuilder = uri.buildUpon();
                                    newUriBuilder.appendQueryParameter("media_source", mediaSource);
                                    uri = newUriBuilder.build();
                                }
                                this.handleDeeplink(new DeepLinkBundle(DeeplinkSource.APP_FLYER, uri, mediaSource == null ? "" : mediaSource), false);
                            }
                        });
                    }
                    final String finalDpId = dpId;
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20026513").put("function_id", "show").put("act_id", String.valueOf(AccountUtil.getUid())).put("first_login", "1"));
                            HashMap afReportMap = new HashMap();
                            afReportMap.put("af_status", map.get("af_status"));
                            afReportMap.put("media_source", mediaSource);
                            afReportMap.put("af_siteid", map.get("af_siteid"));
                            afReportMap.put("campaign_id", map.get("campaign_id"));
                            afReportMap.put("hdid", map.get("hdid"));
                            DeepLinkStatistics.reportSdkResult((String)"2", (String)mediaSource, (String)((String)map.get("consuming_time")), (Map)HiidoEvent.map((Pair[])new Pair[]{new Pair((Object)"deeplink", (Object)DeepLinkStatistics.getReportDeepLinkString((String)dp)), new Pair((Object)"campaign", (Object)(campaign == null ? "" : campaign)), new Pair((Object)"campaign_code", (Object)finalDpId), new Pair((Object)"is_arrive_homepage", (Object)String.valueOf(DeferredDeepLinkManager.this.mAccountLogin)), new Pair((Object)"af_orginal_data", (Object)JsonParser.toJson(afReportMap))}));
                            HiidoSDK.instance().reportAppsflyer(JsonParser.toJson((Object)map));
                        }
                    });
                }
            }
        }
    }

    private String getDpId(String campaign) {
        String dpId = "";
        if (StringUtils.isEmpty((String)campaign)) {
            return dpId;
        }
        try {
            Matcher m = sDpIdPattern.matcher(campaign);
            if (m.find()) {
                dpId = m.group().substring(2, m.group().length() - 1);
            }
        }
        catch (Exception ex) {
            MLog.error((Object)TAG, (Throwable)ex);
        }
        return dpId;
    }

    private boolean isReasonableScheme(String uri) {
        if (TextUtils.isEmpty((CharSequence)uri)) {
            return false;
        }
        return uri.startsWith("hago") || uri.startsWith("http") || uri.startsWith("olaparty") || uri.startsWith("https") || uri.startsWith("yylitemobile") || uri.startsWith(ResourceUtils.getString((int)R.string.fb_login_protocol_scheme));
    }
}

