/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app;

import com.yy.appbase.abtest.IUserAbTestService;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.notify.NotificationIdDef;
import com.yy.appbase.service.IHomePlanService;
import com.yy.appbase.service.IHonorService;
import com.yy.appbase.service.IServiceManager;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.INotify;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.hiyo.coins.base.ICoinsService;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.game.service.IGameCenterService;
import com.yy.hiyo.game.service.IGameInfoService;
import com.yy.hiyo.game.service.IGameService;
import com.yy.hiyo.im.ImService;
import com.yy.hiyo.wallet.base.IPrivilegeService;
import com.yy.hiyo.wallet.base.privilege.service.CheckHadService;
import com.yy.hiyo.wallet.base.revenue.privilege.DummyCallback;
import com.yy.hiyo.wallet.base.revenue.privilege.IPrivilegeCallback;

final class ServiceNotifyCenter
implements INotify {
    private static final String TAG = "ServiceNotifyCenter";
    private IServiceManager serviceManager;

    public ServiceNotifyCenter(IServiceManager serviceManager) {
        this.serviceManager = serviceManager;
        this.registerGlobalNotify();
    }

    private void registerGlobalNotify() {
        NotificationCenter center = NotificationCenter.getGlobalInstance();
        center.register(NotificationDef.N_STARTUP_FINISHED, (INotify)this);
        center.register(NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS, (INotify)this);
        center.register(NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS, (INotify)this);
        center.register(NotificationDef.N_STARTUP_FINISHED_AFTER_10_SECONDS, (INotify)this);
        center.register(NotificationDef.N_LOGIN_LOGIN_OUT, (INotify)this);
        center.register(NotificationDef.N_LOGIN_ACCOUNT_CHANGED, (INotify)this);
        center.register(NotificationDef.N_LOGIN_SUCCESS, (INotify)this);
        center.register(NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS, (INotify)this);
        center.register(NotificationDef.N_SHOW_HOME_PAGE, (INotify)this);
        center.register(NotificationDef.N_LOGIN_PROCESS_COMPLETED, (INotify)this);
        center.register(NotificationDef.N_FOREGROUND_CHANGE, (INotify)this);
        center.register(NotificationIdDef.CHANNEL_ENTERED, (INotify)this);
        center.register(NotificationDef.N_NETWORK_STATE_CHANGE, (INotify)this);
    }

    public void notify(Notification notification) {
        if (this.serviceManager == null) {
            MLog.error((Object)TAG, (String)"notify error: serviceManager is null", (Object[])new Object[0]);
            return;
        }
        if (!RuntimeContext.sIsServicesInited) {
            MLog.error((Object)TAG, (String)"notify error: services not init yet", (Object[])new Object[0]);
            return;
        }
        try {
            if (notification.id == NotificationDef.N_STARTUP_FINISHED) {
                this.onStartUpFinish();
            }
            if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_1_SECONDS) {
                this.onStartUpFinishAfterOne();
            }
            if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_3_SECONDS) {
                this.onStartUpFinishAfterThree();
            }
            if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_5_SECONDS) {
                this.onStartUpFinishAfterFive();
            }
            if (notification.id == NotificationDef.N_STARTUP_FINISHED_AFTER_10_SECONDS) {
                this.onStartUpFinishAfterTen();
            }
            if (notification.id == NotificationDef.N_LOGIN_LOGIN_OUT) {
                this.onLogout();
            }
            if (notification.id == NotificationDef.N_LOGIN_ACCOUNT_CHANGED) {
                this.onAccountChange();
            }
            if (notification.id == NotificationDef.N_LOGIN_SUCCESS) {
                this.onLoginSuccess();
            }
            if (notification.id == NotificationDef.N_SHOW_HOME_PAGE) {
                this.onShowHomePage();
            }
            if (notification.id == NotificationDef.N_LOGIN_PROCESS_COMPLETED) {
                this.onLoginProcessCompleted();
            }
            if (notification.id == NotificationDef.N_FOREGROUND_CHANGE) {
                this.onForegroundChange(notification);
            }
            if (notification.id == NotificationDef.N_NETWORK_STATE_CHANGE) {
                this.onNetWorkStateChange();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            MLog.error((Object)TAG, (String)"notify error:", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private void onNetWorkStateChange() {
        MLog.info((Object)TAG, (String)"onNetWorkStateChange", (Object[])new Object[0]);
        if (RuntimeContext.sIsAppStartFinished) {
            ((IGameService)this.serviceManager.getService(IGameService.class)).checkNet();
        }
    }

    private void onForegroundChange(Notification notification) {
        boolean isForeground = (Boolean)notification.extObj;
        if (this.serviceManager.hasRegisterService(ImService.class)) {
            MLog.info((Object)TAG, (String)"onForegroundChange: isForeground=%s", (Object[])new Object[]{isForeground});
            ((ImService)this.serviceManager.getService(ImService.class)).onForegroundChange(isForeground);
        }
    }

    private void onLoginProcessCompleted() {
        MLog.info((Object)TAG, (String)"onLoginProcessCompleted", (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IHomePlanService)ServiceNotifyCenter.this.serviceManager.getService(IHomePlanService.class)).initCheckShowDialog();
            }
        }, (long)1000L);
    }

    private void onShowHomePage() {
        MLog.info((Object)TAG, (String)"onShowHomePage", (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IHomePlanService)ServiceNotifyCenter.this.serviceManager.getService(IHomePlanService.class)).initCheckShowDialog();
            }
        }, (long)1000L);
    }

    private void onLoginSuccess() {
        MLog.info((Object)TAG, (String)"onLoginSuccess", (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IGameAudioService)ServiceNotifyCenter.this.serviceManager.getService(IGameAudioService.class)).getAudioConfig();
                ((ICoinsService)ServiceNotifyCenter.this.serviceManager.getService(ICoinsService.class)).initData();
            }
        }, (long)2000L);
    }

    private void onAccountChange() {
        MLog.info((Object)TAG, (String)"onAccountChange", (Object[])new Object[0]);
        if (AccountUtil.getUid() > 0L) {
            if (this.serviceManager.hasRegisterService(ImService.class)) {
                ((ImService)this.serviceManager.getService(ImService.class)).onAccountChange();
            }
            if (this.serviceManager.hasRegisterService(IGameService.class)) {
                ((IGameService)this.serviceManager.getService(IGameService.class)).onAccountChange();
            }
            if (this.serviceManager.hasRegisterService(IUserAbTestService.class)) {
                ((IUserAbTestService)this.serviceManager.getService(IUserAbTestService.class)).onAccountChange();
            }
            if (this.serviceManager.hasRegisterService(IGameInfoService.class)) {
                ((IGameInfoService)this.serviceManager.getService(IGameInfoService.class)).onAccountChanged();
            }
        }
    }

    private void onLogout() {
        MLog.info((Object)TAG, (String)"onLogout", (Object[])new Object[0]);
        ((IGameInfoService)this.serviceManager.getService(IGameInfoService.class)).resetGame();
        ((IGameService)this.serviceManager.getService(IGameService.class)).onLogout();
    }

    private void onStartUpFinish() {
        MLog.info((Object)TAG, (String)"onStartUpFinish", (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IGameService)ServiceNotifyCenter.this.serviceManager.getService(IGameService.class)).init();
                ((IGameCenterService)ServiceNotifyCenter.this.serviceManager.getService(IGameCenterService.class)).registerInviteListener();
                ((IUserAbTestService)ServiceNotifyCenter.this.serviceManager.getService(IUserAbTestService.class)).requestUserAbTest();
            }
        });
    }

    private void onStartUpFinishAfterOne() {
        MLog.info((Object)TAG, (String)"onStartUpFinishAfterOne", (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ((IGameService)ServiceNotifyCenter.this.serviceManager.getService(IGameService.class)).checkUpdatePlayGameInfo();
                ((IHonorService)ServiceNotifyCenter.this.serviceManager.getService(IHonorService.class)).registerNotify();
            }
        });
    }

    private void onStartUpFinishAfterThree() {
        MLog.info((Object)TAG, (String)"onStartUpFinishAfterThree", (Object[])new Object[0]);
        if (!RuntimeContext.isStartAtFirstInstalled() && !RuntimeContext.isStartAtCoverInstalled()) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ((IGameAudioService)ServiceNotifyCenter.this.serviceManager.getService(IGameAudioService.class)).getAudioConfig();
                    ServiceNotifyCenter.this.requestUserPrivilege();
                }
            });
        }
    }

    private void requestUserPrivilege() {
        CheckHadService checkHadService;
        long uid = AccountUtil.getUid();
        if (uid > 0L && (checkHadService = (CheckHadService)((IPrivilegeService)this.serviceManager.getService(IPrivilegeService.class)).getService(CheckHadService.class)) != null) {
            checkHadService.fetchUserPrivilege(uid, false, (IPrivilegeCallback)new DummyCallback());
        }
    }

    private void onStartUpFinishAfterFive() {
        MLog.info((Object)TAG, (String)"onStartUpFinishAfterFive", (Object[])new Object[0]);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!RuntimeContext.isHagoPartySdk()) {
                    ((ICoinsService)ServiceNotifyCenter.this.serviceManager.getService(ICoinsService.class)).report();
                }
                ((ImService)ServiceNotifyCenter.this.serviceManager.getService(ImService.class)).initOutOfLine();
                ((IGameService)ServiceNotifyCenter.this.serviceManager.getService(IGameService.class)).delResutlDB();
                DyResLoader.INSTANCE.initDR();
                if (RuntimeContext.isStartAtFirstInstalled() || RuntimeContext.isStartAtCoverInstalled()) {
                    ((IGameAudioService)ServiceNotifyCenter.this.serviceManager.getService(IGameAudioService.class)).getAudioConfig();
                    ServiceNotifyCenter.this.requestUserPrivilege();
                }
            }
        });
    }

    private void onStartUpFinishAfterTen() {
        ((IGameService)this.serviceManager.getService(IGameService.class)).checkDeleteGame();
    }
}

