/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.app;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Message;
import androidx.fragment.app.FragmentActivity;
import com.yy.appbase.aab.IAABService;
import com.yy.appbase.aab.IAabApi;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.service.IServiceManager;
import com.yy.appbase.service.LiveEnv;
import com.yy.base.env.RuntimeContext;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.ControllerCenter;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ICompatibilityAutoRegister;
import com.yy.framework.core.IControllerFactory;
import com.yy.framework.core.IControllerRegister;
import com.yy.framework.core.IMsgProcessor;
import com.yy.framework.core.INotify;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.framework.core.NotificationDef;
import com.yy.framework.core.ui.ACWindowManager;
import com.yy.framework.core.ui.AbstractWindowManager;
import com.yy.framework.core.ui.DeviceManager;
import com.yy.hiyo.app.ServiceManager;
import com.yy.hiyo.app.aab.AABService;
import com.yy.hiyo.core.ControllerFactory;
import com.yy.hiyo.core.register.ControllerRegistry;
import com.yy.hiyo.home.base.startup.StartUpBridgeHelper;
import com.yy.hiyo.main.base.startup.IStartUpBridge;
import com.yy.hiyo.main.msg.MsgDef;

public class HagoEnvIniter {
    private static Application sApplication;
    private static ControllerRegistry sControllerRegistry;
    private static LiveEnv baseEnv;
    private static ACWindowManager sWindowManager;
    private static HagoEnvHandler sHagoEnvHandler;
    private static INotify sMainActivityDestroy;

    public static synchronized LiveEnv initEnv(Application application, IAabApi aabApi) {
        if (baseEnv != null) {
            return baseEnv;
        }
        sApplication = application;
        baseEnv = new LiveEnv((Context)application);
        sWindowManager = new ACWindowManager();
        baseEnv.setContext((Context)application);
        baseEnv.setDeviceManager(new DeviceManager((Context)application));
        baseEnv.setWindowManager((AbstractWindowManager)sWindowManager);
        sWindowManager.setContext((Context)application);
        ControllerCenter mControllerCenter = new ControllerCenter((Environment)baseEnv, (IControllerFactory)new ControllerFactory());
        sControllerRegistry = new ControllerRegistry((IControllerRegister)mControllerCenter);
        mControllerCenter.setCallback((IControllerRegister.IControllerCenterCallback)sControllerRegistry);
        baseEnv.setServiceManager((IServiceManager)ServiceManager.getInstance());
        ServiceManager.getInstance().setLiveEnv(baseEnv, (IControllerRegister)mControllerCenter);
        HagoEnvIniter.registerAABService(aabApi);
        sControllerRegistry.registerCoreControllers();
        MsgDispatcher.init((IMsgProcessor)mControllerCenter, (ICompatibilityAutoRegister)mControllerCenter);
        NotificationCenter.getGlobalInstance().setStaticNotificationProxy((NotificationCenter.IStaticNotificationProxy)mControllerCenter);
        sHagoEnvHandler = new HagoEnvHandler((Environment)baseEnv, aabApi);
        return baseEnv;
    }

    public static synchronized void onMainActivity(FragmentActivity activity, boolean isPartySdk) {
        baseEnv.updateActivity(activity);
        sWindowManager.setActivity((Activity)activity, isPartySdk ? 0 : -1);
        baseEnv.getDeviceManager().updateActivity((Activity)activity);
        if (RuntimeContext.isHagoPartySdk()) {
            NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)NotificationDef.N_APP_RESTART, (Object)baseEnv));
            NotificationCenter.getGlobalInstance().register(NotificationDef.N_APP_DESTROY, HagoEnvIniter.getMainActivityDestroy());
        }
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.ROOT_ONCREATE, (Object)new Object[]{activity, activity.getIntent()});
    }

    public static synchronized void onActivityNewIntent(FragmentActivity activity, Intent intent) {
        MsgDispatcher.getInstance().sendMessageSync(MsgDef.ROOT_ONNEWINTENT, (Object)intent);
    }

    public static synchronized void onActivityDestroy(FragmentActivity activity) {
        HagoEnvIniter.onActivityDestroy();
    }

    private static INotify getMainActivityDestroy() {
        if (sMainActivityDestroy == null) {
            sMainActivityDestroy = new INotify(){

                public void notify(Notification notification) {
                    HagoEnvIniter.onActivityDestroy();
                }
            };
        }
        return sMainActivityDestroy;
    }

    public static void onActivityDestroy() {
        baseEnv.updateActivity(null);
        sWindowManager.setContext((Context)sApplication);
        sWindowManager.setActivity(null);
        baseEnv.getDeviceManager().updateActivity(null);
    }

    public static void registerNonCoreControllers() {
        sControllerRegistry.registerNonCoreControllers();
    }

    public static IStartUpBridge getStartUpBridge() {
        return sHagoEnvHandler.mStartUpBridge;
    }

    public static void registerAABService(IAabApi aabApi) {
        ServiceManager.getInstance().setService(IAABService.class, (env, manager) -> new AABService(aabApi));
    }

    private static class HagoEnvHandler
    extends DefaultController {
        private IStartUpBridge mStartUpBridge = StartUpBridgeHelper.INSTANCE.getStartUpBridge();

        public HagoEnvHandler(Environment env, IAabApi aabApi) {
            super(env);
            this.mStartUpBridge.onModuleLoaderCreated(env, aabApi);
            this.registerMessage(MsgDef.ROOT_ON_SERVICE_NOT_FIND);
            this.registerMessage(MsgDef.ROOT_ON_SERVICE_START_REGISTER);
            this.registerMessage(BaseMsgDef.ON_MSG_HANDLER_NOT_FIND);
        }

        public Object handleMessageSync(Message msg) {
            Object result = null;
            if (MsgDef.ROOT_ON_SERVICE_NOT_FIND == msg.what) {
                this.mStartUpBridge.onServiceNotFind(msg.obj instanceof Class ? (Class)msg.obj : null);
            } else if (MsgDef.ROOT_ON_SERVICE_START_REGISTER == msg.what) {
                this.mStartUpBridge.initModuleDeforeStartup();
            } else if (BaseMsgDef.ON_MSG_HANDLER_NOT_FIND == msg.what) {
                this.mStartUpBridge.onMsgHanderNotFind(msg.arg1);
            }
            return result;
        }
    }
}

