/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo;

import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.util.Log;
import android.webkit.WebView;
import androidx.multidex.MultiDex;
import com.yy.base.env.ConstDef;
import com.yy.base.env.IApplicationRoute;
import com.yy.base.env.MyApplication;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.timing.TimingTracer;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.SharedPreferencesUtils;
import com.yy.base.utils.StrictModeUtil;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.hiyo.HagoPartySdkApplication;
import com.yy.hiyo.applicationroute.ApplicationFactory;
import com.yy.hiyo.applicationroute.AyncLoadDex;
import com.yy.hiyo.home.base.startup.StartUpBridgeHelper;
import com.yy.hiyo.login.base.language.LanguageLocaleHelper;
import com.yy.hiyo.module.performancemonitor.perfcollect.PerfCollecter;
import com.yy.hiyo.restart.RestartHelper;
import java.io.File;

public class LiteApplication
extends Application {
    private IApplicationRoute mIApplicationRoute;
    private static volatile boolean initEnvWhenGetSharedPreferences;
    private static boolean sInitPieWebViewed;

    public void onCreate() {
        TimingTracer.beginTrace((String)"startup");
        this.initPackageName();
        Log.e((String)"loadDex", (String)("App onCreate processnane: " + RuntimeContext.sCurProcessName));
        if (RuntimeContext.sIsMainProcess) {
            StrictModeUtil.openStrictMode();
            if (this.mIApplicationRoute != null) {
                this.mIApplicationRoute.onCreate((Application)this);
            }
        } else if (RestartHelper.isRestartProcess((Context)this)) {
            super.onCreate();
        } else if (this.mIApplicationRoute != null) {
            this.mIApplicationRoute.onCreate((Application)this);
            this.initPieWebView();
        } else {
            super.onCreate();
            StartUpBridgeHelper.INSTANCE.getStartUpBridge().fbAudieNetworkWrapperInit((Application)this);
            this.initPieWebView();
        }
    }

    private void initPackageName() {
        if (StringUtils.isNotEmpty((String)RuntimeContext.sPackageName) && RuntimeContext.sApplicationContext != null) {
            return;
        }
        RuntimeContext.sApplicationContext = this;
        RuntimeContext.sPackageName = this.getPackageName();
        String processName = this.getProcessName((Context)this);
    }

    protected void attachBaseContext(Context base) {
        if (RuntimeContext.isHagoPartySdk()) {
            super.attachBaseContext(base);
            HagoPartySdkApplication.attachBaseContext(base);
            return;
        }
        RuntimeContext.sApplicationContext = this;
        this.mIApplicationRoute = ApplicationFactory.getApplication(this);
        Log.e((String)"loadDex", (String)("App onCreate processnane: " + this.getProcessName((Context)this)));
        if (RestartHelper.isRestartProcess(base)) {
            super.attachBaseContext(base);
            Log.d((String)"loadDex", (String)"isRestartProcess ");
        } else {
            super.attachBaseContext(LanguageLocaleHelper.wrapContext((Context)base));
            MultiDex.install((Context)base);
            if (this.mIApplicationRoute == null) {
                try {
                    this.initPieWebView();
                }
                catch (Throwable e) {
                    Log.e((String)"loadDex", (String)"", (Throwable)e);
                }
            }
            if (this.mIApplicationRoute != null) {
                this.mIApplicationRoute.attachBaseContext((Application)this);
            }
        }
    }

    public void onTrimMemory(int level) {
        if (RuntimeContext.isHagoPartySdk()) {
            return;
        }
        RuntimeContext.sHappenLowMemWarn = level != 5;
        super.onTrimMemory(level);
        if (this.mIApplicationRoute != null) {
            this.mIApplicationRoute.onTrimMemory((Application)this, level);
        }
    }

    public void onLowMemory() {
        if (RuntimeContext.isHagoPartySdk()) {
            return;
        }
        RuntimeContext.sHappenLowMemWarn = true;
        super.onLowMemory();
        if (this.mIApplicationRoute != null) {
            this.mIApplicationRoute.onLowMemory((Application)this);
        }
    }

    public SharedPreferences getSharedPreferences(final String name, final int mode) {
        if (RuntimeContext.isHagoPartySdk()) {
            return super.getSharedPreferences(name, mode);
        }
        if (AyncLoadDex.isMainProcess(this)) {
            if (!initEnvWhenGetSharedPreferences) {
                this.initPackageName();
                if (RuntimeContext.isLocalBuild()) {
                    SettingFlags.init((Context)this);
                    MyApplication.setDebuggable((Application)this);
                    PerfCollecter.onApplicationCreate(this);
                    MyApplication.initLogging((boolean)true);
                } else {
                    SettingFlags.init((Context)this);
                    PerfCollecter.onApplicationCreate(this);
                }
                SharedPreferencesUtils.INSTANCE.ensureCopySystemSPFile((Context)this);
                if (RuntimeContext.sIsDebuggable) {
                    final boolean startUpFinished = RuntimeContext.sIsAppStartFinished;
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            MLog.info((Object)"LiteApplication", (String)"SharedPreference name:%s, mode:%d, isStartFinished:%d", (Object[])new Object[]{name, mode, startUpFinished ? 1 : 0});
                        }
                    });
                }
                initEnvWhenGetSharedPreferences = true;
            }
            return SharedPreferencesUtils.INSTANCE.getSharedPreferences((Context)this, name, mode, true);
        }
        return super.getSharedPreferences(name, mode);
    }

    private void initPieWebView() {
        String processName = this.getProcessName((Context)this);
        if (ConstDef.DEFAULT_PACKAGE_NAME.equals(processName)) {
            return;
        }
        TimingTracer.addSplit((String)"startup", (String)"initPieWebView");
        if (Build.VERSION.SDK_INT >= 28 && !sInitPieWebViewed) {
            File dir = new File(FileStorageUtils.getInstance().getInternalFileRootDir());
            if (dir == null) {
                return;
            }
            String path = dir.getAbsolutePath();
            if (path == null || path.startsWith("/mnt/expand/")) {
                Log.i((String)"LiteApplication", (String)("initPieWebView path = " + path));
                return;
            }
            sInitPieWebViewed = true;
            if (!ConstDef.DEFAULT_PACKAGE_NAME.equals(processName)) {
                String suf = processName;
                int index = processName.lastIndexOf(":");
                if (index > 0 && index < processName.length() - 1) {
                    suf = processName.substring(index + 1);
                }
                Log.i((String)"LiteApplication", (String)(processName + " , suf " + suf));
                if (StringUtils.isNotEmpty((String)suf)) {
                    WebView.setDataDirectorySuffix((String)suf);
                }
            }
        }
    }

    public String getProcessName(Context context) {
        return IApplicationRoute.getProcessNameFromProc((Application)this);
    }

    static {
        String string2 = "123";
        initEnvWhenGetSharedPreferences = false;
        sInitPieWebViewed = false;
    }
}

