/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.linkmic.business.linker;

import android.view.View;
import androidx.arch.core.util.Function;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import androidx.lifecycle.Transformations;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.extensions.CommonExtensionsKt;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.appbase.safelivedata.SafeLiveData;
import com.yy.appbase.service.IService;
import com.yy.appbase.service.IUserInfoService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.service.callback.OnKSProfileListCallback;
import com.yy.appbase.ui.widget.YYPlaceHolderView;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.SettingFlags;
import com.yy.hiyo.linkmic.LinkMicMvpContext;
import com.yy.hiyo.linkmic.LinkMicPage;
import com.yy.hiyo.linkmic.R;
import com.yy.hiyo.linkmic.business.linker.Linker;
import com.yy.hiyo.linkmic.business.linker.LinkerAudioView;
import com.yy.hiyo.linkmic.business.linker.LinkerVideoView;
import com.yy.hiyo.linkmic.business.linker.LinkerViewModel;
import com.yy.hiyo.linkmic.business.options.LinkMicOptionsViewModel;
import com.yy.hiyo.linkmic.data.entity.ChangeJoinMicType;
import com.yy.hiyo.linkmic.data.entity.LinkMicStatus;
import com.yy.hiyo.linkmic.report.LinkMicReportTrack;
import com.yy.hiyo.mvp.base.BasePresenter;
import com.yy.hiyo.mvp.base.IMvpContext;
import com.yy.hiyo.relation.base.IRelationService;
import com.yy.hiyo.relation.base.data.Relation;
import com.yy.hiyo.relation.base.data.RelationInfo;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.mgr.JoinMicStatus;
import net.ihago.channel.srv.mgr.JoinMicType;
import net.ihago.room.srv.follow.EPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u00032\u00020\u0004B\u0005\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\"H\u0016J\u0010\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%H\u0002J\u0010\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020%H\u0016J\b\u0010(\u001a\u00020%H\u0016J\u0018\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\"2\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010+\u001a\u00020\b2\u0006\u0010,\u001a\u00020%2\u0006\u0010$\u001a\u00020%H\u0016J\b\u0010-\u001a\u00020\u001fH\u0016J\b\u0010.\u001a\u00020\u001fH\u0016J\u0010\u0010/\u001a\u00020\u001f2\u0006\u00100\u001a\u00020\u0002H\u0016J\b\u00101\u001a\u00020\u001fH\u0016J\u0018\u00102\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\b2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u000206H\u0007J\b\u00107\u001a\u00020\u001fH\u0016J\u0018\u00108\u001a\u00020\u001f2\u0006\u00103\u001a\u00020\b2\u0006\u00109\u001a\u00020:H\u0016J\u0010\u0010;\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020%H\u0016R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR)\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\b0\b0\f8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u000b\u0010\u000eR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\tR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R#\u0010\u0016\u001a\n \r*\u0004\u0018\u00010\u00170\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0010\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\t\u00a8\u0006<"}, d2={"Lcom/yy/hiyo/linkmic/business/linker/LinkerViewModel;", "Lcom/yy/hiyo/mvp/base/BasePresenter;", "Lcom/yy/hiyo/linkmic/LinkMicMvpContext;", "Lcom/yy/hiyo/mvp/base/BaseViewModel;", "Lcom/yy/hiyo/linkmic/business/linker/Linker$IViewModel;", "()V", "isFollowed", "Lcom/yy/appbase/safelivedata/SafeLiveData;", "", "()Lcom/yy/appbase/safelivedata/SafeLiveData;", "isLinkUIClosed", "isOptionsVisible", "Landroidx/lifecycle/LiveData;", "kotlin.jvm.PlatformType", "()Landroidx/lifecycle/LiveData;", "isOptionsVisible$delegate", "Lkotlin/Lazy;", "isVideoMode", "mBinder", "Lcom/yy/base/event/kvo/helper/KvoBinder;", "mDelayRunnable", "Ljava/lang/Runnable;", "relationService", "Lcom/yy/hiyo/relation/base/IRelationService;", "getRelationService", "()Lcom/yy/hiyo/relation/base/IRelationService;", "relationService$delegate", "targetInfo", "Lcom/yy/appbase/kvo/UserInfoKS;", "getTargetInfo", "changeLinkModeUI", "", "isDelay", "mode", "", "fetchLinkerUserInfo", "joinUid", "", "follow", "uid", "getCurrentJoinUid", "handleLinkModeChange", "linkMicType", "isLinkMicInitiator", "anchorUid", "onAvatarClick", "onDestroy", "onInit", "mvpContext", "onLinkClose", "onLinkModeChange", "isVideo", "onRelationChanged", "event", "Lcom/yy/base/event/kvo/KvoEventIntent;", "removeLastViews", "showOptionsMenu", "holder", "Lcom/yy/appbase/ui/widget/YYPlaceHolderView;", "unFollow", "linkmic_debug"})
public final class LinkerViewModel
extends BasePresenter<LinkMicMvpContext>
implements Linker.IViewModel {
    @NotNull
    private final Lazy isOptionsVisible$delegate = LazyKt.lazy((Function0)((Function0)new Function0<LiveData<Boolean>>(this){
        final /* synthetic */ LinkerViewModel this$0;

        @NotNull
        public final LiveData<Boolean> invoke() {
            return Transformations.map(((LinkMicMvpContext)this.this$0.getMvpContext()).getLinkMicModel().getLinkMicStatusData(), (Function)isOptionsVisible.1.INSTANCE);
        }
        {
            this.this$0 = linkerViewModel;
            super(0);
        }
    }));
    @NotNull
    private final SafeLiveData<Boolean> isFollowed = new SafeLiveData();
    @NotNull
    private final SafeLiveData<UserInfoKS> targetInfo = new SafeLiveData();
    @NotNull
    private final SafeLiveData<Boolean> isLinkUIClosed = new SafeLiveData();
    @NotNull
    private final SafeLiveData<Boolean> isVideoMode = new SafeLiveData();
    private Runnable mDelayRunnable;
    private final Lazy relationService$delegate = LazyKt.lazy((Function0)relationService.2.INSTANCE);
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    @Override
    @NotNull
    public LiveData<Boolean> isOptionsVisible() {
        Lazy lazy = this.isOptionsVisible$delegate;
        LinkerViewModel linkerViewModel = this;
        Object var3_3 = null;
        boolean bl = false;
        return (LiveData)lazy.getValue();
    }

    @NotNull
    public SafeLiveData<Boolean> isFollowed() {
        return this.isFollowed;
    }

    @NotNull
    public SafeLiveData<UserInfoKS> getTargetInfo() {
        return this.targetInfo;
    }

    @NotNull
    public SafeLiveData<Boolean> isLinkUIClosed() {
        return this.isLinkUIClosed;
    }

    @NotNull
    public SafeLiveData<Boolean> isVideoMode() {
        return this.isVideoMode;
    }

    private final IRelationService getRelationService() {
        Lazy lazy = this.relationService$delegate;
        LinkerViewModel linkerViewModel = this;
        Object var3_3 = null;
        boolean bl = false;
        return (IRelationService)lazy.getValue();
    }

    public void onInit(@NotNull LinkMicMvpContext mvpContext2) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)mvpContext2), (String)"mvpContext");
        super.onInit((IMvpContext)mvpContext2);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, mvpContext2){
            final /* synthetic */ LinkerViewModel this$0;
            final /* synthetic */ LinkMicMvpContext $mvpContext;

            public final void run() {
                LinkMicMvpContext linkMicMvpContext = this.$mvpContext;
                boolean bl = false;
                boolean bl2 = false;
                LinkMicMvpContext $this$with = linkMicMvpContext;
                boolean bl3 = false;
                $this$with.getLinkMicModel().getLinkMicStatusData().observe((LifecycleOwner)$this$with.getLifecycleOwner(), (Observer)new Observer<LinkMicStatus>(this){
                    final /* synthetic */ onInit.1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void onChanged(LinkMicStatus it) {
                        if (it == null) {
                            return;
                        }
                        if (it.getStatus() == JoinMicStatus.JOIN_MIC_GOING.getValue() && CommonExtensionsKt.orZero((Long)it.getJoinUid()) > 0L) {
                            Long l = it.getAnchorUid();
                            Long l2 = it.getJoinUid();
                            if (this.this$0.this$0.isLinkMicInitiator(l != null ? l : 0L, l2 != null ? l2 : 0L)) {
                                this.this$0.this$0.handleLinkModeChange(it.getJoinMicType(), CommonExtensionsKt.orZero((Long)it.getJoinUid()));
                            }
                        } else {
                            this.this$0.this$0.onLinkClose();
                        }
                    }
                });
                $this$with.getLinkMicModel().getChangeJoinMicTypeData().observe((LifecycleOwner)$this$with.getLifecycleOwner(), (Observer)new Observer<ChangeJoinMicType>($this$with, this){
                    final /* synthetic */ LinkMicMvpContext $this_with;
                    final /* synthetic */ onInit.1 this$0;
                    {
                        this.$this_with = linkMicMvpContext;
                        this.this$0 = var2_2;
                    }

                    public final void onChanged(ChangeJoinMicType it) {
                        if (it == null) {
                            return;
                        }
                        LinkMicStatus linkMicStatus2 = (LinkMicStatus)this.$this_with.getLinkMicModel().getLinkMicStatusData().getValue();
                        Long anchorUid = linkMicStatus2 != null ? linkMicStatus2.getAnchorUid() : null;
                        Long l = anchorUid;
                        Long l2 = it.getJoinUid();
                        if (this.this$0.this$0.isLinkMicInitiator(l != null ? l : 0L, l2 != null ? l2 : 0L)) {
                            this.this$0.this$0.handleLinkModeChange(it.getJoinMicType(), CommonExtensionsKt.orZero((Long)it.getJoinUid()));
                        }
                    }
                });
            }
            {
                this.this$0 = linkerViewModel;
                this.$mvpContext = linkMicMvpContext;
            }
        }, (long)1000L);
    }

    public void onDestroy() {
        block1: {
            if (((LinkMicMvpContext)this.getMvpContext()).isSupportPageReuse()) {
                this.removeLastViews();
            }
            super.onDestroy();
            Runnable runnable = this.mDelayRunnable;
            if (runnable == null) break block1;
            Runnable runnable2 = runnable;
            boolean bl = false;
            boolean bl2 = false;
            Runnable it = runnable2;
            boolean bl3 = false;
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)it);
        }
    }

    @Override
    public void onLinkModeChange(boolean isVideo, long joinUid) {
        MLog.info((Object)"FTLinkMic.Linker", (String)("onLinkModeChange " + isVideo + ", " + joinUid), (Object[])new Object[0]);
        LinkMicPage page2 = ((LinkMicMvpContext)this.getMvpContext()).getPage();
        if (page2.getVideoContainer() == null || page2.getAudioContainer() == null) {
            MLog.info((Object)"FTLinkMic.Linker", (String)"onLinkModeChange error videoContainer or audioContainer null", (Object[])new Object[0]);
            return;
        }
        if (joinUid != AccountUtil.getUid()) {
            this.mBinder.clearAllKvoConnections();
            this.mBinder.singleBindSourceTo((KvoSource)this.getRelationService().requestRelation(joinUid));
        }
        this.isVideoMode().setValue((Object)isVideo);
        this.isLinkUIClosed().setValue((Object)false);
        if (isVideo) {
            LinkerVideoView tagView = (LinkerVideoView)page2.getVideoContainer().findViewById(R.id.id_link_mic_video_linker_view);
            if (tagView == null) {
                LinkerVideoView view = new LinkerVideoView(((LinkMicMvpContext)this.getMvpContext()).getContext(), null, 0, 6, null);
                view.setId(R.id.id_link_mic_video_linker_view);
                page2.getVideoContainer().addView((View)view, -1, -1);
                MLog.info((Object)"FTLinkMic.Linker", (String)"add LinkerVideoView to videoContainer", (Object[])new Object[0]);
                view.setPresenter(this);
                LinkMicReportTrack.INSTANCE.showBigWindow(joinUid);
            }
        } else {
            LinkerAudioView tagView = (LinkerAudioView)page2.getAudioContainer().findViewById(R.id.id_link_mic_audio_linker_view);
            if (tagView == null) {
                LinkerAudioView view = new LinkerAudioView(((LinkMicMvpContext)this.getMvpContext()).getContext(), null, 0, 6, null);
                view.setId(R.id.id_link_mic_audio_linker_view);
                page2.getAudioContainer().addView((View)view, -1, -1);
                MLog.info((Object)"FTLinkMic.Linker", (String)"add LinkerAudioView to audioContainer", (Object[])new Object[0]);
                view.setPresenter(this);
                LinkMicReportTrack.INSTANCE.showSmallWindow(joinUid);
            }
        }
        this.fetchLinkerUserInfo(joinUid);
    }

    private final void fetchLinkerUserInfo(long joinUid) {
        IUserInfoService service = (IUserInfoService)ServiceManagerProxy.getService(IUserInfoService.class);
        UserInfoKS userInfoKS = service.getUserInfo(joinUid);
        Intrinsics.checkExpressionValueIsNotNull((Object)userInfoKS, (String)"service.getUserInfo(joinUid)");
        UserInfoKS info = userInfoKS;
        if (info.ver > 0L) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(this, info){
                final /* synthetic */ LinkerViewModel this$0;
                final /* synthetic */ UserInfoKS $info;

                public final void run() {
                    this.this$0.getTargetInfo().postValue((Object)this.$info);
                }
                {
                    this.this$0 = linkerViewModel;
                    this.$info = userInfoKS;
                }
            });
        } else {
            service.requestUserInfoFromServer(joinUid, new OnKSProfileListCallback(this, service, joinUid){
                final /* synthetic */ LinkerViewModel this$0;
                final /* synthetic */ IUserInfoService $service;
                final /* synthetic */ long $joinUid;

                public void onError(@Nullable String reason, long code) {
                    this.this$0.getTargetInfo().postValue((Object)this.$service.getUserInfo(this.$joinUid));
                }

                public void onUISuccess(@NotNull List<? extends UserInfoKS> userInfo) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull(userInfo, (String)"userInfo");
                        UserInfoKS userInfoKS = (UserInfoKS)CollectionsKt.getOrNull(userInfo, (int)0);
                        if (userInfoKS == null) break block0;
                        UserInfoKS userInfoKS2 = userInfoKS;
                        boolean bl = false;
                        boolean bl2 = false;
                        UserInfoKS it = userInfoKS2;
                        boolean bl3 = false;
                        this.this$0.getTargetInfo().postValue((Object)it);
                    }
                }
                {
                    this.this$0 = $outer;
                    this.$service = $captured_local_variable$1;
                    this.$joinUid = $captured_local_variable$2;
                }
            });
        }
    }

    @KvoMethodAnnotation(name="relation", sourceClass=RelationInfo.class, thread=1)
    public final void onRelationChanged(@NotNull KvoEventIntent event) {
        Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
        MLog.debug((Object)"FTLinkMic.Linker", (String)("onRelationChanged " + (Relation)event.newValue()), (Object[])new Object[0]);
        KvoSource kvoSource = event.source();
        Intrinsics.checkExpressionValueIsNotNull((Object)kvoSource, (String)"event.source<RelationInfo>()");
        RelationInfo relation = (RelationInfo)kvoSource;
        this.isFollowed().setValue((Object)relation.isFollow());
    }

    @Override
    public void onLinkClose() {
        MLog.info((Object)"FTLinkMic.Linker", (String)"onLinkClose", (Object[])new Object[0]);
        this.mBinder.clearAllKvoConnections();
        this.isLinkUIClosed().setValue((Object)true);
    }

    @Override
    public void onAvatarClick() {
        UserInfoKS userInfoKS = (UserInfoKS)this.getTargetInfo().getValue();
        if (userInfoKS == null || AccountUtil.getUid() != userInfoKS.uid) {
            UserInfoKS userInfoKS2 = (UserInfoKS)this.getTargetInfo().getValue();
            ((LinkMicMvpContext)this.getMvpContext()).getParam().getBehavior().showProfileCard(CommonExtensionsKt.orZero((Long)(userInfoKS2 != null ? Long.valueOf(userInfoKS2.uid) : null)));
        }
    }

    @Override
    public long getCurrentJoinUid() {
        LinkMicStatus linkMicStatus2 = (LinkMicStatus)((LinkMicMvpContext)this.getMvpContext()).getLinkMicModel().getLinkMicStatusData().getValue();
        if (linkMicStatus2 != null) {
            LinkMicStatus linkMicStatus3 = linkMicStatus2;
            boolean bl = false;
            boolean bl2 = false;
            LinkMicStatus it = linkMicStatus3;
            boolean bl3 = false;
            if (it.getStatus() == JoinMicStatus.JOIN_MIC_GOING.getValue()) {
                Long l = it.getJoinUid();
                return l != null ? l : 0L;
            }
        }
        return 0L;
    }

    @Override
    public boolean isLinkMicInitiator(long anchorUid, long joinUid) {
        return anchorUid == AccountUtil.getUid() || joinUid == AccountUtil.getUid();
    }

    @Override
    public void changeLinkModeUI(boolean isDelay, int mode) {
        if (!isDelay) {
            Long joinUid;
            LinkMicStatus linkMicStatus2 = (LinkMicStatus)((LinkMicMvpContext)this.getMvpContext()).getLinkMicModel().getLinkMicStatusData().getValue();
            Long l = joinUid = linkMicStatus2 != null ? linkMicStatus2.getJoinUid() : null;
            if (joinUid == null || joinUid < 0L) {
                return;
            }
            this.handleLinkModeChange(mode, joinUid);
        } else {
            if (this.mDelayRunnable != null) {
                YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mDelayRunnable);
            }
            this.mDelayRunnable = new Runnable(this){
                final /* synthetic */ LinkerViewModel this$0;

                public final void run() {
                    LinkMicStatus linkMicStatus2 = (LinkMicStatus)((LinkMicMvpContext)this.this$0.getMvpContext()).getLinkMicModel().getLinkMicStatusData().getValue();
                    if (linkMicStatus2 != null) {
                        long joinUid;
                        LinkMicStatus linkMicStatus3 = linkMicStatus2;
                        boolean bl = false;
                        boolean bl2 = false;
                        LinkMicStatus it = linkMicStatus3;
                        boolean bl3 = false;
                        Long l = it.getJoinUid();
                        long l2 = joinUid = l != null ? l : 0L;
                        if (joinUid > 0L && it.getStatus() == JoinMicStatus.JOIN_MIC_GOING.getValue()) {
                            this.this$0.handleLinkModeChange(it.getJoinMicType(), joinUid);
                        }
                    }
                    LinkerViewModel.access$setMDelayRunnable$p(this.this$0, null);
                }
                {
                    this.this$0 = linkerViewModel;
                }
            };
            int delay = SettingFlags.getIntValue((String)"key_linkmic_delaytimer", (int)0);
            MLog.info((Object)"FTLinkMic.Linker", (String)("changeLinkModeUI delay: " + delay), (Object[])new Object[0]);
            YYTaskExecutor.postToMainThread((Runnable)this.mDelayRunnable, (long)delay);
        }
    }

    @Override
    public void handleLinkModeChange(int linkMicType, long joinUid) {
        int n = linkMicType;
        if (n == JoinMicType.JAT_VIDEO.getValue()) {
            this.onLinkModeChange(true, joinUid);
        } else if (n == JoinMicType.JAT_RADIO.getValue()) {
            this.onLinkModeChange(false, joinUid);
        } else {
            MLog.error((Object)"FTLinkMic.Linker", (String)"error status\uff0cui do nothing", (Object[])new Object[0]);
        }
    }

    @Override
    public void removeLastViews() {
        this.isLinkUIClosed().setValue((Object)true);
    }

    @Override
    public void showOptionsMenu(boolean isVideo, @NotNull YYPlaceHolderView holder) {
        Intrinsics.checkParameterIsNotNull((Object)holder, (String)"holder");
        ((LinkMicOptionsViewModel)this.getViewModel(LinkMicOptionsViewModel.class)).showOption(isVideo, holder);
    }

    @Override
    public void follow(long uid) {
        IService iService = ServiceManagerProxy.getService(IRelationService.class);
        boolean bl = false;
        boolean bl2 = false;
        IRelationService $this$with = (IRelationService)iService;
        boolean bl3 = false;
        RelationInfo relation = $this$with.getRelationLocal(uid);
        $this$with.requestFollow(relation, EPath.PATH_VIDEO.getValue());
    }

    @Override
    public void unFollow(long uid) {
        IService iService = ServiceManagerProxy.getService(IRelationService.class);
        boolean bl = false;
        boolean bl2 = false;
        IRelationService $this$with = (IRelationService)iService;
        boolean bl3 = false;
        RelationInfo relation = $this$with.getRelationLocal(uid);
        $this$with.requestCancelFollow(relation);
    }

    public static final /* synthetic */ Runnable access$getMDelayRunnable$p(LinkerViewModel $this) {
        return $this.mDelayRunnable;
    }

    public static final /* synthetic */ void access$setMDelayRunnable$p(LinkerViewModel $this, Runnable runnable) {
        $this.mDelayRunnable = runnable;
    }
}

