/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.linkmic.business.invitepanel;

import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.Observer;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.kvo.UserInfoKS;
import com.yy.base.logger.MLog;
import com.yy.hiyo.linkmic.LinkMicMvpContext;
import com.yy.hiyo.linkmic.business.invitepanel.ILinkMicPresenter;
import com.yy.hiyo.linkmic.business.invitepanel.LinkMicInviteTab;
import com.yy.hiyo.linkmic.business.invitepanel.LinkMicTabHelper;
import com.yy.hiyo.linkmic.data.entity.JoinMicOperation;
import com.yy.hiyo.linkmic.data.entity.LinkMicStatus;
import com.yy.hiyo.linkmic.data.entity.LinkMicUser;
import com.yy.hiyo.linkmic.data.entity.OnlineOperation;
import com.yy.hiyo.linkmic.data.entity.UserListPage;
import com.yy.hiyo.linkmic.data.model.LinkMicModel;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ihago.channel.srv.mgr.JoinMicStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u000f\u0018\u0000 12\u00020\u0001:\u00011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u001b\u001a\u00020\u000bH\u0002J\u0018\u0010\u001c\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010\u001f\u001a\u00020\u000bH\u0002J \u0010 \u001a\u00020\u00162\u000e\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00132\u0006\u0010\"\u001a\u00020#H\u0002J\u0006\u0010$\u001a\u00020\u0016J\u0016\u0010%\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010&\u001a\u00020\u0016J\u001c\u0010'\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013J\u0016\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020#2\u0006\u0010\u001b\u001a\u00020\u000bJ\u0006\u0010*\u001a\u00020\u0018J&\u0010+\u001a\u00020\u00182\u0006\u0010,\u001a\u00020\u001e2\u0006\u0010\u001b\u001a\u00020\u000b2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\u000e\u0010-\u001a\u00020\u00182\u0006\u0010\u0015\u001a\u00020\u0016J \u0010.\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020#2\u0006\u0010/\u001a\u00020\u0016H\u0002J\u0010\u00100\u001a\u00020\u00182\u0006\u0010\u001b\u001a\u00020\u000bH\u0002R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/yy/hiyo/linkmic/business/invitepanel/LinkMicInviteDataManager;", "", "context", "Lcom/yy/hiyo/linkmic/LinkMicMvpContext;", "linkMicTabHelper", "Lcom/yy/hiyo/linkmic/business/invitepanel/LinkMicTabHelper;", "linkMicPanelPresenter", "Lcom/yy/hiyo/linkmic/business/invitepanel/ILinkMicPresenter;", "(Lcom/yy/hiyo/linkmic/LinkMicMvpContext;Lcom/yy/hiyo/linkmic/business/invitepanel/LinkMicTabHelper;Lcom/yy/hiyo/linkmic/business/invitepanel/ILinkMicPresenter;)V", "callback", "cid", "", "linkMicModel", "Lcom/yy/hiyo/linkmic/data/model/LinkMicModel;", "linkMicMvpContext", "linkMicStatus", "Lcom/yy/hiyo/linkmic/data/entity/LinkMicStatus;", "listCache", "", "", "Lcom/yy/hiyo/linkmic/data/entity/LinkMicUser;", "meShowing", "", "addToList", "", "list", "refreshList", "tabType", "getConfig", "Landroidx/lifecycle/LiveData;", "Lcom/yy/hiyo/linkmic/data/entity/UserListPage;", "type", "isContainUid", "currentItems", "uid", "", "joiningMic", "loadMore", "refresh", "observeData", "removeFromList", "joinUid", "resetData", "setData", "config", "setIsAnchor", "updateOnlineList", "visible", "updateStatus", "Companion", "linkmic_debug"})
public final class LinkMicInviteDataManager {
    private final LinkMicModel linkMicModel;
    private final String cid;
    private final ILinkMicPresenter callback;
    private final LinkMicMvpContext linkMicMvpContext;
    private final Map<String, List<LinkMicUser>> listCache;
    private final LinkMicTabHelper linkMicTabHelper;
    private LinkMicStatus linkMicStatus;
    private boolean meShowing;
    @NotNull
    public static final String TAG = "FTLinkMic.LinkMicInviteDataManager";
    @NotNull
    public static final String ANCHOR_WAITING = "1";
    @NotNull
    public static final String ANCHOR_ONLINE = "2";
    @NotNull
    public static final String GUEST = "3";
    public static final Companion Companion = new Companion(null);

    private final LiveData<UserListPage> getConfig(String type) {
        if (Intrinsics.areEqual((Object)type, (Object)ANCHOR_WAITING) || Intrinsics.areEqual((Object)type, (Object)GUEST)) {
            return this.linkMicModel.getWaitingUserData();
        }
        if (Intrinsics.areEqual((Object)type, (Object)ANCHOR_ONLINE)) {
            return this.linkMicModel.getOnlineUserData();
        }
        return null;
    }

    public final void loadMore(@NotNull String type, boolean refresh) {
        Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
        if (Intrinsics.areEqual((Object)type, (Object)ANCHOR_WAITING) || Intrinsics.areEqual((Object)type, (Object)GUEST)) {
            int n;
            if (refresh) {
                n = 0;
            } else {
                List<LinkMicUser> list = this.listCache.get(type);
                n = list != null ? list.size() : 0;
            }
            this.linkMicModel.getJoinMicQueueRequest(this.cid, n);
        } else if (Intrinsics.areEqual((Object)type, (Object)ANCHOR_ONLINE)) {
            this.linkMicModel.getCurrentOnLineUsers(this.cid, refresh);
        }
    }

    public final void observeData(@NotNull String tabType, @NotNull List<LinkMicUser> list) {
        block0: {
            Intrinsics.checkParameterIsNotNull((Object)tabType, (String)"tabType");
            Intrinsics.checkParameterIsNotNull(list, (String)"list");
            this.listCache.put(tabType, list);
            LiveData<UserListPage> liveData = this.getConfig(tabType);
            if (liveData == null) break block0;
            liveData.observe((LifecycleOwner)this.linkMicMvpContext, (Observer)new Observer<UserListPage>(this, tabType, list){
                final /* synthetic */ LinkMicInviteDataManager this$0;
                final /* synthetic */ String $tabType;
                final /* synthetic */ List $list;

                public final void onChanged(UserListPage it) {
                    UserListPage userListPage = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)userListPage, (String)"it");
                    LinkMicInviteDataManager.access$setData(this.this$0, userListPage, this.$tabType, this.$list);
                }
                {
                    this.this$0 = linkMicInviteDataManager;
                    this.$tabType = string2;
                    this.$list = list;
                }
            });
        }
    }

    public final boolean joiningMic() {
        LinkMicStatus linkMicStatus2 = this.linkMicStatus;
        return linkMicStatus2 != null && linkMicStatus2.getStatus() == JoinMicStatus.JOIN_MIC_GOING.getValue();
    }

    private final void setData(UserListPage config, String tabType, List<LinkMicUser> list) {
        block7: {
            LinkMicInviteTab linkMicInviteTab = this.linkMicTabHelper.getPreViewlList().get(tabType);
            if (linkMicInviteTab != null) {
                linkMicInviteTab.hideAllStatus();
            }
            if (config.isRefresh()) {
                list.clear();
                Iterable $this$forEach$iv = config.getList();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    LinkMicUser it = (LinkMicUser)element$iv;
                    boolean bl = false;
                    it.setVisible(Intrinsics.areEqual((Object)tabType, (Object)ANCHOR_ONLINE) ^ true || Intrinsics.areEqual((Object)tabType, (Object)ANCHOR_ONLINE) && !this.isContainUid(this.listCache.get(ANCHOR_WAITING), it.getUserInfoKS().uid));
                    it.setLinkMicStatus(this.linkMicStatus);
                    this.updateOnlineList(tabType, it.getUserInfoKS().uid, false);
                }
                List<LinkMicUser> list2 = config.getList();
                boolean bl = false;
                boolean bl2 = false;
                List<LinkMicUser> it = list2;
                boolean bl3 = false;
                list.addAll((Collection<LinkMicUser>)it);
                LinkMicInviteTab linkMicInviteTab2 = this.linkMicTabHelper.getPreViewlList().get(tabType);
                if (linkMicInviteTab2 != null && (linkMicInviteTab2 = linkMicInviteTab2.getMyAdapter()) != null) {
                    linkMicInviteTab2.notifyDataSetChanged();
                }
            } else {
                this.addToList(list, config.getList(), tabType);
            }
            LinkMicInviteTab linkMicInviteTab3 = this.linkMicTabHelper.getPreViewlList().get(tabType);
            if (linkMicInviteTab3 != null) {
                linkMicInviteTab3.setHasMore(config.getHasLoadMore());
            }
            this.updateStatus(tabType);
            if (!Intrinsics.areEqual((Object)tabType, (Object)GUEST)) break block7;
            LinkMicInviteTab linkMicInviteTab4 = this.linkMicTabHelper.getPreViewlList().get(tabType);
            if (linkMicInviteTab4 != null) {
                linkMicInviteTab4.scrollToCurrentUser();
            }
        }
    }

    private final void addToList(List<LinkMicUser> list, List<LinkMicUser> refreshList, String tabType) {
        block1: {
            int lastPos = list.size();
            Iterable $this$forEach$iv = refreshList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinkMicUser item = (LinkMicUser)element$iv;
                boolean bl = false;
                if (this.isContainUid(list, item.getUserInfoKS().uid)) continue;
                item.setVisible(Intrinsics.areEqual((Object)tabType, (Object)ANCHOR_ONLINE) ^ true || Intrinsics.areEqual((Object)tabType, (Object)ANCHOR_ONLINE) && !this.isContainUid(this.listCache.get(ANCHOR_WAITING), item.getUserInfoKS().uid));
                item.setLinkMicStatus(this.linkMicStatus);
                list.add(item);
                int n = lastPos;
                lastPos = n + 1;
                this.updateOnlineList(tabType, item.getUserInfoKS().uid, false);
            }
            LinkMicInviteTab linkMicInviteTab = this.linkMicTabHelper.getPreViewlList().get(tabType);
            if (linkMicInviteTab == null || (linkMicInviteTab = linkMicInviteTab.getMyAdapter()) == null) break block1;
            linkMicInviteTab.notifyDataSetChanged();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void removeFromList(long joinUid, @NotNull String tabType) {
        Intrinsics.checkParameterIsNotNull((Object)tabType, (String)"tabType");
        int uidIndex = -1;
        List<LinkMicUser> list = this.listCache.get(tabType);
        if (list != null) {
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void it;
                int n = index$iv++;
                boolean bl = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = n;
                LinkMicUser linkMicUser = (LinkMicUser)item$iv;
                int index = n2;
                boolean bl2 = false;
                if (it.getUserInfoKS().uid != joinUid) continue;
                uidIndex = index;
            }
        }
        if (uidIndex != -1) {
            LinkMicInviteTab linkMicInviteTab;
            List<LinkMicUser> list2 = this.listCache.get(tabType);
            if (list2 != null) {
                list2.remove(uidIndex);
            }
            if ((linkMicInviteTab = this.linkMicTabHelper.getPreViewlList().get(tabType)) != null && (linkMicInviteTab = linkMicInviteTab.getMyAdapter()) != null) {
                linkMicInviteTab.notifyItemRemoved(uidIndex);
            }
            this.updateOnlineList(tabType, joinUid, true);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void updateOnlineList(String tabType, long joinUid, boolean visible) {
        if (Intrinsics.areEqual((Object)tabType, (Object)ANCHOR_WAITING)) {
            List<LinkMicUser> list = this.listCache.get(ANCHOR_ONLINE);
            if (list != null) {
                Iterable $this$forEachIndexed$iv = list;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void linkMicUser;
                    int n = index$iv++;
                    boolean bl = false;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    int n2 = n;
                    LinkMicUser linkMicUser2 = (LinkMicUser)item$iv;
                    int index = n2;
                    boolean bl2 = false;
                    if (linkMicUser.getUserInfoKS().uid != joinUid) continue;
                    linkMicUser.setVisible(visible);
                    LinkMicInviteTab linkMicInviteTab = this.linkMicTabHelper.getPreViewlList().get(ANCHOR_ONLINE);
                    if (linkMicInviteTab != null && (linkMicInviteTab = linkMicInviteTab.getMyAdapter()) != null) {
                        linkMicInviteTab.notifyItemRangeChanged(index, 1);
                    }
                }
            }
        }
    }

    private final void updateStatus(String tabType) {
        block3: {
            if (Intrinsics.areEqual((Object)tabType, (Object)GUEST)) {
                LinkMicInviteTab linkMicInviteTab = this.linkMicTabHelper.getPreViewlList().get(tabType);
                if (linkMicInviteTab != null) {
                    linkMicInviteTab.alReadyJoin(this.isContainUid(this.listCache.get(tabType), AccountUtil.getUid()));
                }
            }
            if (Intrinsics.areEqual((Object)tabType, (Object)ANCHOR_WAITING)) {
                List<LinkMicUser> list = this.listCache.get(tabType);
                this.callback.waitingListNotify((list != null ? list.size() : 0) <= 0);
            }
            LinkMicInviteTab linkMicInviteTab = this.linkMicTabHelper.getPreViewlList().get(tabType);
            if (linkMicInviteTab == null) break block3;
            List<LinkMicUser> list = this.listCache.get(tabType);
            linkMicInviteTab.showNoData((list != null ? list.size() : 0) <= 0);
        }
    }

    private final boolean isContainUid(List<LinkMicUser> currentItems, long uid) {
        List<LinkMicUser> list = currentItems;
        if (list != null) {
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                LinkMicUser it = (LinkMicUser)element$iv;
                boolean bl = false;
                if (it.getUserInfoKS().uid != uid) continue;
                return true;
            }
        }
        return false;
    }

    public final void setIsAnchor(boolean meShowing) {
        this.meShowing = meShowing;
    }

    public final void resetData() {
        this.meShowing = false;
        this.listCache.clear();
    }

    public LinkMicInviteDataManager(@NotNull LinkMicMvpContext context, final @NotNull LinkMicTabHelper linkMicTabHelper2, @NotNull ILinkMicPresenter linkMicPanelPresenter) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)((Object)context), (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)linkMicTabHelper2, (String)"linkMicTabHelper");
        Intrinsics.checkParameterIsNotNull((Object)linkMicPanelPresenter, (String)"linkMicPanelPresenter");
        this.linkMicModel = context.getLinkMicModel();
        this.cid = context.getCid();
        this.callback = linkMicPanelPresenter;
        this.linkMicMvpContext = context;
        LinkMicInviteDataManager linkMicInviteDataManager = this;
        boolean bl = false;
        linkMicInviteDataManager.listCache = map = (Map)new LinkedHashMap();
        this.linkMicTabHelper = linkMicTabHelper2;
        this.linkMicModel.getJoinMicOperationData().observe((LifecycleOwner)context, (Observer)new Observer<JoinMicOperation>(){

            public final void onChanged(JoinMicOperation it) {
                String tabType;
                MLog.info((Object)LinkMicInviteDataManager.TAG, (String)("getJoinMicOperationData " + it), (Object[])new Object[0]);
                String string2 = tabType = meShowing ? LinkMicInviteDataManager.ANCHOR_WAITING : LinkMicInviteDataManager.GUEST;
                if (it.getDelete()) {
                    this.removeFromList(it.getJoinUid(), tabType);
                } else {
                    UserInfoKS userInfoKS = it.getUserInfoKS();
                    if (userInfoKS != null) {
                        UserInfoKS userInfoKS2 = userInfoKS;
                        boolean bl = false;
                        boolean bl2 = false;
                        UserInfoKS it1 = userInfoKS2;
                        boolean bl3 = false;
                        List list = (List)listCache.get(tabType);
                        if (list != null) {
                            List list2 = list;
                            boolean bl4 = false;
                            boolean bl5 = false;
                            List list3 = list2;
                            boolean bl6 = false;
                            this.addToList(list3, CollectionsKt.mutableListOf((Object[])new LinkMicUser[]{new LinkMicUser(it1, true, it.getMedalIds(), null, 8, null)}), tabType);
                        }
                    }
                }
                this.updateStatus(tabType);
            }
        });
        this.linkMicModel.getOnlineOperationData().observe((LifecycleOwner)context, (Observer)new Observer<OnlineOperation>(){

            public final void onChanged(OnlineOperation it) {
                MLog.info((Object)LinkMicInviteDataManager.TAG, (String)("getOnlineOperationData " + it), (Object[])new Object[0]);
                if (it.isDelete()) {
                    this.removeFromList(it.getUser().uid, LinkMicInviteDataManager.ANCHOR_ONLINE);
                } else {
                    UserInfoKS userInfoKS = it.getUser();
                    boolean bl = false;
                    boolean bl2 = false;
                    UserInfoKS it1 = userInfoKS;
                    boolean bl3 = false;
                    List list = (List)listCache.get(LinkMicInviteDataManager.ANCHOR_ONLINE);
                    if (list != null) {
                        List list2 = list;
                        boolean bl4 = false;
                        boolean bl5 = false;
                        List list3 = list2;
                        boolean bl6 = false;
                        this.addToList(list3, CollectionsKt.mutableListOf((Object[])new LinkMicUser[]{new LinkMicUser(it1, true, it.getMedalIds(), null, 8, null)}), LinkMicInviteDataManager.ANCHOR_ONLINE);
                    }
                }
                this.updateStatus(LinkMicInviteDataManager.ANCHOR_ONLINE);
            }
        });
        this.linkMicModel.getLinkMicStatusData().observe((LifecycleOwner)context, (Observer)new Observer<LinkMicStatus>(){

            public final void onChanged(LinkMicStatus linkMicStatus2) {
                block9: {
                    block8: {
                        LinkMicInviteTab linkMicInviteTab;
                        if (linkMicStatus2 == null) {
                            MLog.info((Object)LinkMicInviteDataManager.TAG, (String)("observe LinkMicStatusData:" + linkMicStatus2 + " return"), (Object[])new Object[0]);
                            return;
                        }
                        linkMicStatus = linkMicStatus2;
                        List list = (List)listCache.get(LinkMicInviteDataManager.ANCHOR_ONLINE);
                        if (list != null) {
                            Iterable $this$forEach$iv = list;
                            boolean $i$f$forEach = false;
                            for (Object element$iv : $this$forEach$iv) {
                                LinkMicUser it = (LinkMicUser)element$iv;
                                boolean bl = false;
                                it.setLinkMicStatus(linkMicStatus2);
                            }
                        }
                        if ((linkMicInviteTab = linkMicTabHelper2.getPreViewlList().get(LinkMicInviteDataManager.ANCHOR_ONLINE)) != null && (linkMicInviteTab = linkMicInviteTab.getMyAdapter()) != null) {
                            linkMicInviteTab.notifyDataSetChanged();
                        }
                        Long l = linkMicStatus2.getAnchorUid();
                        long l2 = AccountUtil.getUid();
                        if (l != null && l == l2) break block8;
                        Long l3 = linkMicStatus2.getJoinUid();
                        l2 = AccountUtil.getUid();
                        if (l3 == null || l3 != l2) break block9;
                    }
                    if (this.joiningMic()) {
                        callback.hidePanel(false);
                    }
                }
            }
        });
    }

    public static final /* synthetic */ void access$setData(LinkMicInviteDataManager $this, UserListPage config, String tabType, List list) {
        $this.setData(config, tabType, list);
    }

    public static final /* synthetic */ void access$setMeShowing$p(LinkMicInviteDataManager $this, boolean bl) {
        $this.meShowing = bl;
    }

    public static final /* synthetic */ LinkMicStatus access$getLinkMicStatus$p(LinkMicInviteDataManager $this) {
        return $this.linkMicStatus;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/yy/hiyo/linkmic/business/invitepanel/LinkMicInviteDataManager$Companion;", "", "()V", "ANCHOR_ONLINE", "", "ANCHOR_WAITING", "GUEST", "TAG", "linkmic_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

