/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.panel.view;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.ViewFlipper;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.yy.appbase.AppbaseMsgDef;
import com.yy.appbase.common.BiCallback;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.KtvWorksEntranceConfig;
import com.yy.base.env.RuntimeContext;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.MsgDispatcher;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.model.record.KTVWorksUtils;
import com.yy.hiyo.channel.plugins.ktv.panel.view.IPanelViewState;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import com.yy.hiyo.channel.plugins.ktv.widget.KTVPanelButton;
import com.yy.yylite.commonbase.hiido.HiidoEvent;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.util.ArrayList;

public class KTVGetReadyPanelView
extends YYConstraintLayout
implements View.OnClickListener,
IPanelViewState {
    private static final String TAG = "KTVGetReadyPanelView";
    private ImageView mIvClosePanel;
    private FrameLayout mLayoutAvatar;
    private TextView mTvNextTip;
    private CircleImageView mIvAvatar;
    private TextView mTvNick;
    private LinearLayout mLayoutNoSong;
    private KTVPanelButton mPanelBtn;
    private View mAudienceTip;
    private LinearLayout mLlLoading;
    private ProgressBar mPbLoading;
    private TextView mTvLoading;
    private ViewFlipper mViewFlipper;
    private View mSingerInfoView;
    private View mSongInfoView;
    private TextView mTvSongName;
    private View mKtvRecord;
    private CheckBox mAggreRecord;
    private ImageView mKtvWorksBtn;
    private boolean mIsShowing;
    private boolean mIsReadyState;
    private boolean mIsSinger;
    private boolean mHaveMic;
    private boolean mIsDownloading;
    private Context mContext;
    private OnGetReadyPanelListener mGetReadyPanelListener;
    private Runnable mFlipIntervalRunnable = new Runnable(){

        @Override
        public void run() {
            if (KTVGetReadyPanelView.this.mViewFlipper != null) {
                KTVGetReadyPanelView.this.mViewFlipper.setFlipInterval(1000);
            }
        }
    };
    private Runnable mStopFlipperRunnable = new Runnable(){

        @Override
        public void run() {
            if (KTVGetReadyPanelView.this.mViewFlipper != null) {
                KTVGetReadyPanelView.this.mViewFlipper.stopFlipping();
            }
        }
    };

    public KTVGetReadyPanelView(Context context) {
        this(context, null);
        this.mContext = context;
    }

    public KTVGetReadyPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_ktv_get_ready_panel_channel, (ViewGroup)this, true);
        this.setUpParams();
        this.mIvClosePanel = (ImageView)this.findViewById(R.id.iv_close_panel);
        this.mIvAvatar = (CircleImageView)this.findViewById(R.id.civ_avatar);
        this.mTvNick = (TextView)this.findViewById(R.id.tv_nick);
        this.mLayoutNoSong = (LinearLayout)this.findViewById(R.id.llyt_no_song);
        this.mPanelBtn = (KTVPanelButton)this.findViewById(R.id.btn_panel);
        this.mAudienceTip = this.findViewById(R.id.audience_tip_layout);
        this.mLayoutAvatar = (FrameLayout)this.findViewById(R.id.layout_get_ready_avatar);
        this.mTvNextTip = (TextView)this.findViewById(R.id.tv_next_tip);
        this.mLlLoading = (LinearLayout)this.findViewById(R.id.ll_ktv_progress);
        this.mPbLoading = (ProgressBar)this.findViewById(R.id.ktv_progress_bar);
        this.mTvLoading = (TextView)this.findViewById(R.id.tv_ktv_progress);
        this.mViewFlipper = (ViewFlipper)this.findViewById(R.id.view_flipper);
        this.mSingerInfoView = this.findViewById(R.id.mIconInfoSinger);
        this.mSongInfoView = this.findViewById(R.id.mIconInfoMusic);
        this.mTvSongName = (TextView)this.findViewById(R.id.tv_song_name);
        this.mKtvRecord = this.findViewById(R.id.ll_record);
        this.mAggreRecord = (CheckBox)this.findViewById(R.id.cb_record);
        this.mKtvWorksBtn = (ImageView)this.findViewById(R.id.iv_ktv_works);
        this.mKtvWorksBtn.setOnClickListener((View.OnClickListener)this);
        this.mIvClosePanel.setOnClickListener((View.OnClickListener)this);
        this.mPanelBtn.setOnClickListener(this);
        this.mAggreRecord.setOnCheckedChangeListener((buttonView, isChecked) -> {
            MLog.info((Object)"check box", (String)"ischeck : %s", (Object[])new Object[]{isChecked});
            if (this.mGetReadyPanelListener != null) {
                this.mGetReadyPanelListener.clickRecordKtv(isChecked);
            }
            if (isChecked) {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20033151").put("function_id", "record_guide_select_click"));
            } else {
                HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20033151").put("function_id", "record_guide_no_select_click"));
            }
        });
    }

    private void setUpParams() {
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(ResourceUtils.getDrawable((int)R.drawable.shape_ktv_panel_bg));
        } else {
            this.setBackgroundDrawable(ResourceUtils.getDrawable((int)R.drawable.shape_ktv_panel_bg));
        }
    }

    public View getGetReadyPanelAvatarLayout() {
        return this.mLayoutAvatar;
    }

    public void showReadyLayout(boolean isSinger, boolean isDownloading) {
        this.mIsReadyState = true;
        this.mIsSinger = isSinger;
        this.mHaveMic = false;
        this.mIsDownloading = isDownloading;
        if (isSinger) {
            this.showSingerReadyLayout(isDownloading);
        } else {
            this.showAudienceReadyLayout(isDownloading);
        }
        this.loadKtvWorksBtnState();
    }

    public void showNoSongLayout(boolean haveMic, boolean showClose) {
        this.mIsReadyState = false;
        this.mIsSinger = false;
        this.mIsDownloading = false;
        this.mHaveMic = haveMic;
        this.showHaveMicNoSongLayout(showClose);
        this.mKtvRecord.setVisibility(8);
        this.loadKtvWorksBtnState();
    }

    public void loadSongInfo(String songName, String singerName, String avatarUrl, String composer, String songWriter, boolean isScrollSongInfo) {
        ArrayList<String> flipperInfos = new ArrayList<String>();
        this.mTvSongName.setText((CharSequence)songName);
        flipperInfos.add(songName);
        if (isScrollSongInfo) {
            if (!TextUtils.isEmpty((CharSequence)composer)) {
                flipperInfos.add(ResourceUtils.getString((int)R.string.title_ktv_composer) + ": " + composer);
            }
            if (!TextUtils.isEmpty((CharSequence)songWriter)) {
                flipperInfos.add(ResourceUtils.getString((int)R.string.title_ktv_song_writer) + ": " + songWriter);
            }
        }
        this.loadSongInfoFlipper(flipperInfos);
        this.mTvNick.setText((CharSequence)singerName);
        ImageLoader.loadImage((RecycleImageView)this.mIvAvatar, (String)(avatarUrl + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.icon_default_photo);
    }

    private void loadSongInfoFlipper(ArrayList<String> flipperInfos) {
        this.resetViewFlipper();
        for (String content : flipperInfos) {
            this.mViewFlipper.addView((View)this.getFlipperTextView(content));
        }
        if (flipperInfos.size() == 3) {
            this.mViewFlipper.startFlipping();
            this.mViewFlipper.postDelayed(this.mFlipIntervalRunnable, 1000L);
            this.mViewFlipper.postDelayed(this.mStopFlipperRunnable, 4500L);
        } else if (flipperInfos.size() == 2) {
            this.mViewFlipper.startFlipping();
            this.mViewFlipper.postDelayed(this.mFlipIntervalRunnable, 1000L);
            this.mViewFlipper.postDelayed(this.mStopFlipperRunnable, 3500L);
        }
    }

    public void resetViewFlipper() {
        if (this.mViewFlipper != null) {
            this.mViewFlipper.removeAllViews();
            this.mViewFlipper.removeCallbacks(this.mFlipIntervalRunnable);
            this.mViewFlipper.removeCallbacks(this.mStopFlipperRunnable);
            this.mViewFlipper.stopFlipping();
            this.mViewFlipper.setAnimateFirstView(false);
            this.mViewFlipper.setFlipInterval(2000);
        }
    }

    private YYTextView getFlipperTextView(String text) {
        YYTextView textView = new YYTextView(this.mContext);
        textView.setGravity(16);
        textView.setTextSize(12.0f);
        textView.setIncludeFontPadding(false);
        textView.setSingleLine(true);
        textView.setTextColor(-1);
        textView.setTypeface(Typeface.DEFAULT_BOLD);
        textView.setText((CharSequence)text);
        ConstraintLayout.LayoutParams params = new ConstraintLayout.LayoutParams(-2, -2);
        textView.setLayoutParams((ViewGroup.LayoutParams)params);
        return textView;
    }

    public void setOnGetReadyPanelListener(OnGetReadyPanelListener listener) {
        this.mGetReadyPanelListener = listener;
    }

    public void setSelectSongPolicy(boolean enable) {
        if (enable) {
            if (this.mPanelBtn != null) {
                this.mPanelBtn.setChooseSongEnable();
            }
        } else if (this.mPanelBtn != null) {
            this.mPanelBtn.setChooseSongUnable();
        }
    }

    public void onClick(View v) {
        int vId = v.getId();
        if (vId == R.id.iv_close_panel) {
            this.confirmClose(v);
        } else if (vId == R.id.btn_panel) {
            if (this.mIsReadyState) {
                if (this.mIsDownloading) {
                    return;
                }
                if (this.mIsSinger && this.mGetReadyPanelListener != null) {
                    this.mGetReadyPanelListener.clickSingSongBtn(v);
                }
            } else if (this.mGetReadyPanelListener != null) {
                this.mGetReadyPanelListener.clickChooseASongBtn(v, this.mHaveMic);
            }
        } else if (vId == R.id.iv_ktv_works) {
            MsgDispatcher.getInstance().sendMessage(AppbaseMsgDef.ChannelMsgDef.OPEN_KTV_WORKS_WINDOW);
            KTVEventReportUtil.reportAudioKtvWorksClick("1");
        }
    }

    private void showAudienceReadyLayout(boolean isDownloading) {
        this.mLayoutNoSong.setVisibility(8);
        this.mIvClosePanel.setVisibility(8);
        this.mPanelBtn.setVisibility(8);
        this.mLlLoading.setVisibility(8);
        this.setUpSongInfoVisible(true);
        this.mAudienceTip.setVisibility(0);
        if (isDownloading) {
            if (this.mLlLoading != null) {
                this.mLlLoading.setVisibility(0);
            }
            if (this.mPbLoading != null) {
                this.mPbLoading.setProgress(0);
            }
            if (this.mTvLoading != null) {
                this.mTvLoading.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_ktv_download_hint));
            }
        } else {
            this.mPanelBtn.setSingState();
        }
        this.mKtvRecord.setVisibility(8);
    }

    private void showSingerReadyLayout(boolean isDownloading) {
        this.mLayoutNoSong.setVisibility(8);
        this.mIvClosePanel.setVisibility(8);
        this.mAudienceTip.setVisibility(8);
        this.mLlLoading.setVisibility(8);
        this.mTvNextTip.setVisibility(0);
        this.setUpSongInfoVisible(true);
        this.mPanelBtn.setVisibility(0);
        if (isDownloading) {
            this.mPanelBtn.setVisibility(8);
            if (this.mLlLoading != null) {
                this.mLlLoading.setVisibility(0);
            }
            if (this.mPbLoading != null) {
                this.mPbLoading.setProgress(0);
            }
            if (this.mTvLoading != null) {
                this.mTvLoading.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_ktv_download_hint));
            }
        } else {
            this.mPanelBtn.setVisibility(0);
            this.mPanelBtn.setSingState();
        }
        if (this.mGetReadyPanelListener != null && this.mGetReadyPanelListener.hasShowKtvRecordPermission()) {
            if (RuntimeContext.isHagoPartySdk()) {
                this.mKtvRecord.setVisibility(8);
            } else {
                this.mKtvRecord.setVisibility(0);
            }
            if (this.mGetReadyPanelListener != null) {
                this.mGetReadyPanelListener.clickRecordKtv(this.mGetReadyPanelListener.hasSeletedRecord());
            }
            HiidoStatis.reportEvent((HiidoEvent)HiidoEvent.obtain().eventId("20033151").put("function_id", "record_guide_show"));
        } else {
            this.mKtvRecord.setVisibility(8);
        }
    }

    private void showHaveMicNoSongLayout(boolean showClose) {
        this.mIvClosePanel.setVisibility(8);
        this.setUpSongInfoVisible(false);
        this.mAudienceTip.setVisibility(8);
        this.mTvNextTip.setVisibility(8);
        this.mLlLoading.setVisibility(8);
        this.mLayoutNoSong.setVisibility(0);
        this.mPanelBtn.setVisibility(0);
        this.mPanelBtn.setChooseSongEnable();
        if (showClose) {
            this.mIvClosePanel.setVisibility(0);
        }
    }

    @Override
    public void onPanelViewShow(boolean isSinger, boolean isPause) {
        this.mIsShowing = true;
        this.setAlpha(1.0f);
        this.mLayoutAvatar.setScaleX(1.0f);
        this.mLayoutAvatar.setScaleY(1.0f);
    }

    private void setUpSongInfoVisible(boolean isVisible) {
        int visibility = 0;
        if (!isVisible) {
            visibility = 8;
        }
        this.mLayoutAvatar.setVisibility(visibility);
        this.mSongInfoView.setVisibility(visibility);
        this.mSingerInfoView.setVisibility(visibility);
        this.mTvNick.setVisibility(visibility);
        this.mTvSongName.setVisibility(visibility);
    }

    @Override
    public void onPanelViewHide() {
        this.mIsShowing = false;
        this.mPanelBtn.clearAnimator();
    }

    @Override
    public void onIsPauseState(boolean isPause) {
    }

    @Override
    public boolean isShowing() {
        return this.mIsShowing;
    }

    public void showProgress(long total, long current) {
        if (total == 0L) {
            MLog.info((Object)"KTVProgress", (String)"total:%s", (Object[])new Object[]{0});
            return;
        }
        int progress = (int)((float)current / (float)total * 100.0f);
        if (this.mPbLoading != null) {
            this.mPbLoading.setProgress(progress);
        }
        MLog.info((Object)"KTVProgress", (String)"progress:%s", (Object[])new Object[]{progress});
        if (this.mTvLoading != null) {
            this.mTvLoading.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_ktv_download, (Object[])new Object[]{progress}));
        }
    }

    public void setCloseVisible(boolean showClose) {
        this.mIvClosePanel.setVisibility(showClose ? 0 : 8);
    }

    private void confirmClose(final View view) {
        DialogLinkManager manager = new DialogLinkManager(this.getContext());
        OkCancelDialog dialog2 = new OkCancelDialog.Builder().cancelable(true).message((CharSequence)ResourceUtils.getString((int)R.string.short_tips_close_prepare)).listener(new OkCancelDialogListener(){

            public void onCancel() {
            }

            public void onOk() {
                if (KTVGetReadyPanelView.this.mGetReadyPanelListener != null) {
                    KTVGetReadyPanelView.this.mGetReadyPanelListener.clickClosePanelBtn(view);
                }
            }
        }).build();
        manager.showDialog((BaseDialog)dialog2);
    }

    private void loadKtvWorksBtnState() {
        MLog.info((Object)TAG, (String)"loadKtvWorksBtnState", (Object[])new Object[0]);
        if (!this.isKtvWorksEntranceShow()) {
            MLog.info((Object)TAG, (String)"isKtvWorksEntranceShow false", (Object[])new Object[0]);
            return;
        }
        KTVWorksUtils.INSTANCE.getKtvWorksNum(new BiCallback<Long, String>(){

            public void onSuccess(final Long data) {
                MLog.info((Object)KTVGetReadyPanelView.TAG, (String)("loadKtvWorksBtnState data: " + data), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (KTVGetReadyPanelView.this.mKtvWorksBtn == null) {
                            MLog.info((Object)KTVGetReadyPanelView.TAG, (String)"loadKtvWorksBtnState mKtvWorksBtn null", (Object[])new Object[0]);
                            return;
                        }
                        if (data > 0L) {
                            KTVGetReadyPanelView.this.mKtvWorksBtn.setVisibility(0);
                        } else {
                            KTVGetReadyPanelView.this.mKtvWorksBtn.setVisibility(8);
                        }
                    }
                });
            }

            public void onError(String error) {
                MLog.info((Object)KTVGetReadyPanelView.TAG, (String)("loadKtvWorksBtnState error: " + error), (Object[])new Object[0]);
                YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (KTVGetReadyPanelView.this.mKtvWorksBtn == null) {
                            return;
                        }
                        KTVGetReadyPanelView.this.mKtvWorksBtn.setVisibility(8);
                    }
                });
            }
        });
    }

    private boolean isKtvWorksEntranceShow() {
        KtvWorksEntranceConfig config = (KtvWorksEntranceConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.KTV_WORKS_SAVE_ENTRANCE);
        return config != null && config.getKtvWorksEntranceData() != null && config.getKtvWorksEntranceData().isShow();
    }

    public static interface OnGetReadyPanelListener {
        public void clickSkipSongBtn(View var1);

        public void clickClosePanelBtn(View var1);

        public void clickSingSongBtn(View var1);

        public void clickChooseASongBtn(View var1, boolean var2);

        public void clickRecordKtv(boolean var1);

        public boolean hasShowKtvRecordPermission();

        public boolean hasSeletedRecord();
    }
}

