/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.panel;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.opensource.svgaplayer.SVGAImageView;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.util.RepeatClickUtils;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoleInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.cbase.module.ktv.live.IKtvLiveView;
import com.yy.hiyo.channel.cbase.module.ktv.live.IKtvPlayContract;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVControlInfo;
import com.yy.hiyo.channel.plugins.ktv.model.room.KTVRoomServices;
import com.yy.hiyo.channel.plugins.ktv.panel.IControlInfoCallBack;
import com.yy.hiyo.channel.plugins.ktv.panel.ISvgaAnimListener;
import com.yy.hiyo.channel.plugins.ktv.panel.KTVPanelContract;
import com.yy.hiyo.channel.plugins.ktv.panel.KTVPanelPresenter;
import com.yy.hiyo.channel.plugins.ktv.panel.utils.KTVPanelTranAnimatorPlayer;
import com.yy.hiyo.channel.plugins.ktv.panel.view.IPanelViewState;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVAudiencePanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVAudienceVideoPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVAudioSettingPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVEndingPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVGetReadyPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVLoadingPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVSettingPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVSingerSingingPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVSingerVideoPanelView;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class KTVPanelView
extends YYFrameLayout
implements KTVPanelContract.View,
View.OnClickListener {
    private SVGAImageView mSvgaPanelBg;
    private SVGAImageView mSvgaGift;
    private YYFrameLayout mPanelContainer;
    private ViewGroup mControlBar;
    private View mRlytSongList;
    private TextView mTvSongListSize;
    private ImageView mIvSongLib;
    private View mSkip;
    private View mEffectControl;
    private ImageView mIvVideoSetting;
    private KTVGetReadyPanelView mGetReadyPanelView;
    private KTVSingerSingingPanelView mSingerSingingPanelView;
    private KTVAudiencePanelView mAudiencePanelView;
    private KTVLoadingPanelView mLoadingPanelView;
    private KTVEndingPanelView mEndingPanelView;
    private KTVSingerVideoPanelView mSingerVideoPanelView;
    private KTVAudienceVideoPanelView mAudienceVideoPanelView;
    private KTVPanelPresenter mPanelPresenter;
    private long mCurrTime;
    private long mStartShowGetReadyTime;
    private KTVPanelTranAnimatorPlayer mPlayer;
    private boolean hasPauseSongPolicy = false;
    private KTVGetReadyPanelView.OnGetReadyPanelListener mOnGetReadyPanelListener = new KTVGetReadyPanelView.OnGetReadyPanelListener(){

        @Override
        public void clickSkipSongBtn(View view) {
            KTVPanelView.this.clickSkipSong();
        }

        @Override
        public void clickClosePanelBtn(View view) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"click close panel", (Object[])new Object[0]);
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.closePanel();
                KTVEventReportUtil.reportClosePanelClick();
            }
        }

        @Override
        public void clickSingSongBtn(View view) {
            if (!RepeatClickUtils.canRepeatClick((String)"ktv_skip_and_SING_CLICK")) {
                return;
            }
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVEventReportUtil.reportClickSingBtn(KTVPanelView.this.mStartShowGetReadyTime + "", System.currentTimeMillis() + "");
                KTVPanelView.this.mPanelPresenter.playSong();
            }
        }

        @Override
        public void clickChooseASongBtn(View view, boolean haveMic) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.openSongLib();
                KTVEventReportUtil.reportOpenSongLib("1");
            }
        }

        @Override
        public void clickRecordKtv(boolean openRecord) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.setCurrentRecordSong(openRecord);
            }
        }

        @Override
        public boolean hasShowKtvRecordPermission() {
            if (KTVPanelView.this.mPanelPresenter != null) {
                return KTVPanelView.this.mPanelPresenter.hasRecordKtvPermission();
            }
            return false;
        }

        @Override
        public boolean hasSeletedRecord() {
            if (KTVPanelView.this.mPanelPresenter != null) {
                return KTVPanelView.this.mPanelPresenter.hasSeletedRecord();
            }
            return false;
        }
    };
    private KTVLoadingPanelView.OnLoadingPanelListener mOnLoadingPanelListener = new KTVLoadingPanelView.OnLoadingPanelListener(){

        @Override
        public void clickClosePanelBtn(View view) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"click close panel", (Object[])new Object[0]);
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.closePanel();
                KTVEventReportUtil.reportClosePanelClick();
            }
        }
    };
    private KTVEndingPanelView.IEndingPanelListner mEndingPanelListner = new KTVEndingPanelView.IEndingPanelListner(){

        @Override
        public void onIdleStateEnd() {
            if (KTVPanelView.this.mEndingPanelView.getVisibility() == 0 && null != KTVPanelView.this.mPanelPresenter && KTVPanelView.this.mPanelPresenter.getHandler().getKTVManager() != null) {
                IKTVManager ktvManager = KTVPanelView.this.mPanelPresenter.getHandler().getKTVManager();
                KTVRoomSongInfo songInfo = ktvManager.getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo();
                boolean showSkip = ktvManager.getKTVRoomServices().getCurrentKTVRoomData().hasSkipSongPolicy();
                boolean showClose = ktvManager.getKTVRoomServices().getCurrentKTVRoomData().hasCloseKTVPolicy();
                boolean isSinger = KTVPanelView.this.mPanelPresenter.isSinger();
                if (StringUtils.isEmpty((String)songInfo.getSongId())) {
                    KTVPanelView.this.showNoSongPanel(KTVPanelView.this.mPanelPresenter.getHandler().getmRoomDataContainer().getSeatData().isInSeat(AccountUtil.getUid()), showClose);
                } else if (0 != songInfo.getStatus()) {
                    KTVPanelView.this.showSingingPanel(isSinger, songInfo, KTVPanelView.this.mPanelPresenter.isRoomOwner());
                } else {
                    KTVPanelView.this.showGetReadyPanel(isSinger, showSkip, false, songInfo);
                }
            }
        }

        @Override
        public void clickSendGift(long uid) {
            KTVPanelView.this.mPanelPresenter.showGiftPanel(uid);
        }

        @Override
        public void guideShow() {
            KTVEventReportUtil.reportEndingGuideShow(KTVPanelView.this.mPanelPresenter.isMeShowing(), KTVPanelView.this.mPanelPresenter.isSinger(), KTVPanelView.this.mPanelPresenter.isInSeat());
        }

        @Override
        public void clickSave() {
            KTVPanelView.this.mPanelPresenter.saveBtnClick();
            KTVEventReportUtil.reportAudioSharePanelClick(KTVPanelView.this.mPanelPresenter.isMeShowing(), KTVPanelView.this.mPanelPresenter.isInSeat(), "1");
        }

        @Override
        public void clickShare() {
            KTVPanelView.this.mPanelPresenter.showShareDialog();
            KTVEventReportUtil.reportAudioSharePanelClick(KTVPanelView.this.mPanelPresenter.isMeShowing(), KTVPanelView.this.mPanelPresenter.isInSeat(), "2");
        }

        @Override
        public void clickGift(KTVRoomSongInfo songInfo, GiftItemInfo giftItemInfo) {
            KTVPanelView.this.mPanelPresenter.sendGift(songInfo, giftItemInfo);
        }
    };
    private KTVSingerSingingPanelView.OnSingSongListener mSingSongListener = new KTVSingerSingingPanelView.OnSingSongListener(){

        @Override
        public void onSingerAvatarClick(long uid) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.showSingerProfile(uid);
            }
        }

        @Override
        public void onCameraSwitch(boolean cameraOpen) {
            KTVPanelView.this.mPanelPresenter.openVideoScheme(cameraOpen);
        }

        @Override
        public void onLiveStart() {
        }

        @Override
        public boolean isRecording() {
            return KTVPanelView.this.mPanelPresenter.isRecording();
        }

        @Override
        public void cancelRecord() {
            KTVPanelView.this.mPanelPresenter.cancelRecord();
        }

        @Override
        public void onGiftClick(@NotNull GiftItemInfo giftInfo) {
            KTVPanelView.this.mPanelPresenter.sendGift(giftInfo);
        }

        @Override
        public void onVideoSettingClick(boolean cameraOpen) {
            KTVPanelView.this.mPanelPresenter.onVideoSettingClick(cameraOpen);
        }

        @Override
        public boolean isSingerVideoShowing() {
            return KTVPanelView.this.mSingerVideoPanelView.getVisibility() == 0;
        }
    };
    private IKtvPlayContract.IKtvOperationCallback mSingerOperationCallback = new IKtvPlayContract.IKtvOperationCallback(){

        public void onSingerProfileShow(long uid) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.showSingerProfile(uid);
            }
        }

        public void onGiftClick(@NotNull GiftItemInfo giftItemInfo) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.sendGift(giftItemInfo);
            }
        }

        public void updateControlBar() {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.updateControlInfo(controlInfo -> {});
            }
        }

        public boolean isVideoOpen() {
            return KTVPanelView.this.mAudienceVideoPanelView.getVisibility() == 0;
        }
    };
    private KTVSingerVideoPanelView.ISingerVideoCallback mSingerVideoCallback = cameraOpen -> {
        if (this.mSingerSingingPanelView != null) {
            this.mSingerSingingPanelView.onCameraSwitch(cameraOpen);
        }
        this.mPanelPresenter.onSingerVideoModeChange(cameraOpen);
        if (cameraOpen) {
            this.mSvgaPanelBg.stopAnimation();
        } else if (this.mPanelPresenter.isSinging() || this.mPanelPresenter.isPause()) {
            this.mPlayer.playPanelBgSvga(this.mSvgaPanelBg);
        }
    };
    private KTVAudienceVideoPanelView.IAudienceVideoOperator mAudienceOperator = new KTVAudienceVideoPanelView.IAudienceVideoOperator(){

        @Override
        public void updateControlBar(IControlInfoCallBack callBack) {
            KTVPanelView.this.mPanelPresenter.updateControlInfo(callBack);
        }

        @Override
        public void onCameraSwitch(boolean isCameraOpen) {
            if (KTVPanelView.this.mAudiencePanelView != null) {
                KTVPanelView.this.mAudiencePanelView.onCameraSwitch(isCameraOpen);
            }
            KTVPanelView.this.mPanelPresenter.onAudienceVideoModeChange(isCameraOpen);
            if (isCameraOpen) {
                KTVPanelView.this.mSvgaPanelBg.stopAnimation();
            } else if (KTVPanelView.this.mPanelPresenter.isSinging() || KTVPanelView.this.mPanelPresenter.isPause()) {
                KTVPanelView.this.mPlayer.playPanelBgSvga(KTVPanelView.this.mSvgaPanelBg);
            }
        }

        @Override
        @Nullable
        public Drawable getThemeBg() {
            return KTVPanelView.this.mPanelPresenter.getThemeBg();
        }
    };
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public KTVPanelView(Context context) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_panel_container_channel, (ViewGroup)this);
        this.mSvgaPanelBg = (SVGAImageView)this.findViewById(R.id.svga_panel_bg);
        this.mSvgaGift = (SVGAImageView)this.findViewById(R.id.svga_gift);
        this.mPanelContainer = (YYFrameLayout)this.findViewById(R.id.panel_container);
        this.mControlBar = (ViewGroup)this.findViewById(R.id.control_layout);
        this.mRlytSongList = this.findViewById(R.id.rlyt_song_list);
        this.mTvSongListSize = (TextView)this.findViewById(R.id.tv_song_list_size);
        this.mIvSongLib = (ImageView)this.findViewById(R.id.iv_song_lib);
        this.mSkip = this.findViewById(R.id.iv_skip);
        this.mEffectControl = this.findViewById(R.id.iv_audio_effect);
        this.mIvVideoSetting = (ImageView)this.findViewById(R.id.iv_video_setting);
        this.mSingerVideoPanelView = (KTVSingerVideoPanelView)this.findViewById(R.id.video_preview_layout);
        this.mAudienceVideoPanelView = (KTVAudienceVideoPanelView)this.findViewById(R.id.audience_video_view);
        this.mAudienceVideoPanelView.setOperator(this.mAudienceOperator);
        this.mTvSongListSize.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mPlayer = new KTVPanelTranAnimatorPlayer();
        this.mRlytSongList.setOnClickListener((View.OnClickListener)this);
        this.mIvSongLib.setOnClickListener((View.OnClickListener)this);
        this.mSkip.setOnClickListener((View.OnClickListener)this);
        this.mEffectControl.setOnClickListener((View.OnClickListener)this);
        this.mIvVideoSetting.setOnClickListener((View.OnClickListener)this);
        this.initLoadingPanel();
        this.initGetReadyPanel();
        this.initSingerSingingPanel();
        this.initAudiencePanel();
        this.initEndingPanel();
    }

    @Override
    public void destroy() {
        if (this.mSvgaPanelBg != null) {
            this.mSvgaPanelBg.stopAnimation();
        }
        this.mSvgaGift.stopAnimation();
        this.mAudiencePanelView.destroy();
        this.mSingerSingingPanelView.destroy();
    }

    @Override
    public void updateControlState(KTVControlInfo info) {
        this.mSkip.setVisibility(info.getShowSkip() ? 0 : 8);
        this.mEffectControl.setVisibility(info.getShowSoundEffect() ? 0 : 8);
        this.mIvSongLib.setVisibility(info.getShowAdd() ? 0 : 8);
        this.mRlytSongList.setVisibility(info.getShowList() ? 0 : 8);
        if (info.getVideoBtnState().isSinger()) {
            boolean needShow = info.getVideoBtnState().getShowBtn() && info.getVideoBtnState().getHasAuthority();
            this.mIvVideoSetting.setVisibility(needShow ? 0 : 8);
        } else {
            this.mIvVideoSetting.setVisibility(info.getVideoBtnState().getShowBtn() ? 0 : 8);
        }
        this.mIvVideoSetting.setImageResource(info.getVideoBtnState().isSinger() ? R.drawable.selector_voice_room_video_scheme : R.drawable.selector_voice_room_audience_video_scheme);
        this.mIvVideoSetting.setSelected(info.getVideoBtnState().isCameraOpen());
        boolean isShowing = info.getShowAdd() || info.getShowList() || info.getShowSkip() || info.getShowSoundEffect() || info.getVideoBtnState().getShowBtn();
        this.mControlBar.setVisibility(isShowing ? 0 : 8);
        if (info.getShowSkip() && info.getShowSoundEffect()) {
            if (this.mPanelPresenter.isSinging() || this.mPanelPresenter.isPause()) {
                this.mSkip.setVisibility(8);
                this.mEffectControl.setVisibility(0);
            } else {
                this.mSkip.setVisibility(0);
                this.mEffectControl.setVisibility(8);
            }
        }
        if (isShowing) {
            if (this.mGetReadyPanelView != null) {
                int heightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                int widthSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                this.mControlBar.measure(widthSpec, heightSpec);
                this.mGetReadyPanelView.setPaddingRelative(this.mControlBar.getMeasuredWidth(), 0, 0, 0);
                if (this.mEndingPanelView != null) {
                    this.mEndingPanelView.setPaddingRelative(this.mControlBar.getMeasuredWidth(), 0, 0, 0);
                }
            }
        } else {
            if (this.mGetReadyPanelView != null) {
                this.mGetReadyPanelView.setPaddingRelative(0, 0, 0, 0);
            }
            if (this.mEndingPanelView != null) {
                this.mEndingPanelView.setPaddingRelative(0, 0, 0, 0);
            }
        }
        this.adjustControlBar();
    }

    private void adjustControlBar() {
        if (this.mSingerVideoPanelView.getVisibility() == 0 || this.mAudienceVideoPanelView.getVisibility() == 0) {
            this.setWrap();
        } else {
            IPanelViewState currentPanel = this.getCurrentPanel();
            if (currentPanel instanceof KTVAudiencePanelView) {
                if (((KTVAudiencePanelView)currentPanel).isLrcMode()) {
                    this.setMatch();
                } else {
                    this.setWrap();
                }
            } else {
                this.setMatch();
            }
        }
    }

    private void setMatch() {
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.mControlBar.getLayoutParams();
        layoutParams.height = 0;
        layoutParams.topToTop = this.mPanelContainer.getId();
        layoutParams.bottomToBottom = this.mPanelContainer.getId();
        this.mControlBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWrap() {
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.mControlBar.getLayoutParams();
        layoutParams.height = -2;
        layoutParams.topToTop = -1;
        layoutParams.bottomToBottom = this.mPanelContainer.getId();
        this.mControlBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public IPanelViewState getCurrentPanel() {
        for (int i = 0; i < this.mPanelContainer.getChildCount(); ++i) {
            IPanelViewState panelView2;
            View child = this.mPanelContainer.getChildAt(i);
            if (!(child instanceof IPanelViewState) || !(panelView2 = (IPanelViewState)child).isShowing()) continue;
            return panelView2;
        }
        return null;
    }

    @Override
    public List<View> getScrollViews() {
        View singerGift = this.mSingerSingingPanelView.findViewById(R.id.giftLayout);
        View audienceGift = this.mAudiencePanelView.findViewById(R.id.giftLayout);
        return Arrays.asList(this.mControlBar, singerGift, audienceGift);
    }

    @Override
    public void showNoSongPanel(boolean haveMic, boolean showClose) {
        FeatureLog.e((String)"FTKTVPlayer", (String)"show no song panel", (Object[])new Object[0]);
        this.showTargetPanel((View)this.mGetReadyPanelView);
        this.mGetReadyPanelView.showNoSongLayout(haveMic, showClose);
        this.mPanelPresenter.updateControlInfo(controlInfo -> {
            controlInfo.setShowSkip(false);
            controlInfo.setShowSoundEffect(false);
        });
        KTVEventReportUtil.reportNoSongShow();
    }

    @Override
    public void showGetReadyPanel(boolean isSinger, boolean showSkip, boolean isDownloading, KTVRoomSongInfo songInfo) {
        FeatureLog.e((String)"FTKTVPlayer", (String)"show get ready panel", (Object[])new Object[0]);
        this.showTargetPanel((View)this.mGetReadyPanelView);
        this.mGetReadyPanelView.showReadyLayout(isSinger, isDownloading);
        String songName = songInfo.getSongName();
        String nick = songInfo.getNick();
        String avatar = songInfo.getAvatar();
        String composer = songInfo.getComposer();
        String songWriter = songInfo.getSongWriter();
        this.mGetReadyPanelView.loadSongInfo(songName, nick, avatar, composer, songWriter, this.mPanelPresenter.checkScrollSongInfo());
        this.mStartShowGetReadyTime = System.currentTimeMillis();
        KTVEventReportUtil.reportGetReadyShow();
        this.mPanelPresenter.updateControlInfo(controlInfo -> {
            controlInfo.setShowAdd(true);
            controlInfo.setShowList(true);
            controlInfo.setShowSkip(showSkip);
            controlInfo.setShowSoundEffect(false);
        });
    }

    @Override
    public void setSelectSongPolicy(int status, boolean enable) {
        if (status == -1) {
            this.mGetReadyPanelView.setSelectSongPolicy(enable);
        }
    }

    @Override
    public void showSingingPanel(boolean isSinger, KTVRoomSongInfo songInfo, boolean isOwner) {
        FeatureLog.e((String)"FTKTVPlayer", (String)"show singing panel", (Object[])new Object[0]);
        if (this.mEndingPanelView == null || !this.mEndingPanelView.isShowing()) {
            if (isSinger) {
                this.showSingerSingingPanel(songInfo);
                this.mPanelPresenter.updateControlInfo(controlInfo -> {
                    controlInfo.setShowSkip(false);
                    controlInfo.setShowSoundEffect(true);
                });
            } else {
                this.mPanelPresenter.updateControlInfo(controlInfo -> {
                    controlInfo.setShowSkip(false);
                    controlInfo.setShowSoundEffect(isOwner);
                });
                this.showAudienceSingingPanel(songInfo);
            }
            this.mPlayer.playPanelBgSvga(this.mSvgaPanelBg);
        }
    }

    @Override
    public void showLoadingPanel(boolean showClose) {
        FeatureLog.e((String)"FTKTVPlayer", (String)"show loading panel", (Object[])new Object[0]);
        this.showTargetPanel((View)this.mLoadingPanelView);
        if (this.mLoadingPanelView != null) {
            this.mLoadingPanelView.setCloseVisible(showClose);
        }
    }

    @Override
    public void showEndingPanel(boolean isSinger, KTVRoomSongInfo songInfo) {
        FeatureLog.e((String)"FTKTVPlayer", (String)"show ending panel isSinger=%s", (Object[])new Object[]{isSinger});
        this.mEndingPanelView.setKTVRoomSongInfo(songInfo);
        this.mEndingPanelView.setGiftInfo(this.mPanelPresenter.getGiftInfo());
        this.showTargetPanel((View)this.mEndingPanelView);
        if (songInfo != null && songInfo.isSinger()) {
            KTVEventReportUtil.reportAudioSharePanelShow(this.mPanelPresenter.isMeShowing(), this.mPanelPresenter.isInSeat());
        }
    }

    private void showSingerSingingPanel(KTVRoomSongInfo songInfo) {
        this.showTargetPanel((View)this.mSingerSingingPanelView);
        String songName = songInfo.getSongName();
        String nick = songInfo.getNick();
        String avatar = songInfo.getAvatar();
        long singUid = songInfo.getUid();
        this.mSingerSingingPanelView.loadSongInfo(songName, nick, avatar, singUid, this.mPanelPresenter.getGiftInfo());
    }

    private void showAudienceSingingPanel(KTVRoomSongInfo songInfo) {
        this.showTargetPanel((View)this.mAudiencePanelView);
        String songName = songInfo.getSongName();
        String nick = songInfo.getNick();
        String avatar = songInfo.getAvatar();
        long singUid = songInfo.getUid();
        this.mAudiencePanelView.loadSongInfo(songName, nick, avatar, singUid, this.mPanelPresenter.getGiftInfo());
    }

    @Override
    public void loadPanelLyric(String filePath) {
        if (this.mPanelPresenter == null) {
            return;
        }
        if (this.mPanelPresenter.isSinger()) {
            if (this.mSingerSingingPanelView != null) {
                this.mSingerSingingPanelView.loadLrc(filePath);
            }
        } else {
            this.mAudiencePanelView.loadLrc(filePath);
        }
    }

    @Override
    public boolean hasLoadLyricFile() {
        if (this.mPanelPresenter == null || this.mAudiencePanelView == null) {
            return false;
        }
        if (this.mPanelPresenter.isSinger()) {
            return this.mSingerSingingPanelView.hasLrc();
        }
        return this.mAudiencePanelView.hasLrc();
    }

    @Override
    public void updateLyricTime(int time, int totalDuration) {
        if (this.mPanelPresenter == null) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.mCurrTime >= 3000L) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVPlayer", (String)"current time: %s,totalDuration: %s", (Object[])new Object[]{time, totalDuration});
            }
            this.mCurrTime = currentTimeMillis;
        }
        if (this.mPanelPresenter.isSinger()) {
            if (this.mSingerSingingPanelView != null) {
                this.mSingerSingingPanelView.updateLyricTime(time, totalDuration);
            }
        } else if (this.mAudiencePanelView != null) {
            this.mAudiencePanelView.updateLyricTime(time, totalDuration);
        }
    }

    @Override
    public void onIsPauseState(boolean isPause) {
        this.onPanelPause(this.mGetReadyPanelView, isPause);
        this.onPanelPause(this.mAudiencePanelView, isPause);
        this.onPanelPause(this.mSingerSingingPanelView, isPause);
        this.onPanelPause(this.mEndingPanelView, isPause);
    }

    private void onPanelPause(IPanelViewState viewState, boolean isPause) {
        if (viewState != null) {
            viewState.onIsPauseState(isPause);
        }
    }

    @Override
    public void showLoading(long total, long current) {
        if (this.mGetReadyPanelView != null) {
            this.mGetReadyPanelView.showProgress(total, current);
        }
    }

    @Override
    public void startGiftSvga(String url, ISvgaAnimListener listener) {
        this.mPlayer.playPanelGiftSvga(this.mSvgaGift, url, listener);
    }

    private void showSettingView() {
        this.mPanelPresenter.openAudioSettingPanel(this.hasPauseSongPolicy);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.rlyt_song_list) {
            if (this.mPanelPresenter != null) {
                this.mPanelPresenter.openSongList();
                KTVEventReportUtil.reportOpenSongList("4");
            }
        } else if (v.getId() == R.id.iv_song_lib) {
            if (this.mPanelPresenter != null) {
                this.mPanelPresenter.openSongLib();
                KTVEventReportUtil.reportOpenSongLib("2");
            }
        } else if (v.getId() == R.id.iv_skip) {
            this.clickSkipSong();
        } else if (v.getId() == R.id.iv_video_setting) {
            KTVControlInfo info = this.mPanelPresenter.getControlInfo();
            if (info.getVideoBtnState().isSinger()) {
                this.mPanelPresenter.onVideoSettingClick(info.getVideoBtnState().isCameraOpen());
            } else if (!CommonUtils.isFastClick((long)700L)) {
                this.mAudienceVideoPanelView.onVideoAndVoiceSwitch();
            }
        } else if (v.getId() == R.id.iv_audio_effect) {
            ChannelTrack.INSTANCE.ktvControlClick();
            this.showSettingView();
        }
    }

    private void clickSkipSong() {
        FeatureLog.e((String)"FTKTVPlayer", (String)"skip song on get ready panel", (Object[])new Object[0]);
        if (!RepeatClickUtils.canRepeatClick((String)"ktv_skip_and_SING_CLICK")) {
            return;
        }
        if (this.mPanelPresenter != null) {
            this.mPanelPresenter.skipSong();
            String reportStr = this.mPanelPresenter.isSinger() && this.mPanelPresenter.isMeShowing() ? "1&2" : (this.mPanelPresenter.isSinger() ? "2" : "1");
            KTVEventReportUtil.reportChangeSongClick(reportStr);
        }
    }

    private void initGetReadyPanel() {
        if (this.mGetReadyPanelView == null) {
            Context context = this.getContext();
            this.mGetReadyPanelView = new KTVGetReadyPanelView(context);
            this.mPanelContainer.addView((View)this.mGetReadyPanelView);
            this.mGetReadyPanelView.setVisibility(8);
            this.mGetReadyPanelView.setOnGetReadyPanelListener(this.mOnGetReadyPanelListener);
        }
    }

    private void initAudiencePanel() {
        if (this.mAudiencePanelView == null) {
            Context context = this.getContext();
            this.mAudiencePanelView = new KTVAudiencePanelView(context);
            this.mAudiencePanelView.setOpeartionCallback(this.mSingerOperationCallback);
            this.mPanelContainer.addView((View)this.mAudiencePanelView);
            this.mAudiencePanelView.setVisibility(8);
        }
    }

    private void initSingerSingingPanel() {
        if (this.mSingerSingingPanelView == null) {
            Context context = this.getContext();
            this.mSingerSingingPanelView = new KTVSingerSingingPanelView(context);
            this.mPanelContainer.addView((View)this.mSingerSingingPanelView);
            this.mSingerSingingPanelView.setVisibility(8);
            this.mSingerSingingPanelView.setMSingSongListener(this.mSingSongListener);
        }
    }

    private void initLoadingPanel() {
        if (this.mLoadingPanelView == null) {
            Context context = this.getContext();
            this.mLoadingPanelView = new KTVLoadingPanelView(context);
            this.mPanelContainer.addView((View)this.mLoadingPanelView);
            this.mLoadingPanelView.setVisibility(8);
            this.mLoadingPanelView.setOnLoadinganelListener(this.mOnLoadingPanelListener);
        }
    }

    private void initEndingPanel() {
        if (this.mEndingPanelView == null) {
            Context context = this.getContext();
            this.mEndingPanelView = new KTVEndingPanelView(context);
            this.mPanelContainer.addView((View)this.mEndingPanelView);
            this.mEndingPanelView.setVisibility(8);
            this.mEndingPanelView.setOnEndingPanelListner(this.mEndingPanelListner);
        }
    }

    public void showTargetPanel(View panel) {
        if (panel == null || this.mPanelPresenter == null) {
            return;
        }
        if (null != this.mEndingPanelView && panel != this.mEndingPanelView && this.mEndingPanelView.isShowing()) {
            return;
        }
        if (panel.equals(this.mLoadingPanelView)) {
            this.mPanelPresenter.updateControlInfo(controlInfo -> {
                controlInfo.setShowAdd(false);
                controlInfo.setShowList(false);
            });
            if (this.mLoadingPanelView.getVisibility() == 8) {
                this.mLoadingPanelView.onPanelViewShow(this.mPanelPresenter.isSinger(), this.mPanelPresenter.isPause());
                this.mLoadingPanelView.setVisibility(0);
            }
        } else {
            this.handlePanelHide((View)this.mLoadingPanelView);
        }
        if (panel.equals(this.mGetReadyPanelView)) {
            this.mPanelPresenter.updateControlInfo(controlInfo -> {
                controlInfo.setShowAdd(false);
                controlInfo.setShowList(false);
                controlInfo.getVideoBtnState().setShowBtn(false);
            });
            if (this.mGetReadyPanelView.getVisibility() == 8) {
                this.mGetReadyPanelView.onPanelViewShow(this.mPanelPresenter.isSinger(), this.mPanelPresenter.isPause());
                this.mGetReadyPanelView.setVisibility(0);
            }
        } else {
            this.handlePanelHide((View)this.mGetReadyPanelView);
        }
        if (!this.mPanelPresenter.isSinger() && panel.equals(this.mAudiencePanelView)) {
            this.mPanelPresenter.updateControlInfo(controlInfo -> {
                controlInfo.setShowAdd(true);
                controlInfo.setShowList(true);
                controlInfo.getVideoBtnState().setSinger(false);
            });
            if (this.mAudiencePanelView != null && this.mAudiencePanelView.getVisibility() == 8) {
                this.mAudiencePanelView.onPanelViewShow(this.mPanelPresenter.isSinger(), this.mPanelPresenter.isPause());
                this.mAudiencePanelView.setVisibility(0);
            }
        } else {
            this.handlePanelHide((View)this.mAudiencePanelView);
        }
        if (this.mPanelPresenter.isSinger() && panel.equals(this.mSingerSingingPanelView)) {
            this.mPanelPresenter.updateControlInfo(controlInfo -> {
                controlInfo.setShowAdd(true);
                controlInfo.setShowList(true);
                controlInfo.getVideoBtnState().setShowBtn(true);
            });
            if (this.mSingerSingingPanelView.getVisibility() == 8) {
                this.mSingerSingingPanelView.onPanelViewShow(this.mPanelPresenter.isSinger(), this.mPanelPresenter.isPause());
                this.mSingerSingingPanelView.setVisibility(0);
            }
        } else {
            this.handlePanelHide((View)this.mSingerSingingPanelView);
            this.mPanelPresenter.hideVideoSettingPanel();
            this.mSvgaPanelBg.stopAnimation();
        }
        if (panel.equals(this.mEndingPanelView)) {
            this.mPanelPresenter.updateControlInfo(controlInfo -> {
                controlInfo.setShowAdd(true);
                controlInfo.setShowList(true);
                controlInfo.getVideoBtnState().setShowBtn(false);
            });
            if (this.mEndingPanelView.getVisibility() == 8) {
                this.mEndingPanelView.onPanelViewShow(this.mPanelPresenter.isSinger(), this.mPanelPresenter.isPause());
                if (this.mPanelPresenter != null) {
                    this.mEndingPanelView.setShareAndSaveShow(this.mPanelPresenter.isRecordComplete());
                }
                this.mEndingPanelView.setVisibility(0);
            }
            KTVEventReportUtil.reportEndingShow(this.mPanelPresenter.isMeShowing(), this.mPanelPresenter.isSinger(), this.mPanelPresenter.isInSeat());
        } else {
            this.handlePanelHide((View)this.mEndingPanelView);
        }
        if (this.mPanelPresenter != null) {
            KTVSettingPanelView.setHasHeadset(this.mPanelPresenter.getHandler() != null && this.mPanelPresenter.getHandler().getKTVManager().getKTVRoomServices().hasHeadset());
            KTVAudioSettingPanelView.Companion.setHasHeadset(this.mPanelPresenter.getHandler() != null && this.mPanelPresenter.getHandler().getKTVManager().getKTVRoomServices().hasHeadset());
        }
    }

    private void handlePanelHide(View view) {
        if (null != view && view.getVisibility() == 0) {
            view.setVisibility(8);
            if (view instanceof IPanelViewState) {
                ((IPanelViewState)view).onPanelViewHide();
            }
        }
    }

    @Override
    public View getKtvPanelView() {
        return this;
    }

    public void setPresenter(KTVPanelContract.Presenter presenter) {
        this.mPanelPresenter = (KTVPanelPresenter)presenter;
        this.mSingerVideoPanelView.setPanelPresenter(this.mPanelPresenter);
        this.mSingerVideoPanelView.setSingerVideoCallback(this.mSingerVideoCallback);
    }

    @Override
    public void headsetChanged(boolean hasHeadset) {
        if (null != this.mPanelPresenter) {
            this.mPanelPresenter.headsetChanged(hasHeadset);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mBinder.singleBindSourceTo((KvoSource)((KTVRoomServices)this.mPanelPresenter.getHandler().getKTVManager().getKTVRoomServices()));
        this.mBinder.singleBindSourceTo((KvoSource)this.mPanelPresenter.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getRoleInfo());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBinder.clearAllKvoConnections();
    }

    @KvoMethodAnnotation(name="mKTVRoomSongInfoList", sourceClass=KTVRoomServices.class)
    public void onKTVRoomSongListChanged(KvoEventIntent event) {
        KTVRoomServices ktvRoomServices;
        List<KTVRoomSongInfo> ktvRoomSongInfoList;
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVRoomService", (String)"onKTVRoomSongListChanged", (Object[])new Object[0]);
        }
        if (!FP.empty(ktvRoomSongInfoList = (ktvRoomServices = (KTVRoomServices)event.source()).getKTVRoomSongInfoList())) {
            int totalMusicCount = ktvRoomSongInfoList.size();
            this.mTvSongListSize.setText((CharSequence)(totalMusicCount + ""));
        }
    }

    @KvoMethodAnnotation(sourceClass=KTVRoleInfo.class, name="pauseSongPolicy", thread=1)
    public void onPauseSongPolicyChanged(KvoEventIntent event) {
        int newValue;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTKTVRoomService", (String)"onPauseSongPolicyChanged oldValue: %s , newValue: %s", (Object[])new Object[]{event.oldValue(), event.newValue()});
        }
        this.hasPauseSongPolicy = (newValue = ((Integer)event.caseNewValue((Object)0)).intValue()) == 1;
    }

    @KvoMethodAnnotation(sourceClass=KTVRoleInfo.class, name="cutSongPolicy", thread=1)
    public void onSkipSongPolicyChanged(KvoEventIntent event) {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTKTVRoomService", (String)"onSkipSongPolicyChanged oldValue: %s , newValue: %s", (Object[])new Object[]{event.oldValue(), event.newValue()});
        }
        if (this.mGetReadyPanelView != null) {
            int newValue = (Integer)event.caseNewValue((Object)0);
            boolean hasSkipPolicy = newValue == 1;
            List ktvRoomSongInfoList = this.mPanelPresenter.getHandler().getKTVManager().getKTVRoomServices().getKTVRoomSongInfoList();
            if (FP.empty((Collection)ktvRoomSongInfoList)) {
                this.mPanelPresenter.updateControlInfo(controlInfo -> {
                    controlInfo.setShowSkip(false);
                    controlInfo.setShowSoundEffect(false);
                });
            } else {
                this.mPanelPresenter.updateControlInfo(controlInfo -> {
                    controlInfo.setShowSkip(hasSkipPolicy);
                    controlInfo.setShowSoundEffect(hasSkipPolicy);
                });
            }
        }
    }

    @KvoMethodAnnotation(sourceClass=KTVRoleInfo.class, name="closeKTVPolicy", thread=1)
    public void onCloseKTVPolicyChanged(KvoEventIntent event) {
        int newValue;
        boolean hasClosePolicy;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTKTVRoomService", (String)"onCloseKTVPolicyChanged oldValue: %s , newValue: %s", (Object[])new Object[]{event.oldValue(), event.newValue()});
        }
        boolean bl = hasClosePolicy = (newValue = ((Integer)event.caseNewValue((Object)0)).intValue()) == 1;
        if (this.mLoadingPanelView != null) {
            this.mLoadingPanelView.setCloseVisible(hasClosePolicy);
        }
        if (this.mGetReadyPanelView != null) {
            this.mGetReadyPanelView.setCloseVisible(hasClosePolicy);
        }
    }

    @Override
    public IKtvLiveView getKtvLiveView() {
        return this.mSingerVideoPanelView;
    }

    @Override
    public IKtvPlayContract.IKtvPlayView getKtvPlayView() {
        return this.mAudienceVideoPanelView;
    }

    public KTVSingerSingingPanelView getSingerSingingPanelView() {
        return this.mSingerSingingPanelView;
    }

    public KTVSingerVideoPanelView getSingerVideoPanelView() {
        return this.mSingerVideoPanelView;
    }
}

