/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.model.record;

import com.yy.appbase.service.IService;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.base.logger.MLog;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseModel;
import com.yy.hiyo.channel.plugins.ktv.model.KTVRoomManager;
import com.yy.hiyo.channel.plugins.ktv.model.record.IKTVRecorder;
import com.yy.hiyo.voice.base.channelvoice.IKtvLiveServiceExtend;
import com.yy.hiyo.voice.base.channelvoice.IMediaInfoService;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0002\u001b\u001cB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0016J\b\u0010\u0013\u001a\u00020\u000bH\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\u0012\u0010\u0015\u001a\u00020\u00102\b\u0010\u0016\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/yy/hiyo/channel/plugins/ktv/model/record/KTVRecorder;", "Lcom/yy/hiyo/channel/plugins/ktv/model/record/IKTVRecorder;", "Lcom/yy/hiyo/channel/plugins/ktv/common/base/KTVBaseModel;", "ktvManager", "Lcom/yy/hiyo/channel/plugins/ktv/model/KTVRoomManager;", "(Lcom/yy/hiyo/channel/plugins/ktv/model/KTVRoomManager;)V", "mAudioPath", "", "mCurrentSongInfo", "Lcom/yy/hiyo/channel/cbase/module/ktv/bean/KTVRoomSongInfo;", "mIsRecording", "", "mKtvRecordListener", "Lcom/yy/hiyo/channel/plugins/ktv/model/record/KTVRecorder$IKtvRecordListener;", "mNeedRecord", "cancelRecord", "", "destroy", "getNeedRecordSong", "hasRecordPermission", "isRecording", "setKtvRecordListener", "l", "setNeedRecordSong", "record", "startRecord", "stopRecord", "Companion", "IKtvRecordListener", "ktv_release"})
public final class KTVRecorder
extends KTVBaseModel
implements IKTVRecorder {
    private IKtvRecordListener mKtvRecordListener;
    private boolean mNeedRecord;
    private boolean mIsRecording;
    private String mAudioPath;
    private KTVRoomSongInfo mCurrentSongInfo;
    @NotNull
    public static final String TAG = "KTVRecorder";
    public static final int SAMEPLE_RATE = 8000;
    public static final int CHANNEL = 1;
    public static final Companion Companion = new Companion(null);

    @Override
    public void setNeedRecordSong(boolean record) {
        IKTVManager iKTVManager;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("setCurrentRecordSong " + record), (Object[])new Object[0]);
        }
        this.mNeedRecord = record;
        this.mCurrentSongInfo = record ? ((iKTVManager = this.getKtvManager()) != null && (iKTVManager = iKTVManager.getKTVRoomServices()) != null && (iKTVManager = iKTVManager.getCurrentKTVRoomData()) != null ? iKTVManager.getCurrentSongInfo() : null) : null;
    }

    @Override
    public boolean getNeedRecordSong() {
        return this.mNeedRecord && this.hasRecordPermission();
    }

    @Override
    public boolean hasRecordPermission() {
        return true;
    }

    @Override
    public void startRecord() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("startRecord " + this.mNeedRecord), (Object[])new Object[0]);
        }
        this.mAudioPath = "";
        if (this.mNeedRecord) {
            StringBuilder stringBuilder = new StringBuilder();
            FileStorageUtils fileStorageUtils = FileStorageUtils.getInstance();
            Intrinsics.checkExpressionValueIsNotNull((Object)fileStorageUtils, (String)"FileStorageUtils.getInstance()");
            this.mAudioPath = stringBuilder.append(fileStorageUtils.getTempDir()).append(File.separator).append("audio_").append(System.currentTimeMillis()).append(".aac").toString();
            IKtvLiveServiceExtend iKtvLiveServiceExtend = (IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class);
            if (iKtvLiveServiceExtend != null) {
                IService iService = ServiceManagerProxy.getService(IMediaInfoService.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)iService, (String)"ServiceManagerProxy.getS\u2026aInfoService::class.java)");
                int n = ((IMediaInfoService)iService).getThunderAudioSaverOnlyCaptureType();
                IService iService2 = ServiceManagerProxy.getService(IMediaInfoService.class);
                Intrinsics.checkExpressionValueIsNotNull((Object)iService2, (String)"ServiceManagerProxy.getS\u2026aInfoService::class.java)");
                iKtvLiveServiceExtend.startAudioSaver(this.mAudioPath, n, ((IMediaInfoService)iService2).getThunderAudioSaverFileOverrideType());
            }
            this.mIsRecording = true;
        }
    }

    @Override
    public void stopRecord() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("stopRecord " + this.mNeedRecord), (Object[])new Object[0]);
        }
        if (this.mNeedRecord) {
            IKtvLiveServiceExtend iKtvLiveServiceExtend = (IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class);
            if (iKtvLiveServiceExtend != null) {
                iKtvLiveServiceExtend.stopAudioSaver();
            }
            if (StringUtils.isNotEmpty((String)this.mAudioPath) && this.mCurrentSongInfo != null) {
                IKtvRecordListener iKtvRecordListener = this.mKtvRecordListener;
                if (iKtvRecordListener != null) {
                    KTVRoomSongInfo kTVRoomSongInfo = this.mCurrentSongInfo;
                    if (kTVRoomSongInfo == null) {
                        Intrinsics.throwNpe();
                    }
                    KTVRoomSongInfo kTVRoomSongInfo2 = KTVRoomSongInfo.clone((KTVRoomSongInfo)kTVRoomSongInfo);
                    Intrinsics.checkExpressionValueIsNotNull((Object)kTVRoomSongInfo2, (String)"KTVRoomSongInfo.clone(mCurrentSongInfo!!)");
                    iKtvRecordListener.recordComplete(this.mAudioPath, kTVRoomSongInfo2);
                }
            }
            this.destroy();
        }
    }

    @Override
    public void cancelRecord() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)("cancelRecord " + this.mNeedRecord), (Object[])new Object[0]);
        }
        if (this.mNeedRecord) {
            IKtvLiveServiceExtend iKtvLiveServiceExtend = (IKtvLiveServiceExtend)ServiceManagerProxy.getService(IKtvLiveServiceExtend.class);
            if (iKtvLiveServiceExtend != null) {
                iKtvLiveServiceExtend.stopAudioSaver();
            }
            this.destroy();
        }
    }

    @Override
    public boolean isRecording() {
        return this.mIsRecording;
    }

    @Override
    public void destroy() {
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)TAG, (String)"destroy", (Object[])new Object[0]);
        }
        this.mAudioPath = "";
        this.mCurrentSongInfo = null;
        this.mIsRecording = false;
    }

    @Override
    public void setKtvRecordListener(@Nullable IKtvRecordListener l) {
        this.mKtvRecordListener = l;
    }

    public KTVRecorder(@NotNull KTVRoomManager ktvManager) {
        Intrinsics.checkParameterIsNotNull((Object)ktvManager, (String)"ktvManager");
        super(ktvManager);
        this.mNeedRecord = true;
        this.mAudioPath = "";
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/yy/hiyo/channel/plugins/ktv/model/record/KTVRecorder$IKtvRecordListener;", "", "recordComplete", "", "audioPath", "", "currentSongInfo", "Lcom/yy/hiyo/channel/cbase/module/ktv/bean/KTVRoomSongInfo;", "ktv_release"})
    public static interface IKtvRecordListener {
        public void recordComplete(@NotNull String var1, @NotNull KTVRoomSongInfo var2);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/yy/hiyo/channel/plugins/ktv/model/record/KTVRecorder$Companion;", "", "()V", "CHANNEL", "", "SAMEPLE_RATE", "TAG", "", "ktv_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

