/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.model.downloader;

import com.yy.appbase.fileStorage.FileStorageRegistry;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.filestorage.FileStorageUtils;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0013\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0010\u001a\u00020\u0004J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0014\u001a\u00020\u0004J\u000e\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u0004J\u0016\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0004J\u0006\u0010\u0016\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0014\u0010\t\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u0014\u0010\u000b\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u0017"}, d2={"Lcom/yy/hiyo/channel/plugins/ktv/model/downloader/KTVDownloadUtils;", "", "()V", "FOLDER_INSTRUMENTAL", "", "getFOLDER_INSTRUMENTAL", "()Ljava/lang/String;", "FOLDER_KTV", "getFOLDER_KTV", "FOLDER_KTV_RECORD", "getFOLDER_KTV_RECORD", "FOLDER_LYRIC", "getFOLDER_LYRIC", "getInstrumentalFileName", "songId", "url", "getKTVInstrumentalDir", "getKTVInstrumentalFilePath", "getKTVLyricDir", "getKTVLyricFilePath", "getKTVRecordAudioDir", "getLyricFileName", "getSDKTVExternalDir", "ktv_release"})
public final class KTVDownloadUtils {
    @NotNull
    private static final String FOLDER_KTV = "ktv";
    @NotNull
    private static final String FOLDER_INSTRUMENTAL = "instrumental";
    @NotNull
    private static final String FOLDER_LYRIC = "lyric";
    @NotNull
    private static final String FOLDER_KTV_RECORD = "recordAudio";
    public static final KTVDownloadUtils INSTANCE;

    @NotNull
    public final String getFOLDER_KTV() {
        return FOLDER_KTV;
    }

    @NotNull
    public final String getFOLDER_INSTRUMENTAL() {
        return FOLDER_INSTRUMENTAL;
    }

    @NotNull
    public final String getFOLDER_LYRIC() {
        return FOLDER_LYRIC;
    }

    @NotNull
    public final String getFOLDER_KTV_RECORD() {
        return FOLDER_KTV_RECORD;
    }

    @NotNull
    public final String getSDKTVExternalDir() {
        StringBuilder stringBuilder = new StringBuilder();
        FileStorageUtils fileStorageUtils = FileStorageUtils.getInstance();
        Intrinsics.checkExpressionValueIsNotNull((Object)fileStorageUtils, (String)"FileStorageUtils.getInstance()");
        return stringBuilder.append(fileStorageUtils.getExternalFileRootDir()).append(File.separator).append(FOLDER_KTV).append(File.separator).toString();
    }

    @NotNull
    public final String getKTVInstrumentalDir() {
        return this.getSDKTVExternalDir() + FOLDER_INSTRUMENTAL + File.separator;
    }

    @NotNull
    public final String getKTVRecordAudioDir() {
        return this.getSDKTVExternalDir() + FOLDER_KTV_RECORD + File.separator;
    }

    @NotNull
    public final String getKTVInstrumentalFilePath(@NotNull String songId) {
        Intrinsics.checkParameterIsNotNull((Object)songId, (String)"songId");
        return this.getKTVInstrumentalDir() + songId + File.separator;
    }

    @NotNull
    public final String getKTVInstrumentalFilePath(@NotNull String songId, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)songId, (String)"songId");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String filePath = this.getKTVInstrumentalDir() + this.getInstrumentalFileName(songId, url);
        FileStorageRegistry.INSTANCE.extendLife(filePath);
        return filePath;
    }

    @NotNull
    public final String getKTVLyricDir() {
        return this.getSDKTVExternalDir() + FOLDER_LYRIC + File.separator;
    }

    @NotNull
    public final String getKTVLyricFilePath(@NotNull String songId) {
        Intrinsics.checkParameterIsNotNull((Object)songId, (String)"songId");
        return this.getKTVLyricDir() + songId + File.separator;
    }

    @NotNull
    public final String getKTVLyricFilePath(@NotNull String songId, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)songId, (String)"songId");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String filePath = this.getKTVLyricDir() + this.getLyricFileName(songId, url);
        FileStorageRegistry.INSTANCE.extendLife(filePath);
        return filePath;
    }

    @NotNull
    public final String getInstrumentalFileName(@NotNull String songId) {
        Intrinsics.checkParameterIsNotNull((Object)songId, (String)"songId");
        return songId + ".mp3";
    }

    @NotNull
    public final String getInstrumentalFileName(@NotNull String songId, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)songId, (String)"songId");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String prefix = "";
        if (StringsKt.lastIndexOf$default((CharSequence)url, (String)".", (int)0, (boolean)false, (int)6, null) < url.length() - 1) {
            String string2 = url;
            int n = StringsKt.lastIndexOf$default((CharSequence)url, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            prefix = string3;
        }
        if (StringUtils.isNotEmpty((String)prefix)) {
            return songId + "." + prefix;
        }
        return songId + ".mp3";
    }

    @NotNull
    public final String getLyricFileName(@NotNull String songId) {
        Intrinsics.checkParameterIsNotNull((Object)songId, (String)"songId");
        return songId + ".lrc";
    }

    @NotNull
    public final String getLyricFileName(@NotNull String songId, @NotNull String url) {
        Intrinsics.checkParameterIsNotNull((Object)songId, (String)"songId");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        String prefix = "";
        if (StringsKt.lastIndexOf$default((CharSequence)url, (String)".", (int)0, (boolean)false, (int)6, null) < url.length() - 1) {
            String string2 = url;
            int n = StringsKt.lastIndexOf$default((CharSequence)url, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
            boolean bl = false;
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            prefix = string3;
        }
        if (StringUtils.isNotEmpty((String)prefix)) {
            return songId + "." + prefix;
        }
        return songId + ".lrc";
    }

    private KTVDownloadUtils() {
    }

    static {
        KTVDownloadUtils kTVDownloadUtils;
        INSTANCE = kTVDownloadUtils = new KTVDownloadUtils();
        FOLDER_KTV = FOLDER_KTV;
        FOLDER_INSTRUMENTAL = FOLDER_INSTRUMENTAL;
        FOLDER_LYRIC = FOLDER_LYRIC;
        FOLDER_KTV_RECORD = FOLDER_KTV_RECORD;
    }
}

