/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.songlist;

import android.content.Context;
import android.content.DialogInterface;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.ui.dialog.OkCancelDialog;
import com.yy.appbase.ui.dialog.OkCancelDialogListener;
import com.yy.appbase.ui.widget.status.CommonStatusLayout;
import com.yy.base.env.RuntimeContext;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.framework.core.ui.BasePanel;
import com.yy.framework.core.ui.PanelLayer;
import com.yy.framework.core.ui.dialog.frame.BaseDialog;
import com.yy.framework.core.ui.dialog.frame.DialogLinkManager;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVHandler;
import com.yy.hiyo.channel.plugins.ktv.list.songlist.KTVSongListAdapter;
import com.yy.hiyo.channel.plugins.ktv.list.songlist.KTVSongListContract;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import java.util.List;

public class KTVSongListPanel
extends YYConstraintLayout
implements KTVSongListContract.View,
View.OnClickListener,
KTVSongListAdapter.OnItemClickListener {
    private BasePanel mPanel;
    private PanelLayer mLayer;
    private YYTextView mTvTitle;
    private YYTextView mTvOutside;
    private RecyclerView mRvSongList;
    private ConstraintLayout mClBtnChooseSong;
    private CommonStatusLayout mCslStatusLayout;
    private IKTVHandler mHandler;
    private DialogLinkManager mDialogLinkManager;
    private KTVSongListAdapter mAdapter;
    private KTVSongListContract.Presenter mPresenter;

    private KTVSongListPanel(Context context) {
        this(context, null);
    }

    private KTVSongListPanel(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private KTVSongListPanel(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public KTVSongListPanel(@NonNull PanelLayer layer, @NonNull IKTVHandler handler) {
        this(layer != null ? layer.getContext() : RuntimeContext.sApplicationContext);
        this.mLayer = layer;
        this.mHandler = handler;
        this.mDialogLinkManager = new DialogLinkManager(this.getContext());
        this.createView();
    }

    private void createView() {
        View view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_ktv_song_list_channel, (ViewGroup)this);
        this.mTvTitle = (YYTextView)view.findViewById(R.id.tv_title);
        this.mTvOutside = (YYTextView)view.findViewById(R.id.tv_outside);
        this.mRvSongList = (RecyclerView)view.findViewById(R.id.rv_list);
        this.mClBtnChooseSong = (ConstraintLayout)view.findViewById(R.id.cl_btn_choose_song);
        this.mCslStatusLayout = (CommonStatusLayout)view.findViewById(R.id.csl_status);
        this.mTvTitle.setVisibility(8);
        this.mCslStatusLayout.showLoading();
        this.mCslStatusLayout.showNoData(R.drawable.icon_default_no_data, null, (View)this.getNoDataExtendView());
        this.mTvOutside.setOnClickListener((View.OnClickListener)this);
        this.mClBtnChooseSong.setOnClickListener((View.OnClickListener)this);
        this.mAdapter = new KTVSongListAdapter(this.getContext(), this.mHandler);
        this.mAdapter.setOnClickListener(this);
        LinearLayoutManager layoutManager = new LinearLayoutManager(this.getContext());
        this.mRvSongList.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.mRvSongList.setAdapter((RecyclerView.Adapter)this.mAdapter);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
            }
        });
        this.mRvSongList.addOnScrollListener(new RecyclerView.OnScrollListener(){

            public void onScrollStateChanged(RecyclerView recyclerView, int newState) {
                super.onScrollStateChanged(recyclerView, newState);
            }

            public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                super.onScrolled(recyclerView, dx, dy);
                KTVSongListPanel.this.startPlayingSvga(recyclerView);
            }
        });
    }

    private void startPlayingSvga(RecyclerView recyclerView) {
        LinearLayoutManager llm;
        int position;
        int count = recyclerView.getChildCount();
        if (count > 0 && (position = (llm = (LinearLayoutManager)recyclerView.getLayoutManager()).findFirstVisibleItemPosition()) == 0) {
            final KTVSongListAdapter.MyViewHolder viewHolder = (KTVSongListAdapter.MyViewHolder)recyclerView.findViewHolderForAdapterPosition(0);
            SvgaLoader.load((SVGAImageView)viewHolder.svgaPlaying, (String)"playing_wave.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

                public void onFinished(SVGAVideoEntity entity) {
                    viewHolder.svgaPlaying.startAnimation();
                }

                public void onFailed(Exception e) {
                }
            });
        }
    }

    private YYLinearLayout getNoDataExtendView() {
        YYLinearLayout tipsContainer = new YYLinearLayout(this.getContext());
        tipsContainer.setOrientation(1);
        tipsContainer.setGravity(1);
        YYTextView tipOne = new YYTextView(this.getContext());
        tipOne.setIncludeFontPadding(false);
        tipOne.setGravity(17);
        tipOne.setTextSize(2, 17.0f);
        tipOne.setTextColor(ResourceUtils.getColor((int)R.color.color_0b0505));
        tipOne.setText((CharSequence)ResourceUtils.getString((int)R.string.short_tips_no_song));
        YYTextView tipTwo = new YYTextView(this.getContext());
        tipTwo.setIncludeFontPadding(false);
        tipTwo.setTextSize(2, 15.0f);
        tipTwo.setTextColor(ResourceUtils.getColor((int)R.color.color_999999));
        tipTwo.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_request_song_first));
        tipsContainer.addView((View)tipOne);
        tipsContainer.addView((View)tipTwo);
        LinearLayout.LayoutParams params = (LinearLayout.LayoutParams)tipTwo.getLayoutParams();
        if (params != null) {
            params.topMargin = ResolutionUtils.dip2Px((float)9.0f);
        }
        return tipsContainer;
    }

    public void setPresenter(KTVSongListContract.Presenter presenter) {
        this.mPresenter = presenter;
    }

    @Override
    public void show() {
        if (this.mLayer != null && !this.mLayer.hasPanelShowing()) {
            this.mPresenter.start();
            RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-1, -1);
            params.addRule(12);
            if (this.mPanel == null) {
                this.mPanel = new BasePanel(this.getContext());
            }
            this.mPanel.setShowAnim(this.mPanel.createBottomShowAnimation());
            this.mPanel.setHideAnim(this.mPanel.createBottomHideAnimation());
            this.mPanel.setContent((View)this, params);
            this.mLayer.showPanel(this.mPanel, true);
            KTVEventReportUtil.reportMusicListShow("9");
        }
    }

    @Override
    public void hide() {
        if (this.mLayer != null && this.mLayer.hasPanelShowing()) {
            this.mLayer.hideShowingPanel();
            this.mPresenter.stop();
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    KTVSongListPanel.this.mRvSongList.scrollToPosition(0);
                }
            }, (long)300L);
        }
    }

    @Override
    public void updateTitle(int songCount) {
        if (songCount == 0) {
            this.mTvTitle.setVisibility(8);
        } else {
            String title = String.format(ResourceUtils.getString((int)R.string.short_tips_song_list), String.valueOf(songCount));
            this.mTvTitle.setText((CharSequence)title);
            this.mTvTitle.setVisibility(0);
        }
    }

    @Override
    public void updateSongList(List<KTVRoomSongInfo> list) {
        if (!FP.empty(list)) {
            this.mCslStatusLayout.hideNoData();
        } else {
            this.mCslStatusLayout.showNoData(R.drawable.icon_default_no_data, null, (View)this.getNoDataExtendView());
        }
        this.mCslStatusLayout.hideLoading();
        this.updateTitle(list.size());
        this.mAdapter.setData(list);
    }

    @Override
    public void notifyDataSetChanged() {
        this.mAdapter.notifyDataSetChanged();
    }

    public void onClick(View v) {
        if (v.getId() == R.id.cl_btn_choose_song) {
            this.mPresenter.openSongLibrary();
            KTVEventReportUtil.reportOpenSongLib("3");
        } else if (v.getId() == R.id.tv_outside) {
            this.hide();
        }
    }

    @Override
    public void onItemDelete(final KTVRoomSongInfo songInfo) {
        OkCancelDialog dialog2 = new OkCancelDialog((CharSequence)ResourceUtils.getString((int)R.string.tips_delete_song), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_yes), (CharSequence)ResourceUtils.getString((int)R.string.dialog_btn_no), true, false, new OkCancelDialogListener(){

            public void onCancel() {
                if (KTVSongListPanel.this.mDialogLinkManager != null) {
                    KTVSongListPanel.this.mDialogLinkManager.dismissDialog();
                }
            }

            public void onOk() {
                KTVSongListPanel.this.mPresenter.deleteSong(songInfo);
            }
        });
        dialog2.setCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog2) {
                if (KTVSongListPanel.this.mDialogLinkManager != null) {
                    KTVSongListPanel.this.mDialogLinkManager.dismissDialog();
                }
            }
        });
        this.mDialogLinkManager.showDialog((BaseDialog)dialog2);
    }

    @Override
    public void onItemSetTop(KTVRoomSongInfo songInfo) {
        this.mPresenter.setTopSong(songInfo);
        KTVEventReportUtil.reportSongListTopClick();
    }
}

