/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.view;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.RoundConerImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYRelativeLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.plugins.ktv.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class KTVMusicItemAdapter
extends RecyclerView.Adapter<MyViewHolder> {
    public static final String TAG = "KTVMusicItemAdapter";
    public Context mContext;
    public Set<String> mIds;
    public ItemClickListener mItemListener;
    public TabClickListener mTabListener;
    public List<KTVMusicInfo> mSongList;
    public static final int TYPE_LIBRARY = 1;
    public static final int TYPE_HISTORY = 2;
    public static final int TYPE_SEARCH = 3;
    public static final int TYPE_SINGERS = 4;
    public static final int TYPE_RANKING = 5;
    private int mFromType;

    public KTVMusicItemAdapter(Context context, int fromType) {
        this.mContext = context;
        this.mIds = new HashSet<String>();
        this.mSongList = new ArrayList<KTVMusicInfo>();
        this.mFromType = fromType;
        if (this.mFromType == 1) {
            this.mSongList.add(KTVMusicInfo.newBuilder().build());
        }
    }

    public void setOnItemClickListener(ItemClickListener listener) {
        this.mItemListener = listener;
    }

    public void setOnTablickListener(TabClickListener listener) {
        this.mTabListener = listener;
    }

    public void setData(List<KTVMusicInfo> list) {
        if (!FP.empty(list)) {
            this.mIds.clear();
            Iterator<KTVMusicInfo> iterator = list.iterator();
            while (iterator.hasNext()) {
                KTVMusicInfo song = iterator.next();
                if (!this.mIds.contains(song.getSongId())) continue;
                iterator.remove();
            }
            this.mSongList.clear();
            if (this.mFromType == 1) {
                this.mSongList.add(KTVMusicInfo.newBuilder().build());
            }
            if (!FP.empty(list)) {
                this.mSongList.addAll(list);
            }
            this.notifyDataSetChanged();
        }
    }

    public int getItemCount() {
        if (!FP.empty(this.mSongList)) {
            return this.mSongList.size();
        }
        return 0;
    }

    @NonNull
    public MyViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_song_library_channel, parent, false);
        MyViewHolder viewHolder = new MyViewHolder(view);
        return viewHolder;
    }

    public void onBindViewHolder(@NonNull MyViewHolder holder, int position) {
        final KTVMusicInfo song = this.mSongList.get(position);
        if (position == this.mSongList.size() - 1) {
            holder.bottom.setVisibility(0);
        } else {
            holder.bottom.setVisibility(8);
        }
        if (song != null) {
            if (!TextUtils.isEmpty((CharSequence)song.getSongId())) {
                holder.songItem.setVisibility(0);
                holder.tabLayout.setVisibility(8);
            } else {
                holder.songItem.setVisibility(8);
                holder.tabLayout.setVisibility(0);
                Drawable drawableTopTab1 = this.mContext.getResources().getDrawable(R.drawable.ktv_songlist_ranking);
                holder.tab1Tv.setCompoundDrawablesWithIntrinsicBounds(null, drawableTopTab1, null, null);
                holder.tab1Tv.setText((CharSequence)ResourceUtils.getString((int)R.string.title_ktv_ranking_ab));
                Drawable drawableTopTab2 = this.mContext.getResources().getDrawable(R.drawable.ktv_songlist_singers);
                holder.tab2Tv.setCompoundDrawablesWithIntrinsicBounds(null, drawableTopTab2, null, null);
                holder.tab2Tv.setText((CharSequence)ResourceUtils.getString((int)R.string.title_ktv_singers));
                holder.tab1Tv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (KTVMusicItemAdapter.this.mTabListener != null) {
                            KTVMusicItemAdapter.this.mTabListener.onRankingClick();
                        }
                    }
                });
                holder.tab2Tv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (KTVMusicItemAdapter.this.mTabListener != null) {
                            KTVMusicItemAdapter.this.mTabListener.onSingersClick();
                        }
                    }
                });
                holder.tab3Tv.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (KTVMusicItemAdapter.this.mTabListener != null) {
                            KTVMusicItemAdapter.this.mTabListener.onRecordClick();
                        }
                    }
                });
            }
            ImageLoader.loadImage((RecycleImageView)holder.songCover, (String)(song.getCoverImageUrl() + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.icon_song_cover_default);
            holder.songName.setText((CharSequence)song.getSongName());
            holder.singer.setText((CharSequence)song.getArtistName());
            holder.btnSing.setSelected(song.isRequested());
            if (song.isRequested()) {
                holder.btnSing.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_ktv_requested));
            } else {
                holder.btnSing.setText((CharSequence)ResourceUtils.getString((int)R.string.btn_sing));
            }
            if (this.mFromType == 5 && position <= 2) {
                holder.crownIv.setVisibility(0);
                holder.rankTv.setVisibility(0);
                if (0 == position) {
                    holder.rankTv.setText((CharSequence)"1");
                    holder.rankTv.setBackgroundResource(R.drawable.ktv_ranking_1);
                    holder.crownIv.setImageResource(R.drawable.ktv_ranking_crown_1);
                } else if (1 == position) {
                    holder.rankTv.setText((CharSequence)"2");
                    holder.rankTv.setBackgroundResource(R.drawable.ktv_ranking_2);
                    holder.crownIv.setImageResource(R.drawable.ktv_ranking_crown_2);
                } else {
                    holder.rankTv.setText((CharSequence)"3");
                    holder.rankTv.setBackgroundResource(R.drawable.ktv_ranking_3);
                    holder.crownIv.setImageResource(R.drawable.ktv_ranking_crown_3);
                }
            } else {
                holder.crownIv.setVisibility(8);
                holder.rankTv.setVisibility(8);
            }
        }
        holder.btnSing.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (KTVMusicItemAdapter.this.mItemListener != null) {
                    KTVMusicItemAdapter.this.mItemListener.onItemClick(song);
                }
            }
        });
    }

    public static interface TabClickListener {
        public void onSingersClick();

        public void onRankingClick();

        public void onRecordClick();
    }

    public static interface ItemClickListener {
        public void onItemClick(KTVMusicInfo var1);
    }

    public class MyViewHolder
    extends RecyclerView.ViewHolder {
        public YYTextView singer;
        public YYTextView bottom;
        public YYTextView btnSing;
        public YYTextView songName;
        public YYRelativeLayout tabLayout;
        public ConstraintLayout songItem;
        public RoundConerImageView songCover;
        private YYTextView tab1Tv;
        private YYTextView tab2Tv;
        private YYTextView tab3Tv;
        private YYImageView crownIv;
        private YYTextView rankTv;

        public MyViewHolder(View view) {
            super(view);
            this.singer = (YYTextView)view.findViewById(R.id.tv_singer);
            this.bottom = (YYTextView)view.findViewById(R.id.tv_bottom);
            this.btnSing = (YYTextView)view.findViewById(R.id.tv_btn_sing);
            this.songName = (YYTextView)view.findViewById(R.id.tv_name);
            this.songCover = (RoundConerImageView)view.findViewById(R.id.rviv_cover);
            this.songItem = (ConstraintLayout)view.findViewById(R.id.cl_item);
            this.tabLayout = (YYRelativeLayout)view.findViewById(R.id.layout_tab);
            this.tab1Tv = (YYTextView)view.findViewById(R.id.tv_tab_1);
            this.tab2Tv = (YYTextView)view.findViewById(R.id.tv_tab_2);
            this.tab3Tv = (YYTextView)view.findViewById(R.id.tv_tab_3);
            this.crownIv = (YYImageView)view.findViewById(R.id.iv_crown);
            this.rankTv = (YYTextView)view.findViewById(R.id.tv_ranking);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface FromType {
    }
}

