/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.apiservice;

import android.content.Context;
import android.os.SystemClock;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.squareup.wire.AndroidMessage;
import com.yy.appbase.account.AccountUtil;
import com.yy.base.env.RuntimeContext;
import com.yy.base.logger.MLog;
import com.yy.base.utils.SettingFlagBaseKeys;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.network.NetworkUtils;
import com.yy.hiyo.channel.cbase.module.common.KtvRoomModel;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVAudioPosition;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.plugins.ktv.apiservice.KTVProtoHelper;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVProtoCallback;
import com.yy.hiyo.proto.ProtoManager;
import com.yy.hiyo.proto.callback.IProtoCallback;
import com.yy.hiyo.proto.callback.SimpleProtoCallback;
import com.yy.yylite.commonbase.hiido.HiidoStatis;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import net.ihago.bbs.srv.mgr.GetKTVDraftListReq;
import net.ihago.bbs.srv.mgr.GetKTVDraftListRes;
import net.ihago.bbs.srv.mgr.GetKTVDraftNumReq;
import net.ihago.bbs.srv.mgr.GetKTVDraftNumRes;
import net.ihago.bbs.srv.mgr.KTVDraft;
import net.ihago.bbs.srv.mgr.SaveKTVDraftReq;
import net.ihago.bbs.srv.mgr.SaveKTVDraftRes;
import net.ihago.ktv.api.biz.BroadcastTransmissionReq;
import net.ihago.ktv.api.biz.BroadcastTransmissionRsp;
import net.ihago.ktv.api.biz.ExtendKey;
import net.ihago.ktv.api.biz.GetRoomKaraokeInfoReq;
import net.ihago.ktv.api.biz.GetRoomKaraokeInfoRsp;
import net.ihago.ktv.api.biz.KaraokeAddSongReq;
import net.ihago.ktv.api.biz.KaraokeAddSongRsp;
import net.ihago.ktv.api.biz.KaraokeDelSongReq;
import net.ihago.ktv.api.biz.KaraokeDelSongRsp;
import net.ihago.ktv.api.biz.KaraokePauseSongReq;
import net.ihago.ktv.api.biz.KaraokePauseSongRsp;
import net.ihago.ktv.api.biz.KaraokeSongSetTopReq;
import net.ihago.ktv.api.biz.KaraokeSongSetTopRsp;
import net.ihago.ktv.api.biz.KaraokeStartSingReq;
import net.ihago.ktv.api.biz.KaraokeStartSingRsp;
import net.ihago.ktv.api.biz.KaraokeTerminateSongReq;
import net.ihago.ktv.api.biz.KaraokeTerminateSongRsp;
import net.ihago.ktv.api.biz.ReportAudioPositionReq;
import net.ihago.ktv.api.biz.ReportAudioPositionRsp;
import net.ihago.ktv.api.search.DirectlySearchReq;
import net.ihago.ktv.api.search.DirectlySearchRsp;
import net.ihago.ktv.api.search.GetHotRequest;
import net.ihago.ktv.api.search.GetHotResponse;
import net.ihago.ktv.api.search.GetRankingReq;
import net.ihago.ktv.api.search.GetRankingRsp;
import net.ihago.ktv.api.search.GetSingerReq;
import net.ihago.ktv.api.search.GetSingerRsp;
import net.ihago.ktv.api.search.GetSongBySingerReq;
import net.ihago.ktv.api.search.GetSongBySingerRsp;
import net.ihago.ktv.api.search.GetSuggestRequest;
import net.ihago.ktv.api.search.GetSuggestResponse;
import net.ihago.ktv.api.search.RankingType;
import net.ihago.ktv.api.search.RepoGetRequest;
import net.ihago.ktv.api.search.RepoGetResponse;
import net.ihago.ktv.api.search.SearchRequest;
import net.ihago.ktv.api.search.SearchResponse;
import net.ihago.ktv.api.search.SearchType;
import okio.ByteString;

public final class KTVProtoService {
    private KTVProtoService() {
    }

    public static KTVProtoService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void fetchKTVRoomOrderedSongList(String roomId, int offset, int queryCount, final @Nullable IKTVProtoCallback<GetRoomKaraokeInfoRsp> callback) {
        List<ExtendKey> extendKeys = Arrays.asList(ExtendKey.Nick, ExtendKey.Avatar, ExtendKey.SongName, ExtendKey.OriginalSinger);
        GetRoomKaraokeInfoReq req = new GetRoomKaraokeInfoReq.Builder().offset(Integer.valueOf(offset)).query_count(Integer.valueOf(queryCount)).keys(extendKeys).build();
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"KTVProtoService", (String)"req: %s", (Object[])new Object[]{req.toString()});
        }
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<GetRoomKaraokeInfoRsp>(){

            public void onResponse(@Nullable GetRoomKaraokeInfoRsp message) {
                if (message == null || message.common_ret == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvBizFail(message.common_ret)) {
                    KTVProtoHelper.handleOnError(callback, message.common_ret.err_code, message.common_ret.err_string);
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                long returnCode = -1L;
                if (message != null && message.common_ret != null) {
                    returnCode = message.common_ret.err_code.intValue();
                }
                KTVProtoService.statMetric("ktv/fetchSongInfo", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/fetchSongInfo", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void karaokeAddSong(@NonNull String roomId, String resourceId, final IKTVProtoCallback<KaraokeAddSongRsp> callback) {
        KaraokeAddSongReq req = new KaraokeAddSongReq.Builder().resource_id(resourceId).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<KaraokeAddSongRsp>(){

            public void onResponse(@Nullable KaraokeAddSongRsp message) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"KTVAddSong", (String)"receive add song response current time: %s", (Object[])new Object[]{System.currentTimeMillis()});
                }
                if (message == null || message.common_ret == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvBizFail(message.common_ret)) {
                    KTVProtoHelper.handleOnError(callback, message.common_ret.err_code, message.common_ret.err_string);
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                long returnCode = -1L;
                if (message != null && message.common_ret != null) {
                    returnCode = message.common_ret.err_code.intValue();
                }
                KTVProtoService.statMetric("ktv/addSong", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/addSong", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void karaokeStartSing(@NonNull String roomId, String songId, final IKTVProtoCallback<KaraokeStartSingRsp> callback) {
        KaraokeStartSingReq req = new KaraokeStartSingReq.Builder().song_id(songId).mode(KtvRoomModel.INSTANCE.getMVideoScheme()).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<KaraokeStartSingRsp>(){

            public void onResponse(@Nullable KaraokeStartSingRsp message) {
                if (message == null || message.common_ret == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvBizFail(message.common_ret)) {
                    KTVProtoHelper.handleOnError(callback, message.common_ret.err_code, message.common_ret.err_string);
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                long returnCode = -1L;
                if (message != null && message.common_ret != null) {
                    returnCode = message.common_ret.err_code.intValue();
                }
                KTVProtoService.statMetric("ktv/startSong", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/startSong", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void karaokeSongSetTop(@NonNull String roomId, String songId, final IKTVProtoCallback<KaraokeSongSetTopRsp> callback) {
        KaraokeSongSetTopReq req = new KaraokeSongSetTopReq.Builder().song_id(songId).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<KaraokeSongSetTopRsp>(){

            public void onResponse(@Nullable KaraokeSongSetTopRsp message) {
                if (message == null || message.common_ret == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvBizFail(message.common_ret)) {
                    KTVProtoHelper.handleOnError(callback, message.common_ret.err_code, message.common_ret.err_string);
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                long returnCode = -1L;
                if (message != null && message.common_ret != null) {
                    returnCode = message.common_ret.err_code.intValue();
                }
                KTVProtoService.statMetric("ktv/setTopSong", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/setTopSong", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void karaokeDeleteSong(@NonNull String roomId, String songId, final IKTVProtoCallback<KaraokeDelSongRsp> callback) {
        KaraokeDelSongReq req = new KaraokeDelSongReq.Builder().song_id(songId).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<KaraokeDelSongRsp>(){

            public void onResponse(@Nullable KaraokeDelSongRsp message) {
                if (message == null || message.common_ret == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvBizFail(message.common_ret)) {
                    KTVProtoHelper.handleOnError(callback, message.common_ret.err_code, message.common_ret.err_string);
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                long returnCode = -1L;
                if (message != null && message.common_ret != null) {
                    returnCode = message.common_ret.err_code.intValue();
                }
                KTVProtoService.statMetric("ktv/deleteSong", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/deleteSong", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void karaokePauseSong(@NonNull String roomId, String songId, final IKTVProtoCallback<KaraokePauseSongRsp> callback) {
        KaraokePauseSongReq req = new KaraokePauseSongReq.Builder().song_id(songId).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<KaraokePauseSongRsp>(){

            public void onResponse(@Nullable KaraokePauseSongRsp message) {
                if (message == null || message.common_ret == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvBizFail(message.common_ret)) {
                    KTVProtoHelper.handleOnError(callback, message.common_ret.err_code, message.common_ret.err_string);
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                long returnCode = -1L;
                if (message != null && message.common_ret != null) {
                    returnCode = message.common_ret.err_code.intValue();
                }
                KTVProtoService.statMetric("ktv/pauseSong", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/pauseSong", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void karaokeTerminateSong(@NonNull String roomId, String songId, int flag, final IKTVProtoCallback<KaraokeTerminateSongRsp> callback) {
        KaraokeTerminateSongReq req = new KaraokeTerminateSongReq.Builder().song_id(songId).flag(Integer.valueOf(flag)).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<KaraokeTerminateSongRsp>(){

            public void onResponse(@Nullable KaraokeTerminateSongRsp message) {
                if (message == null || message.common_ret == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvBizFail(message.common_ret)) {
                    KTVProtoHelper.handleOnError(callback, message.common_ret.err_code, message.common_ret.err_string);
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                long returnCode = -1L;
                if (message != null && message.common_ret != null) {
                    returnCode = message.common_ret.err_code.intValue();
                }
                KTVProtoService.statMetric("ktv/terminateSong", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/terminateSong", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void reportAudioPosition(@NonNull String roomId, @NonNull KTVAudioPosition position, final IKTVProtoCallback<ReportAudioPositionRsp> callback) {
        ReportAudioPositionReq req = new ReportAudioPositionReq.Builder().pos(KTVAudioPosition.convertTo((KTVAudioPosition)position)).build();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<ReportAudioPositionRsp>(){

            public void onResponse(@Nullable ReportAudioPositionRsp message) {
                if (message == null || message.common_ret == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvBizFail(message.common_ret)) {
                    KTVProtoHelper.handleOnError(callback, message.common_ret.err_code, message.common_ret.err_string);
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
            }
        });
    }

    public void broadcastTransmission(@NonNull String roomId, String content, final IKTVProtoCallback<BroadcastTransmissionRsp> callback) {
        ByteString data = ByteString.encodeString((String)content, (Charset)Charset.defaultCharset());
        BroadcastTransmissionReq req = new BroadcastTransmissionReq.Builder().data(data).build();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<BroadcastTransmissionRsp>(){

            public void onResponse(@Nullable BroadcastTransmissionRsp message) {
                if (message == null || message.common_ret == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvBizFail(message.common_ret)) {
                    KTVProtoHelper.handleOnError(callback, message.common_ret.err_code, message.common_ret.err_string);
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
            }
        });
    }

    public void search(@NonNull String roomId, String query, String cursor, SearchType searchType, final @NonNull IKTVProtoCallback<SearchResponse> callback) {
        SearchRequest request = new SearchRequest.Builder().query(query).cursor(cursor).type(searchType).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<SearchResponse>(){

            public void onResponse(@Nullable SearchResponse message) {
                if (message == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (message.err_code != 404L && KTVProtoHelper.isKtvSearchFail(message.err_code)) {
                    KTVProtoHelper.handleOnError(callback, message.err_code.intValue(), "search target song error.");
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                KTVProtoService.statMetric("ktv/searchSong", SystemClock.uptimeMillis() - startTime, true, message == null ? -1L : message.err_code);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/searchSong", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void fetchSongLibrary(@NonNull String roomId, @NonNull String cursor, final @NonNull IKTVProtoCallback<GetHotResponse> callback) {
        GetHotRequest request = new GetHotRequest.Builder().cursor(cursor).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<GetHotResponse>(){

            public void onResponse(@Nullable GetHotResponse message) {
                if (message == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvSearchFail(message.err_code)) {
                    KTVProtoHelper.handleOnError(callback, message.err_code.intValue(), "fetch song library error.");
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                KTVProtoService.statMetric("ktv/fetchSongLibrary", SystemClock.uptimeMillis() - startTime, true, message == null ? -1L : message.err_code);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/fetchSongLibrary", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void fetchSongByResourceId(@NonNull String roomId, @NonNull String resourceId, final @NonNull IKTVProtoCallback<RepoGetResponse> callback) {
        RepoGetRequest request = new RepoGetRequest.Builder().song_id(resourceId).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<RepoGetResponse>(){

            public void onResponse(@Nullable RepoGetResponse message) {
                if (message == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvSearchFail(message.err_code)) {
                    KTVProtoHelper.handleOnError(callback, message.err_code.intValue(), "query target song library error.");
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                KTVProtoService.statMetric("ktv/fetchSongByResourceId", SystemClock.uptimeMillis() - startTime, true, message == null ? -1L : message.err_code);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/fetchSongByResourceId", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void fetchSingers(@NonNull String roomId, final @NonNull IKTVProtoCallback<GetSingerRsp> callback) {
        GetSingerReq request = new GetSingerReq.Builder().build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<GetSingerRsp>(){

            public void onResponse(@Nullable GetSingerRsp message) {
                if (message == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvSearchFail(message.err_code)) {
                    KTVProtoHelper.handleOnError(callback, message.err_code.intValue(), "fetch all singers error.");
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                long returnCode = -1L;
                if (message != null) {
                    returnCode = message.err_code;
                }
                KTVProtoService.statMetric("ktv/fetchSingers", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/fetchSingers", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void fetchRankingList(@NonNull String roomId, RankingType type, String cursor, final @NonNull IKTVProtoCallback<GetRankingRsp> callback) {
        GetRankingReq request = new GetRankingReq.Builder().type(type).cursor(cursor).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<GetRankingRsp>(){

            public void onResponse(@Nullable GetRankingRsp message) {
                if (message == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvSearchFail(message.err_code)) {
                    KTVProtoHelper.handleOnError(callback, message.err_code.intValue(), "fetch ranking error.");
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                long returnCode = -1L;
                if (message != null) {
                    returnCode = message.err_code;
                }
                KTVProtoService.statMetric("ktv/fetchRankingList", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/fetchRankingList", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void fetchSingerSongList(@NonNull String roomId, long singerId, String cursor, final @NonNull IKTVProtoCallback<GetSongBySingerRsp> callback) {
        GetSongBySingerReq request = new GetSongBySingerReq.Builder().singer_id(Long.valueOf(singerId)).cursor(cursor).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendHttp(roomId, (AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<GetSongBySingerRsp>(){

            public void onResponse(@Nullable GetSongBySingerRsp message) {
                if (message == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvSearchFail(message.err_code)) {
                    KTVProtoHelper.handleOnError(callback, message.err_code.intValue(), "fetch singers song error.");
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                }
                long returnCode = -1L;
                if (message != null) {
                    returnCode = message.err_code;
                }
                KTVProtoService.statMetric("ktv/fetchSingerSongList", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/fetchSingerSongList", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void saveKtvWorksToServer(String digest, String audioUrl, String lyricUrl, KTVRoomSongInfo songInfo, final @NonNull IKTVProtoCallback<SaveKTVDraftRes> callback) {
        KTVDraft draft = new KTVDraft.Builder().digest(digest).audio_url(audioUrl).lyric_url(lyricUrl).uid(Long.valueOf(songInfo.getUid())).song_id(songInfo.getResourceId()).song_name(songInfo.getSongName()).cover_url(songInfo.getCoverImageUrl()).nick(songInfo.getOriginalSinger()).build();
        SaveKTVDraftReq request = new SaveKTVDraftReq.Builder().draft(draft).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<SaveKTVDraftRes>(){

            public void onResponse(@NonNull SaveKTVDraftRes res, long code, String msg) {
                if (res == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, res);
                }
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
            }
        });
    }

    public void fetchKtvWorksList(final @NonNull IKTVProtoCallback<GetKTVDraftListRes> callback) {
        GetKTVDraftListReq request = new GetKTVDraftListReq.Builder().uid(Long.valueOf(AccountUtil.getUid())).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<GetKTVDraftListRes>(){

            public void onResponse(@NonNull GetKTVDraftListRes res, long code, String msg) {
                if (res == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, res);
                }
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
            }
        });
    }

    public void fetchKtvWorksNum(final @NonNull IKTVProtoCallback<GetKTVDraftNumRes> callback) {
        GetKTVDraftNumReq request = new GetKTVDraftNumReq.Builder().uid(Long.valueOf(AccountUtil.getUid())).build();
        ProtoManager.getInstance().sendRpc((AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<GetKTVDraftNumRes>(){

            public void onResponse(@NonNull GetKTVDraftNumRes res, long code, String msg) {
                if (res == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else {
                    KTVProtoHelper.handleOnSuccess(callback, res);
                }
            }

            public void onError(String reason, int code) {
                KTVProtoHelper.handleOnError(callback, code, reason);
            }
        });
    }

    public void ktvAssociateSearch(@NonNull String roomId, String keyWord, final @NonNull IKTVProtoCallback<GetSuggestResponse> callback) {
        GetSuggestRequest request = new GetSuggestRequest.Builder().query(keyWord).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)request, (IProtoCallback)new SimpleProtoCallback<GetSuggestResponse>(){

            public void onResponse(@Nullable GetSuggestResponse message) {
                super.onResponse((AndroidMessage)message);
                if (message == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (message.err_code != 404L) {
                    if (message.err_code == 0L) {
                        KTVProtoHelper.handleOnSuccess(callback, message);
                    } else {
                        callback.onError(message.err_code.intValue(), "\u670d\u52a1\u5668\u51fa\u9519");
                    }
                }
                long returnCode = -1L;
                if (message != null) {
                    returnCode = message.err_code;
                }
                KTVProtoService.statMetric("ktv/associateSearch", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                KTVProtoService.statMetric("ktv/associateSearch", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    public void directlySearch(@NonNull String roomId, String keyWord, String cursor, final @NonNull IKTVProtoCallback<DirectlySearchRsp> callback) {
        DirectlySearchReq req = new DirectlySearchReq.Builder().query(keyWord).cursor(cursor).build();
        final long startTime = SystemClock.uptimeMillis();
        ProtoManager.getInstance().sendRpc(roomId, (AndroidMessage)req, (IProtoCallback)new SimpleProtoCallback<DirectlySearchRsp>(){

            public void onResponse(@Nullable DirectlySearchRsp message) {
                super.onResponse((AndroidMessage)message);
                if (message == null) {
                    KTVProtoHelper.handleOnError(callback, -1000, "result is null");
                } else if (KTVProtoHelper.isKtvSearchSuccess(message.err_code)) {
                    KTVProtoHelper.handleOnSuccess(callback, message);
                } else {
                    KTVProtoHelper.handleOnError(callback, message.err_code.intValue(), "search target song error.");
                }
                long returnCode = -1L;
                if (message != null) {
                    returnCode = message.err_code;
                }
                KTVProtoService.statMetric("ktv/directlySearch", SystemClock.uptimeMillis() - startTime, true, returnCode);
            }

            public void onError(String reason, int code) {
                super.onError(reason, code);
                KTVProtoHelper.handleOnError(callback, code, reason);
                KTVProtoService.statMetric("ktv/directlySearch", SystemClock.uptimeMillis() - startTime, false, code);
            }
        });
    }

    private static void statMetric(String key, long useTime, boolean success, long errorCode) {
        if (SettingFlagBaseKeys.isNormalMetricSwitchOn() || SettingFlags.getBoolean((String)"ktvmetrics", (boolean)false)) {
            if (!NetworkUtils.isNetworkAvailable((Context)RuntimeContext.sApplicationContext) && !success) {
                errorCode = 250L;
            }
            HiidoStatis.reportAppMonitorReturnCode((String)key, (long)useTime, (String)String.valueOf(success ? 0L : errorCode));
        }
    }

    private static final class SingletonHolder {
        static final KTVProtoService INSTANCE = new KTVProtoService();

        private SingletonHolder() {
        }
    }
}

