/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.upload.scan;

import android.content.Context;
import android.os.Message;
import com.yy.appbase.core.DefaultController;
import com.yy.appbase.data.MusicPlaylistDBBean;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.FP;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.framework.core.BaseMsgDef;
import com.yy.framework.core.Environment;
import com.yy.framework.core.ui.AbstractWindow;
import com.yy.hiyo.channel.component.music.addmusic.mvp.AddMusicPresenter;
import com.yy.hiyo.channel.component.music.addmusic.utils.ScanMusicManager;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.upload.scan.KTVScanLocalMusicWindow;
import java.util.List;

public class KTVScanLocalMusicController
extends DefaultController {
    private KTVScanLocalMusicWindow mWindow;
    private boolean mNeedToast;

    public KTVScanLocalMusicController(Environment environment) {
        super(environment);
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (msg.what == BaseMsgDef.OPEN_KTV_SCAN_LOCAL_MUSIC_WINDOW) {
            if (this.mWindow != null) {
                this.mWindowMgr.popWindow(false, (AbstractWindow)this.mWindow);
            }
            this.mWindow = new KTVScanLocalMusicWindow(this.mContext, this);
            this.mWindowMgr.pushWindow((AbstractWindow)this.mWindow, true);
            this.getMusicFiles(false);
        }
    }

    public void closeWindow() {
        if (this.mWindow != null) {
            this.mWindowMgr.popWindow(true, (AbstractWindow)this.mWindow);
        }
        this.mWindow = null;
    }

    public void onWindowDetach(AbstractWindow abstractWindow) {
        super.onWindowDetach(abstractWindow);
        if (this.mWindow == abstractWindow) {
            this.mWindow = null;
        }
    }

    public void getMusicFiles(boolean isRefresh) {
        if (this.mWindow != null) {
            this.mWindow.showLoading();
        }
        if (isRefresh) {
            this.mNeedToast = true;
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (KTVScanLocalMusicController.this.mWindow != null && KTVScanLocalMusicController.this.mNeedToast) {
                        ToastUtils.showToast((Context)KTVScanLocalMusicController.this.mContext, (String)ResourceUtils.getString((int)R.string.short_tips_wait_proceeding_files), (int)0);
                    }
                }
            }, (long)8000L);
            ScanMusicManager.INSTANCE.updateMedia(this.mContext, new AddMusicPresenter.IUpdateMediaCallback(){

                public void updateMediaSucceed() {
                    KTVScanLocalMusicController.this.mNeedToast = false;
                    List localList = ScanMusicManager.INSTANCE.getMusicData(KTVScanLocalMusicController.this.mContext);
                    KTVScanLocalMusicController.this.updateLocalMusicList(localList);
                }
            });
        } else {
            List localList = ScanMusicManager.INSTANCE.getMusicData(this.mContext);
            this.updateLocalMusicList(localList);
        }
    }

    private void updateLocalMusicList(List<MusicPlaylistDBBean> list) {
        if (this.mWindow != null) {
            this.mWindow.hideLoading();
            if (FP.empty(list)) {
                this.mWindow.showNoData();
            } else {
                this.mWindow.hideNoData();
            }
            this.mWindow.updateMusicList(list);
        }
    }
}

