/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.panel.view;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.animation.TimeInterpolator;
import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.LinearInterpolator;
import android.widget.ImageView;
import android.widget.ProgressBar;
import androidx.annotation.Nullable;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.appbase.unifyconfig.BssCode;
import com.yy.appbase.unifyconfig.UnifyConfig;
import com.yy.appbase.unifyconfig.config.KtvWorksEntranceConfig;
import com.yy.appbase.util.RepeatClickUtils;
import com.yy.appbase.util.ScreenWrapperUtils;
import com.yy.appbase.util.ShortNameUtils;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYConstraintLayout;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYLinearLayout;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.DateUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.base.utils.SettingFlags;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.YYImageUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.base.bean.KTVPopularityData;
import com.yy.hiyo.channel.base.bean.KtvPopularitySingEnd;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.panel.view.IPanelViewState;
import com.yy.hiyo.channel.plugins.ktv.panel.view.IPanelVisibleListener;
import com.yy.hiyo.channel.plugins.ktv.widget.ktvmedal.KtvMedalView;
import com.yy.hiyo.channel.service.ktv.IKTVService;
import com.yy.hiyo.game.service.IGameAudioService;
import com.yy.hiyo.wallet.base.revenue.gift.GiftUtils;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.PackageGiftInfo;
import java.util.Calendar;
import java.util.Date;
import net.ihago.ktv.srv.popularity.PopLevelAwardConfig;
import net.ihago.ktv.srv.popularity.PopLevelInfo;
import net.ihago.ktv.srv.popularity.RoomPopStageInfo;

public class KTVEndingPanelView
extends YYConstraintLayout
implements IPanelViewState,
View.OnClickListener {
    private YYTextView countdownTv;
    private SVGAImageView clapSvga;
    private View mNormalEndingLayout;
    private YYTextView songTv;
    private YYTextView nameTv;
    private CircleImageView avatarIv;
    private YYLinearLayout guideLayout;
    private YYTextView mSaveBtn;
    private YYTextView mShareBtn;
    private RecycleImageView mGiftIv;
    private RecycleImageView mDiamondImg;
    private YYTextView mGiftTv;
    private View mGiftLayout;
    private View mShareContainer;
    private KtvMedalView mViewKtvMedal;
    private View mLevelEndingLayout;
    private CircleImageView ivLevelAvatar;
    private YYTextView tvCurrentLevel;
    private YYTextView tvNextLevel;
    private ProgressBar mLevelProgressBar;
    private YYTextView tvRoundValue;
    private YYImageView ivLevelSaveBtn;
    private YYImageView ivLevelShareBtn;
    private YYTextView tvLevelProgress;
    private IEndingPanelListner mListener;
    private KTVRoomSongInfo mSongInfo;
    private AnimatorSet guideAnim;
    private static final int COUNTDOWN = 10;
    private int mLeftTime = 0;
    private PackageGiftInfo packageGiftInfo;
    private boolean isShowing = false;
    private KvoBinder mBinder = new KvoBinder((Object)this);
    private String mCid = "";
    private boolean packageInitFinish = false;
    private Runnable countdownTask = new Runnable(){

        @Override
        public void run() {
            if (0 >= KTVEndingPanelView.this.mLeftTime) {
                KTVEndingPanelView.this.isShowing = false;
                if (null != KTVEndingPanelView.this.mListener) {
                    KTVEndingPanelView.this.mListener.onIdleStateEnd();
                }
                return;
            }
            KTVEndingPanelView.this.countdownTv.setText((CharSequence)ResourceUtils.getString((int)R.string.tips_ktv_ending_coundown, (Object[])new Object[]{KTVEndingPanelView.this.mLeftTime}));
            KTVEndingPanelView.this.mLeftTime--;
            YYTaskExecutor.postToMainThread((Runnable)KTVEndingPanelView.this.countdownTask, (long)1000L);
        }
    };

    public KTVEndingPanelView(Context context) {
        this(context, null);
    }

    public void setCurrentCid(String cid) {
        this.mCid = cid;
        this.mBinder.singleBindSourceTo((KvoSource)((IKTVService)ServiceManagerProxy.getService(IKTVService.class)).getPopularityService().data(cid));
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public KTVEndingPanelView(Context context, AttributeSet attrs) {
        super(context, attrs);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_ktv_ending_panel_channel, (ViewGroup)this, true);
        this.mNormalEndingLayout = this.findViewById(R.id.normal_ending_layout);
        this.countdownTv = (YYTextView)this.findViewById(R.id.tv_countdown);
        this.songTv = (YYTextView)this.findViewById(R.id.tv_song_name);
        this.nameTv = (YYTextView)this.findViewById(R.id.tv_nick);
        this.avatarIv = (CircleImageView)this.findViewById(R.id.civ_avatar);
        this.guideLayout = (YYLinearLayout)this.findViewById(R.id.layout_guide);
        this.clapSvga = (SVGAImageView)this.findViewById(R.id.svga_clap);
        this.mShareContainer = this.findViewById(R.id.layout_share_container);
        this.mShareBtn = (YYTextView)this.findViewById(R.id.btn_song_share);
        this.mGiftLayout = this.findViewById(R.id.giftLayout);
        this.mGiftIv = (RecycleImageView)this.findViewById(R.id.giftIv);
        this.mGiftTv = (YYTextView)this.findViewById(R.id.giftTv);
        this.mDiamondImg = (RecycleImageView)this.findViewById(R.id.diamondImg);
        this.mLevelEndingLayout = this.findViewById(R.id.level_ending_layout);
        this.mLevelEndingLayout.setVisibility(8);
        this.ivLevelAvatar = (CircleImageView)this.findViewById(R.id.iv_avatar);
        this.tvCurrentLevel = (YYTextView)this.findViewById(R.id.tv_current_level);
        this.tvNextLevel = (YYTextView)this.findViewById(R.id.tv_next_level);
        this.mLevelProgressBar = (ProgressBar)this.findViewById(R.id.ktv_end_progress);
        this.tvRoundValue = (YYTextView)this.findViewById(R.id.tv_round_value);
        this.tvLevelProgress = (YYTextView)this.findViewById(R.id.tv_ktv_progress);
        this.ivLevelShareBtn = (YYImageView)this.findViewById(R.id.iv_share);
        this.ivLevelSaveBtn = (YYImageView)this.findViewById(R.id.iv_download);
        this.mViewKtvMedal = (KtvMedalView)this.findViewById(R.id.view_ktv_medal);
        this.mShareBtn.setOnClickListener((View.OnClickListener)this);
        this.ivLevelShareBtn.setOnClickListener((View.OnClickListener)this);
        this.ivLevelSaveBtn.setOnClickListener((View.OnClickListener)this);
        this.avatarIv.setOnClickListener((View.OnClickListener)this);
        this.setBackgroundResource(R.drawable.shape_ktv_panel_bg);
        ViewGroup.LayoutParams lp = new ViewGroup.LayoutParams(-1, -1);
        this.setLayoutParams(lp);
        if (this.isKtvWorksSaveShow()) {
            this.mSaveBtn = (YYTextView)this.findViewById(R.id.btn_song_save);
            this.mSaveBtn.setVisibility(0);
            this.mSaveBtn.setOnTouchListener((v, event) -> {
                if (event.getAction() == 0) {
                    this.mSaveBtn.setAlpha(0.6f);
                }
                if (event.getAction() == 3) {
                    this.mSaveBtn.setAlpha(1.0f);
                }
                if (event.getAction() == 1) {
                    this.mSaveBtn.setAlpha(1.0f);
                    if (null != this.mListener && RepeatClickUtils.canRepeatClick((String)"ktv_works_save_click")) {
                        this.mListener.clickSave();
                    }
                }
                return true;
            });
        }
    }

    public void setShareAndSaveShow(boolean isShow) {
        if (this.mShareContainer == null) {
            return;
        }
        if (this.mSongInfo == null || !this.mSongInfo.isSinger()) {
            MLog.info((Object)"KTVEndingPanelView", (String)"setShareAndSaveShow is not singer", (Object[])new Object[0]);
            return;
        }
        if (isShow) {
            this.mShareContainer.setVisibility(0);
        } else {
            this.mShareContainer.setVisibility(8);
            this.startClapAnim();
        }
    }

    public void setOnEndingPanelListner(IEndingPanelListner listner) {
        this.mListener = listner;
    }

    @Override
    public void onPanelViewShow(boolean isSinger, boolean isPause) {
        if (null == this.mSongInfo) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"show KTVEndingPanelView songInfo=null", (Object[])new Object[0]);
            return;
        }
        this.isShowing = true;
        if (null != ServiceManagerProxy.getServiceManager() && null != ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)) {
            ((IGameAudioService)ServiceManagerProxy.getServiceManager().getService(IGameAudioService.class)).play("ktv_song_ending_show");
        }
        this.mLevelEndingLayout.setVisibility(8);
        this.mNormalEndingLayout.setVisibility(0);
        this.refreshEndContent();
        if (this.mSongInfo.isSinger()) {
            this.guideLayout.setVisibility(8);
            this.mGiftLayout.setVisibility(8);
            this.mShareContainer.setVisibility(0);
        } else {
            this.mShareContainer.setVisibility(8);
            if (this.mGiftLayout.getTag() != null) {
                this.mGiftLayout.setVisibility(0);
            } else {
                this.mGiftLayout.setVisibility(8);
            }
            String guideShowedDay = SettingFlags.getStringValue((String)"key_ktv_ending_gift_guide", (String)"");
            String today = DateUtils.dateToString((Date)Calendar.getInstance().getTime(), (String)"yyyy-MM-dd");
            if (!StringUtils.equal((String)guideShowedDay, (String)today) && this.mGiftLayout.getTag() != null) {
                this.startGuideAnim();
                SettingFlags.setStringValue((String)"key_ktv_ending_gift_guide", (String)today);
            } else {
                this.guideLayout.setVisibility(8);
            }
            this.startClapAnim();
        }
        this.songTv.setText((CharSequence)this.mSongInfo.getSongName());
        this.nameTv.setText((CharSequence)StringUtils.getHtmlText((int)R.string.tips_ktv_ending_singer, (Object[])new Object[]{ShortNameUtils.getShortNameWithoutColon((String)this.mSongInfo.getNick(), (int)9)}));
        ImageLoader.loadImage((ImageView)this.avatarIv, (String)(this.mSongInfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (Drawable)ResourceUtils.getDrawable((int)R.drawable.profile_default_header));
        this.mLeftTime = 10;
        YYTaskExecutor.postToMainThread((Runnable)this.countdownTask);
        if (this.mListener != null) {
            this.post(() -> this.mListener.onChangedVisible());
        }
    }

    private void startClapAnim() {
        SvgaLoader.load((SVGAImageView)this.clapSvga, (String)"ktv_ending_clap.svga", (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity entity) {
                if (null != KTVEndingPanelView.this.clapSvga) {
                    KTVEndingPanelView.this.clapSvga.startAnimation();
                }
            }

            public void onFailed(Exception e) {
            }
        });
    }

    private void startGuideAnim() {
        if (null == this.guideAnim) {
            this.guideAnim = new AnimatorSet();
            ObjectAnimator translationAnim = ObjectAnimator.ofFloat((Object)this.guideLayout, (String)"translationY", (float[])new float[]{0.0f, 15.0f, 0.0f, -15.0f, 0.0f});
            translationAnim.setDuration(2000L);
            translationAnim.setInterpolator((TimeInterpolator)new LinearInterpolator());
            translationAnim.setRepeatCount(-1);
            PropertyValuesHolder holder1 = PropertyValuesHolder.ofFloat((String)"alpha", (float[])new float[]{0.0f, 1.0f});
            PropertyValuesHolder holder2 = PropertyValuesHolder.ofFloat((String)"scaleX", (float[])new float[]{0.0f, 1.0f});
            PropertyValuesHolder holder3 = PropertyValuesHolder.ofFloat((String)"scaleY", (float[])new float[]{0.0f, 1.0f});
            ObjectAnimator scaleAnim = ObjectAnimator.ofPropertyValuesHolder((Object)this.guideLayout, (PropertyValuesHolder[])new PropertyValuesHolder[]{holder1, holder2, holder3});
            scaleAnim.setDuration(500L);
            this.guideAnim.play((Animator)translationAnim).with((Animator)scaleAnim);
        }
        this.guideAnim.start();
        this.guideLayout.setVisibility(0);
        if (null != this.mListener) {
            this.mListener.guideShow();
        }
    }

    @Override
    public void onPanelViewHide() {
        this.mLeftTime = 0;
        this.isShowing = false;
        YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.countdownTask);
        if (null != this.guideAnim) {
            this.guideAnim.cancel();
        }
    }

    @Override
    public void onIsPauseState(boolean isPause) {
    }

    public void onClick(View v) {
        if (v.getId() == R.id.btn_song_share || v.getId() == R.id.iv_share) {
            if (null != this.mListener) {
                this.mListener.clickShare();
            }
        } else if (v.getId() == R.id.giftLayout) {
            if (null != this.mListener && v.getTag() instanceof GiftItemInfo && this.mSongInfo != null) {
                this.mListener.clickGift(this.mSongInfo, (GiftItemInfo)v.getTag());
            }
        } else if (v.getId() == R.id.civ_avatar) {
            if (null != this.mListener && this.mSongInfo != null) {
                this.mListener.onSingerAvatarClick(this.mSongInfo.getUid());
            }
        } else if (v.getId() == R.id.iv_download && null != this.mListener) {
            this.mListener.clickSave();
        }
    }

    private boolean isKtvWorksSaveShow() {
        KtvWorksEntranceConfig config = (KtvWorksEntranceConfig)UnifyConfig.INSTANCE.getConfigData(BssCode.KTV_WORKS_SAVE_ENTRANCE);
        return config != null && config.getKtvWorksEntranceData() != null && config.getKtvWorksEntranceData().isShow();
    }

    @Override
    public boolean isShowing() {
        return this.isShowing;
    }

    @Override
    @Nullable
    public Point getAvatarPoint() {
        int[] loction = new int[2];
        if (this.mLevelEndingLayout.getVisibility() == 0) {
            ScreenWrapperUtils.INSTANCE.getViewPoint((View)this.ivLevelAvatar, false, loction);
        } else {
            ScreenWrapperUtils.INSTANCE.getViewPoint((View)this.avatarIv, false, loction);
        }
        return new Point(loction[0], loction[1]);
    }

    public void setKTVRoomSongInfo(KTVRoomSongInfo mSongInfo) {
        this.mSongInfo = mSongInfo;
    }

    public void setGiftInfo(@Nullable PackageGiftInfo giftInfo) {
        this.packageGiftInfo = giftInfo;
        if (giftInfo == null || giftInfo.getGiftItemInfo() == null || !this.packageInitFinish) {
            this.mGiftLayout.setTag(null);
            this.mGiftLayout.setOnClickListener(null);
            this.mGiftLayout.setVisibility(8);
        } else {
            this.mGiftLayout.setTag((Object)giftInfo.getGiftItemInfo());
            ImageLoader.loadImage((ImageView)this.mGiftIv, (String)(giftInfo.getGiftItemInfo().getStaticIcon() + YYImageUtils.getThumbnailPostfix((int)75)));
            if (giftInfo.getCount() > 0) {
                this.mDiamondImg.setVisibility(8);
                this.mGiftTv.setText((CharSequence)("x" + giftInfo.getCount()));
            } else {
                this.mDiamondImg.setVisibility(0);
                this.mGiftTv.setText((CharSequence)String.valueOf(GiftUtils.giftPrice((GiftItemInfo)giftInfo.getGiftItemInfo())));
            }
            this.mGiftLayout.setOnClickListener((View.OnClickListener)this);
        }
    }

    public void onPackageInitFinish() {
        this.packageInitFinish = true;
        this.setGiftInfo(this.packageGiftInfo);
    }

    public void destroy() {
        this.mBinder.clearAllKvoConnections();
        this.packageInitFinish = false;
        this.packageGiftInfo = null;
    }

    @KvoMethodAnnotation(sourceClass=KTVPopularityData.class, name="kvo_singEnd", thread=1)
    public void onKtvEndingNotify(KvoEventIntent event) {
        if (event.newValue() instanceof KtvPopularitySingEnd) {
            KtvPopularitySingEnd data = (KtvPopularitySingEnd)event.newValue();
            if (data.getUid() <= 0L || TextUtils.isEmpty((CharSequence)data.getSongId())) {
                return;
            }
            this.refreshEndContent();
        }
    }

    private void refreshEndContent() {
        if (this.mSongInfo == null || !this.mSongInfo.isSinger()) {
            return;
        }
        KTVPopularityData data = ((IKTVService)ServiceManagerProxy.getService(IKTVService.class)).getPopularityService().data(this.mCid);
        if (data.getSingEndVersion().getUid() != this.mSongInfo.getUid() || !StringUtils.equal((String)data.getSingEndVersion().getSongId(), (String)this.mSongInfo.getSongId())) {
            return;
        }
        String key = data.getStageInfoKey(this.mSongInfo.getUid(), this.mSongInfo.getSongId());
        RoomPopStageInfo stageInfo = (RoomPopStageInfo)data.getStageInfo().get(key);
        if (stageInfo == null || stageInfo.stage_value <= 0L) {
            return;
        }
        PopLevelInfo info = (PopLevelInfo)data.getLevelInfo().get(this.mSongInfo.getUid());
        if (info == null) {
            return;
        }
        this.mLevelEndingLayout.setVisibility(0);
        this.mNormalEndingLayout.setVisibility(8);
        if (this.mListener != null) {
            this.mListener.onLevelEndingShown();
            this.post(() -> this.mListener.onChangedVisible());
        }
        this.mViewKtvMedal.setPopularityLevel(info.level, info.uid);
        this.tvCurrentLevel.setText((CharSequence)String.format(ResourceUtils.getString((int)R.string.user_level_lv_prefix), info.level));
        PopLevelAwardConfig nextConfig = ((IKTVService)ServiceManagerProxy.getService(IKTVService.class)).getPopularityService().getPopLevelAwardConfigByLevel(info.level + 1);
        if (nextConfig == null) {
            this.tvNextLevel.setVisibility(8);
        } else {
            this.tvNextLevel.setVisibility(0);
            this.tvNextLevel.setText((CharSequence)String.format(ResourceUtils.getString((int)R.string.user_level_lv_prefix), info.level + 1));
        }
        this.tvRoundValue.setText((CharSequence)("+" + stageInfo.stage_value));
        ImageLoader.loadImage((ImageView)this.ivLevelAvatar, (String)(this.mSongInfo.getAvatar() + YYImageUtils.getThumbnailPostfix((int)75)), (Drawable)ResourceUtils.getDrawable((int)R.drawable.profile_default_header));
        PopLevelAwardConfig config = ((IKTVService)ServiceManagerProxy.getService(IKTVService.class)).getPopularityService().getPopLevelAwardConfigByLevel(info.level.intValue());
        if (config == null) {
            return;
        }
        float progress = info.score.floatValue() / (float)config.score.longValue() * 100.0f;
        this.mLevelProgressBar.setProgress((int)progress);
        this.tvLevelProgress.setText((CharSequence)StringUtils.format((String)"%d/%d", (Object[])new Object[]{info.score, config.score}));
    }

    public static interface IEndingPanelListner
    extends IPanelVisibleListener {
        public void onIdleStateEnd();

        public void onSingerAvatarClick(long var1);

        public void guideShow();

        public void clickSave();

        public void clickShare();

        public void clickGift(KTVRoomSongInfo var1, GiftItemInfo var2);

        public void onLevelEndingShown();
    }
}

