/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.panel;

import android.app.Activity;
import android.graphics.Point;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.permission.helper.IPermissionListener;
import com.yy.appbase.permission.helper.PermissionHelper;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.framework.core.Notification;
import com.yy.framework.core.NotificationCenter;
import com.yy.hiyo.channel.base.service.IEnteredChannel;
import com.yy.hiyo.channel.cbase.AbsPage;
import com.yy.hiyo.channel.cbase.context.IChannelPageContext;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.cbase.module.ktv.room.IKTVRoomService;
import com.yy.hiyo.channel.cbase.tools.IRevenueToolsModulePresenter;
import com.yy.hiyo.channel.service.media.AudioNotifyDef;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0010J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eH\u0002J\u000e\u0010\u0018\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000eJ\u0006\u0010\u0019\u001a\u00020\u0010J\b\u0010\u001a\u001a\u00020\u0010H\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0002J\u0006\u0010\u001c\u001a\u00020\u0010J\u0006\u0010\u001d\u001a\u00020\u0010J\u000e\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u001f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/yy/hiyo/channel/plugins/ktv/panel/VirtualSeatManager;", "", "ktvRoomServices", "Lcom/yy/hiyo/channel/cbase/module/ktv/room/IKTVRoomService;", "pageContext", "Lcom/yy/hiyo/channel/cbase/context/IChannelPageContext;", "Lcom/yy/hiyo/channel/cbase/AbsPage;", "(Lcom/yy/hiyo/channel/cbase/module/ktv/room/IKTVRoomService;Lcom/yy/hiyo/channel/cbase/context/IChannelPageContext;)V", "mCachePoint", "Landroid/graphics/Point;", "mCloseVirtualSeatRunnable", "Ljava/lang/Runnable;", "mOpenVirtualSeatRunnable", "startSongCacheUId", "", "checkAudioPermission", "", "checkCloseVirtualSeat", "checkOpenVirtualSeat", "songInfo", "Lcom/yy/hiyo/channel/cbase/module/ktv/bean/KTVRoomSongInfo;", "isInSeat", "", "uid", "isInVirtualSeat", "onDestroy", "removeCloseVirtualSeatRunnable", "removeOpenVirtualSeatRunnable", "removeVirtualSeatRunnable", "startCheckCloseVirtualSeat", "startCheckOpenVirtualSeat", "updateSingerPoint", "point", "ktv_debug"})
public final class VirtualSeatManager {
    private long startSongCacheUId;
    private Runnable mOpenVirtualSeatRunnable;
    private Runnable mCloseVirtualSeatRunnable;
    private Point mCachePoint;
    private final IKTVRoomService ktvRoomServices;
    private final IChannelPageContext<AbsPage> pageContext;

    public final void removeVirtualSeatRunnable() {
        this.removeOpenVirtualSeatRunnable();
        this.removeCloseVirtualSeatRunnable();
    }

    private final void removeOpenVirtualSeatRunnable() {
        if (this.mOpenVirtualSeatRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mOpenVirtualSeatRunnable);
            this.mOpenVirtualSeatRunnable = null;
        }
    }

    private final void removeCloseVirtualSeatRunnable() {
        if (this.mCloseVirtualSeatRunnable != null) {
            YYTaskExecutor.removeRunnableFromMainThread((Runnable)this.mCloseVirtualSeatRunnable);
            this.mCloseVirtualSeatRunnable = null;
        }
    }

    public final void startCheckOpenVirtualSeat(@NotNull KTVRoomSongInfo songInfo) {
        Intrinsics.checkParameterIsNotNull((Object)songInfo, (String)"songInfo");
        this.removeOpenVirtualSeatRunnable();
        this.mOpenVirtualSeatRunnable = new Runnable(this, songInfo){
            final /* synthetic */ VirtualSeatManager this$0;
            final /* synthetic */ KTVRoomSongInfo $songInfo;

            public final void run() {
                this.this$0.checkOpenVirtualSeat(this.$songInfo);
                VirtualSeatManager.access$setMOpenVirtualSeatRunnable$p(this.this$0, null);
            }
            {
                this.this$0 = virtualSeatManager;
                this.$songInfo = kTVRoomSongInfo;
            }
        };
        YYTaskExecutor.postToMainThread((Runnable)this.mOpenVirtualSeatRunnable, (long)2000L);
    }

    public final void startCheckCloseVirtualSeat() {
        this.removeCloseVirtualSeatRunnable();
        this.mCloseVirtualSeatRunnable = new Runnable(this){
            final /* synthetic */ VirtualSeatManager this$0;

            public final void run() {
                this.this$0.checkCloseVirtualSeat();
                VirtualSeatManager.access$setMCloseVirtualSeatRunnable$p(this.this$0, null);
            }
            {
                this.this$0 = virtualSeatManager;
            }
        };
        YYTaskExecutor.postToMainThread((Runnable)this.mCloseVirtualSeatRunnable, (long)2000L);
    }

    public final void checkOpenVirtualSeat(@NotNull KTVRoomSongInfo songInfo) {
        Intrinsics.checkParameterIsNotNull((Object)songInfo, (String)"songInfo");
        this.removeVirtualSeatRunnable();
        if (this.ktvRoomServices.hasWhiteRoomConfig() && this.startSongCacheUId != songInfo.getUid()) {
            this.checkCloseVirtualSeat();
            if (!this.isInSeat(songInfo.getUid())) {
                Point it;
                boolean bl;
                boolean bl2;
                Point point;
                this.startSongCacheUId = songInfo.getUid();
                FeatureLog.i((String)"FTKTVPanel", (String)("checkOpenVirtualSeat:" + this.startSongCacheUId), (Object[])new Object[0]);
                Point point2 = this.pageContext;
                if (point2 != null) {
                    point = point2;
                    bl2 = false;
                    bl = false;
                    it = point;
                    boolean bl3 = false;
                    ArrayList<Long> otherSeatUser = new ArrayList<Long>();
                    otherSeatUser.add(songInfo.getUid());
                    IEnteredChannel iEnteredChannel = it.getChannel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iEnteredChannel, (String)"it.channel");
                    iEnteredChannel.getSeatService().getSeatData().setOtherSeatListChanged((List)otherSeatUser);
                }
                Point point3 = this.mCachePoint;
                if (point3 != null) {
                    point = point3;
                    bl2 = false;
                    bl = false;
                    it = point;
                    boolean bl4 = false;
                    this.updateSingerPoint(it);
                }
                if (songInfo.isSinger()) {
                    this.checkAudioPermission();
                }
            }
        }
    }

    private final void checkAudioPermission() {
        block0: {
            IChannelPageContext<AbsPage> iChannelPageContext = this.pageContext;
            if (iChannelPageContext == null) break block0;
            IChannelPageContext<AbsPage> iChannelPageContext2 = iChannelPageContext;
            boolean bl = false;
            boolean bl2 = false;
            IChannelPageContext<AbsPage> it = iChannelPageContext2;
            boolean bl3 = false;
            PermissionHelper.requestRecordAudioPermission((Activity)((Activity)it.getContext()), (IPermissionListener)new IPermissionListener(){

                public void onPermissionGranted(@NotNull String[] permission) {
                    Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)AudioNotifyDef.INSTANCE.getAUDIO_PERMISSION_NOTIFY()));
                }

                public void onPermissionDenied(@NotNull String[] permission) {
                    Intrinsics.checkParameterIsNotNull((Object)permission, (String)"permission");
                    FeatureLog.e((String)"FTVoice", (String)"enablePublishMic but permission denied!", (Object[])new Object[0]);
                    NotificationCenter.getGlobalInstance().notify(Notification.obtain((int)AudioNotifyDef.INSTANCE.getAUDIO_PERMISSION_NOTIFY()));
                }
            });
        }
    }

    public final void checkCloseVirtualSeat() {
        this.removeVirtualSeatRunnable();
        if (this.ktvRoomServices.hasWhiteRoomConfig() && this.startSongCacheUId != 0L) {
            IChannelPageContext<AbsPage> iChannelPageContext = this.pageContext;
            if (iChannelPageContext != null) {
                IChannelPageContext<AbsPage> iChannelPageContext2 = iChannelPageContext;
                boolean bl = false;
                boolean bl2 = false;
                IChannelPageContext<AbsPage> it = iChannelPageContext2;
                boolean bl3 = false;
                if (AccountUtil.getUid() == this.startSongCacheUId && !this.isInSeat(this.startSongCacheUId)) {
                    IEnteredChannel iEnteredChannel = it.getChannel();
                    Intrinsics.checkExpressionValueIsNotNull((Object)iEnteredChannel, (String)"it.channel");
                    iEnteredChannel.getMediaService().disablePublishMic(2);
                }
                IEnteredChannel iEnteredChannel = it.getChannel();
                Intrinsics.checkExpressionValueIsNotNull((Object)iEnteredChannel, (String)"it.channel");
                iEnteredChannel.getSeatService().getSeatData().setOtherSeatListChanged(null);
                this.updateSingerPoint(null);
            }
            FeatureLog.i((String)"FTKTVPanel", (String)("checkCloseVirtualSeat:" + this.startSongCacheUId), (Object[])new Object[0]);
            this.startSongCacheUId = 0L;
        }
    }

    public final void updateSingerPoint(@Nullable Point point) {
        if (this.pageContext == null || this.pageContext.isDestroy()) {
            return;
        }
        this.mCachePoint = point;
        if (this.startSongCacheUId <= 0L) {
            return;
        }
        if (!this.isInSeat(this.startSongCacheUId)) {
            FeatureLog.i((String)"FTKTVPanel", (String)("updateSingerPoint:" + point), (Object[])new Object[0]);
            ((IRevenueToolsModulePresenter)this.pageContext.getPresenter(IRevenueToolsModulePresenter.class)).updateOtherSeatPointMap(this.startSongCacheUId, point);
        }
    }

    public final boolean isInVirtualSeat(long uid) {
        return this.ktvRoomServices.hasWhiteRoomConfig() && this.startSongCacheUId == uid;
    }

    private final boolean isInSeat(long uid) {
        if (this.pageContext == null) {
            return false;
        }
        IEnteredChannel iEnteredChannel = this.pageContext.getChannel();
        Intrinsics.checkExpressionValueIsNotNull((Object)iEnteredChannel, (String)"pageContext.channel");
        return iEnteredChannel.getSeatService().isInSeat(uid);
    }

    public final void onDestroy() {
        this.removeVirtualSeatRunnable();
        this.checkCloseVirtualSeat();
        this.mCachePoint = null;
    }

    public VirtualSeatManager(@NotNull IKTVRoomService ktvRoomServices, @Nullable IChannelPageContext<AbsPage> pageContext) {
        Intrinsics.checkParameterIsNotNull((Object)ktvRoomServices, (String)"ktvRoomServices");
        this.ktvRoomServices = ktvRoomServices;
        this.pageContext = pageContext;
    }

    public static final /* synthetic */ Runnable access$getMOpenVirtualSeatRunnable$p(VirtualSeatManager $this) {
        return $this.mOpenVirtualSeatRunnable;
    }

    public static final /* synthetic */ void access$setMOpenVirtualSeatRunnable$p(VirtualSeatManager $this, Runnable runnable) {
        $this.mOpenVirtualSeatRunnable = runnable;
    }

    public static final /* synthetic */ Runnable access$getMCloseVirtualSeatRunnable$p(VirtualSeatManager $this) {
        return $this.mCloseVirtualSeatRunnable;
    }

    public static final /* synthetic */ void access$setMCloseVirtualSeatRunnable$p(VirtualSeatManager $this, Runnable runnable) {
        $this.mCloseVirtualSeatRunnable = runnable;
    }
}

