/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.panel;

import android.animation.ObjectAnimator;
import android.animation.PropertyValuesHolder;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Property;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import com.opensource.svgaplayer.SVGACallback;
import com.opensource.svgaplayer.SVGAImageView;
import com.opensource.svgaplayer.SVGAVideoEntity;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.callback.SimpleSVGACallback;
import com.yy.appbase.common.Callback;
import com.yy.appbase.service.ServiceManagerProxy;
import com.yy.appbase.util.RepeatClickUtils;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.logger.MLog;
import com.yy.base.memoryrecycle.views.YYFrameLayout;
import com.yy.base.utils.FP;
import com.yy.base.utils.FontUtils;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.xml.CommonUtils;
import com.yy.framework.core.ui.svga.ISvgaLoadCallback;
import com.yy.framework.core.ui.svga.SvgaLoader;
import com.yy.hiyo.channel.base.bean.KTVRoomPopStageInfo;
import com.yy.hiyo.channel.cbase.channelhiido.ChannelTrack;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoleInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.cbase.module.ktv.live.IKtvLiveView;
import com.yy.hiyo.channel.cbase.module.ktv.live.IKtvPlayContract;
import com.yy.hiyo.channel.gift.IGiftPanelActService;
import com.yy.hiyo.channel.plugins.ktv.DR;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVControlInfo;
import com.yy.hiyo.channel.plugins.ktv.model.room.KTVRoomServices;
import com.yy.hiyo.channel.plugins.ktv.panel.IControlInfoCallBack;
import com.yy.hiyo.channel.plugins.ktv.panel.ISvgaAnimListener;
import com.yy.hiyo.channel.plugins.ktv.panel.KTVPanelContract;
import com.yy.hiyo.channel.plugins.ktv.panel.KTVPanelPresenter;
import com.yy.hiyo.channel.plugins.ktv.panel.utils.KTVPanelTranAnimatorPlayer;
import com.yy.hiyo.channel.plugins.ktv.panel.view.IPanelViewState;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVAudiencePanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVAudienceVideoPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVAudioSettingPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVEndingPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVGetReadyPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVLoadingPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVPopularityView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVSettingPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVSingerSingingPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.KTVSingerVideoPanelView;
import com.yy.hiyo.channel.plugins.ktv.panel.view.OnPopularityListener;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVEventReportUtil;
import com.yy.hiyo.channel.plugins.ktv.utils.KTVPopularityReporter;
import com.yy.hiyo.dyres.api.DyResLoader;
import com.yy.hiyo.dyres.api.IDRCallback;
import com.yy.hiyo.wallet.base.revenue.gift.bean.GiftItemInfo;
import com.yy.hiyo.wallet.base.revenue.gift.bean.PackageGiftInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class KTVPanelView
extends YYFrameLayout
implements KTVPanelContract.View,
View.OnClickListener,
Callback<PackageGiftInfo> {
    private static final String TAG = "KTVPanelView";
    private SVGAImageView mSvgaPanelBg;
    private SVGAImageView mSvgaGift;
    private SVGAImageView mSvgaStage;
    private YYFrameLayout mPanelContainer;
    private ViewGroup mControlBar;
    private View mRlytSongList;
    private TextView mTvSongListSize;
    private ImageView mIvSongLib;
    private View mSkip;
    private View mEffectControl;
    private ImageView mIvVideoSetting;
    private String mCacheStageUrl = "";
    private KTVGetReadyPanelView mGetReadyPanelView;
    private KTVSingerSingingPanelView mSingerSingingPanelView;
    private KTVAudiencePanelView mAudiencePanelView;
    private KTVLoadingPanelView mLoadingPanelView;
    private KTVEndingPanelView mEndingPanelView;
    private KTVSingerVideoPanelView mSingerVideoPanelView;
    private KTVAudienceVideoPanelView mAudienceVideoPanelView;
    private KTVPopularityView mPopularityView;
    private KTVPanelPresenter mPanelPresenter;
    private long mCurrTime;
    private long mStartShowGetReadyTime;
    private KTVPanelTranAnimatorPlayer mPlayer;
    private boolean hasPauseSongPolicy = false;
    private int mStageAnimFrame = 0;
    private boolean isResetStageBgPoint = false;
    private PackageGiftInfo mGiftItemInfo;
    private PackageGiftInfo mFreeGuideGiftItemInfo;
    private long countDownTime = 10L;
    private long lastShowGiftCount = 0L;
    private KTVGetReadyPanelView.OnGetReadyPanelListener mOnGetReadyPanelListener = new KTVGetReadyPanelView.OnGetReadyPanelListener(){

        @Override
        public void onChangedVisible() {
            if (KTVPanelView.this.mPanelPresenter != null && KTVPanelView.this.mGetReadyPanelView != null) {
                KTVPanelView.this.mPanelPresenter.updateSingerPoint(KTVPanelView.this.mGetReadyPanelView.getAvatarPoint());
            }
        }

        @Override
        public void clickClosePanelBtn(View view) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"click close panel", (Object[])new Object[0]);
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.closePanel();
                KTVEventReportUtil.reportClosePanelClick();
            }
        }

        @Override
        public void clickJumpToPopularH5() {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.openPopularityH5();
                KTVPopularityReporter.INSTANCE.clickPopularityStageEnt(KTVPanelView.this.mPanelPresenter.getRoomId());
            }
        }

        @Override
        public void clickSingSongBtn(View view) {
            if (!RepeatClickUtils.canRepeatClick((String)"ktv_skip_and_SING_CLICK")) {
                return;
            }
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVEventReportUtil.reportClickSingBtn(KTVPanelView.this.mStartShowGetReadyTime + "", System.currentTimeMillis() + "");
                KTVPanelView.this.mPanelPresenter.playSong();
            }
        }

        @Override
        public void clickChooseASongBtn(View view, boolean haveMic) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.openSongLib();
                KTVEventReportUtil.reportOpenSongLib("1");
            }
        }

        @Override
        public void clickRecordKtv(boolean openRecord) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.setCurrentRecordSong(openRecord);
            }
        }

        @Override
        public boolean hasShowKtvRecordPermission() {
            if (KTVPanelView.this.mPanelPresenter != null) {
                return KTVPanelView.this.mPanelPresenter.hasRecordKtvPermission();
            }
            return false;
        }

        @Override
        public boolean hasSeletedRecord() {
            if (KTVPanelView.this.mPanelPresenter != null) {
                return KTVPanelView.this.mPanelPresenter.hasSeletedRecord();
            }
            return false;
        }

        @Override
        public void onSingerAvatarClick(long uid) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.showSingerProfile(uid);
            }
        }
    };
    private KTVLoadingPanelView.OnLoadingPanelListener mOnLoadingPanelListener = new KTVLoadingPanelView.OnLoadingPanelListener(){

        @Override
        public void onChangedVisible() {
            if (KTVPanelView.this.mPanelPresenter != null && KTVPanelView.this.mLoadingPanelView != null) {
                KTVPanelView.this.mPanelPresenter.updateSingerPoint(KTVPanelView.this.mLoadingPanelView.getAvatarPoint());
            }
        }

        @Override
        public void clickClosePanelBtn(View view) {
            FeatureLog.e((String)"FTKTVPlayer", (String)"click close panel", (Object[])new Object[0]);
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.closePanel();
                KTVEventReportUtil.reportClosePanelClick();
            }
        }
    };
    private KTVEndingPanelView.IEndingPanelListner mEndingPanelListner = new KTVEndingPanelView.IEndingPanelListner(){

        @Override
        public void onChangedVisible() {
            if (KTVPanelView.this.mPanelPresenter != null && KTVPanelView.this.mEndingPanelView != null) {
                KTVPanelView.this.mPanelPresenter.onEndPanelShow();
                KTVPanelView.this.mPanelPresenter.updateSingerPoint(KTVPanelView.this.mEndingPanelView.getAvatarPoint());
            }
        }

        @Override
        public void onIdleStateEnd() {
            if (KTVPanelView.this.mEndingPanelView.getVisibility() == 0 && null != KTVPanelView.this.mPanelPresenter && KTVPanelView.this.mPanelPresenter.getHandler().getKTVManager() != null) {
                IKTVManager ktvManager = KTVPanelView.this.mPanelPresenter.getHandler().getKTVManager();
                KTVRoomSongInfo songInfo = ktvManager.getKTVRoomServices().getCurrentKTVRoomData().getCurrentSongInfo();
                boolean showSkip = ktvManager.getKTVRoomServices().getCurrentKTVRoomData().hasSkipSongPolicy();
                boolean showClose = ktvManager.getKTVRoomServices().getCurrentKTVRoomData().hasCloseKTVPolicy();
                boolean isSinger = KTVPanelView.this.mPanelPresenter.isSinger();
                if (StringUtils.isEmpty((String)songInfo.getSongId())) {
                    KTVPanelView.this.showNoSongPanel(KTVPanelView.this.mPanelPresenter.getHandler().getmRoomDataContainer().getSeatData().isInSeat(AccountUtil.getUid()), showClose);
                } else if (0 != songInfo.getStatus()) {
                    KTVPanelView.this.showSingingPanel(isSinger, songInfo, KTVPanelView.this.mPanelPresenter.isRoomOwner());
                } else {
                    KTVPanelView.this.showGetReadyPanel(isSinger, showSkip, false, songInfo);
                }
                KTVPanelView.this.mPanelPresenter.onEndPanelHide(songInfo);
            }
        }

        @Override
        public void onSingerAvatarClick(long uid) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.showSingerProfile(uid);
            }
        }

        @Override
        public void guideShow() {
            KTVEventReportUtil.reportEndingGuideShow(KTVPanelView.this.mPanelPresenter.isMeShowing(), KTVPanelView.this.mPanelPresenter.isSinger(), KTVPanelView.this.mPanelPresenter.isInSeat());
        }

        @Override
        public void clickSave() {
            KTVPanelView.this.mPanelPresenter.saveBtnClick();
            KTVEventReportUtil.reportAudioSharePanelClick(KTVPanelView.this.mPanelPresenter.isMeShowing(), KTVPanelView.this.mPanelPresenter.isInSeat(), "1");
        }

        @Override
        public void clickShare() {
            KTVPanelView.this.mPanelPresenter.showShareDialog();
            KTVEventReportUtil.reportAudioSharePanelClick(KTVPanelView.this.mPanelPresenter.isMeShowing(), KTVPanelView.this.mPanelPresenter.isInSeat(), "2");
        }

        @Override
        public void clickGift(KTVRoomSongInfo songInfo, GiftItemInfo giftItemInfo) {
            KTVPanelView.this.mPanelPresenter.sendGift(songInfo, giftItemInfo);
        }

        @Override
        public void onLevelEndingShown() {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPopularityReporter.INSTANCE.showPopularityResultPage(KTVPanelView.this.mPanelPresenter.getRoomId());
            }
        }
    };
    private KTVSingerSingingPanelView.OnSingSongListener mSingSongListener = new KTVSingerSingingPanelView.OnSingSongListener(){

        @Override
        public void onChangedVisible() {
            if (KTVPanelView.this.mPanelPresenter != null && KTVPanelView.this.mSingerSingingPanelView != null) {
                KTVPanelView.this.mPanelPresenter.updateSingerPoint(KTVPanelView.this.mSingerSingingPanelView.getAvatarPoint());
            }
        }

        @Override
        public void onSingerAvatarClick(long uid) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.showSingerProfile(uid);
            }
        }

        @Override
        public void onCameraSwitch(boolean cameraOpen) {
            KTVPanelView.this.mPanelPresenter.openVideoScheme(cameraOpen);
        }

        @Override
        public void onLiveStart() {
        }

        @Override
        public boolean isRecording() {
            return KTVPanelView.this.mPanelPresenter.isRecording();
        }

        @Override
        public void cancelRecord() {
            KTVPanelView.this.mPanelPresenter.cancelRecord();
        }

        @Override
        public void onGiftClick(@NotNull GiftItemInfo giftInfo) {
            KTVPanelView.this.mPanelPresenter.sendGift(giftInfo);
        }

        @Override
        public void onVideoSettingClick(boolean cameraOpen) {
            KTVPanelView.this.mPanelPresenter.onVideoSettingClick(cameraOpen);
        }

        @Override
        public boolean isSingerVideoShowing() {
            return KTVPanelView.this.mSingerVideoPanelView.getVisibility() == 0;
        }
    };
    private KTVAudiencePanelView.IKtvOperationCallback mSingerOperationCallback = new KTVAudiencePanelView.IKtvOperationCallback(){

        @Override
        public void onChangedVisible() {
            if (KTVPanelView.this.mPanelPresenter != null && KTVPanelView.this.mAudiencePanelView != null) {
                KTVPanelView.this.mPanelPresenter.updateSingerPoint(KTVPanelView.this.mAudiencePanelView.getAvatarPoint());
                if (!KTVPanelView.this.isResetStageBgPoint) {
                    KTVPanelView.this.isResetStageBgPoint = KTVPanelView.this.resetStageBgPoint(KTVPanelView.this.mAudiencePanelView.getAvatarPoint());
                }
            }
        }

        @Override
        public void onSingerAvatarClick(long uid) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.showSingerProfile(uid);
            }
        }

        @Override
        public void onGiftClick(@NotNull GiftItemInfo giftItemInfo) {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.sendGift(giftItemInfo);
            }
        }

        @Override
        public void updateControlBar() {
            if (KTVPanelView.this.mPanelPresenter != null) {
                KTVPanelView.this.mPanelPresenter.updateControlInfo(controlInfo -> {});
            }
        }

        @Override
        public boolean isVideoOpen() {
            return KTVPanelView.this.mAudienceVideoPanelView.getVisibility() == 0;
        }
    };
    private KTVSingerVideoPanelView.ISingerVideoCallback mSingerVideoCallback = new KTVSingerVideoPanelView.ISingerVideoCallback(){

        @Override
        public void onChangedVisible() {
            if (KTVPanelView.this.mPanelPresenter != null && KTVPanelView.this.mSingerVideoPanelView != null) {
                KTVPanelView.this.mPanelPresenter.updateSingerPoint(KTVPanelView.this.mSingerVideoPanelView.getAvatarPoint());
                if (KTVPanelView.this.mSingerVideoPanelView.getVisibility() == 0 && KTVPanelView.this.mPopularityView.getVisibility() != 0) {
                    KTVPanelView.this.showPopularityView();
                }
            }
        }

        @Override
        public void onCameraSwitch(boolean cameraOpen) {
            if (KTVPanelView.this.mSingerSingingPanelView != null) {
                KTVPanelView.this.mSingerSingingPanelView.onCameraSwitch(cameraOpen);
            }
            KTVPanelView.this.mPanelPresenter.onSingerVideoModeChange(cameraOpen);
            if (cameraOpen) {
                KTVPanelView.this.updateStageBgVisible(false);
            } else if (KTVPanelView.this.mPanelPresenter.isSinging() || KTVPanelView.this.mPanelPresenter.isPause()) {
                KTVPanelView.this.updateStageBgVisible(true);
            }
        }
    };
    private KTVAudienceVideoPanelView.IAudienceVideoOperator mAudienceOperator = new KTVAudienceVideoPanelView.IAudienceVideoOperator(){

        @Override
        public void onChangedVisible() {
            if (KTVPanelView.this.mPanelPresenter != null && KTVPanelView.this.mAudienceVideoPanelView != null) {
                KTVPanelView.this.mPanelPresenter.updateSingerPoint(KTVPanelView.this.mAudienceVideoPanelView.getAvatarPoint());
            }
            if (KTVPanelView.this.mPopularityView.getVisibility() != 0) {
                KTVPanelView.this.showPopularityView();
            }
        }

        @Override
        public void updateControlBar(IControlInfoCallBack callBack) {
            KTVPanelView.this.mPanelPresenter.updateControlInfo(callBack);
        }

        @Override
        public void onCameraSwitch(boolean isCameraOpen) {
            if (KTVPanelView.this.mAudiencePanelView != null) {
                KTVPanelView.this.mAudiencePanelView.onCameraSwitch(isCameraOpen);
            }
            KTVPanelView.this.mPanelPresenter.onAudienceVideoModeChange(isCameraOpen);
            if (isCameraOpen) {
                KTVPanelView.this.updateStageBgVisible(false);
            } else if (KTVPanelView.this.mPanelPresenter.isSinging() || KTVPanelView.this.mPanelPresenter.isPause()) {
                KTVPanelView.this.updateStageBgVisible(true);
            }
        }

        @Override
        @Nullable
        public Drawable getThemeBg() {
            return KTVPanelView.this.mPanelPresenter.getThemeBg();
        }
    };
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public KTVPanelView(final Context context, String cid) {
        super(context);
        LayoutInflater.from((Context)context).inflate(R.layout.layout_panel_container_channel, (ViewGroup)this);
        DyResLoader.INSTANCE.getResFilePath(DR.bg_ktv_panel, new IDRCallback(){

            public void onSucceed(@NotNull String filePath) {
                ImageLoader.loadBitmap((Context)context, (String)filePath, (ImageLoader.BitmapLoadListener)new ImageLoader.BitmapLoadListener(){

                    public void onLoadFailed(Exception e) {
                    }

                    public void onResourceReady(Bitmap bitmap) {
                        KTVPanelView.this.setBackgroundDrawable((Drawable)new BitmapDrawable(bitmap));
                    }
                });
            }

            public void onFailed(@NotNull String msg) {
            }
        });
        this.mSvgaPanelBg = (SVGAImageView)this.findViewById(R.id.svga_panel_bg);
        this.mSvgaStage = (SVGAImageView)this.findViewById(R.id.svga_panel_stage);
        this.mSvgaGift = (SVGAImageView)this.findViewById(R.id.svga_gift);
        this.mPanelContainer = (YYFrameLayout)this.findViewById(R.id.panel_container);
        this.mControlBar = (ViewGroup)this.findViewById(R.id.control_layout);
        this.mRlytSongList = this.findViewById(R.id.rlyt_song_list);
        this.mTvSongListSize = (TextView)this.findViewById(R.id.tv_song_list_size);
        this.mIvSongLib = (ImageView)this.findViewById(R.id.iv_song_lib);
        this.mSkip = this.findViewById(R.id.iv_skip);
        this.mEffectControl = this.findViewById(R.id.iv_audio_effect);
        this.mIvVideoSetting = (ImageView)this.findViewById(R.id.iv_video_setting);
        this.mSingerVideoPanelView = (KTVSingerVideoPanelView)this.findViewById(R.id.video_preview_layout);
        this.mAudienceVideoPanelView = (KTVAudienceVideoPanelView)this.findViewById(R.id.audience_video_view);
        this.mPopularityView = (KTVPopularityView)this.findViewById(R.id.popularGiftLayout);
        this.mAudienceVideoPanelView.setOperator(this.mAudienceOperator);
        this.mTvSongListSize.setTypeface(FontUtils.getTypeFace((FontUtils.FontType)FontUtils.FontType.DINMittelschriftAlternate));
        this.mPlayer = new KTVPanelTranAnimatorPlayer();
        this.mRlytSongList.setOnClickListener((View.OnClickListener)this);
        this.mIvSongLib.setOnClickListener((View.OnClickListener)this);
        this.mSkip.setOnClickListener((View.OnClickListener)this);
        this.mEffectControl.setOnClickListener((View.OnClickListener)this);
        this.mIvVideoSetting.setOnClickListener((View.OnClickListener)this);
        this.mPopularityView.setOnPopularityListener(new OnPopularityListener(){

            @Override
            public void startAnim(int level) {
                if (KTVPanelView.this.mPanelPresenter != null) {
                    KTVRoomSongInfo songInfo = KTVPanelView.this.mPanelPresenter.getCurrentSongInfo();
                    long singerId = 0L;
                    if (songInfo != null) {
                        singerId = songInfo.getUid();
                    }
                    KTVPopularityReporter.INSTANCE.showPopularityStageCg(KTVPanelView.this.mPanelPresenter.getRoomId(), level, singerId);
                }
            }

            @Override
            public void onViewVisible() {
                if (KTVPanelView.this.mPanelPresenter != null) {
                    KTVPopularityReporter.INSTANCE.showPopularityStageEnt(KTVPanelView.this.mPanelPresenter.getRoomId());
                }
            }

            @Override
            public void openPopularityH5() {
                if (KTVPanelView.this.mPanelPresenter != null) {
                    KTVPanelView.this.mPanelPresenter.openPopularityH5();
                    KTVPopularityReporter.INSTANCE.clickPopularityStageEnt(KTVPanelView.this.mPanelPresenter.getRoomId());
                }
            }

            @Override
            public void onGiftClick(@NotNull GiftItemInfo giftInfo) {
                if (KTVPanelView.this.mPanelPresenter != null) {
                    KTVPanelView.this.mPanelPresenter.sendGift(giftInfo);
                }
            }
        });
        this.initLoadingPanel();
        this.initGetReadyPanel();
        this.initSingerSingingPanel();
        this.initAudiencePanel();
        this.initEndingPanel(cid);
    }

    @Override
    public void destroy() {
        if (this.mSvgaPanelBg != null) {
            this.mSvgaPanelBg.stopAnimation();
        }
        if (this.mSvgaStage != null) {
            this.mSvgaStage.setCallback(null);
            this.mSvgaStage.stopAnimation();
        }
        if (this.mPopularityView != null) {
            this.mPopularityView.destroy();
        }
        this.mFreeGuideGiftItemInfo = null;
        this.mGiftItemInfo = null;
        this.countDownTime = 0L;
        this.lastShowGiftCount = 0L;
        this.mSvgaGift.stopAnimation();
        this.mAudiencePanelView.destroy();
        this.mSingerSingingPanelView.destroy();
        if (this.mEndingPanelView != null) {
            this.mEndingPanelView.destroy();
        }
    }

    @Override
    public void updateControlState(KTVControlInfo info) {
        this.mSkip.setVisibility(info.getShowSkip() ? 0 : 8);
        this.mEffectControl.setVisibility(info.getShowSoundEffect() ? 0 : 8);
        this.mIvSongLib.setVisibility(info.getShowAdd() ? 0 : 8);
        if (info.getShowAdd()) {
            this.mPanelPresenter.checkShowGuideWindow();
        }
        this.mRlytSongList.setVisibility(info.getShowList() ? 0 : 8);
        if (info.getVideoBtnState().isSinger()) {
            boolean needShow = info.getVideoBtnState().getShowBtn() && info.getVideoBtnState().getHasAuthority();
            this.mIvVideoSetting.setVisibility(needShow ? 0 : 8);
        } else {
            this.mIvVideoSetting.setVisibility(info.getVideoBtnState().getShowBtn() ? 0 : 8);
        }
        this.mIvVideoSetting.setImageResource(info.getVideoBtnState().isSinger() ? R.drawable.selector_voice_room_video_scheme : R.drawable.selector_voice_room_audience_video_scheme);
        this.mIvVideoSetting.setSelected(info.getVideoBtnState().isCameraOpen());
        boolean isShowing = info.getShowAdd() || info.getShowList() || info.getShowSkip() || info.getShowSoundEffect() || info.getVideoBtnState().getShowBtn();
        this.mControlBar.setVisibility(isShowing ? 0 : 8);
        if (info.getShowSkip() && info.getShowSoundEffect()) {
            if (this.mPanelPresenter.isSinging() || this.mPanelPresenter.isPause()) {
                this.mSkip.setVisibility(8);
                this.mEffectControl.setVisibility(0);
            } else {
                this.mSkip.setVisibility(0);
                this.mEffectControl.setVisibility(8);
            }
        }
        if (isShowing) {
            if (this.mGetReadyPanelView != null) {
                int heightSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                int widthSpec = View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
                this.mControlBar.measure(widthSpec, heightSpec);
                this.mGetReadyPanelView.setPaddingRelative(this.mControlBar.getMeasuredWidth(), 0, 0, 0);
                if (this.mEndingPanelView != null) {
                    this.mEndingPanelView.setPaddingRelative(this.mControlBar.getMeasuredWidth(), 0, 0, 0);
                }
            }
        } else {
            if (this.mGetReadyPanelView != null) {
                this.mGetReadyPanelView.setPaddingRelative(0, 0, 0, 0);
            }
            if (this.mEndingPanelView != null) {
                this.mEndingPanelView.setPaddingRelative(0, 0, 0, 0);
            }
        }
        this.adjustControlBar();
    }

    private void adjustControlBar() {
        if (this.mSingerVideoPanelView.getVisibility() == 0 || this.mAudienceVideoPanelView.getVisibility() == 0) {
            this.setWrap();
        } else {
            IPanelViewState currentPanel = this.getCurrentPanel();
            if (currentPanel instanceof KTVAudiencePanelView) {
                if (((KTVAudiencePanelView)currentPanel).isLrcMode()) {
                    this.setMatch();
                } else {
                    this.setWrap();
                }
            } else {
                this.setMatch();
            }
        }
    }

    private void setMatch() {
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.mControlBar.getLayoutParams();
        layoutParams.height = 0;
        layoutParams.topToTop = this.mPanelContainer.getId();
        layoutParams.bottomToBottom = this.mPanelContainer.getId();
        this.mControlBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    private void setWrap() {
        ConstraintLayout.LayoutParams layoutParams = (ConstraintLayout.LayoutParams)this.mControlBar.getLayoutParams();
        layoutParams.height = -2;
        layoutParams.topToTop = -1;
        layoutParams.bottomToBottom = this.mPanelContainer.getId();
        this.mControlBar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    @Override
    public IPanelViewState getCurrentPanel() {
        for (int i = 0; i < this.mPanelContainer.getChildCount(); ++i) {
            IPanelViewState panelView2;
            View child = this.mPanelContainer.getChildAt(i);
            if (!(child instanceof IPanelViewState) || !(panelView2 = (IPanelViewState)child).isShowing()) continue;
            return panelView2;
        }
        return null;
    }

    @Override
    public List<View> getScrollViews() {
        return Arrays.asList(new View[]{this.mControlBar, this.mPopularityView});
    }

    @Override
    public void updateSingerStageInfo(KTVRoomPopStageInfo info) {
        this.mPopularityView.bindStageInfo(info);
        if (info == null) {
            return;
        }
        if (info.getConfig() == null) {
            if (!TextUtils.isEmpty((CharSequence)this.mCacheStageUrl)) {
                this.mSvgaStage.setVisibility(8);
                this.mCacheStageUrl = "";
            }
            return;
        }
        if (StringUtils.equal((String)this.mCacheStageUrl, (String)info.getConfig().magic_resources) || StringUtils.equal((String)this.mCacheStageUrl, (String)info.getConfig().magic_resources_low)) {
            return;
        }
        boolean needAlphaAnim = !TextUtils.isEmpty((CharSequence)this.mCacheStageUrl);
        this.mCacheStageUrl = RuntimeContext.getPhoneType() == 1 && !TextUtils.isEmpty((CharSequence)info.getConfig().magic_resources_low) ? info.getConfig().magic_resources_low : info.getConfig().magic_resources;
        if (this.mAudienceVideoPanelView.getVisibility() != 0 && this.mSingerVideoPanelView.getVisibility() != 0) {
            this.mSvgaStage.setVisibility(0);
        }
        this.startStageSvgaAnim(needAlphaAnim);
    }

    private void startStageSvgaAnim(boolean needAlphaAnim) {
        if (this.mSvgaStage.getCallback() == null) {
            this.mSvgaStage.setCallback((SVGACallback)new SimpleSVGACallback(){

                public void onFinished() {
                }

                public void onStep(int frame, double percentage) {
                    KTVPanelView.this.mStageAnimFrame = frame;
                }
            });
        }
        if (needAlphaAnim && RuntimeContext.getPhoneType() != 1 && this.mSvgaStage.getVisibility() == 0) {
            ObjectAnimator anim2 = ObjectAnimator.ofPropertyValuesHolder((Object)this.mSvgaStage, (PropertyValuesHolder[])new PropertyValuesHolder[]{PropertyValuesHolder.ofFloat((Property)View.ALPHA, (float[])new float[]{1.0f, 0.5f, 1.0f})}).setDuration(500L);
            anim2.start();
        }
        SvgaLoader.load((SVGAImageView)this.mSvgaStage, (String)this.mCacheStageUrl, (ISvgaLoadCallback)new ISvgaLoadCallback(){

            public void onFinished(SVGAVideoEntity svgaVideoEntity) {
                if (svgaVideoEntity != null) {
                    if (KTVPanelView.this.mStageAnimFrame > 0 && KTVPanelView.this.mStageAnimFrame < svgaVideoEntity.getFrames()) {
                        KTVPanelView.this.mSvgaStage.stepToFrame(KTVPanelView.this.mStageAnimFrame, KTVPanelView.this.mSvgaStage.getVisibility() == 0);
                        FeatureLog.d((String)"FTKTVPlayer", (String)("stepToFrame: " + KTVPanelView.this.mStageAnimFrame), (Object[])new Object[0]);
                    } else if (KTVPanelView.this.mSvgaStage.getVisibility() == 0) {
                        KTVPanelView.this.mSvgaStage.startAnimation();
                    }
                } else {
                    FeatureLog.e((String)"FTKTVPlayer", (String)"startStageSvgaAnim error!", (Object[])new Object[0]);
                }
            }

            public void onFailed(Exception e) {
                FeatureLog.e((String)"FTKTVPlayer", (String)"startStageSvgaAnim error!", (Object[])new Object[0]);
            }
        });
    }

    @Override
    public void showNoSongPanel(boolean haveMic, boolean showClose) {
        FeatureLog.e((String)"FTKTVPlayer", (String)"show no song panel", (Object[])new Object[0]);
        this.showTargetPanel((View)this.mGetReadyPanelView);
        this.mGetReadyPanelView.showNoSongLayout(haveMic, showClose);
        this.mPanelPresenter.updateControlInfo(controlInfo -> {
            controlInfo.setShowSkip(false);
            controlInfo.setShowSoundEffect(false);
        });
        KTVEventReportUtil.reportNoSongShow();
        this.mPopularityView.setVisibility(8);
        this.mGetReadyPanelView.updateEndPaddingState(true);
    }

    @Override
    public void showGetReadyPanel(boolean isSinger, boolean showSkip, boolean isDownloading, KTVRoomSongInfo songInfo) {
        FeatureLog.e((String)"FTKTVPlayer", (String)"show get ready panel", (Object[])new Object[0]);
        this.showTargetPanel((View)this.mGetReadyPanelView);
        this.mGetReadyPanelView.showReadyLayout(isSinger, isDownloading);
        String songName = songInfo.getSongName();
        String nick = songInfo.getNick();
        String avatar = songInfo.getAvatar();
        String composer = songInfo.getComposer();
        String songWriter = songInfo.getSongWriter();
        this.mGetReadyPanelView.loadSongInfo(songName, nick, avatar, composer, songWriter, this.mPanelPresenter.checkScrollSongInfo(), songInfo.getUid());
        this.mStartShowGetReadyTime = System.currentTimeMillis();
        KTVEventReportUtil.reportGetReadyShow();
        this.mPanelPresenter.updateControlInfo(controlInfo -> {
            controlInfo.setShowAdd(true);
            controlInfo.setShowList(true);
            controlInfo.setShowSkip(showSkip);
            controlInfo.setShowSoundEffect(false);
        });
        this.showPopularityView();
        this.mGetReadyPanelView.updateEndPaddingState(false);
    }

    @Override
    public void setSelectSongPolicy(int status, boolean enable) {
        if (status == -1) {
            this.mGetReadyPanelView.setSelectSongPolicy(enable);
        }
    }

    @Override
    public void showSingingPanel(boolean isSinger, KTVRoomSongInfo songInfo, boolean isOwner) {
        FeatureLog.e((String)"FTKTVPlayer", (String)"show singing panel", (Object[])new Object[0]);
        if (this.mEndingPanelView == null || !this.mEndingPanelView.isShowing()) {
            if (isSinger) {
                this.showSingerSingingPanel(songInfo);
                this.mPanelPresenter.updateControlInfo(controlInfo -> {
                    controlInfo.setShowSkip(false);
                    controlInfo.setShowSoundEffect(true);
                });
            } else {
                this.mPanelPresenter.updateControlInfo(controlInfo -> {
                    controlInfo.setShowSkip(false);
                    controlInfo.setShowSoundEffect(isOwner);
                });
                this.showAudienceSingingPanel(songInfo);
            }
            this.updateStageBgVisible(true);
        }
    }

    @Override
    public void showLoadingPanel(boolean showClose) {
        FeatureLog.e((String)"FTKTVPlayer", (String)"show loading panel", (Object[])new Object[0]);
        this.showTargetPanel((View)this.mLoadingPanelView);
        if (this.mLoadingPanelView != null) {
            this.mLoadingPanelView.setCloseVisible(showClose);
        }
    }

    @Override
    public void showEndingPanel(boolean isSinger, KTVRoomSongInfo songInfo) {
        FeatureLog.e((String)"FTKTVPlayer", (String)"show ending panel isSinger=%s", (Object[])new Object[]{isSinger});
        this.mEndingPanelView.setKTVRoomSongInfo(songInfo);
        this.mPanelPresenter.getGiftInfo((Callback<PackageGiftInfo>)((Callback)data -> this.mEndingPanelView.setGiftInfo((PackageGiftInfo)data)));
        this.showTargetPanel((View)this.mEndingPanelView);
        if (songInfo != null && songInfo.isSinger()) {
            KTVEventReportUtil.reportAudioSharePanelShow(this.mPanelPresenter.isMeShowing(), this.mPanelPresenter.isInSeat());
        }
    }

    private void showSingerSingingPanel(KTVRoomSongInfo songInfo) {
        this.showTargetPanel((View)this.mSingerSingingPanelView);
        String songName = songInfo.getSongName();
        String nick = songInfo.getNick();
        String avatar = songInfo.getAvatar();
        long singUid = songInfo.getUid();
        this.mSingerSingingPanelView.loadSongInfo(songName, nick, avatar, singUid);
        this.mPanelPresenter.getGiftInfo(this);
    }

    private void showAudienceSingingPanel(KTVRoomSongInfo songInfo) {
        this.showTargetPanel((View)this.mAudiencePanelView);
        String songName = songInfo.getSongName();
        String nick = songInfo.getNick();
        String avatar = songInfo.getAvatar();
        long singUid = songInfo.getUid();
        this.mAudiencePanelView.loadSongInfo(songName, nick, avatar, singUid);
        this.mPanelPresenter.getGiftInfo(this);
    }

    @Override
    public void loadPanelLyric(String filePath) {
        if (this.mPanelPresenter == null) {
            return;
        }
        if (this.mPanelPresenter.isSinger()) {
            if (this.mSingerSingingPanelView != null) {
                this.mSingerSingingPanelView.loadLrc(filePath);
            }
        } else {
            this.mAudiencePanelView.loadLrc(filePath);
        }
    }

    @Override
    public boolean hasLoadLyricFile() {
        if (this.mPanelPresenter == null || this.mAudiencePanelView == null) {
            return false;
        }
        if (this.mPanelPresenter.isSinger()) {
            return this.mSingerSingingPanelView.hasLrc();
        }
        return this.mAudiencePanelView.hasLrc();
    }

    @Override
    public void updateLyricTime(int time, int totalDuration) {
        if (this.mPanelPresenter == null) {
            return;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis - this.mCurrTime >= 3000L) {
            FeatureLog.i((String)"FTKTVPlayer", (String)"current time: %s,totalDuration: %s", (Object[])new Object[]{time, totalDuration});
            this.mCurrTime = currentTimeMillis;
        }
        if (this.mPanelPresenter.isSinger()) {
            if (this.mSingerSingingPanelView != null) {
                this.mSingerSingingPanelView.updateLyricTime(time, totalDuration);
            }
        } else if (this.mAudiencePanelView != null) {
            this.mAudiencePanelView.updateLyricTime(time, totalDuration);
        }
    }

    @Override
    public void onIsPauseState(boolean isPause) {
        this.onPanelPause(this.mGetReadyPanelView, isPause);
        this.onPanelPause(this.mAudiencePanelView, isPause);
        this.onPanelPause(this.mSingerSingingPanelView, isPause);
        this.onPanelPause(this.mEndingPanelView, isPause);
    }

    private void onPanelPause(IPanelViewState viewState, boolean isPause) {
        if (viewState != null) {
            viewState.onIsPauseState(isPause);
        }
    }

    @Override
    public void showLoading(long total, long current) {
        if (this.mGetReadyPanelView != null) {
            this.mGetReadyPanelView.showProgress(total, current);
        }
    }

    @Override
    public void startGiftSvga(String url, ISvgaAnimListener listener) {
        this.mPlayer.playPanelGiftSvga(this.mSvgaGift, url, listener);
    }

    private void showSettingView() {
        this.mPanelPresenter.openAudioSettingPanel(this.hasPauseSongPolicy);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.rlyt_song_list) {
            if (this.mPanelPresenter != null) {
                this.mPanelPresenter.openSongList();
                KTVEventReportUtil.reportOpenSongList("4");
            }
        } else if (v.getId() == R.id.iv_song_lib) {
            if (this.mPanelPresenter != null) {
                this.mPanelPresenter.openSongLib();
                KTVEventReportUtil.reportOpenSongLib("2");
            }
        } else if (v.getId() == R.id.iv_skip) {
            this.clickSkipSong();
        } else if (v.getId() == R.id.iv_video_setting) {
            KTVControlInfo info = this.mPanelPresenter.getControlInfo();
            if (info.getVideoBtnState().isSinger()) {
                this.mPanelPresenter.onVideoSettingClick(info.getVideoBtnState().isCameraOpen());
            } else if (!CommonUtils.isFastClick((long)700L)) {
                this.mAudienceVideoPanelView.onVideoAndVoiceSwitch();
            }
        } else if (v.getId() == R.id.iv_audio_effect) {
            ChannelTrack.INSTANCE.ktvControlClick();
            this.showSettingView();
        }
    }

    private void clickSkipSong() {
        FeatureLog.e((String)"FTKTVPlayer", (String)"skip song on get ready panel", (Object[])new Object[0]);
        if (!RepeatClickUtils.canRepeatClick((String)"ktv_skip_and_SING_CLICK")) {
            return;
        }
        if (this.mPanelPresenter != null) {
            this.mPanelPresenter.skipSong();
            String reportStr = this.mPanelPresenter.isSinger() && this.mPanelPresenter.isMeShowing() ? "1&2" : (this.mPanelPresenter.isSinger() ? "2" : "1");
            KTVEventReportUtil.reportChangeSongClick(reportStr);
        }
    }

    private void initGetReadyPanel() {
        if (this.mGetReadyPanelView == null) {
            Context context = this.getContext();
            this.mGetReadyPanelView = new KTVGetReadyPanelView(context);
            this.mPanelContainer.addView((View)this.mGetReadyPanelView);
            this.mGetReadyPanelView.setVisibility(8);
            this.mGetReadyPanelView.setOnGetReadyPanelListener(this.mOnGetReadyPanelListener);
        }
    }

    private void initAudiencePanel() {
        if (this.mAudiencePanelView == null) {
            Context context = this.getContext();
            this.mAudiencePanelView = new KTVAudiencePanelView(context);
            this.mAudiencePanelView.setOpeartionCallback(this.mSingerOperationCallback);
            this.mPanelContainer.addView((View)this.mAudiencePanelView);
            this.mAudiencePanelView.setVisibility(8);
        }
    }

    private void initSingerSingingPanel() {
        if (this.mSingerSingingPanelView == null) {
            Context context = this.getContext();
            this.mSingerSingingPanelView = new KTVSingerSingingPanelView(context);
            this.mPanelContainer.addView((View)this.mSingerSingingPanelView);
            this.mSingerSingingPanelView.setVisibility(8);
            this.mSingerSingingPanelView.setMSingSongListener(this.mSingSongListener);
        }
    }

    private void initLoadingPanel() {
        if (this.mLoadingPanelView == null) {
            Context context = this.getContext();
            this.mLoadingPanelView = new KTVLoadingPanelView(context);
            this.mPanelContainer.addView((View)this.mLoadingPanelView);
            this.mLoadingPanelView.setVisibility(8);
            this.mLoadingPanelView.setOnLoadinganelListener(this.mOnLoadingPanelListener);
        }
    }

    private void initEndingPanel(String cid) {
        if (this.mEndingPanelView == null) {
            Context context = this.getContext();
            this.mEndingPanelView = new KTVEndingPanelView(context);
            this.mEndingPanelView.setCurrentCid(cid);
            this.mPanelContainer.addView((View)this.mEndingPanelView);
            this.mEndingPanelView.setVisibility(8);
            this.mEndingPanelView.setOnEndingPanelListner(this.mEndingPanelListner);
        }
    }

    public void showTargetPanel(View panel) {
        if (panel == null || this.mPanelPresenter == null) {
            return;
        }
        if (null != this.mEndingPanelView && panel != this.mEndingPanelView && this.mEndingPanelView.isShowing()) {
            return;
        }
        if (panel.equals(this.mLoadingPanelView)) {
            this.mPanelPresenter.updateControlInfo(controlInfo -> {
                controlInfo.setShowAdd(false);
                controlInfo.setShowList(false);
            });
            if (this.mLoadingPanelView.getVisibility() == 8) {
                this.mLoadingPanelView.onPanelViewShow(this.mPanelPresenter.isSinger(), this.mPanelPresenter.isPause());
                this.handlePanelShow((View)this.mLoadingPanelView);
            }
        } else {
            this.handlePanelHide((View)this.mLoadingPanelView);
        }
        if (panel.equals(this.mGetReadyPanelView)) {
            this.mPanelPresenter.updateControlInfo(controlInfo -> {
                controlInfo.setShowAdd(false);
                controlInfo.setShowList(false);
                controlInfo.getVideoBtnState().setShowBtn(false);
            });
            if (this.mGetReadyPanelView.getVisibility() == 8) {
                this.mGetReadyPanelView.onPanelViewShow(this.mPanelPresenter.isSinger(), this.mPanelPresenter.isPause());
                this.handlePanelShow((View)this.mGetReadyPanelView);
            }
        } else {
            this.handlePanelHide((View)this.mGetReadyPanelView);
        }
        if (!this.mPanelPresenter.isSinger() && panel.equals(this.mAudiencePanelView)) {
            this.mPanelPresenter.updateControlInfo(controlInfo -> {
                controlInfo.setShowAdd(true);
                controlInfo.setShowList(true);
                controlInfo.getVideoBtnState().setSinger(false);
            });
            if (this.mAudiencePanelView != null && this.mAudiencePanelView.getVisibility() == 8) {
                this.mAudiencePanelView.onPanelViewShow(this.mPanelPresenter.isSinger(), this.mPanelPresenter.isPause());
                this.handlePanelShow((View)this.mAudiencePanelView);
            }
        } else {
            this.handlePanelHide((View)this.mAudiencePanelView);
        }
        if (this.mPanelPresenter.isSinger() && panel.equals(this.mSingerSingingPanelView)) {
            this.mPanelPresenter.updateControlInfo(controlInfo -> {
                controlInfo.setShowAdd(true);
                controlInfo.setShowList(true);
                if (RuntimeContext.isHagoPartySdk()) {
                    controlInfo.getVideoBtnState().setShowBtn(false);
                } else {
                    controlInfo.getVideoBtnState().setShowBtn(true);
                }
            });
            if (this.mSingerSingingPanelView.getVisibility() == 8) {
                this.mSingerSingingPanelView.onPanelViewShow(this.mPanelPresenter.isSinger(), this.mPanelPresenter.isPause());
                this.handlePanelShow((View)this.mSingerSingingPanelView);
            }
        } else {
            this.handlePanelHide((View)this.mSingerSingingPanelView);
            this.mPanelPresenter.hideVideoSettingPanel();
            this.updateStageBgVisible(false);
            if (panel == this.mEndingPanelView || panel == this.mGetReadyPanelView) {
                this.mCacheStageUrl = "";
            }
        }
        if (panel.equals(this.mEndingPanelView)) {
            this.mPanelPresenter.updateControlInfo(controlInfo -> {
                controlInfo.setShowAdd(true);
                controlInfo.setShowList(true);
                controlInfo.getVideoBtnState().setShowBtn(false);
            });
            if (this.mEndingPanelView.getVisibility() == 8) {
                this.mEndingPanelView.onPanelViewShow(this.mPanelPresenter.isSinger(), this.mPanelPresenter.isPause());
                if (this.mPanelPresenter != null) {
                    this.mEndingPanelView.setShareAndSaveShow(this.mPanelPresenter.isRecordComplete());
                }
                this.handlePanelShow((View)this.mEndingPanelView);
            }
            KTVEventReportUtil.reportEndingShow(this.mPanelPresenter.isMeShowing(), this.mPanelPresenter.isSinger(), this.mPanelPresenter.isInSeat());
        } else {
            this.handlePanelHide((View)this.mEndingPanelView);
        }
        if (this.mPanelPresenter != null) {
            KTVSettingPanelView.setHasHeadset(this.mPanelPresenter.getHandler() != null && this.mPanelPresenter.getHandler().getKTVManager().getKTVRoomServices().hasHeadset());
            KTVAudioSettingPanelView.Companion.setHasHeadset(this.mPanelPresenter.getHandler() != null && this.mPanelPresenter.getHandler().getKTVManager().getKTVRoomServices().hasHeadset());
        }
    }

    private void handlePanelShow(View view) {
        if (null != view && view.getVisibility() != 0) {
            view.setVisibility(0);
            if (view instanceof KTVAudiencePanelView || view instanceof KTVSingerSingingPanelView) {
                this.showPopularityView();
            } else {
                this.mPopularityView.setVisibility(8);
            }
        }
    }

    private void updateStageBgVisible(boolean visible) {
        if (visible) {
            this.mSvgaPanelBg.setVisibility(0);
            this.mPlayer.playPanelBgSvga(this.mSvgaPanelBg);
            if (!TextUtils.isEmpty((CharSequence)this.mCacheStageUrl)) {
                this.mSvgaStage.setVisibility(0);
                this.mSvgaStage.startAnimation();
            }
        } else {
            this.mSvgaPanelBg.stopAnimation();
            this.mSvgaPanelBg.setVisibility(8);
            this.mSvgaStage.stopAnimation();
            this.mSvgaStage.setVisibility(8);
        }
    }

    private void showPopularityView() {
        if (this.mPanelPresenter != null) {
            this.mPanelPresenter.getGiftInfo(this);
            this.mPopularityView.bindStageInfo(this.mPanelPresenter.getCurrentSingerStageInfo());
        }
        this.mPopularityView.setVisibility(0);
    }

    private void handlePanelHide(View view) {
        if (null != view && view.getVisibility() == 0) {
            view.setVisibility(8);
            if (view instanceof IPanelViewState) {
                ((IPanelViewState)view).onPanelViewHide();
            }
        }
    }

    @Override
    public View getKtvPanelView() {
        return this;
    }

    public void setPresenter(KTVPanelContract.Presenter presenter) {
        this.mPanelPresenter = (KTVPanelPresenter)presenter;
        this.mSingerVideoPanelView.setPanelPresenter(this.mPanelPresenter);
        this.mSingerVideoPanelView.setSingerVideoCallback(this.mSingerVideoCallback);
    }

    @Override
    public void headsetChanged(boolean hasHeadset) {
        if (null != this.mPanelPresenter) {
            this.mPanelPresenter.headsetChanged(hasHeadset);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mBinder.singleBindSourceTo((KvoSource)((KTVRoomServices)this.mPanelPresenter.getHandler().getKTVManager().getKTVRoomServices()));
        this.mBinder.singleBindSourceTo((KvoSource)this.mPanelPresenter.getHandler().getKTVManager().getKTVRoomServices().getCurrentKTVRoomData().getRoleInfo());
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.mBinder.clearAllKvoConnections();
    }

    @KvoMethodAnnotation(name="mKTVRoomSongInfoList", sourceClass=KTVRoomServices.class)
    public void onKTVRoomSongListChanged(KvoEventIntent event) {
        FeatureLog.i((String)"FTKTVRoomService", (String)"onKTVRoomSongListChanged", (Object[])new Object[0]);
        KTVRoomServices ktvRoomServices = (KTVRoomServices)event.source();
        List<KTVRoomSongInfo> ktvRoomSongInfoList = ktvRoomServices.getKTVRoomSongInfoList();
        if (!FP.empty(ktvRoomSongInfoList)) {
            int totalMusicCount = ktvRoomSongInfoList.size();
            this.mTvSongListSize.setText((CharSequence)(totalMusicCount + ""));
        }
    }

    @KvoMethodAnnotation(sourceClass=KTVRoleInfo.class, name="pauseSongPolicy", thread=1)
    public void onPauseSongPolicyChanged(KvoEventIntent event) {
        MLog.info((Object)"FTKTVRoomService", (String)"onPauseSongPolicyChanged oldValue: %s , newValue: %s", (Object[])new Object[]{event.oldValue(), event.newValue()});
        int newValue = (Integer)event.caseNewValue((Object)0);
        this.hasPauseSongPolicy = newValue == 1;
    }

    @KvoMethodAnnotation(sourceClass=KTVRoleInfo.class, name="cutSongPolicy", thread=1)
    public void onSkipSongPolicyChanged(KvoEventIntent event) {
        MLog.info((Object)"FTKTVRoomService", (String)"onSkipSongPolicyChanged oldValue: %s , newValue: %s", (Object[])new Object[]{event.oldValue(), event.newValue()});
        if (this.mGetReadyPanelView != null) {
            int newValue = (Integer)event.caseNewValue((Object)0);
            boolean hasSkipPolicy = newValue == 1;
            List ktvRoomSongInfoList = this.mPanelPresenter.getHandler().getKTVManager().getKTVRoomServices().getKTVRoomSongInfoList();
            if (FP.empty((Collection)ktvRoomSongInfoList)) {
                this.mPanelPresenter.updateControlInfo(controlInfo -> {
                    controlInfo.setShowSkip(false);
                    controlInfo.setShowSoundEffect(false);
                });
            } else {
                this.mPanelPresenter.updateControlInfo(controlInfo -> {
                    controlInfo.setShowSkip(hasSkipPolicy);
                    controlInfo.setShowSoundEffect(hasSkipPolicy);
                });
            }
        }
    }

    @KvoMethodAnnotation(sourceClass=KTVRoleInfo.class, name="closeKTVPolicy", thread=1)
    public void onCloseKTVPolicyChanged(KvoEventIntent event) {
        boolean hasClosePolicy;
        MLog.info((Object)"FTKTVRoomService", (String)"onCloseKTVPolicyChanged oldValue: %s , newValue: %s", (Object[])new Object[]{event.oldValue(), event.newValue()});
        int newValue = (Integer)event.caseNewValue((Object)0);
        boolean bl = hasClosePolicy = newValue == 1;
        if (this.mLoadingPanelView != null) {
            this.mLoadingPanelView.setCloseVisible(hasClosePolicy);
        }
        if (this.mGetReadyPanelView != null) {
            this.mGetReadyPanelView.setCloseVisible(hasClosePolicy);
        }
    }

    @Override
    public IKtvLiveView getKtvLiveView() {
        return this.mSingerVideoPanelView;
    }

    @Override
    public IKtvPlayContract.IKtvPlayView getKtvPlayView() {
        return this.mAudienceVideoPanelView;
    }

    public KTVSingerSingingPanelView getSingerSingingPanelView() {
        return this.mSingerSingingPanelView;
    }

    public KTVSingerVideoPanelView getSingerVideoPanelView() {
        return this.mSingerVideoPanelView;
    }

    public View getSongLibView() {
        return this.mIvSongLib;
    }

    public void updatePanelResource(String avatarBg) {
        MLog.info((Object)"FTKTVRoomService", (String)("updatePanelResource: " + avatarBg), (Object[])new Object[0]);
        if (this.mAudiencePanelView != null) {
            this.mAudiencePanelView.updateAvatarBg(avatarBg);
        }
    }

    private boolean resetStageBgPoint(Point point) {
        if (point.y <= 0 || this.getHeight() <= 0 || this.getWidth() <= 0 || this.mSvgaStage.getLayoutParams() == null) {
            return false;
        }
        float stageBgPoint = 0.425f * (float)this.getHeight();
        ConstraintLayout.LayoutParams params = (ConstraintLayout.LayoutParams)this.mSvgaStage.getLayoutParams();
        params.height = this.getHeight();
        params.width = this.getWidth();
        params.topMargin = point.y - (int)stageBgPoint;
        this.mSvgaStage.setLayoutParams((ViewGroup.LayoutParams)params);
        MLog.info((Object)"FTKTVRoomService", (String)("resetStageBgPoint topMargin:" + params.topMargin + ",height:" + params.height), (Object[])new Object[0]);
        return true;
    }

    @KvoMethodAnnotation(sourceClass=PackageGiftInfo.class, name="kvo_package_gift_info", thread=1)
    public void onGiftInfoChanged(KvoEventIntent event) {
        PackageGiftInfo packageGiftInfo = (PackageGiftInfo)event.source();
        MLog.info((Object)TAG, (String)"onGiftInfoChanged newValue: %s, getGiftItemInfo null %s", (Object[])new Object[]{packageGiftInfo.getPropId(), packageGiftInfo.getGiftItemInfo() == null});
        if (packageGiftInfo.getGiftItemInfo() != null) {
            this.mPopularityView.bindGiftInfo(packageGiftInfo);
            if (this.countDownTime > 0L && this.mFreeGuideGiftItemInfo != null && this.mFreeGuideGiftItemInfo.getPropId() == packageGiftInfo.getPropId()) {
                MLog.info((Object)TAG, (String)"startCountDown getGiftInfo %s", (Object[])new Object[]{packageGiftInfo.getPropId()});
                this.startCountDown(packageGiftInfo, this.countDownTime);
            }
        }
    }

    @KvoMethodAnnotation(sourceClass=PackageGiftInfo.class, name="kvo_package_gift_count", thread=1)
    public void onGiftCountChanged(KvoEventIntent event) {
        MLog.info((Object)TAG, (String)"onGiftCountChanged oldValue: %s , newValue: %s", (Object[])new Object[]{event.oldValue(), event.newValue()});
        PackageGiftInfo packageGiftInfo = (PackageGiftInfo)event.source();
        this.mPopularityView.bindGiftInfo(packageGiftInfo);
        if (this.mEndingPanelView != null) {
            this.mEndingPanelView.setGiftInfo(packageGiftInfo);
        }
        if (packageGiftInfo.getCount() <= 0 && this.lastShowGiftCount != (long)packageGiftInfo.getCount()) {
            MLog.info((Object)TAG, (String)"onGiftCountChanged req getGiftInfo", (Object[])new Object[0]);
            this.mFreeGuideGiftItemInfo = null;
            this.countDownTime = 0L;
            this.mPanelPresenter.getGiftInfo(this);
        }
        this.lastShowGiftCount = packageGiftInfo.getCount();
    }

    public void onResponse(PackageGiftInfo data) {
        this.updateGiftInfo(data);
    }

    private void bindData(PackageGiftInfo data) {
        if (data != null) {
            this.mBinder.clearKvoConnection("kvo_package_gift_info");
            this.mBinder.singleBindSourceTo("kvo_package_gift_info", (KvoSource)data);
            if (ServiceManagerProxy.getService(IGiftPanelActService.class) != null && ((IGiftPanelActService)ServiceManagerProxy.getService(IGiftPanelActService.class)).isKtvGiftNewConfig()) {
                this.mBinder.clearKvoConnection("kvo_package_gift_count");
                this.mBinder.singleBindSourceTo("kvo_package_gift_count", (KvoSource)data);
            } else {
                this.mPopularityView.bindGiftInfo(data);
            }
        } else {
            this.mPopularityView.bindGiftInfo(null);
        }
    }

    @Override
    public void startCountDown(PackageGiftInfo info, long time) {
        if (info != null) {
            this.mFreeGuideGiftItemInfo = info;
            if (this.mFreeGuideGiftItemInfo.getGiftItemInfo() == null) {
                MLog.info((Object)TAG, (String)"startCountDown return", (Object[])new Object[0]);
                this.countDownTime = time;
                return;
            }
            this.countDownTime = 0L;
            this.mPopularityView.startCountDown(info, time, (Callback<Boolean>)((Callback)data -> {
                if (this.mFreeGuideGiftItemInfo != null && this.mFreeGuideGiftItemInfo.getCount() > 0) {
                    MLog.info((Object)TAG, (String)"startCountDown bindData mFreeGuideGiftItemInfo", (Object[])new Object[0]);
                    this.bindData(this.mFreeGuideGiftItemInfo);
                } else {
                    MLog.info((Object)TAG, (String)"startCountDown bindData mGiftItemInfo", (Object[])new Object[0]);
                    this.mPopularityView.endGiftGuidAnim();
                    this.bindData(this.mGiftItemInfo);
                }
            }));
        }
    }

    @Override
    public void updateGiftInfo(PackageGiftInfo giftInfo) {
        this.mGiftItemInfo = giftInfo;
        if (this.mFreeGuideGiftItemInfo != null && this.mFreeGuideGiftItemInfo != giftInfo) {
            MLog.info((Object)TAG, (String)"updateGiftInfo return", (Object[])new Object[0]);
            return;
        }
        this.bindData(giftInfo);
    }

    @Override
    public void onPackageInitFinish() {
        if (this.mPopularityView != null) {
            this.mPopularityView.onPackageInitFinish();
        }
        if (this.mEndingPanelView != null) {
            this.mEndingPanelView.onPackageInitFinish();
        }
    }
}

