/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.widget.lyric;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.os.AsyncTask;
import android.os.Looper;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.animation.LinearInterpolator;
import androidx.annotation.MainThread;
import com.yy.base.memoryrecycle.views.YYView;
import com.yy.base.utils.ResolutionUtils;
import com.yy.base.utils.ResourceUtils;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.widget.lyric.LrcEntry;
import com.yy.hiyo.channel.plugins.ktv.widget.lyric.LrcUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class KTVLyricView
extends YYView {
    private List<LrcEntry> mLrcEntryList = new ArrayList<LrcEntry>();
    private TextPaint mLrcPaint = new TextPaint();
    private TextPaint mLabelPaint = new TextPaint();
    private TextPaint mSongNamePaint = new TextPaint();
    private float mDividerHeight;
    private long mAnimationDuration;
    private int mNormalTextColor;
    private int mCurrentTextColor;
    private int mLabelTextColor;
    private String mDefaultLabel;
    private float mLrcPadding;
    private ValueAnimator mAnimator;
    private ObjectAnimator alphaAnimator;
    private AnimatorSet mAnimatorSet;
    private float mOffset;
    private int mCurrentLine;
    private Object mFlag;
    private int mTextGravity;
    private Rect mSongNameRect = new Rect();
    float lrcNormalTextSize;
    float lrcCurrentTextSize;
    float labelTextSize;
    private int mMusicIconWidth;
    private Bitmap mMusicIcon;
    private String mSongName;
    boolean hasSongName;
    boolean mIsPause;
    boolean mIsAlphaAnimaScrollLyric = false;
    private float lineHeight = this.dp2Px(30.0f);
    private int mShowLineCount = 0;
    private int mExceedLineCount = 2;
    private boolean mLyricWithShadow = false;
    private boolean mShowSongName = false;
    public static final int LINE_SPACE_0 = 0;
    public static final int LINE_SPACE_1 = 1;
    public static final int LINE_SPACE_2 = 2;

    private float dp2Px(float value) {
        return TypedValue.applyDimension((int)1, (float)value, (DisplayMetrics)Resources.getSystem().getDisplayMetrics());
    }

    public KTVLyricView(Context context) {
        this(context, null);
    }

    public KTVLyricView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public KTVLyricView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        TypedArray ta = this.getContext().obtainStyledAttributes(attrs, R.styleable.LrcView);
        this.lrcNormalTextSize = ta.getDimension(R.styleable.LrcView_lrcNormalTextSize, (float)ResolutionUtils.dip2Px((float)12.0f));
        this.lrcCurrentTextSize = ta.getDimension(R.styleable.LrcView_lrcCurrentTextSize, (float)ResolutionUtils.dip2Px((float)14.0f));
        this.mDividerHeight = ta.getDimension(R.styleable.LrcView_lrcDividerHeight, (float)ResolutionUtils.dip2Px((float)2.0f));
        int defDuration = 800;
        this.mAnimationDuration = ta.getInt(R.styleable.LrcView_lrcAnimationDuration, defDuration);
        this.mAnimationDuration = this.mAnimationDuration < 0L ? (long)defDuration : this.mAnimationDuration;
        this.mNormalTextColor = ta.getColor(R.styleable.LrcView_lrcNormalTextColor, Color.parseColor((String)"#9E9E9E"));
        this.mCurrentTextColor = ta.getColor(R.styleable.LrcView_lrcCurrentTextColor, Color.parseColor((String)"#FF4081"));
        this.mDefaultLabel = ta.getString(R.styleable.LrcView_lrcLabel);
        this.mDefaultLabel = TextUtils.isEmpty((CharSequence)this.mDefaultLabel) ? "\u6682\u65e0\u6b4c\u8bcd~~~" : this.mDefaultLabel;
        this.mLrcPadding = ta.getDimension(R.styleable.LrcView_lrcPadding, this.dp2Px(6.0f));
        this.mTextGravity = ta.getInteger(R.styleable.LrcView_lrcTextGravity, 2);
        this.mLyricWithShadow = ta.getBoolean(R.styleable.LrcView_lrcTextShadow, false);
        this.mShowSongName = ta.getBoolean(R.styleable.LrcView_lrcShowSongName, false);
        ta.recycle();
        this.mLabelTextColor = this.mNormalTextColor;
        this.labelTextSize = this.lrcCurrentTextSize;
        this.mLrcPaint.setAntiAlias(true);
        this.mLrcPaint.setTextSize(this.lrcNormalTextSize);
        this.mLrcPaint.setTextAlign(Paint.Align.LEFT);
        if (this.mLyricWithShadow) {
            this.mLrcPaint.setShadowLayer(2.0f, 2.0f, 2.0f, Color.parseColor((String)"#7f000000"));
        }
        this.mDividerHeight = this.dp2Px(6.0f);
        this.mMusicIconWidth = (int)this.dp2Px(14.0f);
        this.mMusicIcon = LrcUtils.getResDrawable(this.getContext(), R.drawable.ico_ktv_inf_music, this.mMusicIconWidth);
        this.initLabelPaint();
    }

    private void initLabelPaint() {
        this.mLabelPaint.setTextSize(this.labelTextSize);
        this.mLabelPaint.setColor(this.mLabelTextColor);
        this.mLabelPaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.mLabelPaint.setTextAlign(Paint.Align.LEFT);
    }

    @Deprecated
    public void onDrag(long time) {
        this.updateTime(time);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (oldh != h && this.mLrcEntryList != null && !this.mLrcEntryList.isEmpty()) {
            for (int i = 0; i < this.mLrcEntryList.size(); ++i) {
                this.mLrcEntryList.get(i).setOffset(Float.MIN_VALUE);
                this.getOffset(i);
            }
            this.scrollToCurrLine(this.mCurrentLine, 0L);
        }
    }

    protected void onDraw(Canvas canvas) {
        int minLine;
        int maxLine;
        super.onDraw(canvas);
        int showLineCount = this.mShowLineCount;
        boolean countFix = showLineCount % 2 == 0;
        float centerY = (float)this.getHeight() / 2.0f;
        if (!(this.hasLrc() && !this.mIsPause || TextUtils.isEmpty((CharSequence)this.mDefaultLabel))) {
            if (this.mIsPause) {
                this.setPauseLabel();
            } else if (!this.hasLrc()) {
                this.setNoLyricLabel();
            }
            this.drawText(canvas, this.adjustTextSizeForStaticLayout(this.mLabelPaint, this.mDefaultLabel, (int)this.getLrcWidth(), 1), this.mLrcPadding, centerY);
            return;
        }
        canvas.translate(0.0f, this.mOffset);
        boolean drawSongName = false;
        if (this.mShowSongName && this.hasSongName && !TextUtils.isEmpty((CharSequence)this.mSongName) && !this.mIsPause && (showLineCount <= 0 || !((double)this.mCurrentLine - Math.floor((float)showLineCount / 2.0f) >= 0.0) || this.mIsPause)) {
            float left;
            int songNameWidth;
            drawSongName = true;
            --showLineCount;
            float iconPadding = (float)this.mMusicIconWidth + this.dp2Px(4.0f);
            int lineOffset = 0;
            if (countFix) {
                lineOffset = 1;
            }
            float songNameY = this.hasLrc() && !this.mIsPause ? centerY - (this.lineHeight + this.mDividerHeight) - this.getOffset(lineOffset) : centerY - (this.lineHeight + this.mDividerHeight);
            StaticLayout staticLayout = this.adjustTextSizeForStaticLayout(this.mSongNamePaint, this.mSongName, (int)(this.getLrcWidth() - iconPadding), 1);
            if (this.mTextGravity == 2) {
                this.mSongNamePaint.getTextBounds(this.mSongName, 0, this.mSongName.length(), this.mSongNameRect);
                songNameWidth = this.mSongNameRect.width();
                left = this.getLrcWidth() / 2.0f - (float)(songNameWidth >> 1) - this.mLrcPadding;
                canvas.drawBitmap(this.mMusicIcon, left, songNameY - this.lineHeight / 2.0f + (float)(staticLayout.getHeight() >> 1) - this.mLrcPadding, (Paint)this.mLrcPaint);
            } else if (this.mTextGravity == 3) {
                this.mSongNamePaint.getTextBounds(this.mSongName, 0, this.mSongName.length(), this.mSongNameRect);
                songNameWidth = this.mSongNameRect.width();
                left = this.getLrcWidth() - (float)songNameWidth - this.mLrcPadding;
                canvas.drawBitmap(this.mMusicIcon, left, songNameY - this.lineHeight / 2.0f + (float)(staticLayout.getHeight() >> 1), (Paint)this.mLrcPaint);
            } else {
                canvas.drawBitmap(this.mMusicIcon, this.mLrcPadding, songNameY - this.lineHeight / 2.0f + (float)(staticLayout.getHeight() >> 1), (Paint)this.mLrcPaint);
            }
            this.drawText(canvas, staticLayout, this.mLrcPadding + iconPadding, songNameY);
        }
        int centerLine = this.getCenterLine();
        if (countFix) {
            maxLine = (int)((double)centerLine + Math.floor((float)showLineCount / 2.0f));
            minLine = (int)((double)centerLine - Math.floor((float)showLineCount / 2.0f)) + 1;
        } else {
            maxLine = (int)((double)centerLine + Math.floor((float)showLineCount / 2.0f));
            minLine = (int)((double)centerLine - Math.floor((float)showLineCount / 2.0f));
        }
        if (!drawSongName && this.mCurrentLine == 0 && showLineCount != 1) {
            canvas.translate(0.0f, -this.lineHeight - this.mDividerHeight);
            ++maxLine;
        }
        float lyricY = 0.0f;
        for (int i = 0; i < this.mLrcEntryList.size(); ++i) {
            if (i > 0) {
                lyricY += this.lineHeight + this.mDividerHeight;
            }
            if (showLineCount > 0 && (i < minLine || i > maxLine)) continue;
            if (i == this.mCurrentLine) {
                this.mLrcPaint.setTextSize(this.lrcCurrentTextSize);
                this.mLrcPaint.setColor(this.mCurrentTextColor);
                this.mLrcPaint.setTypeface(Typeface.DEFAULT_BOLD);
            } else {
                this.mLrcPaint.setColor(this.mNormalTextColor);
                this.mLrcPaint.setTextSize(this.lrcNormalTextSize);
                this.mLrcPaint.setTypeface(Typeface.DEFAULT);
            }
            LrcEntry lrcEntry = this.mLrcEntryList.get(i);
            StaticLayout staticLayout = this.adjustTextSizeForStaticLayout(this.mLrcPaint, lrcEntry.getText(), (int)this.getLrcWidth(), this.mExceedLineCount);
            lrcEntry.setStaticLayout(staticLayout);
            this.drawText(canvas, lrcEntry.getStaticLayout(), this.mLrcPadding, lyricY);
        }
    }

    private void drawText(Canvas canvas, StaticLayout staticLayout, float x, float y) {
        canvas.save();
        canvas.translate(x, y - (float)(staticLayout.getHeight() >> 1));
        staticLayout.draw(canvas);
        canvas.restore();
    }

    private StaticLayout adjustTextSizeForStaticLayout(TextPaint paint, String drawText, int width, int limitLineCount) {
        Layout.Alignment align;
        switch (this.mTextGravity) {
            case 1: {
                align = Layout.Alignment.ALIGN_NORMAL;
                break;
            }
            default: {
                align = Layout.Alignment.ALIGN_CENTER;
                break;
            }
            case 3: {
                align = Layout.Alignment.ALIGN_OPPOSITE;
            }
        }
        width = width < 0 ? 0 : width;
        StaticLayout staticLayout = new StaticLayout((CharSequence)drawText, paint, width, align, 1.0f, 0.0f, false);
        float tryTextSize = this.lrcNormalTextSize;
        while (staticLayout.getLineCount() > limitLineCount) {
            paint.setTextSize(tryTextSize);
            staticLayout = new StaticLayout((CharSequence)drawText, paint, (int)this.getLrcWidth(), align, 1.0f, 0.0f, false);
            tryTextSize -= 1.0f;
        }
        return staticLayout;
    }

    public void setShowLineCount(int showLineCount) {
        this.mShowLineCount = showLineCount;
        this.requestLayout();
    }

    public void setNormalColor(int normalColor) {
        this.mNormalTextColor = normalColor;
        this.postInvalidate();
    }

    public void setLrcNormalTextSize(float size) {
        this.lrcNormalTextSize = size;
        this.postInvalidate();
    }

    public void setCurrentColor(int currentColor) {
        this.mCurrentTextColor = currentColor;
        this.postInvalidate();
    }

    public void setLrcCurrentTextSize(float size) {
        this.lrcCurrentTextSize = size;
        this.postInvalidate();
    }

    public void setTextGravityLeft() {
        this.mTextGravity = 1;
        this.postInvalidate();
    }

    public void setTextGravityRight() {
        this.mTextGravity = 3;
        this.postInvalidate();
    }

    public void setTextGravityCenter() {
        this.mTextGravity = 2;
        this.postInvalidate();
    }

    public void setIsPause(boolean isPause) {
        this.mIsPause = isPause;
        this.postInvalidate();
    }

    public void setAlphaAnimaScrollLyric(boolean isAlphaAnimaScrollLyric) {
        this.mIsAlphaAnimaScrollLyric = isAlphaAnimaScrollLyric;
    }

    private void setNoLyricLabel() {
        this.mDefaultLabel = this.isInEditMode() ? "No Lyric" : ResourceUtils.getString((int)R.string.tip_no_lyric);
        this.mLabelTextColor = Color.parseColor((String)"#ffffff");
        this.labelTextSize = ResolutionUtils.dip2Px((float)14.0f);
        this.initLabelPaint();
    }

    private void setPauseLabel() {
        this.mDefaultLabel = ResourceUtils.getString((int)R.string.tip_pause);
        this.mLabelTextColor = ResourceUtils.getColor((int)R.color.red_ff4a);
        this.labelTextSize = ResolutionUtils.dip2Px((float)14.0f);
        this.initLabelPaint();
    }

    public void setSongNameShow(String songName) {
        if (TextUtils.isEmpty((CharSequence)songName) || songName.equals(this.mSongName)) {
            return;
        }
        this.mSongName = songName;
        if (TextUtils.isEmpty((CharSequence)songName)) {
            this.hasSongName = false;
            return;
        }
        this.mSongNamePaint.setTextSize((float)ResolutionUtils.dip2Px((float)14.0f));
        this.mSongNamePaint.setColor(ResourceUtils.getColor((int)R.color.white));
        this.mSongNamePaint.setTextAlign(Paint.Align.LEFT);
        this.mSongNamePaint.setTypeface(Typeface.DEFAULT_BOLD);
        this.mOffset += -(this.lineHeight + this.mDividerHeight);
        this.hasSongName = true;
        this.requestLayout();
        this.invalidate();
    }

    public void setLrcPadding(float padding) {
        this.mLrcPadding = padding;
        this.postInvalidate();
    }

    public void setExceedLineCount(int exceedLineCount) {
        this.mExceedLineCount = exceedLineCount;
    }

    public void loadLrc(final File lrcFile) {
        this.runOnUi(() -> {
            this.reset();
            this.setFlag(lrcFile);
            new AsyncTask<File, Integer, List<LrcEntry>>(){

                protected List<LrcEntry> doInBackground(File ... params) {
                    return LrcEntry.parseLrc(params[0]);
                }

                protected void onPostExecute(List<LrcEntry> lrcEntries) {
                    if (KTVLyricView.this.getFlag() == lrcFile) {
                        KTVLyricView.this.onLrcLoaded(lrcEntries);
                        KTVLyricView.this.setFlag(null);
                    }
                }
            }.execute((Object[])new File[]{lrcFile});
        });
    }

    public boolean hasLrc() {
        return !this.mLrcEntryList.isEmpty();
    }

    public void updateTime(long time) {
        this.runOnUi(() -> {
            if (!this.hasLrc()) {
                return;
            }
            int line = this.findShowLine(time);
            if (line != this.mCurrentLine) {
                if (line - this.mCurrentLine > 1) {
                    this.mCurrentLine = line;
                    this.scrollToCurrLine(line, 0L);
                } else {
                    this.mCurrentLine = line;
                    this.scrollToCurrLine(line, this.mAnimationDuration);
                }
            }
        });
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
    }

    private void onLrcLoaded(List<LrcEntry> entryList) {
        if (entryList != null && !entryList.isEmpty()) {
            this.mLrcEntryList.addAll(entryList);
        }
        this.initEntryList();
        this.invalidate();
    }

    private void initEntryList() {
        if (!this.hasLrc() || this.getWidth() == 0) {
            return;
        }
        Collections.sort(this.mLrcEntryList);
        for (LrcEntry lrcEntry : this.mLrcEntryList) {
            lrcEntry.init(this.mLrcPaint, (int)this.getLrcWidth(), this.mTextGravity);
        }
        this.mOffset = this.getHeight() >> 1;
    }

    @MainThread
    public void reset() {
        this.endAnimation();
        this.mLrcEntryList.clear();
        this.mOffset = 0.0f;
        this.mCurrentLine = 0;
        this.invalidate();
    }

    private void scrollToCurrLine(int line, long duration) {
        float offset = this.getOffset(line);
        this.endAnimation();
        this.mAnimator = ValueAnimator.ofFloat((float[])new float[]{this.mOffset, offset});
        this.mAnimator.setDuration(duration);
        this.mAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        this.mAnimator.addUpdateListener(animation -> {
            this.mOffset = ((Float)animation.getAnimatedValue()).floatValue();
            this.invalidate();
        });
        if (this.mIsAlphaAnimaScrollLyric) {
            this.alphaAnimator = ObjectAnimator.ofFloat((Object)((Object)this), (String)"alpha", (float[])new float[]{1.0f, 0.0f, 1.0f});
            this.alphaAnimator.setDuration(duration);
            this.alphaAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
            this.mAnimatorSet = new AnimatorSet();
            this.mAnimatorSet.play((Animator)this.mAnimator).with((Animator)this.alphaAnimator);
            this.mAnimatorSet.start();
        } else {
            this.mAnimator.start();
        }
    }

    private void endAnimation() {
        if (this.mAnimator != null && this.mAnimator.isRunning()) {
            this.mAnimator.end();
        }
        if (this.mAnimatorSet != null && this.mAnimatorSet.isRunning()) {
            this.mAnimatorSet.end();
        }
    }

    private int findShowLine(long time) {
        int left = 0;
        int right = this.mLrcEntryList.size();
        while (left <= right) {
            int middle = (left + right) / 2;
            long middleTime = this.mLrcEntryList.get(middle).getTime();
            if (time < middleTime) {
                right = middle - 1;
                continue;
            }
            if (middle + 1 >= this.mLrcEntryList.size() || time < this.mLrcEntryList.get(middle + 1).getTime()) {
                return middle;
            }
            left = middle + 1;
        }
        return 0;
    }

    private int getCenterLine() {
        int centerLine = 0;
        if (!this.hasLrc()) {
            return centerLine;
        }
        float minDistance = Float.MAX_VALUE;
        for (int i = 0; i < this.mLrcEntryList.size(); ++i) {
            if (!(Math.abs(this.mOffset - this.getOffset(i)) < minDistance)) continue;
            minDistance = Math.abs(this.mOffset - this.getOffset(i));
            centerLine = i;
        }
        return centerLine;
    }

    private float getOffset(int line) {
        if (this.mLrcEntryList.get(line).getOffset() == Float.MIN_VALUE) {
            float offset = this.getHeight() >> 1;
            for (int i = 1; i <= line; ++i) {
                offset -= this.lineHeight + this.mDividerHeight;
            }
            this.mLrcEntryList.get(line).setOffset(offset);
        }
        return this.mLrcEntryList.get(line).getOffset();
    }

    private float getLrcWidth() {
        float width = (float)this.getWidth() - this.mLrcPadding * 2.0f;
        return width < 0.0f ? 0.0f : width;
    }

    private void runOnUi(Runnable r) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            r.run();
        } else {
            this.post(r);
        }
    }

    private Object getFlag() {
        return this.mFlag;
    }

    private void setFlag(Object flag) {
        this.mFlag = flag;
    }

    public void setUpLineSpacing(int lineSpace) {
        if (lineSpace == 0) {
            this.lineHeight = this.dp2Px(16.0f);
            this.mDividerHeight = this.dp2Px(3.0f);
        } else if (lineSpace == 2) {
            this.lineHeight = this.dp2Px(20.0f);
            this.mDividerHeight = this.dp2Px(8.0f);
        } else {
            this.lineHeight = this.dp2Px(30.0f);
            this.mDividerHeight = this.dp2Px(3.0f);
        }
    }
}

