/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.model.downloader;

import android.content.Context;
import androidx.annotation.NonNull;
import com.yy.appbase.account.AccountUtil;
import com.yy.appbase.dowload.DownloadBussinessGroup;
import com.yy.base.env.RuntimeContext;
import com.yy.base.event.kvo.KvoEventIntent;
import com.yy.base.event.kvo.KvoMethodAnnotation;
import com.yy.base.event.kvo.KvoSource;
import com.yy.base.event.kvo.helper.KvoBinder;
import com.yy.base.featurelog.FeatureLog;
import com.yy.base.logger.MLog;
import com.yy.base.taskexecutor.IQueueTaskExecutor;
import com.yy.base.taskexecutor.YYTaskExecutor;
import com.yy.base.utils.StringUtils;
import com.yy.base.utils.ToastUtils;
import com.yy.base.utils.YYFileUtils;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVMusicInfo;
import com.yy.hiyo.channel.cbase.module.ktv.bean.KTVRoomSongInfo;
import com.yy.hiyo.channel.plugins.ktv.common.base.IKTVManager;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseContext;
import com.yy.hiyo.channel.plugins.ktv.common.base.KTVBaseModel;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVDownloadInfo;
import com.yy.hiyo.channel.plugins.ktv.common.callback.IKTVQueryCallback;
import com.yy.hiyo.channel.plugins.ktv.model.downloader.IKTVDownloader;
import com.yy.hiyo.channel.plugins.ktv.model.downloader.IKTVdownloadCallback;
import com.yy.hiyo.channel.plugins.ktv.model.downloader.KTVDownloadUtils;
import com.yy.hiyo.channel.plugins.ktv.model.downloader.MyKTVDownloader;
import com.yy.hiyo.channel.plugins.ktv.model.room.KTVRoomServices;
import downloader.Downloader;
import downloader.IDownloadCallback;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class KTVDownloader
extends KTVBaseModel
implements IKTVDownloader {
    private static final String TAG = "KTVDownloader";
    public static final int STATUS_FILE_OK = 2;
    public static final int STATUS_FILE_FALSE = 4;
    private IQueueTaskExecutor mTaskExecutor;
    private List<KTVMusicInfo> mKtvMusicInfo = new CopyOnWriteArrayList<KTVMusicInfo>();
    private List<MyKTVDownloader> myKTVDownloaders = new CopyOnWriteArrayList<MyKTVDownloader>();
    private List<PreDownloadInfo> mPreDownloadList = new CopyOnWriteArrayList<PreDownloadInfo>();
    private MyKTVDownloader mCurDownloader;
    private int maxSongSize = 2;
    private static final int DOWNLOAD_DEFAULT_SIZE = 1;
    private long mVersion = 0L;
    private Set<IKTVdownloadCallback> mDownloaderListenerList = new HashSet<IKTVdownloadCallback>();
    private final KvoBinder mBinder = new KvoBinder((Object)this);

    public KTVDownloader(IKTVManager iktvManager) {
        super(iktvManager);
    }

    @Override
    public void onCreate(KTVBaseContext context) {
        super.onCreate(context);
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVDownLoader", (String)"KTVDownloader onCreate", (Object[])new Object[0]);
        }
        this.initDownLoader();
    }

    private void initDownLoader() {
        this.bindData();
    }

    private void bindData() {
        this.mBinder.clearAllKvoConnections();
        this.mBinder.singleBindSourceTo((KvoSource)((KTVRoomServices)this.getKtvManager().getKTVRoomServices()));
    }

    @KvoMethodAnnotation(name="mKTVRoomSongInfoList", sourceClass=KTVRoomServices.class, thread=1)
    public void onKTVRoomSongInfoListChanged(KvoEventIntent event) {
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVDownLoader", (String)"onKTVRoomSongInfoListChanged", (Object[])new Object[0]);
        }
        this.parsePreDownloaderList(((KTVRoomServices)event.source()).getKTVRoomSongInfoList());
        this.checkPreDownload(false);
    }

    private void parsePreDownloaderList(List<KTVRoomSongInfo> songInfoList) {
        ++this.mVersion;
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVDownLoader", (String)"onKTVRoomSongInfoListChanged+%d", (Object[])new Object[]{this.mVersion});
        }
        this.mPreDownloadList.clear();
        this.myKTVDownloaders.clear();
        if (songInfoList.size() <= 0) {
            return;
        }
        int downloadSongMaxSize = 1;
        int curPreDownloadCount = 0;
        KTVRoomSongInfo currSongInfo = songInfoList.get(0);
        if (currSongInfo.getUid() == AccountUtil.getUid()) {
            downloadSongMaxSize = this.maxSongSize;
        }
        for (KTVRoomSongInfo songInfo : songInfoList) {
            if (songInfo.getUid() == AccountUtil.getUid() && curPreDownloadCount < downloadSongMaxSize && songInfoList.indexOf(songInfo) <= 10) {
                PreDownloadInfo preDownloadSongInfo = new PreDownloadInfo();
                preDownloadSongInfo.resourceId = songInfo.getResourceId();
                preDownloadSongInfo.type = "Instrumental";
                preDownloadSongInfo.version = this.mVersion;
                PreDownloadInfo preDownloadInfolyrc = new PreDownloadInfo();
                preDownloadInfolyrc.resourceId = songInfo.getResourceId();
                preDownloadInfolyrc.type = "lyric";
                preDownloadInfolyrc.version = this.mVersion;
                ++curPreDownloadCount;
                this.mPreDownloadList.add(preDownloadSongInfo);
                this.mPreDownloadList.add(preDownloadInfolyrc);
                continue;
            }
            if (songInfoList.indexOf(songInfo) != 0 && songInfoList.indexOf(songInfo) != 1) continue;
            PreDownloadInfo preDownloadInfo = new PreDownloadInfo();
            preDownloadInfo.resourceId = songInfo.getResourceId();
            preDownloadInfo.type = "lyric";
            preDownloadInfo.version = this.mVersion;
            this.mPreDownloadList.add(preDownloadInfo);
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVDownLoader", (String)"mPreDownloadList :%s", (Object[])new Object[]{this.mPreDownloadList});
        }
    }

    private void checkPreDownload(final boolean isRetry) {
        FeatureLog.i((String)"FTKTVDownLoader", (String)"checkPreDownload,mPreDownloadList size:%s", (Object[])new Object[]{this.mPreDownloadList.size()});
        if (this.mPreDownloadList.size() > 0) {
            final PreDownloadInfo preDownloadInfo = this.mPreDownloadList.get(0);
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVDownLoader", (String)"checkPreDownload,preDownloadInfo:%s", (Object[])new Object[]{preDownloadInfo});
            }
            this.getKtvManager().getKTVMusicListProvider().getMusicInfo(preDownloadInfo.resourceId, new IKTVQueryCallback<KTVMusicInfo>(){

                @Override
                public void onSuccess(final KTVMusicInfo data, final boolean isCache) {
                    if (!KTVDownloader.this.checkVersion(preDownloadInfo.version, KTVDownloader.this.mVersion)) {
                        return;
                    }
                    YYTaskExecutor.execute((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            KTVDownloader.this.checkPreDownloadItemSuccess(preDownloadInfo, data, isCache);
                        }
                    });
                }

                @Override
                public void onFail(String errorMessage) {
                    if (!KTVDownloader.this.checkVersion(preDownloadInfo.version, KTVDownloader.this.mVersion)) {
                        return;
                    }
                    if (!isRetry) {
                        KTVDownloader.this.checkPreDownload(true);
                    }
                }
            });
        }
    }

    private void checkPreDownloadItemSuccess(final PreDownloadInfo preDownloadInfo, final KTVMusicInfo data, boolean isCache) {
        final boolean isNeedDownload = this.isNeedDownload(data, preDownloadInfo.type);
        YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                KTVDownloader.this.mPreDownloadList.remove(preDownloadInfo);
                if (isNeedDownload) {
                    String url;
                    String string2 = url = preDownloadInfo.type.equals("Instrumental") ? data.getInstrumentalUrl() : data.getLyricUrl();
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTKTVDownLoader", (String)"checkPreDownload,url: %s", (Object[])new Object[]{url});
                    }
                    if (StringUtils.isNotEmpty((String)url)) {
                        KTVDownloader.this.myKTVDownloaders.add(KTVDownloader.this.create(data, preDownloadInfo.type, null));
                        KTVDownloader.this.startDownload();
                    } else {
                        for (IKTVdownloadCallback callback : KTVDownloader.this.mDownloaderListenerList) {
                            callback.onError(data, preDownloadInfo.type, "download url error = " + url);
                        }
                    }
                }
                KTVDownloader.this.checkPreDownload(false);
            }
        });
    }

    private void startDownload() {
        if (this.myKTVDownloaders.size() <= 0) {
            return;
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVDownLoader", (String)"startDownload", (Object[])new Object[0]);
        }
        MyKTVDownloader firstDownload = this.myKTVDownloaders.get(0);
        if (firstDownload.mDownloader == null) {
            FeatureLog.e((String)"FTKTVDownLoader", (String)"startDownload error download = null", (Object[])new Object[0]);
            this.myKTVDownloaders.remove(firstDownload);
            return;
        }
        if (this.mCurDownloader == null) {
            this.mCurDownloader = firstDownload;
            this.mCurDownloader.start();
        } else if (!MyKTVDownloader.checkeEqual(this.mCurDownloader, firstDownload)) {
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVDownLoader", (String)"startDownload \u505c\u6389\u65e7\u7684\u4e0b\u8f7d", (Object[])new Object[0]);
            }
            this.stopCurDownloader();
            this.mCurDownloader = firstDownload;
            this.mCurDownloader.start();
        } else if (this.mCurDownloader != null) {
            this.myKTVDownloaders.set(0, this.mCurDownloader);
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVDownLoader", (String)"startDownload \u6700\u9ad8\u4f18\u5148\u7ea7\u5df2\u5728\u4e0b\u8f7d\u5df2\u5728\u4e0b\u8f7d\u4e2d\uff1a%s", (Object[])new Object[]{this.mCurDownloader.toString()});
            }
        }
    }

    private boolean checkVersion(long resVersion, long curVersion) {
        return resVersion == curVersion;
    }

    @Override
    public int checkInstrumentalVaild(KTVMusicInfo ktvSongInfo) {
        String url = KTVDownloadUtils.INSTANCE.getKTVInstrumentalFilePath(ktvSongInfo.getSongId(), ktvSongInfo.getInstrumentalUrl());
        try {
            try {
                if (YYFileUtils.checkFileValidation((String)url, (String)ktvSongInfo.getInstrumentalMd5())) {
                    return 2;
                }
                return 4;
            }
            catch (OutOfMemoryError error) {
                return 2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 4;
        }
    }

    @Override
    public int checkLyricVaild(KTVMusicInfo ktvSongInfo) {
        String filePath = KTVDownloadUtils.INSTANCE.getKTVLyricFilePath(ktvSongInfo.getSongId(), ktvSongInfo.getLyricUrl());
        try {
            try {
                if (YYFileUtils.checkFileValidation((String)filePath, (String)ktvSongInfo.getLyricMd5())) {
                    return 2;
                }
                return 4;
            }
            catch (OutOfMemoryError error) {
                return 2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return 4;
        }
    }

    private boolean isNeedDownload(KTVMusicInfo ktvSongInfo, String type) {
        boolean isNeed = false;
        if ("Instrumental".equals(type)) {
            isNeed = this.checkInstrumentalVaild(ktvSongInfo) != 2;
        } else if ("lyric".equals(type)) {
            boolean bl = isNeed = this.checkLyricVaild(ktvSongInfo) != 2;
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVDownLoader", (String)"isNeedDownload\uff1aktvSongInfo\uff1a%s\uff0ctype\uff1a%s,isNeed:%s", (Object[])new Object[]{ktvSongInfo, type, isNeed});
        }
        return isNeed;
    }

    @Override
    public void onDestroy() {
        super.onDestroy();
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVDownLoader", (String)"KTVDownloader onDestroy", (Object[])new Object[0]);
        }
        this.mBinder.clearAllKvoConnections();
        this.stopCurDownloader();
        this.mDownloaderListenerList.clear();
    }

    @Override
    public void downloadAsync(KTVMusicInfo songInfo, String type, IKTVdownloadCallback callback) {
        Downloader downloader;
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTKTVDownLoader", (String)"downloadAsync songInfo:%s,typs=%s", (Object[])new Object[]{songInfo, type});
        }
        MyKTVDownloader myKTVDownloader = new MyKTVDownloader();
        myKTVDownloader.mSongInfo = songInfo;
        myKTVDownloader.mType = type;
        String parentPath = "";
        String fileName = "";
        String url = "";
        if (type.equals("Instrumental")) {
            parentPath = KTVDownloadUtils.INSTANCE.getKTVInstrumentalDir();
            fileName = KTVDownloadUtils.INSTANCE.getInstrumentalFileName(songInfo.getSongId());
            url = songInfo.getInstrumentalUrl();
        } else {
            parentPath = KTVDownloadUtils.INSTANCE.getKTVLyricDir();
            fileName = KTVDownloadUtils.INSTANCE.getLyricFileName(songInfo.getSongId());
            url = songInfo.getLyricUrl();
        }
        if (MLog.isLogLevelBlowInfo()) {
            MLog.info((Object)"FTKTVDownLoader", (String)"downloadAsync start parentPath:%s,fileName=%s,url =%s", (Object[])new Object[]{parentPath, fileName, url});
        }
        Downloader.Builder builder = new Downloader.Builder(url, parentPath, fileName);
        int priority = 100;
        builder.setPriority(priority);
        builder.setSupportContinueTransfer(true);
        builder.setTaskGroup(DownloadBussinessGroup.KTV_FILE);
        builder.setTaskSubGroup(type);
        if (type.equals("Instrumental")) {
            builder.setFileEtagCheckContent("md5", songInfo.getInstrumentalMd5());
        } else {
            builder.setFileEtagCheckContent("md5", songInfo.getLyricMd5());
        }
        builder.setCallBack((IDownloadCallback)new KTVDownloadCallback(songInfo, type, callback));
        myKTVDownloader.mDownloader = downloader = builder.build();
        downloader.start();
    }

    @Override
    public IKTVManager getKtvManager() {
        return super.getKtvManager();
    }

    public String getLocalInstrumentalFilePath(KTVMusicInfo ktvSongInfo, boolean isAutoDownload, IKTVdownloadCallback callback) {
        String filePath = "";
        if (this.checkInstrumentalVaild(ktvSongInfo) == 2) {
            filePath = KTVDownloadUtils.INSTANCE.getKTVInstrumentalFilePath(ktvSongInfo.getSongId(), ktvSongInfo.getInstrumentalUrl());
        } else if (isAutoDownload) {
            this.downloadAsync(ktvSongInfo, "Instrumental", callback);
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVDownLoader", (String)"\u83b7\u53d6\u4f34\u5531\u8def\u5f84\uff1afilepath\uff1a%s", (Object[])new Object[]{filePath});
        }
        return filePath;
    }

    @Override
    public String getLocalInstrumentalFilePath(KTVMusicInfo ktvSongInfo) {
        return this.getLocalInstrumentalFilePath(ktvSongInfo, false, null);
    }

    @Override
    public String getLocalLyricFilePath(KTVMusicInfo ktvSongInfo) {
        String filePath = "";
        if (this.checkLyricVaild(ktvSongInfo) == 2) {
            filePath = KTVDownloadUtils.INSTANCE.getKTVLyricFilePath(ktvSongInfo.getSongId(), ktvSongInfo.getLyricUrl());
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVDownLoader", (String)"\u83b7\u53d6\u6b4c\u8bcd\u8def\u5f84\uff1afilepath\uff1a%s", (Object[])new Object[]{filePath});
        }
        return filePath;
    }

    private void stopCurDownloader() {
        if (this.mCurDownloader != null) {
            this.mCurDownloader.stop();
            if (FeatureLog.isLogLevelBlowInfo()) {
                FeatureLog.i((String)"FTKTVDownLoader", (String)"stop %s", (Object[])new Object[]{this.mCurDownloader.mSongInfo.getSongId()});
            }
        }
        this.mCurDownloader = null;
    }

    public MyKTVDownloader create(KTVMusicInfo songInfo, String type, IKTVdownloadCallback callback) {
        MyKTVDownloader myKTVDownloader = new MyKTVDownloader();
        myKTVDownloader.mSongInfo = songInfo;
        myKTVDownloader.mType = type;
        String parentPath = "";
        String fileName = "";
        String url = "";
        if (type.equals("Instrumental")) {
            url = songInfo.getInstrumentalUrl();
            parentPath = KTVDownloadUtils.INSTANCE.getKTVInstrumentalDir();
            fileName = KTVDownloadUtils.INSTANCE.getInstrumentalFileName(songInfo.getSongId(), url);
        } else {
            url = songInfo.getLyricUrl();
            parentPath = KTVDownloadUtils.INSTANCE.getKTVLyricDir();
            fileName = KTVDownloadUtils.INSTANCE.getLyricFileName(songInfo.getSongId(), url);
        }
        if (FeatureLog.isLogLevelBlowInfo()) {
            FeatureLog.i((String)"FTKTVDownLoader", (String)"create downloader start parentPath:%s,fileName=%s,url =%s", (Object[])new Object[]{parentPath, fileName, url});
        }
        try {
            Downloader.Builder builder = new Downloader.Builder(url, parentPath, fileName);
            int priority = 100;
            builder.setPriority(priority);
            builder.setSupportContinueTransfer(true);
            builder.setTaskGroup(DownloadBussinessGroup.KTV_FILE);
            builder.setTaskSubGroup(type);
            if (type.equals("Instrumental")) {
                builder.setFileEtagCheckContent("md5", songInfo.getInstrumentalMd5());
            } else {
                builder.setFileEtagCheckContent("md5", songInfo.getLyricMd5());
            }
            builder.setCallBack((IDownloadCallback)new KTVDownloadCallback(songInfo, type, callback));
            myKTVDownloader.mDownloader = builder.build();
        }
        catch (IllegalStateException e) {
            FeatureLog.e((String)"FTKTVDownLoader", (String)"error %s", (Object[])new Object[]{e});
        }
        return myKTVDownloader;
    }

    @Override
    public void registerKTVDonwloadListener(@NonNull IKTVdownloadCallback callback) {
        if (callback == null) {
            return;
        }
        this.mDownloaderListenerList.add(callback);
    }

    @Override
    public void unRegisterKTVDonwloadListener(@NonNull IKTVdownloadCallback callback) {
        if (callback == null) {
            return;
        }
        this.mDownloaderListenerList.remove(callback);
    }

    @Override
    public KTVDownloadInfo getCurrentDownloadInfo() {
        if (this.mCurDownloader != null) {
            return new KTVDownloadInfo(this.mCurDownloader.mSongInfo.getSongId(), this.mCurDownloader.mType);
        }
        return null;
    }

    public class PreDownloadInfo
    extends KTVDownloadInfo {
        public long version;

        public String toString() {
            return "PreDownloadInfo{version=" + this.version + ", resourceId='" + this.resourceId + '\'' + ", type='" + this.type + '\'' + '}';
        }
    }

    class KTVDownloadCallback
    implements IDownloadCallback {
        KTVMusicInfo info;
        String type;
        IKTVdownloadCallback callback;

        KTVDownloadCallback(KTVMusicInfo info, String type, IKTVdownloadCallback callback) {
            this.info = info;
            this.type = type;
            this.callback = callback;
        }

        public void onComplete(final Downloader downloader) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (FeatureLog.isLogLevelBlowInfo()) {
                        FeatureLog.i((String)"FTKTVDownLoader", (String)"onComplete downloader=%s", (Object[])new Object[]{downloader.getUrl()});
                    }
                    if (KTVDownloadCallback.this.callback != null) {
                        KTVDownloadCallback.this.callback.onSuccess(KTVDownloadCallback.this.info, KTVDownloadCallback.this.type, downloader.getFilePath());
                    }
                    if (KTVDownloader.this.mCurDownloader != null && downloader == ((KTVDownloader)KTVDownloader.this).mCurDownloader.mDownloader) {
                        if (RuntimeContext.sIsDebuggable) {
                            ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)(((KTVDownloader)KTVDownloader.this).mCurDownloader.mSongInfo.getSongName() + "\u4e0b\u8f7d\u7c7b\u578b\uff1a" + ((KTVDownloader)KTVDownloader.this).mCurDownloader.mType + "\u4e0b\u8f7d\u5b8c\u6210"), (int)0);
                        }
                        if (FeatureLog.isLogLevelBlowInfo()) {
                            FeatureLog.i((String)"FTKTVDownLoader", (String)"onComplete startNextDownload", (Object[])new Object[0]);
                        }
                        for (IKTVdownloadCallback iDownloadCallback : KTVDownloader.this.mDownloaderListenerList) {
                            iDownloadCallback.onSuccess(((KTVDownloader)KTVDownloader.this).mCurDownloader.mSongInfo, KTVDownloadCallback.this.type, downloader.getFilePath());
                        }
                        KTVDownloader.this.myKTVDownloaders.remove(KTVDownloader.this.mCurDownloader);
                        KTVDownloader.this.mCurDownloader = null;
                        KTVDownloader.this.startDownload();
                    }
                }
            });
        }

        public void onError(Downloader downloader, int errorType, String errorInfo) {
            FeatureLog.e((String)"FTKTVDownLoader", (String)"onError mCurDownloader: %s", (Object[])new Object[]{KTVDownloader.this.mCurDownloader});
            if (KTVDownloader.this.mCurDownloader != null && downloader == ((KTVDownloader)KTVDownloader.this).mCurDownloader.mDownloader) {
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)(((KTVDownloader)KTVDownloader.this).mCurDownloader.mSongInfo.getSongName() + "\u4e0b\u8f7d\u7c7b\u578b\uff1a" + ((KTVDownloader)KTVDownloader.this).mCurDownloader.mType + "\u4e0b\u8f7d\u5931\u8d25"), (int)0);
                }
                for (IKTVdownloadCallback callback : KTVDownloader.this.mDownloaderListenerList) {
                    callback.onError(((KTVDownloader)KTVDownloader.this).mCurDownloader.mSongInfo, this.type, errorInfo);
                }
                KTVDownloader.this.myKTVDownloaders.remove(KTVDownloader.this.mCurDownloader);
                KTVDownloader.this.mCurDownloader = null;
                KTVDownloader.this.startDownload();
            }
        }

        public void onProgressChange(Downloader downloader, long totalSize, long curSize) {
            for (IKTVdownloadCallback callback : KTVDownloader.this.mDownloaderListenerList) {
                if (MLog.isLogLevelBlowInfo()) {
                    MLog.info((Object)"KTVProgress", (String)"songInfo:%s, total:%s, cur:%s", (Object[])new Object[]{((KTVDownloader)KTVDownloader.this).mCurDownloader.mSongInfo, totalSize, curSize});
                }
                callback.onProgress(((KTVDownloader)KTVDownloader.this).mCurDownloader.mSongInfo, this.type, totalSize, curSize);
            }
        }

        public void onStart(Downloader downloader) {
            if (KTVDownloader.this.mCurDownloader != null && downloader == ((KTVDownloader)KTVDownloader.this).mCurDownloader.mDownloader) {
                FeatureLog.d((String)"FTKTVDownLoader", (String)"onStart mCurDownloader:%s", (Object[])new Object[]{KTVDownloader.this.mCurDownloader});
                if (RuntimeContext.sIsDebuggable) {
                    ToastUtils.showToast((Context)RuntimeContext.sApplicationContext, (String)(((KTVDownloader)KTVDownloader.this).mCurDownloader.mSongInfo.getSongName() + "\u4e0b\u8f7d\u7c7b\u578b\uff1a" + ((KTVDownloader)KTVDownloader.this).mCurDownloader.mType + "\u5f00\u59cb\u4e0b\u8f7d"), (int)0);
                }
                for (IKTVdownloadCallback iDownloadCallback : KTVDownloader.this.mDownloaderListenerList) {
                    iDownloadCallback.onStarted(((KTVDownloader)KTVDownloader.this).mCurDownloader.mSongInfo, this.type);
                }
            }
        }
    }
}

