/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.yy.appbase.ui.widget.image.CircleImageView;
import com.yy.base.imageloader.ImageLoader;
import com.yy.base.imageloader.view.RecycleImageView;
import com.yy.base.memoryrecycle.views.YYImageView;
import com.yy.base.memoryrecycle.views.YYTextView;
import com.yy.base.utils.YYImageUtils;
import com.yy.hiyo.channel.plugins.ktv.R;
import com.yy.hiyo.channel.plugins.ktv.common.bean.KTVSingersItemInfo;
import com.yy.hiyo.channel.plugins.ktv.list.musiclibrary.singers.ISelectSingerListener;
import java.util.List;

public class KTVSingersAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_HEADER = 0;
    private static final int TYPE_NORMAL = 1;
    private Context mContext;
    private List<KTVSingersItemInfo> mList;
    private ISelectSingerListener mListener;
    private int mPageType;

    public KTVSingersAdapter(Context context, List<KTVSingersItemInfo> list, int pageType) {
        this.mContext = context;
        this.mList = list;
        this.mPageType = pageType;
    }

    @NonNull
    public RecyclerView.ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        if (viewType == 0) {
            return new HeaderVH(LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_singers_header_channel, parent, false));
        }
        return new NormalVH(LayoutInflater.from((Context)this.mContext).inflate(R.layout.item_singers_normal_channel, parent, false));
    }

    public void onBindViewHolder(@NonNull RecyclerView.ViewHolder holder, final int position) {
        if (this.getItemViewType(position) == 0) {
            HeaderVH headVH = (HeaderVH)holder;
            if (position == 0 && this.mPageType == 1) {
                headVH.hotIv.setVisibility(0);
                headVH.titleTv.setVisibility(8);
            } else {
                headVH.hotIv.setVisibility(8);
                headVH.titleTv.setVisibility(0);
                headVH.titleTv.setText((CharSequence)this.mList.get(position).getLetter());
            }
        } else {
            NormalVH normalVH = (NormalVH)holder;
            normalVH.nameTv.setText((CharSequence)this.mList.get((int)position).getSinger().singer_name);
            ImageLoader.loadBitmap((RecycleImageView)normalVH.avatarIv, (String)(this.mList.get((int)position).getSinger().avatar_url + YYImageUtils.getThumbnailPostfix((int)75)), (int)R.drawable.ktv_singer_default_avatar);
            normalVH.rootiew.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (null != KTVSingersAdapter.this.mListener) {
                        KTVSingersAdapter.this.mListener.onSelect(((KTVSingersItemInfo)KTVSingersAdapter.this.mList.get(position)).getSinger(), KTVSingersAdapter.this.mPageType);
                    }
                }
            });
            if (position == this.mList.size() - 1) {
                normalVH.bottomView.setVisibility(0);
            } else {
                normalVH.bottomView.setVisibility(8);
            }
        }
    }

    public int getItemCount() {
        return this.mList.size();
    }

    public int getItemViewType(int position) {
        return this.mList.get(position).getType() == 0 ? 0 : 1;
    }

    public void setOnSelectSingerListener(ISelectSingerListener listener) {
        this.mListener = listener;
    }

    static class HeaderVH
    extends RecyclerView.ViewHolder {
        private YYTextView titleTv;
        private YYImageView hotIv;

        public HeaderVH(View itemView) {
            super(itemView);
            this.titleTv = (YYTextView)itemView.findViewById(R.id.tv_title);
            this.hotIv = (YYImageView)itemView.findViewById(R.id.iv_hot);
        }
    }

    static class NormalVH
    extends RecyclerView.ViewHolder {
        private CircleImageView avatarIv;
        private YYTextView nameTv;
        private View bottomView;
        private View rootiew;

        public NormalVH(View itemView) {
            super(itemView);
            this.rootiew = itemView;
            this.avatarIv = (CircleImageView)itemView.findViewById(R.id.iv_avatar);
            this.nameTv = (YYTextView)itemView.findViewById(R.id.tv_name);
            this.bottomView = itemView.findViewById(R.id.view_bottom);
        }
    }
}

