/*
 * Decompiled with CFR 0.152.
 */
package com.yy.hiyo.channel.plugins.ktv.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import com.yy.base.memoryrecycle.views.YYTextView;

@SuppressLint(value={"ClassComment"})
public class ShiningTextView
extends YYTextView {
    private Paint mPaint;
    private LinearGradient mLinearGradient;
    private Matrix mGradientMatrix;
    private int mViewWidth;
    private int mTranslate;
    private boolean mIsAttach;
    private int mOriginColor = -16777216;
    private int mShiningColor = -1;
    Runnable shiningRun = new Runnable(){

        @Override
        public void run() {
            if (!ShiningTextView.this.mIsAttach) {
                return;
            }
            if (ShiningTextView.this.mGradientMatrix != null && ShiningTextView.this.mLinearGradient != null) {
                ShiningTextView.this.mTranslate = ShiningTextView.this.mTranslate + 40;
                if (ShiningTextView.this.mTranslate > 2 * ShiningTextView.this.mViewWidth) {
                    ShiningTextView.this.mTranslate = -ShiningTextView.this.mViewWidth;
                }
                ShiningTextView.this.mGradientMatrix.setTranslate((float)ShiningTextView.this.mTranslate, 0.0f);
                ShiningTextView.this.mLinearGradient.setLocalMatrix(ShiningTextView.this.mGradientMatrix);
                ShiningTextView.this.postDelayed(this, 60L);
                ShiningTextView.this.postInvalidate();
            }
        }
    };

    public ShiningTextView(Context context) {
        super(context);
    }

    public ShiningTextView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ShiningTextView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public void setShiningColor(int originColor, int shiningColor) {
        this.mOriginColor = originColor;
        this.mShiningColor = shiningColor;
    }

    protected void onSizeChanged(int w, int h, int oldW, int oldH) {
        super.onSizeChanged(w, h, oldW, oldH);
        if (this.mViewWidth == 0) {
            this.mViewWidth = this.getMeasuredWidth();
            if (this.mViewWidth > 0) {
                this.mPaint = new Paint(1);
                this.mPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
                this.mLinearGradient = new LinearGradient(0.0f, 0.0f, (float)this.mViewWidth, 0.0f, new int[]{this.mOriginColor, this.mShiningColor, this.mOriginColor}, null, Shader.TileMode.CLAMP);
                this.mPaint.setShader((Shader)this.mLinearGradient);
                this.mGradientMatrix = new Matrix();
                this.removeCallbacks(this.shiningRun);
                this.shiningRun.run();
            }
        }
    }

    protected void onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        if (visibility == 0) {
            this.mIsAttach = true;
            this.removeCallbacks(this.shiningRun);
            this.shiningRun.run();
        } else if (visibility == 4) {
            this.mIsAttach = false;
        } else if (visibility == 8) {
            this.mIsAttach = false;
        }
    }

    protected void onDraw(Canvas canvas) {
        canvas.saveLayer(null, null, 31);
        super.onDraw(canvas);
        canvas.drawPaint(this.mPaint);
        canvas.restore();
    }

    public boolean isFocused() {
        return true;
    }
}

